(function($) {

$.fn.textarea = function(user_options) {

	var options = $.extend({}, $.fn.textarea.defaults, user_options);

	return this.each(function() {

		if (this.type != "textarea" || this["jquery.textarea"]) {
			return false;
		}
		this["jquery.textarea"] = true; // prevent reapplying plugin by mistake

		var $textarea = $(this);
		var minRows = options.expandable.minRows ? options.expandable.minRows : parseInt($textarea.attr("rows"));
		var maxlength = parseInt($textarea.attr("maxlength"));

		var $wrapper_div = $("<div></div>").css({"position": "relative"});
		$textarea.wrap($wrapper_div);

		function resize() {
			textarea = $textarea[0];

			while ((textarea.rows > minRows) && (textarea.scrollHeight < textarea.offsetHeight)) {
				textarea.rows--;
			}
		
			while (textarea.scrollHeight > textarea.offsetHeight) {
				textarea.rows++;
			}
	
			if (options.expandable.extraLine) {
				textarea.rows++;
			}
		}

		function checkLength() {
			if ($textarea.val().getBytes() > maxlength) {
				var text = $textarea.val().substr(0, maxlength);

				while ((text.getBytes() > maxlength) && (text.length > 0)) {
					text = text.slice(0, -1);
				}

				$textarea.val(text);
				options.remaining.onlimit(this);
			}

			var args = {
				"$textarea": $textarea,
				"byteLength": $textarea.val().getBytes(),
				"maxlength": maxlength,
				"remaining": $textarea.val().getBytes() - maxlength
			};
	
			options.remaining.onedit(args);
		}

		if (options.remaining.use && $textarea.attr("maxlength")) {
			var remainingLabel = $("<label></label>")
				.addClass("ui-textarea-elem-remaining")
				.css(options.remaining.css)
				.insertAfter($textarea);

			$textarea.keyup(function() {
				checkLength();
			});

			$textarea.live('input paste cut', function(e) {
				setTimeout(checkLength, 250);
			});

			checkLength();
		}

		if (options.expandable.use) {
			$textarea.css({"overflow":"hidden"});

			$textarea.keyup(function() {
				resize();
			});

			$textarea.live('input paste cut', function(e) {
				setTimeout(resize, 250);
			});

			resize();
		}

		if (options.emptyText.use && $textarea.attr("title")) {
			var emptyText = $textarea.attr("title");
			var pos = $textarea.position();

			var $emptyText_textarea = $textarea.clone()
				.text(emptyText)
				.removeAttr("name")
				.removeAttr("id")
				.hide()
				.click(function () { $emptyText_textarea.hide(); $textarea.focus(); })
				.focus(function () { $emptyText_textarea.hide(); $textarea.focus(); })
				.css({"position": "absolute", "left": pos.left + "px", "top": pos.top + "px"})
				.css(options.emptyText.css)
				.insertAfter($textarea);

			$emptyText_textarea[0]["jquery.textarea"] = true;

			$textarea.focus(function () {
				$emptyText_textarea.hide();
			});

			$textarea.blur(function () {
				if ($textarea.val() == "") {
					$emptyText_textarea.show();
				}
			});

			if ($textarea.val() == "") {
				$emptyText_textarea.show();
			}
		}
	});
};

$.fn.textarea.defaults = {

	"remaining": {
		"use": true,
		"css": { "font-size": "9px", "color": "#333" },
		"onedit": function(args) {
			args.$textarea.siblings(".ui-textarea-elem-remaining").text(args.byteLength + "/" + args.maxlength);
		},
		"onlimit": function() {}
	},

	"expandable": {
		"use": true,
		"extraLine": false
	},

	"emptyText": {
		"use": true,
		"css": {"color": "gray"}
	}
};

})(jQuery);
