/*global fweb*/
(function($) {
    'use strict';

    $.extend({'fgt_wizard': fgt_wizard});
    $.fn.fgt_wizard = fgt_wizard;
    /* This selector will get:
     - visible input/select
     - invisible input/select within visibile .multiList-container
    */
    var VISIBLE_SEL = 'input:visible,select:visible,' +
        '.multiList-container:visible input:not(.multiList-input),' +
        '.multiList-container:visible select';

    function fgt_wizard(settings) {
        var defaults = {
            lang: {
                next: $.getInfo('wizard_next') + '  &gt;',
                prev: '&lt; ' + $.getInfo('wizard_prev'),
                done: $.getInfo('wizard_done')
            },
            current_chain: [], // the path from beginning to current
            starting_step: '',
            planned_chain: [], // the intended path which may keep changing
            // structure to present possible wizard paths
            // - Without prev: First Step
            // - Without next: Last Step
            wmap: {}
        };

        var config = $.extend(true, {}, defaults, settings);

        if ($.isEmptyObject(config.wmap)) {
            // nothing to do
            return;
        }

        function common_validate(dfd, step) {
            // need to validate:

            if (fweb.util.is_valid('fieldset#' + step, VISIBLE_SEL)) {
                dfd.resolve();
            } else {
                dfd.reject();
            }
        }

        function is_first_step(step) {
            return step === config.starting_step;
        }

        function is_last_step(step) {
            var idx = $.inArray(step, config.planned_chain);
            return (idx === (config.planned_chain.length - 1));
        }

        function update_progress_tracker(chain) {
            var len = chain.length,
                i,
                step,
                total_width = 0;
            var $progress_tracker = $('#progress_tracker');
            $progress_tracker.empty();
            for (i = 0; i < len; i++) {
                step = chain[i];
                var li = '<li id="progress_' + step + '">' +
                    '<a href="#"><span>' + (i + 1) + '</span>' +
                    $.getInfo(step) +
                    '</a></li>';
                $progress_tracker.append(li);
            }
            // To prevent breadcrumbs steps being broken into separate rows,
            // we need to set a width to the container. However, the number
            // of steps and the text in each step are flexible, so we have
            // to calculate it on-the-fly
            $('#progress_tracker li a').each(function() {
                var jthis = $(this);
                // IE is using float for internal calculated widths and
                // heights, so using outerWidth()/outerHeight() does not
                // always return the correct integer result
                // (see http://bugs.jquery.com/ticket/9628)
                // Here we are adding 1 extra pixel to avoid lacking spaces
                // for each breadcrumb item to be rendered
                total_width += jthis.outerWidth(true) + 1;
            });
            $progress_tracker.width(total_width);
        }

        function update_footer_nav_buttons(step) {
            var jnext = $('#progress_next');
            var jprev = $('#progress_prev');
            toggle_nav_btn(jprev, !is_first_step(step));
            if (is_last_step(step)) {
                jnext.html(config.lang.done);
            } else {
                jnext.html(config.lang.next);
            }
            jnext.data('current', step);
            jprev.data('current', step);
        }

        function toggle_nav_btn(jbtn, enable) {
            if (enable) {
                jbtn.removeAttr('disabled');
                jbtn.toggleClass('disabled', false);
            } else {
                jbtn.attr('disabled', 'disabled');
                jbtn.toggleClass('disabled', true);
            }
        }

        function set_current(step) {
            update_footer_nav_buttons(step);

            $('fieldset').hide();
            $('#' + step).show();
            $('#msteps').trigger('jqwizard.step_shown', {step: step});
            $('#progress_tracker li').removeClass('current_step');
            $('#progress_' + step).removeClass('done').addClass('current_step');

            var idx = $.inArray(step, config.current_chain);
            if (idx >= 0) {
                config.current_chain = config.current_chain.splice(0, idx + 1);
            } else {
                config.current_chain.push(step);
            }
            $('#progress_' + step + ' span').html(config.current_chain.length);
            step_focus(step);
        }

        function step_focus(step) {
            var jstep = $('#' + step + ' .field');
            var jautofocus = jstep.find('[autofocus]');
            if (jautofocus.length) {
                // respect autofocus if any
                jautofocus.focus();
            } else {
                // focus the first visible input
                var jfirst = jstep.find(VISIBLE_SEL).first();
                if (jfirst.length) {
                    if (jfirst.closest('.multiList-container').length) {
                        // adding dummy tabindex to make focus work on ul
                        var ul = jfirst.siblings('.multiList-list')
                                       .attr('tabindex', 0);
                        ul.focus();
                    } else {
                        jfirst.focus();
                    }
                }
            }
        }

        function mark_step_done(step) {
            $('#progress_' + step).toggleClass('done', true);
            $('#progress_' + step + ' span').html('&#10004;');
        }

        function common_init() {
            $('#progress_nav').on('click', 'button.step_nav', function() {
                var jthis = $(this);
                var step = jthis.data('current');
                var is_prev = jthis.data('type') === 'prev';
                var idx = config.current_chain.length - 1;
                var upcoming_step = is_prev ?
                    (config.planned_chain[idx - 1]) :
                    (config.planned_chain[idx + 1]);
                var prev_cb = config.wmap[step] ?
                    config.wmap[step].before_prev : null;
                var next_cb = config.wmap[step] ?
                    config.wmap[step].before_next || common_validate : null;

                var dfd = $.Deferred();
                dfd.done(function() {
                    if (is_prev || !is_last_step(step)) {
                        set_current(upcoming_step);
                    }
                    if (!is_prev) {
                        mark_step_done(step);
                    }
                });

                if (is_prev && $.isFunction(prev_cb)) {
                    prev_cb(dfd, step);
                } else if (!is_prev && $.isFunction(next_cb)) {
                    next_cb(dfd, step);
                } else {
                    dfd.resolve();
                }
            });

            if (config.hasOwnProperty('path_changer')) {
                var path_changer = config.path_changer;
                var type_selector = path_changer.selector;
                $(type_selector).on('click', function() {
                    var jtype = $(this);
                    var val = jtype.val();
                    var chain = path_changer.paths[val];
                    if (chain) {
                        config.planned_chain = chain;
                        update_progress_tracker(config.planned_chain);
                        set_current(config.starting_step);
                    }

                    if ($.isFunction(config.custom_type_select_cb)) {
                        config.custom_type_select_cb(jtype);
                    }
                });
            } else if (config.hasOwnProperty('path')) {
                config.planned_chain = config.path;
                update_progress_tracker(config.planned_chain);
                set_current(config.starting_step);
            }
        }

        //// Main control logic
        common_init();
        if ($.isFunction(config.init_fn)) {
            config.init_fn();
        }
        //// End main control logic
    }

})(jQuery);
