var JSONRPC = (function ($) {
	var id = 0;
	var url = "/json";

	function jsonrpc_on_success(response, textStatus) {
		alert('jsonrpc success: \n\n' + JSON.stringify(response));
	}

	function jsonrpc_on_error(response, textStatus) {
		alert('jsonrpc error: \n\n' + JSON.stringify(response));
	}

	function jsonrpc_send(request, args) {
		if (!request) {
			return;
		}

		if (typeof request.id === "undefined") {
			 request.id = id++;
		}

		if (!args) {
			args = {};
		}

		if (!args.on_error) {
			args.on_error = jsonrpc_on_error;
		}

		if (!args.on_success) {
			args.on_success = jsonrpc_on_success;
		}

		$.ajax({
			"url": url,
			"cache": false,
			"dataType": "json",
			"type": "POST",
			"data": {
				"json": JSON.stringify(request)
			},
			"async": typeof(args.async) == "boolean" ? args.async : true,
			"success": 	function __jsonrpc_on_success(response, textStatus) {
				if (!response) {
					return;
				}
				if (response.error) {
					args.on_error(response.error, textStatus);
				}
				else if (response.result) {
					args.on_success(response.result, textStatus);
				}
				else if (typeOf(response) === "array") {
					args.on_success(response, textStatus);
				}
				else {
					// error
				}
			},

			"error": function (XMLHttpRequest, textStatus, errorThrown) {
				var response = {
					"id": null,
					"error": {
						"code": -32000,
						"message": "Connection error",
						"data": {
							"XMLHttpRequest": XMLHttpRequest,
							"textStatus": textStatus,
							"errorThrown": errorThrown
						}
					}
				};

				args.on_error(response.error, textStatus);
			}
		});
	}
	
	if (window.Prototype) {
		delete Object.prototype.toJSON;
		delete Array.prototype.toJSON;
		delete Hash.prototype.toJSON;
		delete String.prototype.toJSON;
	}

	return {
		"send": jsonrpc_send
	};

})(jQuery);

// other methods
JSONRPC.Batch = (function ($) {
	var Request = {
		"method": "batch",
		"params": {
			"batch": []
		}
	}

	function jsonrpc_batch_send(params, args) {
		if (!params) {
			return;
		}

		if (!args) {
			args = {};
		}

		var request = $.extend(true, {}, JSONRPC.Batch.Request);
		request.params = $.extend(true, {}, params);

		JSONRPC.send(request, args);
	}

	return {
		"Request": Request,

		"send": jsonrpc_batch_send
	};

})(jQuery);
