JSONRPC.CMDB = (function ($) {
	var Request = {
		"method": "cmdb",
		"params": {}
	};

	// defaults
	var Method = {

		"Select": {
			"method": "select",
			"filters": [{
				"key": "name", // default masterkey (on omission)
				"type": "string" // default string
			}],

			// recursive structure
			"params": {
				"method": "get" // move, edit, delete, get - default = get (list)
			}
		},

		"Get": {
			"method": "get"  // no mkey -> get default values
		},

		"Append": {
			"method": "append",
			"overwrite": true
		},

		"Insert": {
			"method": "insert",
			"type": "index",
			"location": 0
		},

		"Move": {
			"method": "move",
			"type": "index",
			"from": 1,
			"to": 2
		},

		"Edit": {
			"method": "edit"
		},

		"Delete": {
			"method": "delete"
		},

		"Clear": {
			"method": "clear"
		}
	};

	function jsonrpc_cmdb_select(params, args) {
		send($.extend(true, {}, Method.Select, params), args);
	}

	function jsonrpc_cmdb_get(params, args) {
		send($.extend(true, {}, Method.Get, params), args);
	}

	function jsonrpc_cmdb_append(params, args) {
		send($.extend(true, {}, Method.Append, params), args);
	}

	function jsonrpc_cmdb_insert(params, args) {
		send($.extend(true, {}, Method.Insert, params), args);
	}

	function jsonrpc_cmdb_move(params, args) {
		send($.extend(true, {}, Method.Move, params), args);
	}

	function jsonrpc_cmdb_edit(params, args) {
		send($.extend(true, {}, Method.Edit, params), args);
	}

	function jsonrpc_cmdb_delete(params, args) {
		send($.extend(true, {}, Method.Delete, params), args);
	}

	function jsonrpc_cmdb_clear(params, args) {
		send($.extend(true, {}, Method.Clear, params), args);
	}

	function send(params, args) {
		var default_args = {
			"on_error" : jsonrpc_cmdb_on_error,
			"on_success" : jsonrpc_cmdb_on_success
		};

		if (!params) {
			return;
		}
		params = $.extend(true, {}, params);

		args = $.extend({}, default_args, args);

		var request = $.extend(true, {}, Request);
		request.params = $.extend(true, {}, params);

		JSONRPC.send(request, args);
	}

	function create(method, params, args) {
		var default_args = {};

		if (!params) {
			return;
		}
		params = $.extend(true, {}, params);

		args = $.extend({}, default_args, args);

		var request = $j.extend(true, {}, JSONRPC.CMDB.Request);
		request.params = $.extend(true, {}, JSONRPC.CMDB.Method[method], params);
		request.id = request.params.path + "." + request.params.name; // DEBUG

		return request;
	}

	function jsonrpc_cmdb_on_error(error) {
		alert('cmdb error: \n\n' + JSON.stringify(error));
	}

	function jsonrpc_cmdb_on_success(result) {
		alert('cmdb success: \n\n' + JSON.stringify(result));
	}

	return {
		"Request": Request,
		"Method": Method,

		"send": send,
		"create": create,

		"select": jsonrpc_cmdb_select,
		"get": jsonrpc_cmdb_get,
		"append": jsonrpc_cmdb_append,
		"insert": jsonrpc_cmdb_insert,
		"move": jsonrpc_cmdb_move,
		"edit": jsonrpc_cmdb_edit,
		"delete": jsonrpc_cmdb_delete,
		"clear": jsonrpc_cmdb_clear
	};

})(jQuery);

var CMDB = (function ($) {
	function api_cmdb_fetch(cmdb_path, cmdb_name, preferences, callback, async) {
		var parameters = {
			"action": "select",
			"path": cmdb_path,
			"name": cmdb_name
		};
		$.extend(parameters, preferences);
		$.ajax({
			"url": "/api/cmdb",
			"cache": false,
			"dataType": "json",
			"data": {
				"request": JSON.stringify(parameters)
			},
			"async": typeof(async) == "boolean" ? async : true,
			"success": function (data, textStatus) {
				if (!data || !data.results) return;
				if (typeof(callback) == "function") {
					callback(data, textStatus);
				}
			}
		});
	}

	function api_cmdb_fetch_default(cmdb_path, cmdb_name, callback, async) {
		api_cmdb_fetch(cmdb_path, cmdb_name, {
			"action": "fetch_default"
		}, callback, async)
	}

	function api_cmdb_fetch_list(cmdb_path, cmdb_name, cmdb_key, callback) {
		api_cmdb_fetch(cmdb_path, cmdb_name, {}, function (data, textStatus) {
			var option_list = [];
			$.each(data.results, function () {
				option_list.push(this[cmdb_key]);
			});
			if (typeof(callback) == "function") {
				callback(option_list);
			}
		});
	}

	function __api_cmdb_edit_object(action, cmdb_path, cmdb_name, mkey, cmdb_object, callback, preferences) {
		var parameters = {
			"action": action,
			"path": cmdb_path,
			"name": cmdb_name,
			"mkey": mkey,
			"json": cmdb_object
		};
		$.extend(parameters, preferences);
		$.post("/api/cmdb", {
			"request": JSON.stringify(parameters)
		}, function (data) {
			if (!data) return;
			if (typeof(callback) == "function") {
				callback(data);
			}
		}, "json");
	}

	function api_cmdb_edit_object(cmdb_path, cmdb_name, mkey, cmdb_object, callback, preferences) {
		__api_cmdb_edit_object("edit", cmdb_path, cmdb_name, mkey, cmdb_object, callback, preferences);
	}

	function api_cmdb_append_object(cmdb_path, cmdb_name, mkey, cmdb_object, callback, preferences) {
		__api_cmdb_edit_object("append", cmdb_path, cmdb_name, mkey, cmdb_object, callback, preferences);
	}

	if (window.Prototype) {
		delete Object.prototype.toJSON;
		delete Array.prototype.toJSON;
		delete Hash.prototype.toJSON;
		delete String.prototype.toJSON;
	}

	return {
		"fetch": api_cmdb_fetch,
		"fetch_default": api_cmdb_fetch_default,
		"fetch_list": api_cmdb_fetch_list,
		"edit": api_cmdb_edit_object,
		"append": api_cmdb_append_object
	};

})(jQuery);
