/* jshint strict: false, supernew: true, evil: true*/
/* globals $j, matchFieldExp, RegExpCommon, ipStrToNum, getParentProperty*/
/* exported validateFields */
var ValidationType = new function() {
        this.NAME = 1;
        this.INTEGER = 2;
        this.EMAIL_ADDRESS = 3;
        this.MAC_ADDRESS = 4;
        this.MAXLENGTH = 5;
        this.RANGE = 6;
        this.REGEXP = 7;
        this.XSS = 8;
        this.IP_HOST = 10;
        this.IP_HOST1 = 11;
        this.IP_MASK = 12;
        this.IP_SUBNET = 13;
        this.IP_RANGE = 14;
        this.PORT = 15;
        this.PORT1 = 16;
        this.PROTOCOL = 17;
        this.HEX_INTEGER = 18;
        this.HEX_RANGE = 19;
        this.CUSTOM = 20;
    },
    errorMessageArray = [];

errorMessageArray[ValidationType.INTEGER] = $j.getInfo('integer');
errorMessageArray[ValidationType.MAXLENGTH] = $j.getInfo('maxlength');
errorMessageArray[ValidationType.RANGE] = $j.getInfo('range');
errorMessageArray[ValidationType.PORT] = $j.getInfo('port');
errorMessageArray[ValidationType.PORT1] = $j.getInfo('port1');
errorMessageArray[ValidationType.PROTOCOL] = $j.getInfo('protocol');
errorMessageArray[ValidationType.IP_SUBNET] = $j.getInfo('ip_subnet');
errorMessageArray[ValidationType.IP_HOST] = $j.getInfo('ip_host');
errorMessageArray[ValidationType.REGEXP] = $j.getInfo('regexp');
errorMessageArray[ValidationType.XSS] = $j.getInfo('xss');
errorMessageArray[ValidationType.HEX_INTEGER] = $j.getInfo('hex_integer');
errorMessageArray[ValidationType.HEX_RANGE] = $j.getInfo('range');
errorMessageArray[ValidationType.CUSTOM] = $j.getInfo('custom');

function ErrorFieldElement(fieldObj, fieldLabel, errorMessage) {
    this.fieldObj = fieldObj;
    this.fieldLabel = fieldLabel;
    this.errorMessage = errorMessage;

    this.toString = function toString(showFieldName) {
        return (showFieldName ?
            ((this.fieldLabel ? this.fieldLabel : this.fieldObj.name) + ': ') :
            '') + this.errorMessage;
    };
}

function validateRange(stringValue, min, max, base) {
    var value = parseInt(stringValue, base);
    if (isNaN(value) || (value < min || value > max)) {
        return false;
    }

    return true;
}

/* jshint unused: false */
function validateFields(fieldArray, errorMax) {
    var validate;
    var errorFieldArray = [];
    var args;
    var i;
    if (!errorMax) {
        errorMax = 1;
    }

    for (i = 0; i < fieldArray.length; i++) {
        validate = eval(fieldArray[i].getAttribute('validate'));
        if (!validate) {
            continue;
        }

        if (fieldArray[i].disabled) {
            continue;
        }
        if (errorFieldArray.length > errorMax - 1) {
            continue;
        }
        switch (validate) {
            case ValidationType.INTEGER:
                if (matchFieldExp(fieldArray[i].value,
                        [RegExpCommon.INTEGER]) < 0) {
                    errorFieldArray.push(new ErrorFieldElement(fieldArray[i],
                        fieldArray[i].getAttribute('fieldLabel'),
                        errorMessageArray[ValidationType.INTEGER]));
                }
                break;
            case ValidationType.HEX_INTEGER:
                if (matchFieldExp(fieldArray[i].value,
                        [RegExpCommon.HEX_INTEGER]) < 0) {
                    errorFieldArray.push(new ErrorFieldElement(fieldArray[i],
                        fieldArray[i].getAttribute('fieldLabel'),
                        errorMessageArray[ValidationType.HEX_INTEGER]));
                }
                break;
            case ValidationType.MAXLENGTH:
                args = eval(fieldArray[i].getAttribute('args'));
                if (fieldArray[i].value.length > args) {
                    errorFieldArray.push(new ErrorFieldElement(fieldArray[i],
                        fieldArray[i].getAttribute('fieldLabel'),
                        errorMessageArray[ValidationType.MAXLENGTH] +
                            ' ' + args + '.'));
                }
                break;
            case ValidationType.RANGE:
                if (matchFieldExp(fieldArray[i].value,
                        [RegExpCommon.INTEGER]) < 0) {
                    errorFieldArray.push(new ErrorFieldElement(fieldArray[i],
                        fieldArray[i].getAttribute('fieldLabel'),
                        errorMessageArray[ValidationType.INTEGER]));
                    break;
                }
                args = eval(fieldArray[i].getAttribute('args'));
                if (!validateRange(fieldArray[i].value, args[0], args[1])) {
                    errorFieldArray.push(new ErrorFieldElement(fieldArray[i],
                        fieldArray[i].getAttribute('fieldLabel'),
                        errorMessageArray[ValidationType.RANGE] + ' ' +
                            args[0] + ' - ' + args[1] + '.'));
                }
                break;
            case ValidationType.HEX_RANGE:
                if (matchFieldExp(fieldArray[i].value,
                        [RegExpCommon.HEX_INTEGER]) < 0) {
                    errorFieldArray.push(new ErrorFieldElement(fieldArray[i],
                        fieldArray[i].getAttribute('fieldLabel'),
                        errorMessageArray[ValidationType.HEX_INTEGER]));
                    break;
                }
                args = eval(fieldArray[i].getAttribute('args'));
                if (!validateRange(fieldArray[i].value, args[0], args[1], 16)) {
                    errorFieldArray.push(new ErrorFieldElement(fieldArray[i],
                        fieldArray[i].getAttribute('fieldLabel'),
                        errorMessageArray[ValidationType.HEX_RANGE] +
                            ' 0x' + args[0].toString(16) + ' - 0x' +
                            args[1].toString(16) + '.'));
                }
                break;
            case ValidationType.PORT:
                if (matchFieldExp(fieldArray[i].value,
                        [RegExpCommon.INTEGER]) < 0) {
                    errorFieldArray.push(new ErrorFieldElement(fieldArray[i],
                        fieldArray[i].getAttribute('fieldLabel'),
                        errorMessageArray[ValidationType.INTEGER]));
                    break;
                }
                if (!validateRange(fieldArray[i].value, 0, 65535)) {
                    errorFieldArray.push(new ErrorFieldElement(fieldArray[i],
                        fieldArray[i].getAttribute('fieldLabel'),
                        errorMessageArray[ValidationType.PORT]));
                }
                break;
            case ValidationType.PORT1:
                if (matchFieldExp(fieldArray[i].value,
                        [RegExpCommon.INTEGER]) < 0) {
                    errorFieldArray.push(new ErrorFieldElement(fieldArray[i],
                        fieldArray[i].getAttribute('fieldLabel'),
                        errorMessageArray[ValidationType.INTEGER]));
                    break;
                }
                if (!validateRange(fieldArray[i].value, 1, 65535)) {
                    errorFieldArray.push(new ErrorFieldElement(fieldArray[i],
                        fieldArray[i].getAttribute('fieldLabel'),
                        errorMessageArray[ValidationType.PORT1]));
                }
                break;
            case ValidationType.PROTOCOL:
                if (matchFieldExp(fieldArray[i].value,
                        [RegExpCommon.INTEGER]) < 0) {
                    errorFieldArray.push(new ErrorFieldElement(fieldArray[i],
                        fieldArray[i].getAttribute('fieldLabel'),
                        errorMessageArray[ValidationType.INTEGER]));
                    break;
                }
                if (!validateRange(fieldArray[i].value, 0, 255)) {
                    errorFieldArray.push(new ErrorFieldElement(fieldArray[i],
                        fieldArray[i].getAttribute('fieldLabel'),
                        errorMessageArray[ValidationType.PROTOCOL]));
                }
                break;
            case ValidationType.IP_HOST:
                args = eval(fieldArray[i].getAttribute('args'));
                if (Number(args) === 0 && fieldArray[i].value === '') {
                    break;
                }
                if (matchFieldExp(fieldArray[i].value,
                        [RegExpCommon.IP_HOST]) < 0) {
                    errorFieldArray.push(new ErrorFieldElement(fieldArray[i],
                        fieldArray[i].getAttribute('fieldLabel'),
                        errorMessageArray[ValidationType.IP_HOST]));
                }
                break;
            case ValidationType.IP_HOST1:
                var ipNum = ipStrToNum(fieldArray[i].value);
                args = eval(fieldArray[i].getAttribute('args'));
                if (Number(args) === 0 && fieldArray[i].value === '') {
                    break;
                }
                if (matchFieldExp(fieldArray[i].value,
                        [RegExpCommon.IP_HOST]) < 0 || ipNum === 0 ||
                            ipNum === Math.pow(2, 32)) {
                    errorFieldArray.push(new ErrorFieldElement(fieldArray[i],
                        fieldArray[i].getAttribute('fieldLabel'),
                        errorMessageArray[ValidationType.IP_HOST]));
                }
                break;
            case ValidationType.IP_SUBNET:
                if (matchFieldExp(fieldArray[i].value,
                        [RegExpCommon.IP_SUBNET]) < 0) {
                    errorFieldArray.push(new ErrorFieldElement(fieldArray[i],
                            fieldArray[i].getAttribute('fieldLabel'),
                            errorMessageArray[ValidationType.IP_SUBNET]));
                }
                break;
            case ValidationType.REGEXP:
                args = eval(fieldArray[i].getAttribute('args'));
                if (matchFieldExp(fieldArray[i].value, args) < 0) {
                    errorFieldArray.push(new ErrorFieldElement(fieldArray[i],
                        fieldArray[i].getAttribute('fieldLabel'),
                        errorMessageArray[ValidationType.REGEXP] + ' ' +
                            args[0].source));
                }
                break;
            case ValidationType.XSS:
                if (matchFieldExp(fieldArray[i].value,
                        [RegExpCommon.XSS]) < 0) {
                    errorFieldArray.push(new ErrorFieldElement(fieldArray[i],
                        fieldArray[i].getAttribute('fieldLabel'),
                        errorMessageArray[ValidationType.XSS]));
                }
                break;
            case ValidationType.CUSTOM:
                args = eval(fieldArray[i].getAttribute('args'));
                if (matchFieldExp(fieldArray[i].value, args[0]) < 0) {
                    errorFieldArray.push(new ErrorFieldElement(fieldArray[i],
                        fieldArray[i].getAttribute('fieldLabel'),
                        args[1] ? args[1] :
                            (errorMessageArray[ValidationType.CUSTOM] + ' ' +
                                args[0].source)));
                }
                break;
        }
    }

    switch (errorFieldArray.length) {
        case 0:
            break;
        case 1:
            var errorbuf = '';
            errorbuf += errorFieldArray[0].toString(false);
            alert(errorbuf);
            if (getParentProperty(errorFieldArray[0].fieldObj, 'style.display',
                    /^none$/).length > 0) {
                break;
            }
            errorFieldArray[0].fieldObj.focus();
            errorFieldArray[0].fieldObj.select();
            break;
        default:
            for (i = 0; i < errorFieldArray.length; i++) {
                errorbuf += errorFieldArray[i].toString(true);
                errorbuf += '\n';
            }
            alert(errorbuf);
            if (getParentProperty(errorFieldArray[0].fieldObj, 'style.display',
                    /^none$/).length > 0) {
                break;
            }
            errorFieldArray[0].fieldObj.focus();
            errorFieldArray[0].fieldObj.select();
    }

    return errorFieldArray.length;
}
