var MAX_FRAG_TIME = 150
  , FOCUSABLE_ROW_TABINDEX = 1e4
  , QLIST_EVT_NS = ".qlist-internal";
!function($) {
    "use strict";
    function qlist_append_row(table, item, hide_cb) {
        var checkbox = $('<input type="checkbox" class="qlist_cb" />');
        "undefined" == typeof hide_cb && (hide_cb = !1),
        hide_cb === !1 && $("<td></td>").prependTo(item),
        $("td:first-child", item).prepend(checkbox),
        checkbox.toggle(hide_cb === !1),
        $(item).addClass("qlist_row").appendTo(table)
    }
    function _ext_resolve_config(parent, path) {
        var current, i, parts = path.split("."), _len = parts.length;
        for (i = 0; _len > i; i++)
            current = parts[i],
            null == parent[current] && (parent[current] = {}),
            parent = parent[current];
        return parent
    }
    function _ext_calculate_dependancies() {
        function visit(cur, dependents) {
            visited[cur] || (dependents.push(cur),
            visited[cur] = !0,
            $.each(graph[cur], function(i, dependancy) {
                if ($.inArray(dependancy, dependents) >= 0)
                    throw new Error("Circular dependancy found on " + dependancy);
                visited[dependancy] || visit(dependancy, dependents.slice(0))
            }),
            ext_dependency_cache_order.push(cur),
            ext_dependency_cache_keys[cur] = !0)
        }
        var key, graph, visited, dirty = !1;
        for (key in $.qlist.ext)
            if ($.qlist.ext.hasOwnProperty(key) && !ext_dependency_cache_keys.hasOwnProperty(key)) {
                dirty = !0;
                break
            }
        if (!dirty)
            return ext_dependency_cache_order;
        ext_dependency_cache_keys = {},
        ext_dependency_cache_order = [],
        graph = {},
        visited = {};
        for (key in $.qlist.ext)
            $.qlist.ext.hasOwnProperty(key) && (graph[key] = [],
            $.qlist.ext[key].depends && $.merge(graph[key], $.qlist.ext[key].depends));
        for (key in graph)
            graph.hasOwnProperty(key) && visit(key, []);
        return ext_dependency_cache_order
    }
    function _ext_check_dependancies() {
        var key, depends, i;
        for (key in $.qlist.ext)
            if ($.qlist.ext.hasOwnProperty(key))
                for (depends = $.qlist.ext[key].depends || [],
                i = 0; i < depends.length; ++i)
                    if (!$.qlist.ext.hasOwnProperty(depends[i]))
                        throw new Error("Missing dependancy for " + key + ": " + depends[i])
    }
    function _ext_extend_defaults(defaults) {
        _ext_check_dependancies(),
        _ext_calculate_dependancies(),
        $.each(ext_dependency_cache_order, function(i, ext) {
            var _ref = $.qlist.ext[ext];
            if (null != _ref.defaults && $.extend(_ext_resolve_config(defaults, _ref.config_path), _ref.defaults),
            null != _ref.core_defaults) {
                var options = $.extend({}, defaults.options, _ref.core_defaults.options);
                $.extend(defaults, _ref.core_defaults),
                defaults.options = options
            }
        })
    }
    function _ext_handle_commands(command_name, that, internal_core, args) {
        var rval = NOT_CALLED
          , state = internal_core.state;
        return $.each(ext_dependency_cache_order, function(i, ext) {
            var cmd_fn, local_internal_core, _ref = $.qlist.ext[ext];
            return local_internal_core = $.extend({
                $self: null != state ? state[ext] : !1
            }, internal_core),
            null != _ref.commands && $.isFunction(cmd_fn = _ref.commands[command_name]) ? (rval = cmd_fn.apply(_ref, $.merge([that, local_internal_core || {}], $.makeArray(args).slice(1))),
            !1) : void 0
        }),
        rval
    }
    function _ext_is_managed_enabled(ext, exts, config) {
        if (!ext.managed)
            return !0;
        if (!(null == ext.enabled_config_path ? _ext_resolve_config(config, ext.config_path).enabled : _ext_resolve_config(config, ext.enabled_config_path)))
            return !1;
        var enabled = !0;
        return "auto" === ext.managed && $.each(ext.depends, function(i, dependancy) {
            return _ext_is_managed_enabled(exts[dependancy], exts, config) ? void 0 : (enabled = !1,
            !1)
        }),
        enabled
    }
    function _ext_call(name, that, internal) {
        var __slice = [].slice
          , _args = arguments;
        internal = {
            core: internal || {}
        };
        var state = internal.core.state;
        $.each(ext_dependency_cache_order, function(i, ext) {
            var result, local_internal, _ref = $.qlist.ext[ext];
            _ext_is_managed_enabled(_ref, $.qlist.ext, internal.core.config) && $.isFunction(_ref[name]) && (local_internal = $.extend({
                $self: null != state ? state[ext] : !1
            }, internal),
            result = internal[ext] = _ref[name].apply(_ref, [that, local_internal].concat(__slice.call(_args, 3))),
            result instanceof _ref.constructor && null != state && (state[ext] = result))
        })
    }
    function _ext_decorate_fn(name, that, internal_core, fn) {
        var __slice = [].slice
          , _args = arguments;
        return $.each(ext_dependency_cache_order, function(i, ext) {
            var _ref = $.qlist.ext[ext];
            _ext_is_managed_enabled(_ref, $.qlist.ext, internal_core.config) && $.isFunction(_ref[name]) && (fn = _ref[name].apply(_ref, __slice.call(_args, 1)),
            _args[3] = fn)
        }),
        fn
    }
    $.qlist || ($.qlist = {
        format_fn: {}
    });
    var qlist, get_urlparam_once = fweb.util.dom.getURIParamOnce, try_JSON_parse = fweb.util.dom.try_JSON_parse, render_template = fweb.util.dom.renderTemplate;
    $.fn.qlist = function(parameters, value) {
        function refresh_qlist() {
            adjust_all_tables()
        }
        function save_page() {
            if (config.paging.enabled) {
                var page_no = $(that).find(".page_current").val();
                localStorage && +page_no && localStorage.setItem(config.prefix + "/current_page", page_no)
            }
        }
        function reload_page() {
            that.find(".current-page").trigger("change", !0)
        }
        function add_filter(arr, flt, overwrite) {
            for (var col, i = 0; col = arr[i]; i++)
                if (col.id === flt.id)
                    return overwrite && (arr[i] = flt),
                    arr;
            return arr.push(flt),
            arr
        }
        function filterSubmit(panel, event) {
            var validateResult, err = !1, flt_arr = [];
            return panel.filterSection(function(oflt, flt) {
                return validateResult = flt.validate.call(this, oflt),
                (err = !validateResult) ? !1 : (oflt.logic.is = flt.is,
                void (oflt.value && oflt.value.join("") && (flt_arr = add_filter(flt_arr, oflt))))
            }),
            err || apply_filter(flt_arr),
            !1
        }
        function reset_columns() {
            removeCookie(config.ck_name.column),
            config.chosen_columns = config.default_columns;
            var filter = get_filter_settings()
              , wasFiltered = filter && filter.length > 0;
            removeCookie(config.ck_name.filter),
            that.trigger("reset_columns"),
            config.column_filters.enabled && wasFiltered && $.isFunction(config.column_filters.server_side_reload) ? config.column_filters.server_side_reload() : $(that).qlist("reload")
        }
        function update_chosen_columns(chosen) {
            if (chosen.join(",") !== config.chosen_columns.join(",")) {
                config.chosen_columns = chosen,
                chosen.length && setCookie(config.ck_name.column, chosen.join(","));
                var fltarr = get_filter_settings()
                  , newflt = $.grep(fltarr, function(flt) {
                    return $.inArray(flt.id, chosen) >= 0
                });
                newflt.length !== fltarr.length ? apply_filter(newflt) : $(that).qlist("reload")
            }
        }
        function clear_filters() {
            var filter = get_filter_settings()
              , wasFiltered = filter && filter.length > 0;
            config.column_filters.value = [],
            removeCookie(config.ck_name.filter);
            var filters_cleared_event = $.Event("filters_cleared");
            that.trigger(filters_cleared_event),
            config.column_filters.enabled && wasFiltered && $.isFunction(config.column_filters.server_side_reload) ? config.column_filters.server_side_reload() : $(that).qlist("reload")
        }
        function clear_selection() {
            var $qlist = $(that)
              , state = $qlist.data("qlist_state");
            $qlist.find("tr.selected").removeClass("selected"),
            state && state.selected_rows && (state.selected_rows = [])
        }
        function apply_filter(flt_arr) {
            config.column_filters.value = flt_arr,
            setCookie(config.ck_name.filter, flt_arr.length ? JSON.stringify(flt_arr) : "");
            var filter_applied_event = $.Event("filter_applied");
            that.trigger(filter_applied_event, [flt_arr]),
            config.paging.server_side && !config.column_filters.force_client_side ? $.isFunction(config.column_filters.server_side_reload) ? config.column_filters.server_side_reload() : window.location.reload() : $(that).qlist()
        }
        function find_row_indices(config, to_match) {
            function is_matched(entry, to_match) {
                var match_keys, match_obj, j, k, key, value, all_keys_matched, match = !1, to_matches = Array.isArray(to_match) ? to_match : [to_match];
                for (j = 0; j < to_matches.length; j++) {
                    for (match_obj = to_matches[j],
                    match_keys = Object.keys(match_obj),
                    all_keys_matched = !0,
                    k = 0; k < match_keys.length; k++)
                        if (key = match_keys[k],
                        value = match_obj[key],
                        entry[key] !== value) {
                            all_keys_matched = !1;
                            break
                        }
                    if (all_keys_matched) {
                        match = !0;
                        break
                    }
                }
                return match
            }
            var i, entry, indices = [], source = config.source, length = source.length;
            for (i = 0; length > i; i++)
                entry = source[i],
                is_matched(entry, to_match) && (entry[located_row_id] = !0,
                indices.push(i));
            return indices
        }
        function get_filter_settings() {
            if (config.column_filters.value)
                return config.column_filters.value;
            var paramFilter = get_urlparam_once("filter")
              , flt_arr = try_JSON_parse(getCookie(config.ck_name.filter) || "[]") || [];
            return "undefined" != typeof paramFilter && "undefined" != typeof (paramFilter = try_JSON_parse(paramFilter)) && (flt_arr = add_filter(flt_arr, $.extend({
                logic: {},
                value: []
            }, paramFilter), !0),
            setCookie(config.ck_name.filter, JSON.stringify(flt_arr))),
            flt_arr
        }
        function setup_filtering(table) {
            config.column_filters.enabled && filterSetup(table)
        }
        function filterSetup(tableId) {
            var dfd = new jQuery.Deferred;
            "undefined" == typeof filterLoadResource ? dfd = $.addScript({
                url: "/" + fweb.CONFIG_GUI_NO + "/module_js/filter.js"
            }) : dfd.resolve().promise(),
            dfd.done(function() {
                filterLoadResource(),
                $(tableId).filterConsole({
                    columns: get_filter_columns(),
                    filters: get_filter_settings(),
                    action: filterSubmit,
                    targetSelector: "th span.filter"
                })
            })
        }
        function get_selected_rows() {
            var state = that.data("qlist_state")
              , selected = state.selected_rows;
            return selected || (selected = state.selected_rows = []),
            selected
        }
        function set_selected_rows(rows) {
            var state = that.data("qlist_state");
            state && (state.selected_rows = rows)
        }
        function sort_columns(chosen) {
            function sort_string(col) {
                return "lang_key"in col && null !== col.lang_key ? $.getInfo(col.lang_key) : col.selector
            }
            config.columns.sort(function(a, b) {
                var i = $.inArray(a.selector, chosen)
                  , j = $.inArray(b.selector, chosen);
                return i !== j ? 0 > i ? 1 : 0 > j ? -1 : i - j : $.sortCompareText(sort_string(a), sort_string(b))
            })
        }
        function get_column_value(td, selector, entry, searchMatch) {
            var fmt = config.format_fn[selector] || config.format_fn["*"] || entry[selector];
            return $.isFunction(fmt) && (fmt = fmt(td, config.column_map[selector] || selector, entry, config.$scope, searchMatch)),
            "undefined" == typeof fmt ? entry[selector] : fmt
        }
        function default_filter_fn(flt, entry) {
            var test = !1
              , val = get_column_value(null, flt.id, entry)
              , fld = config.column_map[flt.id];
            if (null == fld)
                return !0;
            if ("datetime" === fld.fld_type && flt.logic.RANGE && flt.value && 2 === flt.value.length) {
                var from_date = Date.parse(flt.value[0].replace(/-/g, "/")) / 1e3
                  , to_date = Date.parse(flt.value[1].replace(/-/g, "/")) / 1e3
                  , entry_date = entry[flt.id];
                return entry_date >= from_date && (!flt.value[1] || to_date >= entry_date)
            }
            var is_selection = !!fld.value;
            return Array.isArray(val) ? $(val).each(function(i, value) {
                return test = __filter_inArray(value, flt, is_selection) >= 0,
                !test
            }) : test = __filter_inArray(val, flt, is_selection) >= 0,
            test
        }
        function __filter_inArray(value, flt, is_selection) {
            var arr = Array.isArray(flt.value) ? flt.value : [flt.value];
            if (flt.logic.RANGE && 2 === arr.length)
                return "int" === config.column_map[flt.id].fld_type ? "" === value ? -1 : (value = +_filter_digit_regex.exec(value)[0],
                flt.logic.RANGE_EXCLUSIVE ? (value > +arr[0] && ("" === arr[1] || value < +arr[1])) - 1 : (value >= +arr[0] && ("" === arr[1] || value <= +arr[1])) - 1) : flt.logic.RANGE_EXCLUSIVE ? value > arr[0] && ("" === arr[1] || value < arr[1]) ? 1 : -1 : value >= arr[0] && ("" === arr[1] || value <= arr[1]) ? 1 : -1;
            var isString = !is_selection && "string" === $.type(value);
            isString && (value = value.toLowerCase());
            for (var i = arr.length; i--; ) {
                var item = arr[i];
                if (isString) {
                    if (fweb.util.patterns.htmlStringContains(value, item.toString().toLowerCase()))
                        return i
                } else {
                    if ($.isPlainObject(value))
                        for (var k in value)
                            if (value.hasOwnProperty(k)) {
                                if ("string" === $.type(value[k]) && -1 !== value[k].toLowerCase().indexOf(item.toString().toLowerCase()))
                                    return i;
                                if ($.isPlainObject(value[k]) && __filter_inArray(value[k], flt, is_selection) >= 0)
                                    return i
                            }
                    if (String(value) === item)
                        return i
                }
            }
            return -1
        }
        function default_filter(entry, filters) {
            for (var flt, flt_arr = filters || get_filter_settings(), i = 0; flt = flt_arr[i]; i++) {
                var flt_fn = config.filter_fn[flt.id] || config.filter_fn["*"] || default_filter_fn
                  , ret = flt_fn(flt, entry);
                if ("0" === flt.logic.NOT && fweb.log("flt.logic.NOT has invalid value '0', please check."),
                ret === (!!flt.logic.NOT || !1))
                    return !1
            }
        }
        function default_compare(a, b) {
            for (var selector, i = 0; selector = this[i]; i++) {
                var va = get_column_value(null, selector, a)
                  , vb = get_column_value(null, selector, b);
                if (va !== vb)
                    return va > vb ? 1 : -1
            }
            return 0
        }
        function default_ondrop(to, from, nearby) {
            var before, after, qlist_source = config.source, obj = qlist_source[to];
            if (to > from) {
                do
                    after = qlist_source[--to].q_origin_key;
                while (!after)
            } else
                do
                    before = qlist_source[++to].q_origin_key;
                while (!before);if (obj.q_path && obj.q_name) {
                var move_url = "/api/v2/cmdb/" + obj.q_path + "/" + obj.q_name + "/" + obj.q_origin_key + "?action=move&" + (after ? "after=" + after : "before=" + before);
                $.ajax({
                    url: move_url,
                    method: "PUT"
                }).done(function() {
                    config.reordering.refresh_on_drop ? $(that).qlist("reload", !1) : $.isFunction(config.callbacks.post_reorder) && config.callbacks.post_reorder.call(that[0], qlist),
                    Notify.post($.getInfo("changes_saved"), "success"),
                    $(config.reordering.items).each(function(i) {
                        var even = i % 2;
                        $(this).toggleClass("odd", !!even)
                    })
                }).error(function(response) {
                    Notify.post($.getInfo(response.status), "error")
                })
            }
        }
        function sort_categories() {
            var sort_fn = config.sort_categories_fn
              , implicit_category = $.getInfo("implicit")
              , map = config.categories.length ? config.categories_map : {}
              , category_list = (Object.keys || function(map) {
                return $.map(map, function(val, key) {
                    return key
                })
            }
            )(map);
            category_list.sort(function(a, b) {
                return a === implicit_category ? 1 : b === implicit_category ? -1 : sort_fn(a, b)
            });
            var new_map = config.categories_map = {};
            $(category_list).each(function(i, x) {
                new_map[x] = map[x]
            })
        }
        function sort_sections(source) {
            var sort_fn = config.sort_sections_fn;
            $.isFunction(sort_fn) && source.sort(function(a, b) {
                return a.implicit ? 1 : b.implicit ? -1 : sort_fn.call(config.sections, a, b)
            })
        }
        function get_category(index) {
            var cat_name = null;
            return $.each(config.categories_map || {}, function(key, arr) {
                return index < arr.length ? (cat_name = key,
                !1) : void (index -= arr.length)
            }),
            cat_name
        }
        function get_section(entry) {
            function get_labels(cols, entry) {
                for (var labels = [], i = 0; i < cols.length; i++) {
                    var label = get_column_value(null, cols[i], entry);
                    void 0 !== label && labels.push(label)
                }
                return labels
            }
            return get_labels(config.sections, entry).join(" - ")
        }
        function section_has_widget(sections_with_widgets, entry) {
            for (var i = 0; i < sections_with_widgets.length; ++i) {
                var section = sections_with_widgets[i]
                  , section_val = get_column_value(null, section, entry);
                if (void 0 !== section_val)
                    return !0
            }
            return !1
        }
        function sort_source(source) {
            function cat_add(label, entry) {
                for (var x in map)
                    if (map.hasOwnProperty(x)) {
                        if (!label && $.inArray(entry, map[x]) >= 0)
                            continue;
                        if (0 !== sort_fn.call(cats, owner[x], entry))
                            continue;
                        label ? map[x].push(entry) : map[x].unshift(entry)
                    }
                label && !map[label] && (owner[label] = entry,
                map[label] = [entry])
            }
            function cats_label(vals) {
                return vals.join(" - ")
            }
            var k, entry, sort_fn = config.sort_compare, cats = config.categories, map = config.categories_map = {}, owner = {};
            for (k = 0,
            entry; entry = source[k]; k++) {
                var vals = [];
                if ("category"in entry && "string" == typeof entry.category)
                    cat_add(entry.category, entry);
                else {
                    for (var i = 0; i < cats.length; i++)
                        vals.push(get_column_value(null, cats[i], entry));
                    cat_add(cats_label(vals), entry)
                }
            }
            for (k = source.length - 2; k >= 0; k--)
                cat_add(null, source[k]);
            $.isFunction(config.sort_categories_fn) && sort_categories(),
            source.length = 0,
            $.each(config.categories_map, function(key, arr) {
                config.sections.length && sort_sections(arr),
                $.merge(source, arr)
            })
        }
        function get_filter_columns() {
            function default_fld_type(col) {
                return "number" == typeof col.fld_type ? col.fld_type : col.values ? FIELD_TYPE.ENUM : FIELD_TYPE.STRING
            }
            var dict = {
                "int": FIELD_TYPE.INTEGER,
                date: FIELD_TYPE.DATE,
                datetime: FIELD_TYPE.DATE_TIME,
                ip: FIELD_TYPE.IP_HOST
            }
              , column_objs = $.map(config.chosen_columns, function(selector) {
                var col = config.column_map[selector];
                if (null == col)
                    return setFilterDetails({
                        key: selector
                    });
                var flt = {
                    key: selector,
                    label: "lang_key"in col && null !== col.lang_key ? $.getInfo(col.lang_key) : f_icon_html(col.icon),
                    selection: col.values
                };
                return col.filter && (flt.validate = col.filter.validate,
                flt.display = col.filter.display,
                flt.support = col.filter.support,
                flt.help = col.filter.help),
                setFilterDetails(flt, dict[col.fld_type] || default_fld_type(col), col.fld_max || DISPLAY_FILTER_TYPE_SELECT_MULTIPLE),
                flt
            });
            return filter_settings[config.prefix] = column_objs,
            column_objs
        }
        function update_controls(current_page, total_pages) {
            var $this = $(this);
            null == current_page && (current_page = $this.find(".current-page").val()),
            null == total_pages && (total_pages = $this.find(".total-pages").text()),
            current_page = +current_page,
            total_pages = +total_pages;
            var $first = $this.find(".first-page")
              , $prev = $this.find(".previous-page")
              , $next = $this.find(".next-page")
              , $last = $this.find(".last-page")
              , enable_back = current_page > 1
              , enable_forward = total_pages > current_page;
            $first.prop("disabled", !enable_back),
            $prev.prop("disabled", !enable_back),
            $next.prop("disabled", !enable_forward),
            $last.prop("disabled", !enable_forward),
            config.paging.last_page_button || ($last.hide(),
            $this.find(".show-more-less").toggle(enable_forward)),
            $this.find(".current-page").val(total_pages ? current_page || 1 : 0).prop({
                disabled: 0 >= total_pages,
                max: total_pages
            })
	    // only_show_total will hide buttons in paging, just new added for fortiview first/second level list
	    if(config.paging.only_show_total){
		    $first.hide(),$prev.hide(),$next.hide(),$last.hide();
		    $this.find('.current-page').hide();
		    $this.find('.of-pages').hide();
		    $this.find('.total-pages').hide();
		    $this.height(31);
	    }
        }
        function append_rows(tbody, begin, len) {
            load_rows(tbody, len, begin).done(function() {
                $.isFunction(config.callbacks.post_paging) && config.callbacks.post_paging.call(that[0], that[0]);
                that.qlist("refresh");//FWB_CHANGE To fix bug 0444188
            })
        }
        function goto_page(page_num, total_pages, one_page, fetcher, $loading) {
            return page_num = Number(page_num),
            1 > page_num || page_num > total_pages && !config.paging._unknown_pagecount ? void ($loading && $loading.remove()) : (current_page_num = page_num,
            total_pages = Number(total_pages),
            this.find(".current-page").enable(total_pages > 0).val(total_pages >= page_num ? page_num : total_pages),
            update_controls.call(this, page_num, total_pages),
            $.isFunction(config.callbacks.pre_paging) && config.callbacks.pre_paging.call(that[0]),
            void fetcher(page_num))
        }
        function get_complete_filter_fn(that, config, state) {
            var column_filter_fn, decorated_filter_fn, dummy_filter_fn;
            return dummy_filter_fn = function() {
                return !0
            }
            ,
            column_filter_fn = config.column_filters.enabled ? config.column_filters.filter_fn : dummy_filter_fn,
            decorated_filter_fn = _ext_decorate_fn("get_filter_fn", that, {
                config: config,
                state: state,
                fn: _ext_internal_functions
            }, column_filter_fn),
            decorated_filter_fn === dummy_filter_fn ? null : decorated_filter_fn
        }
        function get_entry_cache(entry) {
            var cid = entry._cache_id || (entry._cache_id = "xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g, function(c) {
                var r = 16 * Math.random() | 0
                  , v = "x" === c ? r : 3 & r | 8;
                return v.toString(16)
            }));
            return state.cache.source[cid] || (state.cache.source[cid] = {})
        }
        function is_filtered(entry, flt_fn, col_flt_fn, flt_arr) {
            var cache = get_entry_cache(entry)
              , filtered = cache.filtered;
            return void 0 !== filtered ? filtered : ($.isPlainObject(entry.expansion) ? filtered = get_entry_cache(entry.expansion).filtered : (filtered = !1,
            !filtered && $.isFunction(flt_fn) && (filtered = flt_fn(entry, flt_arr) === !1),
            !filtered && $.isFunction(col_flt_fn) && (filtered = col_flt_fn(entry, flt_arr) === !1)),
            cache.filtered = filtered)
        }
        function get_filtered_lines(col_flt_fn, filters) {
            if (void 0 !== state.cache.filtered_lines)
                return state.cache.filtered_lines;
            var flt_fn = config.filter;
            if (!col_flt_fn && !flt_fn)
                return state.cache.filtered_lines = config.source.length;
            for (var entry, l = 0, flt_arr = filters || get_filter_settings(), i = 0; entry = config.source[i]; i++)
                is_filtered(entry, flt_fn, col_flt_fn, flt_arr) || l++;
            return state.cache.filtered_lines = l
        }
        function src_index(i) {
            return state.display_master.length > i ? state.display_master[i] : i
        }
        function get_filtered_index(index, flt_fn, col_flt_fn, flt_arr) {
            for (var entry, n = 0, i = 0; entry = config.source[src_index(i)]; i++)
                if (!is_filtered(entry, flt_fn, col_flt_fn, flt_arr)) {
                    if (n === index)
                        return i;
                    n++
                }
            return n
        }
        function client_paged_rows(tbody, $qlist_container) {
            function fetcher(page_num, cb) {
                var begin = (page_num - 1) * one_page;
                tbody.empty(),
                (cb || append_rows)(tbody, begin, one_page),
                adjust_table(table)
            }
            var that = $qlist_container
              , table = tbody.parent()
              , one_page = config.paging.page_lines;
            if (config.paging.total_lines > 0 && config.paging.total_lines === config.paging.page_lines)
                return load_rows(tbody, one_page, void 0, $qlist_container);
            var total_lines = config.source.length;
            return locate_row_search || (total_lines = get_filtered_lines(get_complete_filter_fn(that, config, state))),
            paged_rows(tbody, total_lines, one_page, fetcher)
        }
        function page_completed() {
            return "undefined" == typeof config.paging.completed || config.paging.completed()
        }
        function server_paged_rows(tbody, $qlist_container) {
            function fetcher(page_num, cb) {
                var empty = !1;
                clearTimeout(config.timer),
                $(tbody).data("page_cur") !== page_num && ($(tbody).data("page_cur", page_num),
                config.paging.hybrid_server_paging || (config.source.length = 0),
                empty = !0),
                config.paging.fetch(page_num, function(data, begin) {
                    empty && (tbody.empty(),
                    tbody.scrollParent().scrollTop(0));
                    var i;
                    for (null == begin && (begin = config.source.length),
                    i = 0; data.source[i]; i++)
                        config.source[begin + i] = data.source[i];
                    config.paging.total_lines = data.total_lines;
                    var total_lines = data.total_lines
                      , total_pages = Math.ceil(total_lines / one_page);
                    $qlist_container.find(".total-pages").text(total_pages),
                    $qlist_container.find(".total-lines-total").text(total_lines),
                    update_controls.call($qlist_container, page_num, total_pages);
                    var render = cb || append_rows;
                    config.paging.hybrid_server_paging ? render(tbody, (page_num - 1) * one_page, one_page) : render(tbody, begin, i),
                    that.trigger("qlist.update"),
                    page_completed() || (config.timer = setTimeout(function() {
                        fetcher(page_num, cb)
                    }, config.paging.timeout))
                }, {
                    page_num: page_num,
                    source_length: config.source.length,
                    lines_per_page: one_page
                })
            }
            var one_page = config.paging.page_lines || config.source.length;
            page_completed() || (config.timer = setTimeout(fetcher, config.paging.timeout));
            var total_lines = config.paging.total_lines;
            return paged_rows(tbody, total_lines, one_page, fetcher)
        }
        function paged_rows(tbody, total_lines, one_page, fetcher) {
            function set_page_lines(mode) {
                "show_less" === mode && (one_page = total_lines)
            }
            function add_loading_indicator(tbody) {
                return tbody.find(".loading-container").remove(),
                $('<div class="loading-container flex-centered"><f-icon class="fa-loading icon-xxxl" ng-show="loading"></f-icon></div>').appendTo(tbody)
            }
            config.paging.mode && set_page_lines(config.paging.mode),
            located_row_index >= 0 && (current_page_num = Math.ceil(located_row_index / one_page) || 1);
            var total_pages = Math.ceil(total_lines / one_page)
              , $footer = that.find(".qlist-footer");
            $footer.length ? $footer.empty() : ($footer = $('<div class="qlist-footer"></div>'),
            that.append($footer)),
            $('<button type="button" class="first-page"><f-icon class="fa-angle-double-left"></f-icon></button>').attr("title", $.getInfo("page_first")).on("click", function() {
                var total = Number($footer.find(".total-pages").text())
                  , $loading = add_loading_indicator(tbody);
                goto_page.call($footer, 1, total, one_page, fetcher, $loading)
            }).appendTo($footer),
            $('<button type="button" class="previous-page"><f-icon class="fa-angle-left"></f-icon></button>').attr("title", $.getInfo("page_prev")).on("click", function() {
                var total = Number($footer.find(".total-pages").text())
                  , current = Number($footer.find(".current-page").val())
                  , $loading = add_loading_indicator(tbody);
                goto_page.call($footer, current - 1, total, one_page, fetcher, $loading)
            }).appendTo($footer);
            var $loading, do_change = $.debounce(500, function(force, $loading) {
                if (force || current_page_num !== parseInt(this.value)) {
                    current_page_num = null,
                    $(tbody).data("page_cur", null);
                    var total = Number($footer.find(".total-pages").text());
                    goto_page.call($footer, this.value, total, one_page, fetcher, $loading)
                }
            });
            $('<input type="number" class="bare current-page" />').prop({
                min: 1,
                max: total_pages,
                value: total_lines ? current_page_num : 0
            }).on("change", function(event, force) {
                force || current_page_num !== parseInt(this.value) ? (tbody.find(".loading-container").remove(),
                $loading = add_loading_indicator(tbody)) : tbody.find(".loading-container").remove(),
                do_change.call(this, force, $loading)
            }).on("keypress", function(e) {
                return 13 === e.keyCode ? ($(this).change(),
                !1) : void 0
            }).appendTo($footer);
            var next_button_disabled = one_page >= total_lines && page_completed()
              , unknown_pagecount = !config.paging.last_page_button && !next_button_disabled;
            config.paging._unknown_pagecount = unknown_pagecount,
            unknown_pagecount || $footer.append('<span class="of-pages">/</span>');
            var $total_pages = $('<span class="total-pages"></span>').text(total_pages).appendTo($footer);
            $total_pages.toggle(!unknown_pagecount),
            $('<button type="button" class="next-page"><f-icon class="fa-angle-right"></f-icon></button>').attr("title", $.getInfo("page_next")).on("click", function() {
                var total = Number($footer.find(".total-pages").text())
                  , current = Number($footer.find(".current-page").val())
                  , $loading = add_loading_indicator(tbody);
                goto_page.call($footer, current + 1, total, one_page, fetcher, $loading)
            }).appendTo($footer),
            config.paging.last_page_button && $('<button type="button" class="last-page"><f-icon class="fa-angle-double-right"></f-icon></button>').attr("title", $.getInfo("page_last")).on("click", function() {
                var total = Number($footer.find(".total-pages").text())
                  , $loading = add_loading_indicator(tbody);
                goto_page.call($footer, total, total, one_page, fetcher, $loading)
            }).appendTo($footer);
            var $total_entries = $('<span class="total-lines">[' + $.getInfo("total") + ': <span class="total-lines-total">' + total_lines + "</span>]</span>").appendTo($footer);
            if ($total_entries.toggle(!unknown_pagecount),
            (total_pages > 1 || config.paging.mode) && config.paging.show_all_button) {
                config.paging.mode = config.paging.mode || "show_more";
                var toggle_mode = function() {
                    var mode = config.paging.mode
                      , next_mode = "show_more";
                    mode === next_mode && ($footer.find(".current-page").val(1),
                    next_mode = "show_less"),
                    config.paging.mode = next_mode
                };
                $('<button class="bare show-more-less"></button>').text($.getInfo(config.paging.mode)).on("click", function() {
                    return toggle_mode(),
                    $(that).qlist("reload", !1),
                    !1
                }).appendTo($footer)
            }
            return update_controls.call($footer, current_page_num, total_pages),
            load_rows(tbody, one_page, (current_page_num - 1) * one_page)
        }
        function load_rows(tbody, len, from, $qlist_container) {
            function get_formatted_labels(cols, entry, td, opts) {
                opts = $.extend(opts || {}, {
                    separator: " - ",
                    wrap_selector: !1
                });
                for (var labels = config.options.atomic_render ? [] : $(), i = 0; i < cols.length; i++) {
                    var label = get_formatted_cell(td, opts.wrap_selector ? {
                        selector: cols[i]
                    } : cols[i], entry);
                    void 0 !== label && (config.options.atomic_render ? labels.push(label) : ("string" === $.type(label) && (label = $.parseHTML(label)),
                    labels = labels.add(label)))
                }
                return opts.separator !== !1 && (config.options.atomic_render ? labels = labels.join(opts.separator) : labels.not(":last").after(opts.separator)),
                labels
            }
            function add_category_num() {
                if (cat_tbody) {
                    var label = $("label", cat_tbody);
                    $.inArray("#", config.chosen_columns) >= 0 ? $(label).append(" (" + (rowIndex - catIndex + 1) + " - " + rowIndex + ")") : $(label).append(" (" + catIndex + ")")
                }
            }
            function add_section_num() {
                if (sec_row) {
                    var label = $("label", sec_row);
                    $.inArray("#", config.chosen_columns) >= 0 ? $(label).append(" (" + (secIndex + 1) + " - " + rowIndex + ")") : $(label).append(" (" + (rowIndex - secIndex) + ")"),
                    sec_row = void 0
                }
            }
            var fr = from || 0;
            if (!from && localStorage) {
                var num = +localStorage.getItem(config.prefix + "/current_page");
                num && $.isNumeric(len) && (localStorage.setItem(config.prefix + "/current_page", ""),
                fr = len * (num - 1),
                update_controls.call(tbody, num))
            }
            var tr, entry, cat_tbody, sec_row, rowIndex = 0, catIndex = 0, secIndex = 0, secExpand = !0, sort_fn = config.sort_compare, flt_fn = config.filter, flt_arr = get_filter_settings(), ck_cats = (getCookie(config.ck_name.category) || "").split(","), col_len = config.chosen_columns.length, done = $.Deferred(), that = $qlist_container || $(tbody).closest("div.qlist");
            located_row_index >= 0 && (ck_cats.push(get_category(located_row_index)),
            ck_cats.push(get_section(config.source[located_row_index]))),
            !config.sort || config.sort.fast_update === !1 || config.paging.enabled || null !== config.category.q_type && null != config.column_map.category ? state.fast_sort = void 0 : (state.fast_sort = [],
            state.fast_sort_target = tbody);
            var col_flt_fn = get_complete_filter_fn(that, config, state)
              , get_formatted_cell = _ext_decorate_fn("get_formatted_cell", that, {
                config: config,
                state: state,
                fn: _ext_internal_functions
            }, get_column_value)
              , get_formatted_category_header = _ext_decorate_fn("get_formatted_category_header", that, {
                config: config,
                state: state
            }, function(category_value) {
                return category_value
            });
            fr > 0 && !locate_row_search && (fr = get_filtered_index(fr, flt_fn, col_flt_fn, flt_arr));
            var category, row, td, row_widget, row_widget_td, i = fr, load_row_frag = function(last_i) {
                function gen_row(entry, i, rowIndex, isHidden) {
                    var source_i = src_index(i)
                      , local_after_format_queue = after_format_queue ? null : {}
                      , af_queue = local_after_format_queue || after_format_queue;
                    tr = document.createElement("tr"),
                    config.options.focusable_rows && ("number" == typeof config.options.focusable_rows ? tr.setAttribute("tabindex", config.options.focusable_rows) : tr.setAttribute("tabindex", FOCUSABLE_ROW_TABINDEX));
                    var tr_class = "qlist_row";
                    isHidden && (tr_class += " hidden"),
                    locate_row_search && entry[located_row_id] && (tr_class += " located_row"),
                    tbody.get(0).appendChild(tr),
                    tr.setAttribute("data-source-index", source_i),
                    state.fast_sort && (state.fast_sort[source_i] = $(tr)),
                    $(tr).data("regenerate", function(tr, data, context) {
                        var cls_name, new_context, is_hidden = $(tr).hasClass("hidden"), new_tr = gen_row(data, i, source_i, is_hidden);
                        return context && (cls_name = $(context).closest("td").attr("class"),
                        new_context = $(new_tr).find("." + cls_name)),
                        tr.replaceWith(new_tr),
                        {
                            row: new_tr,
                            context: new_context
                        }
                    }),
                    $.each(config.row_attr, function(i, attr) {
                        var _value = entry[attr.selector];
                        null != _value && tr.setAttribute(attr.name, "__index__" === attr.selector ? source_i : _value)
                    }),
                    tr.setAttribute("class", tr_class),
                    config.row_gen.call($(tr), fr + rowIndex, entry);
                    for (var val, selector, row_body = "", temp_td = document.createElement("td"), j = 0; selector = config.chosen_columns[j]; j++)
                        if (config.options.atomic_render) {
                            temp_td.setAttribute("class", selector),
                            temp_td.setAttribute("selector", selector),
                            temp_td.setAttribute("atomicSourceIndex", i),
                            val = get_formatted_cell($(temp_td), selector, entry);
                            var cell_body = '<td class="' + temp_td.getAttribute("class") + '">';
                            row_body += cell_body + val + "</td>"
                        } else {
                            if (td = $('<td class="' + selector + '"/>').attr("selector", selector).appendTo(tr),
                            val = get_formatted_cell(td, selector, entry),
                            td.append(val),
                            config.after_format_fn && selector in config.after_format_fn) {
                                var queue = af_queue[selector] = af_queue[selector] || [];
                                queue.push(td[0])
                            }
                            config.custom_cols && -1 !== config.custom_cols.indexOf(selector) && config.col_gen(td, entry, selector, rowIndex, tr)
                        }
                    return config.options.atomic_render && (tr.innerHTML = row_body),
                    do_after_format(local_after_format_queue),
                    $(tr)
                }
                function do_after_format(queue) {
                    if (null !== queue)
                        for (var selector in queue) {
                            var fn = config.after_format_fn[selector];
                            fn && fn(queue[selector])
                        }
                }
                function load_row_fragment_event(source_i) {
                    return function() {
                        load_row_frag(source_i)
                    }
                }
                var source_i, collapse_enabled, frag_start = Date.now(), filtered_lines = 0, after_format_queue = null;
                for (_ext_call("load_row_frag", that, {
                    config: config,
                    state: state,
                    tbody: tbody,
                    fn: _ext_internal_functions
                }),
                after_format_queue = {}; entry = config.source[source_i = src_index(i)]; i++)
                    if (locate_row_search || !is_filtered(entry, flt_fn, col_flt_fn, flt_arr)) {
                        if (category = get_category(source_i),
                        category && (i === fr || category !== get_category(last_i))) {
                            state.fast_sort = void 0;
                            var tbody_parent = tbody.parent();
                            i !== fr ? (config.options.add_section_num && add_section_num(),
                            config.options.add_category_num && add_category_num(),
                            catIndex = 0,
                            cat_tbody = $("<tbody/>").appendTo(tbody_parent)) : cat_tbody = tbody,
                            tbody = $("<tbody/>").appendTo(tbody_parent),
                            cat_tbody.addClass("category").data("category", category),
                            row = $('<tr class="qlist_category"/>').appendTo(cat_tbody),
                            td = $('<td class="left" colspan="' + col_len + '"/>').appendTo(row),
                            collapse_enabled = void 0 !== typeof config.options.collapsible_categories[category] && config.options.collapsible_categories[category] || config.options.collapsible_categories["*"];
                            var exp = !collapse_enabled || $.inArray(category, ck_cats) >= 0
                              , formatted_category = get_formatted_category_header(category, source_i);
                            td.append('<label class="visual-toggle-label ' + (collapse_enabled ? 'collapsible"><button type="button" class="compact-visual-toggle' + (exp ? " active" : "") + '"></button> ' : '">') + formatted_category + "</label>"),
                            tbody.toggleClass("hidden", !exp),
                            secExpand = !0
                        }
                        if (!catIndex || 0 !== sort_fn.call(config.sections, entry, config.source[last_i])) {
                            state.fast_sort = void 0,
                            config.options.add_section_num && add_section_num();
                            var section = get_section(entry)
                              , has_widget = section_has_widget(config.section_widgets, entry);
                            if (section) {
                                row = $('<tr class="qlist_section" />').data("section", section).data("sectionFirstIndex", i);
                                for (var s = 0; s < config.section_attr.length; s++) {
                                    var attr = config.section_attr[s];
                                    row.attr(attr.name, entry[attr.selector] || "")
                                }
                                has_widget ? (row_widget = $('<tr class="qlist_section_widget unselectable" />'),
                                row_widget_td = $('<td class="left" colspan="' + col_len + '"><div class="qlist_widget_content"></div></td>'),
                                row_widget_td.appendTo(row_widget),
                                row_widget.attr("section", section),
                                row.add(row_widget).appendTo(tbody)) : row.appendTo(tbody),
                                config.options.editable_sections && (row.attr("mkey", entry[config.sections[0]]),
                                row.attr("can_delete", 0)),
                                td = $('<td class="left" colspan="' + col_len + '"/>').appendTo(row),
                                collapse_enabled = void 0 !== typeof config.options.collapsible_sections[section] && config.options.collapsible_sections[category] || config.options.collapsible_sections["*"],
                                secExpand = !collapse_enabled || $.inArray(section, ck_cats) >= 0,
                                row_widget && row_widget.toggleClass("hidden", !secExpand);
                                var formatted_section = get_formatted_labels(config.sections, entry, td)
                                  , section_row_gen = config.section_row_gen;
                                if ("function" != typeof section_row_gen) {
                                    var sec_td_inner_html = '<label class="{{ sec_td_class }}">{{ sec_td_label_html }}</label>'
                                      , sec_td_label_html = "";
                                    collapse_enabled && (sec_td_label_html = '<button type="button" class="{{ btn_class }}"></button>',
                                    sec_td_label_html = render_template(sec_td_label_html, {
                                        btn_class: "compact-visual-toggle " + (secExpand ? "active" : "")
                                    })),
                                    sec_td_inner_html = render_template(sec_td_inner_html, {
                                        sec_td_class: collapse_enabled ? "visual-toggle-label collapsible" : "visual-toggle-label",
                                        sec_td_label_html: sec_td_label_html
                                    }),
                                    td.append($(sec_td_inner_html).append(formatted_section))
                                } else
                                    secExpand = section_row_gen.call(td, entry, collapse_enabled, secExpand, formatted_section, col_len);
                                sec_row = row,
                                secIndex = rowIndex
                            }
                        }
                        if (tr = gen_row(entry, i, rowIndex, !secExpand),
                        $(tr).hasClass("qlist_expansion_child") || (catIndex++,
                        rowIndex++),
                        len && rowIndex >= len)
                            break;
                        if (Date.now() - frag_start > MAX_FRAG_TIME)
                            return setTimeout(load_row_fragment_event(source_i), 0),
                            i++,
                            void do_after_format(after_format_queue);
                        last_i = source_i
                    } else
                        filtered_lines += 1;
                do_after_format(after_format_queue),
                after_format_queue = null,
                config.options.add_category_num && add_category_num(),
                config.options.add_section_num && add_section_num(),
                setTimeout(function() {
                    config.source.length <= filtered_lines && page_completed() && (state.fast_sort = void 0,
                    gen_empty_row($("<tr/>").appendTo(tbody), config.empty_msg)),
                    config._gen_row_export = gen_row,
                    done.resolve()
                }, 0)
            };
            return load_row_frag(),
            done.promise()
        }
        function append_row(entry, index) {
            var table = $("#" + config.prefix + "-qlist")
              , tbody = table.find("tbody").last();
            tbody.find("tr.empty_row").remove();
            var i = tbody.children("TR").length;
            index >= 0 && i >= index && (i = index);
            var result = config._gen_row_export(entry, i, i);
            result.jquery || (result = $(result));
            var row = tbody.find("tr.qlist_row").eq(i).data("source-index", i);
            return result.insertBefore(row),
            result
        }
        function select_row(row) {
            $(row).find("td").first().trigger("click")
        }
        function select_rows(rows) {
            config._api && config._api.select_rows && config._api.select_rows(rows)
        }
        function get_selected_entries() {
            var state = that.data("qlist_state");
            return state._rows_ready.then(function() {
                return config._api.get_selected_entries()
            })
        }
        function get_num_filtered_lines() {
            return (that.data("qlist_state").cache || {}).filtered_lines
        }
        function get_filtered_source() {
            var state = that.data("qlist_state").cache || {}
              , source = config.source;
            return state.filtered_lines ? state.filtered_lines === source.length ? source : source.filter(function(entry) {
                return !state.source[entry._cache_id].filtered
            }) : []
        }
        function clean_up() {
            config.prefix && $(window).off(WINDOW_RESIZE_REFRESH)
        }
        function load_all_rows(tbody, $qlist_container) {
            var rows_ready = $.Deferred();
            return $.when(config.source).done(function(row_data) {
                var source = row_data;
                if (config.options.inline || (source = $.extend([], row_data),
                config.source = source),
                config.categories.length ? sort_source(source) : config.sections.length && sort_sections(source),
                _ext_call("source_load_complete", that, {
                    config: config,
                    state: state,
                    tbody: tbody,
                    fn: _ext_internal_functions
                }),
                locate_row_search) {
                    var located_row_indices = find_row_indices(config, locate_row_search);
                    0 === located_row_indices.length ? (Notify.post($.getInfo("Could not locate entry in list"), "warn"),
                    located_row_index = -1) : located_row_index = located_row_indices[0]
                }
                if (config.paging.enabled) {
                    var paged_rows = config.paging.server_side ? server_paged_rows(tbody, $qlist_container) : client_paged_rows(tbody, $qlist_container);
                    paged_rows.then(function() {
                        rows_ready.resolve()
                    }, rows_ready.reject)
                } else
                    load_rows(tbody).then(function() {
                        rows_ready.resolve()
                    }, rows_ready.reject)
            }),
            rows_ready.promise()
        }
        function setup_row_selection() {
            var $qlist = $(that)
              , last_selected = null
              , $selected_section = null
              , $selected_category = null
              , selector = "tr.qlist_row:not(.unselectable)"
              , section_selector = "tr.qlist_section"
              , category_selector = "tr.qlist_category"
              , shift_direction = null
              , event_selector = selector
              , ctx_event_selector = selector + "," + section_selector + "," + category_selector
              , get_all_rows = function() {
                return $qlist.find(selector)
            }
              , find_selected_rows = function() {
                return $qlist.find("tr.qlist_row.selected")
            }
              , unselect_selected = function() {
                get_selected_rows().forEach(function(row) {
                    $(row).removeClass("selected")
                }),
                set_selected_rows([])
            }
              , unselect_section = function() {
                $selected_section && ($selected_section.removeClass("selected"),
                $selected_section = null),
                $selected_category && ($selected_category = null)
            }
              , mouse_click = function(event, row) {
                var selected, new_selected_rows, all_rows, first_row, last_row, index, current_index, first_index, last_index, $row = $(row), shift = event.shiftKey, ctrl = event.ctrlKey || event.metaKey;
                if (event.originalEvent && event.originalEvent.qlistIgnore)
                    return !1;
                if (config.options.disable_selection)
                    return !1;
                if ($(":focusable").not(row).blur(),
                unselect_section(),
                $row.is(section_selector))
                    $selected_section = $row,
                    unselect_selected(),
                    $row.addClass("selected"),
                    last_selected = null;
                else if (shift) {
                    if (new_selected_rows = find_selected_rows(),
                    !new_selected_rows.length)
                        return !1;
                    first_row = new_selected_rows.get(0),
                    last_row = new_selected_rows.get(new_selected_rows.length - 1),
                    all_rows = get_all_rows(),
                    index = 0,
                    all_rows.each(function() {
                        this === row && (current_index = index),
                        this === first_row && (first_index = index),
                        this === last_row && (last_index = index),
                        index++
                    }),
                    current_index >= last_index ? (first_row = "down" === shift_direction || ctrl ? first_row : last_row,
                    last_row = row,
                    shift_direction = "down") : first_index >= current_index ? (last_row = "up" === shift_direction || ctrl ? last_row : first_row,
                    first_row = row,
                    shift_direction = "up") : "down" === shift_direction ? last_row = row : first_row = row,
                    index = -1,
                    all_rows.each(function() {
                        var selected = !1;
                        0 > index ? this === first_row && (selected = !0,
                        index = 0) : 0 === index && (selected = !0,
                        this === last_row && (index = 1)),
                        $(this).toggleClass("selected", selected)
                    }),
                    last_selected = row,
                    set_selected_rows(find_selected_rows().toArray())
                } else
                    ctrl ? $row.hasClass("selected") ? ($row.removeClass("selected"),
                    selected = get_selected_rows(),
                    selected.splice(selected.indexOf(row), 1)) : ($row.addClass("selected"),
                    last_selected = row,
                    set_selected_rows(find_selected_rows().toArray())) : (unselect_selected(),
                    $row.addClass("selected"),
                    last_selected = row,
                    set_selected_rows([row]));
                return !0
            }
              , row_to_entry = function(tr) {
                return config.source[tr.getAttribute("data-source-index")]
            }
              , trigger_row_event = function(name, event) {
                var $td, column_selector, column_value, last_selected_entry = last_selected ? row_to_entry(last_selected) : null, selected = get_selected_rows();
                event && ($td = $(event.target).closest("td"),
                $td.closest("tr").is(".qlist_section") || (column_selector = $td.attr("selector"),
                last_selected_entry && (column_value = last_selected_entry[column_selector]))),
                $(that).trigger(name, {
                    event: event,
                    $section_row: $selected_section,
                    $category_row: $selected_category,
                    last_selected: last_selected_entry,
                    rows: selected,
                    entries: selected.map(row_to_entry),
                    $td: $td,
                    column_selector: column_selector,
                    column_value: column_value
                })
            };
            config.options.editable_sections && (event_selector += "," + section_selector),
            $qlist.off("click" + QLIST_EVT_NS).on("click" + QLIST_EVT_NS, event_selector, function(event) {
                mouse_click(event, this) && (config.options.inline || fweb.util.dom.clearTextSelection(),
                trigger_row_event("qlist_select_rows", event))
            }),
            $qlist.off("dblclick").on("dblclick", event_selector, function(event) {
                mouse_click(event, this) && trigger_row_event("qlist_dblclick_row", event)
            });
            var $delayedSelectRow = null;
            $qlist.off("keydown.qlist").on("keydown.qlist", event_selector, function(event) {
                function getNeighbour(direction) {
                    var $rows = $(get_selected_rows());
                    if ($rows.length) {
                        var $row = direction > 0 ? $rows.last().next(event_selector) : $rows.first().prev(event_selector);
                        return $row.length && $row
                    }
                    return null
                }
                config.options.focusable_rows && (event.which === $.ui.keyCode.UP ? $delayedSelectRow = getNeighbour(-1) : event.which === $.ui.keyCode.DOWN && ($delayedSelectRow = getNeighbour(1)),
                $delayedSelectRow && event.preventDefault())
            }),
            $qlist.off("keyup.qlist").on("keyup.qlist", event_selector, function(event) {
                $delayedSelectRow && ($delayedSelectRow.length && $delayedSelectRow.focus().click(),
                $delayedSelectRow = null)
            }),
            config._api.select_rows = function(rows) {
                unselect_selected(),
                $(rows).addClass("selected"),
                last_selected = rows[rows.length - 1],
                set_selected_rows(rows),
                trigger_row_event("qlist_select_rows")
            }
            ,
            config._api.get_selected_entries = function() {
                var selected = get_selected_rows();
                return selected.map(row_to_entry)
            }
            ,
            $qlist.find("tbody").off("contextmenu").on("contextmenu", function(event) {
                event.preventDefault();
                var $row = $(event.target).closest(ctx_event_selector);
                if ($row.length) {
                    var row = $row[0];
                    unselect_section(),
                    get_selected_rows().indexOf(row) < 0 ? (unselect_selected(),
                    $row.is(section_selector) ? ($selected_section = $row,
                    last_selected = null) : $row.is(category_selector) ? ($selected_category = $row,
                    last_selected = null) : (set_selected_rows([row]),
                    last_selected = row),
                    (!$selected_section && !$selected_category || $selected_section && config.options.editable_sections) && $row.addClass("selected"),
                    trigger_row_event("qlist_select_rows", event)) : last_selected = row,
                    trigger_row_event("qlist_contextmenu", event)
                }
                return !1
            })
        }
        function init_qlist(table, init, $qlist_container) {
            setup_row_selection()
        }
        function gen_empty_row(tr, msg, extra_class) {
            "undefined" == typeof extra_class && (extra_class = ""),
            $(tr).addClass("empty_row nodrag qlist_row qlist_skip_row unselectable").attr("can_edit", "0").attr("can_delete", "0");
            var td = $('<td class="' + extra_class + '" />').appendTo(tr)
              , tr_head = $("thead tr:first", tr.closest("table"))[0];
            tr_head && (td.attr("colspan", tr_head.cells.length),
            td.text(msg))
        }
        function render_filter_th(th, selector) {
            var logic, enabled = "", title = "", flt_arr = get_filter_settings();
            if (!locate_row_search)
                for (var flt, i = 0; flt = flt_arr[i]; ++i)
                    if (flt.id === selector) {
                        logic = flt.logic || {},
                        logic.NOT && (title += "NOT "),
                        title += $.getInfo("filter_contains") + ": ",
                        title += Array.isArray(flt.value) ? flt.value.join(logic.RANGE ? " - " : " OR ") : flt.value,
                        enabled = "filter-enabled";
                        break
                    }
            return $('<span class="filter"></span>').html('<f-icon class="fa-filter ' + enabled + '"></f-icon>').attr("title", title)
        }
        function on_th_resize(event, ui) {
            var th = ui.element.closest("th");
            th.data("preset") && (th.data("preset").width = th.width()),
            adjust_table(th.closest("table"))
        }
        function f_icon_html(icon) {
            return '<f-icon class="' + icon + '"></f-icon>'
        }
        function render_th(th, column) {
            var th_div = $("<div/>").appendTo(th);
            if ("selector"in column) {
                var text, filters = config.column_filters;
                filters.enabled && (void 0 === column.filter || column.filter) && -1 === $.inArray(column.selector, filters.exempts) && (text = render_filter_th(th, column.selector),
                th_div.append(text));
                var lang_key = "lang_key"in column ? column.lang_key : "field_" + column.selector;
                // column.icon && th_div.append(f_icon_html(column.icon)),
                // text = null === lang_key ? "" : $.getInfo(lang_key),
                // th_div.append(text)
                if(column.title_html) {
                    text = column.title_html; 
                } else {
                    if (column.icon) {
                        th_div.append(f_icon_html(column.icon));
                    }
                    text = lang_key === null ? '' : $.getInfo(lang_key);
                }
                th_div.append(text);
            }
            config.options.resizable_columns && config.options.inline && th_div.resizable({
                handles: "e",
                alsoResize: th,
                start: function() {
                    var table = th.closest("table.qlist");
                    table.data("adjust.locker", on_th_resize)
                },
                stop: on_th_resize,
                minWidth: th_div.width() - 1
            })
        }
        function lock_adjust_table($qlist, lock_or_unlock) {
            return arguments.length > 1 ? void $qlist.data("adjustLock", !!lock_or_unlock) : $qlist.data("adjustLock") || !1
        }
        function trigger_config_menu_event($qlist, event) {
            $qlist.trigger("qlist_config_menu", {
                event: event,
                options: {
                    columns: config.columns,
                    chosen_columns: config.chosen_columns
                }
            })
        }
        function build_fixed_header($qlist, $table) {
            var $fixed_header = $qlist.find(".qlist-fixed-head")
              , $fixed_header_table = $("<table></table>")
              , $cloned_thead = $table.find("thead").clone(!0);
            return $cloned_thead.find("*").addBack().off(),
            $fixed_header.append($fixed_header_table.append($cloned_thead))
        }
        function setup_fixed_resize($qlist, $table, $fixed_header_table) {
            config.options.resizable_columns && (adjust_table($table),
            $fixed_header_table.find("th").each(function() {
                $(this).find("div:first").resizable({
                    alsoResize: this,
                    handles: "e",
                    start: function() {
                        lock_adjust_table($qlist, !0)
                    },
                    stop: function() {
                        sync_column_width($fixed_header_table, $table),
                        sync_column_width($table, $fixed_header_table),
                        lock_adjust_table($qlist, !1)
                    },
                    minWidth: $(this).find("div:first").width()
                })
            }))
        }
        function setup_fixed_column_reorder($qlist, $table, $fixed_header_table) {
            var th_selector = "th:not([fixed])";
            $fixed_header_table.find(th_selector).addClass("sortable"),
            $fixed_header_table.sortable({
                items: "th:not([fixed])",
                helper: "clone",
                start: function(evt, ui) {
                    ui.item.data("start-pos", ui.item.index())
                },
                update: function(evt, ui) {
                    var chosen = config.chosen_columns
                      , fr = Number(ui.item.data("start-pos"))
                      , to = ui.item.index()
                      , selector = ui.item.data("selector")
                      , swap = chosen.splice(fr, 1);
                    chosen.splice(to, 0, swap.pop());
                    var column_reorder_event = $.Event("column_reorder");
                    that.trigger(column_reorder_event, [selector, chosen]),
                    setCookie(config.ck_name.column, chosen.join(",")),
                    $(that).qlist("reload")
                },
                distance: 15
            }).disableSelection()
        }
        function setup_fixed_column_context($qlist, $table, $fixed_header_table) {
            $fixed_header_table.off("contextmenu").on("contextmenu", function(event) {
                return event.preventDefault(),
                trigger_config_menu_event($qlist, event),
                !1
            })
        }
        function setup_fixed_click($qlist, $table, $fixed_header_table) {
            $fixed_header_table.off("click.fixedclick").on("click.fixedclick", "th", function() {
                var selector = "th:nth-child(" + ($(this).index() + 1) + ")";
                $table.find(selector).click()
            })
        }
        function get_fixed_header_table($qlist, $table) {
            var $fixed_header_table = $qlist.find(".qlist-fixed-head table");
            if ($fixed_header_table.length < 1) {
                var $fixed_header = build_fixed_header($qlist, $table);
                $fixed_header_table = $fixed_header.find("table"),
                setup_filtering($fixed_header_table),
                setup_fixed_resize($qlist, $table, $fixed_header_table),
                setup_fixed_column_context($qlist, $table, $fixed_header_table),
                setup_fixed_column_reorder($qlist, $table, $fixed_header_table),
                setup_fixed_click($qlist, $table, $fixed_header_table);
                var $table_container = $qlist.find(".qlist-table");
                $table_container.off("scroll.qlist-fixed-header").on("scroll.qlist-fixed-header", function() {
                    $fixed_header_table.css("margin-left", 0 - $table_container[0].scrollLeft + "px")
                })
            }
            return $fixed_header_table
        }
        function center_located_row($qlist) {
            var $table_container = $qlist.find(".qlist-table")
              , $located_row = $table_container.find("tr.qlist_row.located_row");
            if ($located_row.length) {
                var top = $table_container.scrollTop() + $located_row.position().top;
                top -= $table_container.height() / 2,
                top += $located_row.height() / 2,
                $table_container.scrollTop(top)
            }
        }
        function sync_column_width($ref_table, $set_table) {
            var $ref_th = $ref_table.find("th")
              , $set_th = $set_table.find("th")
              , length = Math.min($ref_th.length, $set_th.length);
            $set_table.css("max-width", $ref_table.width());
            for (var i = 0; length > i; ++i)
                $($set_th[i]).children("div:first").width(window.getComputedStyle($($ref_th[i]).children("div:first")[0]).width)
        }
        function adjust_fixed_header($qlist, $table, $fixed_header_table) {
            sync_column_width($table, $fixed_header_table)
        }
        function adjust_table(table_selector) {
            var $table = $(table_selector);
            if (!$table.is(".qlist_fixed_column_header")) {
                var $qlist = $table.closest("div.qlist");
                lock_adjust_table($qlist) || $qlist.length < 1 || (config.options.inline || adjust_fixed_header($qlist, $table, get_fixed_header_table($qlist, $table)),
                center_located_row($qlist))
            }
        }
        function adjust_all_tables() {
            $(".qlist-table table", that).each(function(i, table) {
                adjust_table(table)
            })
        }
        function sortable_table(table) {
            if (config.reordering.enable) {
                var tbody = $("tbody:not(.category)", table).addClass("sortable");
                adjust_table(table);
                var children_expanded, restore_children = function(ui) {
                    var dependants = ui.item.data("dependant");
                    dependants && dependants.addClass("qlist_expansion_child").toggleClass("hidden", !children_expanded).insertAfter(ui.item)
                };
                tbody.find(config.reordering.drag).addClass("sortable");
                var sortable_options = {
                    items: ">" + config.reordering.items,
                    handle: config.reordering.drag,
                    helper: "clone",
                    start: function(evt, ui) {
                        var fr = ui.item.index();
                        if (ui.item.data("start-pos", fr),
                        ui.item.hasClass("qlist_expansion_child"))
                            ui.item.data("parent", $(ui.placeholder).prevAll(":not(.qlist_expansion_child):first"));
                        else {
                            var $children = $(ui.placeholder).nextUntil(":not(.qlist_expansion_child)");
                            children_expanded = $children.is(":not(.hidden)"),
                            ui.item.data("dependant", $children.removeClass("qlist_expansion_child").addClass("hidden"))
                        }
                        for (var cell, row = $("tr.qlist_row:first", ui.item.parent())[0], i = 0; cell = ui.helper[0].cells[i]; i++)
                            $(cell).width($(row.cells[i]).width())
                    },
                    stop: function(evt, ui) {
                        restore_children(ui)
                    },
                    update: function(evt, ui) {
                        function item_seek(item, backward) {
                            do
                                item = backward ? item.prev() : item.next();
                            while (item[0] && void 0 === item.data("sourceIndex"));return item
                        }
                        var dstIndex, i, tr, ref, srcIndex = ui.item.data("sourceIndex"), fr = ui.item.data("start-pos"), to = ui.item.index(), len = (ui.item.data("dependant") || []).length;
                        if (null != ui.item.prev().data("sourceIndex") ? (ref = ui.item.prev(),
                        dstIndex = srcIndex > ref.data("sourceIndex") ? ref.data("sourceIndex") + 1 : ref.data("sourceIndex") - len) : (ref = ui.item.next(),
                        dstIndex = srcIndex > ref.data("sourceIndex") ? ref.data("sourceIndex") : ref.data("sourceIndex") - 1 - len,
                        0 > dstIndex && (dstIndex = 0)),
                        ui.item.hasClass("qlist_expansion_child")) {
                            var newp = ui.item.prevAll(":not(.qlist_expansion_child):first");
                            if (newp[0] !== ui.item.data("parent")[0])
                                return void ui.item.parent().sortable("cancel")
                        } else {
                            var nextTo = ui.item.nextUntil(":not(.qlist_expansion_child)");
                            if (nextTo[0]) {
                                if (to += nextTo.length,
                                fr === to)
                                    return ui.item.parent().sortable("cancel"),
                                    void restore_children(ui);
                                ui.item.insertAfter(nextTo[nextTo.length - 1])
                            }
                        }
                        if (to > fr)
                            for (tr = ui.item,
                            tr = item_seek(tr, 1); tr[0] && tr.index() >= fr; tr = item_seek(tr, 1))
                                tr.attr("data-source-index", tr.data("sourceIndex") - (1 + len));
                        else {
                            for (tr = ui.item,
                            i = 0; len > i; i++)
                                tr = tr.next();
                            for (tr = item_seek(tr); tr[0] && tr.index() < fr + 1 + len; tr = item_seek(tr))
                                tr.attr("data-source-index", tr.data("sourceIndex") + (1 + len))
                        }
                        for (ui.item.attr("data-source-index", dstIndex),
                        i = 0; len > i; i++)
                            tr = ui.item.data("dependant")[i],
                            $(tr).attr("data-source-index", dstIndex + i);
                        for (var block = config.source.splice(srcIndex, 1 + len); block.length; )
                            config.source.splice(dstIndex, 0, block.pop());
                        config.reordering.onDrop.call(ui.item, dstIndex, srcIndex, ref.data("sourceIndex"))
                    }
                };
                tbody.on("mouseenter", "tr.qlist_row", config.reordering.drag, function() {
                    $(this).parents("tbody").sortable(sortable_options)
                })
            }
        }
        function qlist_refresh_table() {
            $(that).qlist("reload")
        }
        var that = this
          , default_row_attr = [{
            name: "mkey",
            selector: "name"
        }, {
            name: "mkey_type",
            selector: "mkey_type"
        }, {
            name: "vdom",
            selector: "vdom"
        }, {
            name: "q_type",
            selector: "q_type"
        }, {
            name: "q_type_extra",
            selector: "q_type_extra"
        }, {
            name: "q_ref",
            selector: "q_ref"
        }, {
            name: "q_static",
            selector: "q_static"
        }, {
            name: "q_path",
            selector: "q_path"
        }, {
            name: "q_name",
            selector: "q_name"
        }]
          , defaults = {
            source: [],
            columns: [],
            row_attr: [],
            section_attr: [],
            default_columns: [],
            sort_compare: default_compare,
            categories: [],
            sort_categories_fn: function(a, b) {
                return a.localeCompare(b)
            },
            sections: [],
            sort_sections_fn: default_compare,
            section_widgets: [],
            row_gen: function(rowIndex, entry) {},
            format_fn: $.extend({}, $.qlist.format_fn),
            after_format_fn: null,
            filter_fn: {
                "*": default_filter_fn
            },
            filter: function(entry) {
                return !0
            },
            category: {
                sorted: !0,
                collapsible: !0,
                editable: !1,
                q_type: null
            },
            paging: {
                enabled: !1,
                server_side: !1,
                hybrid_server_paging: !1,
                total_lines: 0,
                page_lines: top.state ? top.state.lines_per_page : 50,
                min_page_lines: 10,
                timeout: 500,
                fetch: function(page_num, cb) {},
                show_all_button: !1,
                last_page_button: !0
            },
            empty_msg: $.getInfo("no_entries"),
            prefix: "qlist",
            options: {
                ref_column: !1,
                resizable_columns: !0,
                inline: !1,
                automatic_mkey_column: !0,
                collapsible_sections: {
                    "*": !0
                },
                collapsible_categories: {
                    "*": !0
                },
                editable_sections: !1,
                add_section_num: !0,
                add_category_num: !0,
                atomic_render: !1,
                disable_selection: !1,
                focusable_rows: !1
            },
            reordering: {
                enable: !1,
                items: "tr.qlist_row",
                drag: "td:visible:first-child",
                refresh_on_drop: !1,
                onDrop: default_ondrop
            },
            column_filters: {
                enabled: !1,
                value: null,
                exempts: ["#"],
                log_type: 4,
                filter_fn: default_filter,
                server_side_reload: null,
                force_client_side: !1
            },
            callbacks: {
                pre_load: null,
                load: null,
                pre_paging: null,
                post_paging: null,
                pre_sort: null,
                post_reorder: null
            }
        };
        _ext_extend_defaults(defaults);
        var config = $(this).data("config") || defaults
          , WINDOW_RESIZE_REFRESH = config.prefix ? "resize.refresh_" + config.prefix : "";
        if ("refresh" === parameters)
            return refresh_qlist(),
            this;
        if ("reload" === parameters)
            return value !== !1 && save_page(),
            select_rows([]),
            $(this).qlist(),
            this;
        if ("config" === parameters)
            return value ? $(this).data("config", $.extend(!0, config, value)) : config;
        var commands = {
            reset_columns: reset_columns,
            update_columns: update_chosen_columns,
            clear_filters: clear_filters,
            clear_selection: clear_selection,
            filter: apply_filter,
            append_row: append_row,
            select_row: select_row,
            select_rows: select_rows,
            get_selected_entries: get_selected_entries,
            reload_page: reload_page,
            get_num_filtered_lines: get_num_filtered_lines,
            get_filtered_source: get_filtered_source,
            clean_up: clean_up
        };
        if ("string" == typeof parameters && parameters in commands)
            return commands[parameters](value);
        var locate_row_search = get_urlparam_once("qlist_find")
          , located_row_index = -1
          , located_row_id = "_qlist_located_row_" + Date.now();
        "find" === parameters ? (parameters = void 0,
        locate_row_search = value) : locate_row_search && (locate_row_search = JSON.parse(locate_row_search));
        var state = that.data("qlist_state");
        null == state && that.data("qlist_state", state = {
            display_master: []
        }),
        state.cache = {
            source: {}
        };
        var _ext_internal_functions = {
            adjust_all_tables: adjust_all_tables,
            qlistRefreshTable: qlist_refresh_table,
            get_column_value: get_column_value,
            get_filter_settings: get_filter_settings,
            get_filter_columns: get_filter_columns,
            add_filter: add_filter,
            apply_filter: apply_filter,
            get_filtered_lines: get_filtered_lines,
            get_complete_filter_fn: get_complete_filter_fn
        }
          , ext_command_return_value = _ext_handle_commands(parameters, that, {
            config: config,
            state: state,
            fn: _ext_internal_functions
        }, arguments);
        if (ext_command_return_value !== NOT_CALLED)
            return ext_command_return_value;
        var source;
        parameters && "source"in parameters && (source = parameters.source,
        delete parameters.source);
        var pre_extend_purge = ["chosen_columns", "columns", "default_columns"];
        "object" == typeof parameters && pre_extend_purge.forEach(function(key) {
            parameters[key] && parameters[key].length && (config[key] = [])
        }),
        $(this).data("config", $.extend(!0, config, parameters)),
        void 0 !== source && (config.source = parameters.source = source),
        _ext_call("preconfigure", that, {
            config: config,
            fn: _ext_internal_functions
        }),
        locate_row_search || (locate_row_search = config.locate_row,
        config.locate_row = null),
        config.options.ref_column && (config.column_map && config.column_map.q_ref || config.columns.push({
            selector: "q_ref",
            lang_key: "ref",
            fld_type: "int"
        }),
        config.default_columns.length && config.default_columns.indexOf("q_ref") < 0 && config.default_columns.push("q_ref")),
        delete config.categories_map,
        config.column_map = $.makeObject(config.columns, function() {
            return this.selector || (this.selector = "id" + Math.random())
        });
        for (var attr, row_attr_map = $.makeObject(config.row_attr, function() {
            return this.name
        }), i = 0; attr = default_row_attr[i]; i++) {
            if (row_attr_map[attr.name]) {
                if (attr = row_attr_map[attr.name],
                !attr)
                    continue
            } else
                config.row_attr.push(attr);
            if (config.options.automatic_mkey_column && "mkey" === attr.name && config.default_columns.length && $.inArray(attr.selector, config.default_columns) < 0) {
                var col = $.extend({
                    display: 1
                }, config.column_map[attr.selector]);
                col.display && config.default_columns.unshift(attr.selector)
            }
        }
        var filter = getQueryValue(window.location.href, "filter");
        config.ck_name = {
            column: filter ? config.prefix + "_column_settings_ext" : config.prefix + "_column_settings",
            filter: filter ? config.prefix + "_filter_settings_ext" : config.prefix + "_filter_settings",
            category: config.prefix + "_category_settings"
        };
        var avail = []
          , ck = getCookie(config.ck_name.column)
          , chosen = ck && ck.split(",") || (config.chosen_columns && config.chosen_columns.length ? config.chosen_columns : config.default_columns.length ? config.default_columns : avail);
        $.each(config.columns, function(i, col_config) {
            if (!col_config.hidden) {
                avail.push(col_config.selector),
                "lang_key"in col_config || (col_config.lang_key = $.hasInfo("field_" + col_config.selector) ? "field_" + col_config.selector : col_config.selector);
                var n = $.inArray(col_config.lang_key, chosen);
                n >= 0 && col_config.selector && (chosen[n] = col_config.selector),
                col_config.fixed && -1 === chosen.indexOf(col_config.selector) && chosen.unshift(col_config.selector)
            }
        }),
        chosen = $.grep(chosen, function(column) {
            return -1 !== $.inArray(column, avail)
        }),
        config.chosen_columns = chosen,
        sort_columns(config.chosen_columns),
        config._api = {};
        var _filter_digit_regex = /([+\-]?\d+(?:.\d+)?)/
          , current_page_num = 1;
        _ext_call("postconfigure", that, {
            config: config,
            fn: _ext_internal_functions
        });
        var body, _new_display_master;
        return this.each(function() {
            function build_qlist_scaffolding($qlist) {
                $qlist.append('<div class="qlist-fixed-head"></div><div class="qlist-table"><table></table></div>');
                var table = $qlist.find(".qlist-table table")
                  , thead = $("<thead/>").appendTo(table)
                  , head_row = $("<tr/>").appendTo(thead).addClass("heading");
                return config.options.inline && $qlist.addClass("inline-qlist"),
                {
                    table: table,
                    thead: thead,
                    headRow: head_row
                }
            }
            function setup_context_menu() {
                head_row.on("contextmenu", function(event) {
                    return event.preventDefault(),
                    trigger_config_menu_event($qlist_container, event),
                    !1
                })
            }
            function setup_header() {
                setup_column_header()
            }
            function setup_column_header() {
                if ($(config.chosen_columns).each(function(i, selector) {
                    var th = $("<th/>").appendTo(head_row).data("selector", selector)
                      , column = config.column_map[selector] || {};
                    for (var attr in column)
                        column.hasOwnProperty(attr) && "selector" !== attr && "lang_key" !== attr && th.attr(attr, column[attr]);
                    var val = render_th(th, column);
                    val && th.append(val)
                }),
                config.default_columns.length) {
                    var th_selector = "th:not([fixed])";
                    head_row.find(th_selector).addClass("sortable"),
                    head_row.sortable({
                        items: th_selector,
                        helper: "clone",
                        start: function(evt, ui) {
                            ui.item.data("start-pos", ui.item.index())
                        },
                        update: function(evt, ui) {
                            var chosen = config.chosen_columns
                              , fr = ui.item.data("start-pos")
                              , to = ui.item.index()
                              , selector = ui.item.data("selector")
                              , i = $.inArray(selector, chosen)
                              , swap = chosen.splice(i, 1);
                            chosen.splice(i + (to - fr), 0, swap.pop());
                            var column_reorder_event = $.Event("column_reorder");
                            that.trigger(column_reorder_event, [selector, chosen]),
                            setCookie(config.ck_name.column, chosen.join(",")),
                            $(that).qlist("reload")
                        },
                        distance: 15
                    }).disableSelection()
                }
            }
            function setup_table() {
                _ext_call("preinit", that, {
                    config: config,
                    state: state,
                    fn: _ext_internal_functions
                }),
                config.qlist = qlist = init_qlist(table, void 0, $qlist_container),
                config.qsource && $.isFunction(config.qsource.ready) && config.qsource.ready(table),
                setTimeout(function() {
                    sortable_table(table)
                }),
                config.options.ref_column && table.on("click", "a.qlist_ref", function() {
                    var tr = $(this).closest("tr.qlist_row")
                      , mkey = tr.attr("mkey")
                      , vdom = tr.attr("vdom");
                    if (null != mkey) {
                        var q_type = [tr.attr("q_type")]
                          , q_type_extra = tr.attr("q_type_extra");
                        null != q_type_extra && (q_type = q_type.concat(q_type_extra.split(","))),
                        fweb.util.structure.topPostMessage({
                            messageType: "showObjectUsage",
                            qTypes: q_type,
                            mkey: mkey,
                            vdom: vdom
                        })
                    }
                    return !1
                });
                var selector, update_expand_button = function(button) {
                    var $button = $(button)
                      , expanded = !$button.is(".active");
                    return $button.toggleClass("active", expanded),
                    expanded
                };
                config.categories.length && (selector = ".qlist_category label.visual-toggle-label",
                table.on("click", selector, function(event) {
                    if (event.stopPropagation(),
                    $(event.target).is("button")) {
                        var bExpanded = update_expand_button(event.target)
                          , tbody = $(this).closest("tbody");
                        tbody.nextAll("tbody:first").toggleClass("hidden", !bExpanded);
                        var cat = tbody.data("category");
                        set_category_cookie(cat, bExpanded),
                        adjust_table(table)
                    }
                }).on("dblclick", selector, function(event) {
                    event.stopPropagation()
                })),
                config.sections.length && (selector = ".qlist_section label.visual-toggle-label",
                table.on("click", selector, function(event) {
                    var $this = $(this);
                    if ($this.is("label.collapsible") && event.stopPropagation(),
                    $(event.target).is("button")) {
                        var bExpanded = update_expand_button(event.target)
                          , row = $this.closest("tr");
                        row.nextUntil(".qlist_section").toggleClass("hidden", !bExpanded);
                        var sec = row.data("section");
                        set_category_cookie(sec, bExpanded),
                        adjust_table(table)
                    }
                }).on("dblclick", selector, function(event) {
                    $(this).is("label.collapsible") && event.stopPropagation()
                })),
                adjust_table(table),
                _ext_call("postinit", that, {
                    config: config,
                    state: state,
                    table: table,
                    thead: thead,
                    head_row: head_row,
                    tbody: tbody,
                    qlist: qlist,
                    fn: _ext_internal_functions
                }),
                that.trigger("qlist_load_that");
                var $window = $(window);
                $window.trigger("qlist_load"),
                $window.off(WINDOW_RESIZE_REFRESH),
                $window.on(WINDOW_RESIZE_REFRESH, $.debounce(50, function() {
                    that.qlist("refresh")
                })),
                that.on("qlist.update", function() {
                    that.qlist("refresh")
                }),
                $.isFunction(config.callbacks.load) && config.callbacks.load.call(that[0], qlist),
                _ext_call("postload", that, {
                    config: config,
                    state: state,
                    table: table,
                    thead: thead,
                    head_row: head_row,
                    tbody: tbody,
                    qlist: qlist,
                    fn: _ext_internal_functions
                })
            }
            function set_category_cookie(cat, exp) {
                var ck_cats = (getCookie(config.ck_name.category) || "").split(",")
                  , idx = $.inArray(cat, ck_cats);
                if (exp && 0 > idx)
                    ck_cats.push(cat);
                else {
                    if (exp || !(idx >= 0))
                        return;
                    ck_cats.splice(idx, 1)
                }
                setCookie(config.ck_name.category, ck_cats.join(","))
            }
            var that = $(this);
            that.find("#" + config.prefix + "-extra_hdr_items").detach().addClass("hidden").appendTo($("body")),
            that.find("#" + config.prefix + "-ext_hdr_items").detach().addClass("hidden").appendTo($("body")),
            that.empty().addClass("qlist");
            var $qlist_container = that
              , state = that.data("qlist_state") || {};
            that.state = state,
            that.data("qlist_state", state),
            state.display_master && state.display_master.length !== config.source.length && "undefined" != typeof get_new_display_master && (_new_display_master = state.display_master = get_new_display_master()),
            window._new_display_master && config.options.sorting && state.sorting.length > 0 && (sorting_cookie_data || !config.default_sort_is_serverside) && _do_sort.call(that),
            body = build_qlist_scaffolding($(this));
            var table = body.table
              , thead = body.thead
              , head_row = body.headRow
              , tbody = $("<tbody/>").appendTo(table);
            _ext_call("preload", that, {
                config: config,
                state: state,
                table: table,
                thead: thead,
                head_row: head_row,
                tbody: tbody,
                fn: _ext_internal_functions
            }),
            $.isFunction(config.callbacks.pre_load) && config.callbacks.pre_load.call(that[0], qlist),
            state._rows_ready = load_all_rows(tbody, $qlist_container).done(function() {
                setup_table(),
                setup_context_menu(),
                setup_filtering(thead),
                that.qlist("refresh")
            }),
            setup_header()
        }),
        this.internationalizeLanguageEntries()
    }
    ,
    window.qlist_append_row = qlist_append_row,
    $.qlist.ext = {};
    var NOT_CALLED = {}
      , ext_dependency_cache_keys = {}
      , ext_dependency_cache_order = [];
    _ext_resolve_config($, "qlist._ext").resolve_config = _ext_resolve_config
}(jQuery),
function($, fweb) {
    "use strict";
    function QListInlineHandlers(ctxt, config, menuSelector) {
        function refresh_qlist() {
            var h = handlers;
            if (h.$qlistElem) {
                var $tbody = h.$qlistElem.find("table tbody")
                  , $rows = $tbody.find("tr").not(h.fixed && h.fixed.$tr);
                $rows.remove(),
                h.fixed && h.fixed.$tr && h.fixed.$tr.detach();
                for (var i = 0; i < h.ctxt.length; ++i)
                    add_row_to_table(h.ctxt[i]);
                h.fixed && h.fixed.$tr && $tbody.append(h.fixed.$tr)
            }
        }
        function replace_contents(new_contents) {
            handlers.$qlistElem.qlist("select_rows", []),
            handlers.ctxt.replaceAll(new_contents),
            handlers.refresh_qlist()
        }
        function dep_func(v, k) {
            return "data-" + escapeHTML(k) + '="' + escapeHTML(v) + '" '
        }
        function inline_create() {
            var defaults = $.isFunction(handlers.defaults) ? handlers.defaults() : handlers.defaults
              , row = $.extend(!0, {}, defaults)
              , $tr = inline_append_rows([row]);
            setTimeout(function() {
                handlers.qlist("select_row", $tr),
                inline_edit()
            }, 0)
        }
        function inline_append_rows(rows) {
            function newid() {
                var id = -1
                  , i = 0
                  , l = ctxt.length;
                for (i = 0; l > i; ++i)
                    id = Math.min(id, ctxt[i][handlers.key] - 1);
                return id
            }
            var i, row, $tr;
            for (i = 0; i < rows.length; i++)
                row = rows[i],
                void 0 === row[handlers.key] && (row[handlers.key] = newid()),
                ctxt.push(row),
                $tr = add_row_to_table(row);
            return $tr
        }
        function add_row_to_table(row) {
            var $tr_parent;
            handlers.fixed && handlers.fixed.$tr && ($tr_parent = handlers.fixed.$tr.parent(),
            handlers.fixed.$tr.detach()),
            handlers.$qlistElem.find(".empty_row").remove();
            var $tr = handlers.qlist("append_row", row);
            return $tr_parent && $tr_parent.append(handlers.fixed.$tr),
            handlers._init_row(row, $tr),
            handlers._modified(o.CREATE, ctxt, row, void 0, $tr),
            handlers.updateMenus(),
            $tr
        }
        function inline_add_fixed_row(row, submit) {
            handlers.fixed = {
                row: row,
                submit: submit
            }
        }
        function inline_edit(eo, data) {
            function event_namespace_gen(evts, namespace) {
                return evts.map(function(evt) {
                    return evt + namespace
                }).join(" ")
            }
            function end_edit(eo) {
                if ("blur" === eo.type || "keydown" === eo.type && eo.keyCode === $.ui.keyCode.ENTER || "click" === eo.type && $tr.is(".editing")) {
                    var modified = []
                      , entry = ctxt.filter(handlers._row_match(id))[0];
                    if (void 0 === entry && handlers.fixed && handlers.fixed.$tr[0] === $tr[0] && (entry = handlers.fixed.row),
                    entry) {
                        var $input_groups = $tr.find("span.inline-edit-group");
                        $input_groups.each(function() {
                            var $this = $(this)
                              , col = $this.data("group-name")
                              , values = []
                              , texts = [];
                            $this.find("input.inline-edit-chk:checked").each(function(i, v) {
                                values.push($(v).val()),
                                texts.push($(v).parent(".inline-edit-chk-text").text())
                            }),
                            entry[col] = values.join(" "),
                            $staticTexts.filter('[data-name="' + col + '"]').text(texts.join("/")),
                            $this.closest(".inline-edit:not(input, select, .inline-edit-group)").attr("data-value-" + col, entry[col]),
                            modified.push([ctxt, entry, col, $tr, $this.closest("td")])
                        }),
                        $inputs.filter(":not(.inline-edit-chk)").each(function() {
                            function update_toggle() {
                                var checked = $this.is(":checked")
                                  , un = checked ? "" : "un";
                                entry[col] = $this.data(un + "checked-value"),
                                $colStaticTexts.find("f-icon").toggleClass("fa-enabled", checked).toggleClass("fa-disabled", !checked).attr("title", $.getInfo(entry[col]))
                            }
                            function update_file(file) {
                                var $file = $(file)
                                  , promise = $file.data("inline-new-value");
                                promise && $.when(promise).then(function(data) {
                                    if (promise === $file.data("inline-new-value")) {
                                        $file.data("inline-new-value", null);
                                        var filename_selector = $file.data("filename-selector");
                                        entry[col] = data.content,
                                        filename_selector && void 0 !== data.name && (entry[filename_selector] = data.name)
                                    }
                                })
                            }
                            var $this = $(this)
                              , col = $this.data("name")
                              , className = ""
                              , value = $this.val()
                              , is_input = "input" === this.tagName.toLowerCase()
                              , is_select = "select" === this.tagName.toLowerCase()
                              , is_toggle = is_input && "checkbox" === this.type && $this.hasClass("toggle-switch")
                              , is_file = is_input && "file" === this.type;
                            if (col || (col = $this.closest(".inline-edit").find("[data-name]").data("name")),
                            is_toggle || is_file || entry[col] === value || void 0 === col || (entry[col] = value),
                            is_select) {
                                var selectedOption = $this.find('option[value="' + escapeHTML(value) + '"]');
                                value = selectedOption.text(),
                                className = selectedOption.data("class")
                            }
                            className = className ? " " + className : "";
                            var $colStaticTexts = $staticTexts.filter('[data-name="' + col + '"]');
                            is_toggle ? update_toggle() : is_file ? update_file(this) : (is_input && "password" === this.type && (value = value.replace(/./g, PASSWORD_DOT)),
                            $colStaticTexts.text(value)),
                            is_select && $colStaticTexts.removeClass().addClass("inline-display depends " + col + className),
                            $this.closest(".inline-edit:not(input, select)").attr("data-value-" + col, entry[col]),
                            modified.push([ctxt, entry, col, $tr, $this.closest("td")])
                        }),
                        $tr.toggleClass("editing", !1),
                        $.each(modified, function(i, m) {
                            handlers._modified.apply(handlers, [o.EDIT].concat(m))
                        }),
                        handlers.submitted && (handlers._validate(),
                        handlers.updateMenus())
                    }
                    return clearTimeout(handlers._editingTimoutID),
                    $endEditTargets.off(click_ns),
                    !1
                }
            }
            var BLUR_DELAY = 10;
            if (!handlers.config.read_only) {
                var $tr = handlers.$qlistElem.find("tr.selected")
                  , $inputs = $tr.find("input.inline-edit,select.inline-edit,label.inline-edit input[type=checkbox].toggle-switch,.inline-edit input[type=file]")
                  , $staticTexts = $tr.find(".inline-display")
                  , $target = data && data.event ? $(data.event.target) : $inputs.first()
                  , id = $tr.data(handlers._data_key)
                  , $endEditTargets = $("html").add(handlers.$qlistElem);
                $inputs.each(function(i, e) {
                    var tmp_name = handlers.id + "-" + id + "-" + e.getAttribute("data-name");
                    e.name = e.name || tmp_name,
                    e.id = e.id || tmp_name
                }),
                $tr.toggleClass("editing", !0),
                $inputs = $inputs.filter("input, select"),
                $target.is("td, tr") || ($target = $target.parents("td").first()),
                $target = $target.find("input.inline-edit, select.inline-edit").first(),
                $target.length || ($target = $inputs.first());
                var ns = ".qlist_inline_editing"
                  , evts = ["click", "mousedown", "mouseup", "focus"]
                  , evts_ns = event_namespace_gen(evts, ns)
                  , change_ns = "change" + ns
                  , keydown_ns = "keydown" + ns
                  , click_ns = "click" + ns;
                handlers._editingTimoutID = setTimeout(function() {
                    $inputs.ui_dependencies().each(function(i, elem) {
                        try {
                            elem.setSelectionRange && elem.setSelectionRange(0, 999999)
                        } catch (e) {}
                    }),
                    $target.focus(),
                    $endEditTargets.off(click_ns).on(click_ns, function(eo) {
                        var $exempt = $(eo.target).closest("tr.editing, .qtip, .ui-dialog, .ui-widget-overlay")
                          , insideDialog = $exempt.find(handlers.$qlistElem).length >= 1;
                        if (!$exempt.length || insideDialog) {
                            var input = $inputs.first().get();
                            end_edit.call(input, eo),
                            $inputs.off(ns)
                        } else
                            eo.stopPropagation()
                    })
                }, BLUR_DELAY),
                $inputs.off(ns),
                $inputs.on(evts_ns, function(eo) {
                    eo.stopPropagation()
                }),
                $inputs.on(change_ns, function() {
                    function pluck_name(file) {
                        return file.name
                    }
                    var entry = ctxt.filter(handlers._row_match(id))[0]
                      , $this = $(this)
                      , $td = $this.closest("td")
                      , col = $this.data("name") || $td.find(".inline-edit [data-name]").data("name");
                    if (entry)
                        if ("file" === $this.attr("type")) {
                            var promise = handlers._modified(o.CHANGE, ctxt, entry, col, $tr, $td, $this[0].files)
                              , files = this.files
                              , multiple = this.multiple;
                            promise || (promise = {
                                name: Array.prototype.slice.call(files).map(pluck_name).join(", "),
                                content: multiple ? files : files[0]
                            }),
                            promise = $.when(promise).then(function(result) {
                                var $storage = $td.find('[data-name="' + col + '"]');
                                return $storage.val(result.content),
                                $td.closest("form").validate().element($storage),
                                $td.find(".inline-edit .filename").text(result.name),
                                result
                            }),
                            $this.data("inline-new-value", promise)
                        } else
                            handlers._modified(o.CHANGE, ctxt, entry, col, $tr, $td, $this.val())
                }),
                $inputs.on(keydown_ns, function(eo) {
                    eo.which === $.ui.keyCode.ENTER && (end_edit.call(eo.target, eo),
                    eo.preventDefault())
                })
            }
        }
        function inline_delete() {
            var $rows = handlers.$qlistElem.find("tr.selected")
              , ids = $rows.map(function(i, row) {
                return $(row).data(handlers._data_key)
            }).toArray()
              , removed = [];
            ctxt.replaceAll($(ctxt).not(function(i, row) {
                var remove = $.inArray(row[handlers.key], ids) > -1;
                return remove && removed.push(row),
                remove
            }).toArray()),
            $rows.remove(),
            handlers.$qlistElem.find("tr[data-source-index]").attr("data-source-index", function(idx) {
                return idx
            }),
            handlers._modified(o.DELETE, ctxt, removed, void 0, $rows),
            handlers.updateMenus()
        }
        function get_validate_attrs(validate) {
            if (void 0 === validate || "string" == typeof validate)
                return "";
            var attrs = Object.keys(validate).map(function(key) {
                if ("class" !== key) {
                    if ("function" != typeof validate[key])
                        return escapeHTML(key) + '="' + escapeHTML(validate[key]) + '"';
                    validate["class"] = (validate["class"] || "") + " " + key
                }
            });
            return attrs.join(" ") + " "
        }
        function input_format(selector, entry, type, validate, dependencies, placeholder) {
            type = type || "text";
            var deps_data = $.map(dependencies || {}, dep_func).join("") + " "
              , validate_attrs = get_validate_attrs(validate);
            validate_attrs || (validate = {
                "class": validate
            });
            var visible_value = entry[selector];
            return void 0 === visible_value && (visible_value = ""),
            "password" === type && (entry._password_orig = entry._password_orig || {},
            entry._password_orig[selector] = entry[selector],
            visible_value = visible_value.replace(/./g, PASSWORD_DOT)),
            '<span class="inline-display ' + selector + (dependencies ? " depends" : "") + '" ' + deps_data + 'data-name="' + selector + '">' + escapeHTML(visible_value) + '</span><input class="inline-edit' + (dependencies ? " depends" : "") + (validate["class"] ? " " + validate["class"] : "") + '" ' + validate_attrs + deps_data + 'type="' + type + '" data-name="' + selector + '" value="' + escapeHTML(entry[selector]) + '" placeholder="' + (placeholder ? placeholder : "") + '" />'
        }
        function multiple_checkbox_format(selector, entry, options, validate, dependencies) {
            var deps_data = $.map(dependencies || {}, dep_func).join("");
            if ($.isArray(options)) {
                var arr = options;
                options = {},
                $.each(arr, function(i, o) {
                    options[o] = $.getInfo(o)
                })
            }
            var selected_vals = entry[selector] ? entry[selector].split(" ") : []
              , labels = []
              , inputs = [];
            return $.map(options, function(v, k) {
                var opt_text, prop, opt_val = escapeHTML(k), data = "";
                if ($.isPlainObject(v)) {
                    opt_text = v.text || $.getInfo(k);
                    var data_obj = v.data || {};
                    for (prop in data_obj)
                        data_obj.hasOwnProperty(prop) && (data += " data-" + escapeHTML(prop) + '="' + escapeHTML(data_obj[prop]) + '"');
                    v["class"] && (data += ' data-class="' + escapeHTML(v["class"]) + '"')
                } else
                    opt_text = v;
                opt_text = escapeHTML(opt_text),
                $.inArray(k, selected_vals) >= 0 && labels.push(opt_text),
                inputs.push('<label class="inline-edit inline-edit-chk-text"><input class="inline-edit qlist_col_field inline-edit-chk' + (dependencies ? " depends" : "") + (validate ? " " + validate : "") + '" ' + deps_data + 'type="checkbox" data-name="' + selector + '" ' + ($.inArray(k, selected_vals) >= 0 ? "checked" : " ") + ' value="' + opt_val + '"/>' + opt_text + "</label>")
            }),
            '<span class="inline-display ' + selector + (dependencies ? " depends" : "") + '" ' + deps_data + 'data-name="' + selector + '">' + labels.join("/") + '</span><span class="inline-edit inline-edit-group" data-group-name="' + selector + '">' + inputs.join(" ") + "</span>"
        }
        function file_format(selector, entry, validate, config) {
            var template = ['<span class="inline-edit button-column {{ eSelector }}">', '   <span class="filename">{{ filename }}</span>', '   <input type="text" ', '       class="hidden dependency_ignore_visibility validate_hidden {{ validate_class }}" ', '       value="{{ content }}"', '       id="{{ id }}"', '       data-name="{{ eSelector }}">', '   <input type="file" class="hidden depends" ', '       data-class-if-class="error error #{{ id }}"', '       id="{{ id }}_file" accept="{{ accept }}" ', '       data-filename-selector="{{ filename_selector }}">', '   <label for="{{ id }}_file">', '       <f-icon class="fa-plus-circle"></f-icon>', "       <span>{{ text }}</span>", "   </label>", "</span>"].join("\n");
            return fweb.util.dom.renderTemplate(template, {
                validate_class: validate || "",
                eSelector: escapeHTML(selector),
                id: "inline-file-" + QListInlineHandlers.lastId++,
                text: config.lang ? $.getInfo(config.lang) : "",
                content: escapeHTML(entry[selector]),
                accept: config.accept,
                filename_selector: escapeHTML(config.filename_selector),
                filename: escapeHTML(entry[config.filename_selector]) || $.getInfo("Not Set")
            })
        }
        function toggle_format(selector, entry, checked_value, unchecked_value, dependencies) {
            var esc_selector = escapeHTML(selector)
              , id = "inline-toggle-" + QListInlineHandlers.lastId++
              , icon = entry[selector] === checked_value ? "fa-enabled" : "fa-disabled"
              , deps_data = $.map(dependencies || {}, dep_func).join("")
              , title = escapeHTML($.getInfo(entry[selector]));
            return checked_value = escapeHTML(checked_value),
            unchecked_value = escapeHTML(unchecked_value),
            '<span class="inline-display ' + esc_selector + (dependencies ? " depends" : "") + ' toggle-label"' + deps_data + ' data-name="' + esc_selector + '"><f-icon class="' + icon + '" title="' + title + '"></f-icon></span><label class="inline-edit toggle-label' + (dependencies ? " depends" : "") + '" for="' + id + '"' + deps_data + '><input type="checkbox" class="toggle-switch" id="' + id + '" data-checked-value="' + checked_value + '" data-unchecked-value="' + unchecked_value + '" data-name="' + esc_selector + '" value="' + checked_value + '" ><label for="' + id + '"></label></label>'
        }
        function select_format(selector, entry, options, validate, dependencies) {
            if ($.isArray(options)) {
                var arr = options;
                options = {},
                $.each(arr, function(i, o) {
                    options[o] = $.getInfo(o)
                })
            }
            var esc_selector = escapeHTML(selector)
              , selected_val = entry[selector]
              , selected_opt = options[selected_val]
              , selected_text = $.isPlainObject(selected_opt) ? selected_opt.text || $.getInfo(selected_val) : selected_opt
              , selected_class = $.isPlainObject(selected_opt) ? selected_opt["class"] : ""
              , validate_attrs = get_validate_attrs(validate);
            return validate_attrs || (validate = {
                "class": validate
            }),
            '<span class="inline-display ' + esc_selector + " " + (selected_class ? selected_class : "") + '" data-name="' + esc_selector + '">' + escapeHTML(selected_text || "") + '</span><select class="inline-edit' + (dependencies ? " depends" : "") + (validate["class"] ? " " + validate["class"] : "") + '" ' + validate_attrs + $.map(dependencies || {}, dep_func).join("") + 'data-name="' + esc_selector + '">' + $.map(options, function(v, k) {
                var opt_text, prop, opt_val = escapeHTML(k), data = "";
                if ($.isPlainObject(v)) {
                    opt_text = v.text || $.getInfo(k);
                    var data_obj = v.data || {};
                    for (prop in data_obj)
                        data_obj.hasOwnProperty(prop) && (data += " data-" + escapeHTML(prop) + '="' + escapeHTML(data_obj[prop]) + '"');
                    v["class"] && (data += ' data-class="' + escapeHTML(v["class"]) + '"')
                } else
                    opt_text = v;
                return opt_text = escapeHTML(opt_text),
                '<option value="' + opt_val + '" ' + (k === selected_val ? "selected" : "") + data + ">" + opt_text + "</option>"
            }).join("") + "</select>"
        }
        QListInlineHandlers.lastId = (QListInlineHandlers.lastId || 0) + 1,
        this.id = QListInlineHandlers.lastId;
        var config_defaults = {
            key: "id",
            max_rows: null
        };
        config = $.extend(config_defaults, config);
        var $store, o = QListInlineHandlers.operations, handlers = this;
        this._subscribers = [],
        this.menuSelector = menuSelector,
        ctxt.jquery && ctxt.length && ($store = ctxt,
        ctxt = JSON.parse(ctxt.val())),
        $.each(ctxt, function(i, e) {
            config.key in e || (e[config.key] = i)
        }),
        ctxt.replaceAll = function(contents) {
            var args = [0, this.length].concat(contents);
            Array.prototype.splice.apply(this, args)
        }
        ,
        $.extend(this, {
            ops: QListInlineHandlers.operations,
            config: config,
            key: config.key,
            _data_key: "row-handler-" + config.key,
            ctxt: ctxt,
            $store: $store,
            submitted: !1,
            append_rows: inline_append_rows,
            add_row_to_table: add_row_to_table,
            add_fixed_row: inline_add_fixed_row,
            inline_create: inline_create,
            inline_edit: inline_edit,
            inline_delete: inline_delete,
            input_format: input_format,
            select_format: select_format,
            toggle_format: toggle_format,
            file_format: file_format,
            multiple_checkbox_format: multiple_checkbox_format,
            refresh_qlist: refresh_qlist,
            replace_contents: replace_contents,
            menu_scope_init_fns: [],
            menu_scopes: []
        })
    }
    var PASSWORD_DOT = "●";
    if (QListInlineHandlers.operations = {
        INIT: "init",
        MOVE: "move",
        CREATE: "create",
        DELETE: "delete",
        EDIT: "edit",
        CHANGE: "change"
    },
    $.extend(QListInlineHandlers.prototype, {
        qlist: function() {
            return this.$qlistElem.qlist.apply(this.$qlistElem, arguments)
        },
        modified: function() {},
        subscribe: function(operation, callback) {
            if ("function" == typeof operation && (callback = operation,
            operation = null),
            void 0 === operation)
                throw new Error("Invalid arguments. Please specify a valid operation, null or omit it completely");
            var subscription = {
                cb: callback,
                op: operation
            };
            this._subscribers.push(subscription);
            var unsubscribe = function() {
                var index = this._subscribers.indexOf(subscription);
                index > -1 && this._subscribers.splice(index, 1)
            }
            .bind(this);
            return unsubscribe
        },
        _modified: function(operation) {
            var result = this.modified.apply(this, arguments);
            return this._subscribers.forEach(function(args, sub) {
                var sub_result, op_match = sub.op === operation, array_match = sub.op && Array.isArray(sub.op) && -1 !== sub.op.indexOf(operation);
                if (op_match && (args = Array.prototype.slice.call(args, 1)),
                !sub.op || array_match || op_match) {
                    if (sub_result = sub.cb.apply(this, args),
                    result && sub_result)
                        throw new Error("Only one subscriber may return a result/promise");
                    result || (result = sub_result)
                }
            }
            .bind(this, arguments)),
            result
        },
        _init_row: function(row, $tr) {
            function dup_value_checker(entries_fn, row, selector) {
                function not_row(v) {
                    return v !== row
                }
                function pluck(v) {
                    return v[selector]
                }
                return function() {
                    return entries_fn().filter(not_row).map(pluck)
                }
            }
            function by_selector(s) {
                return function(col) {
                    return col.selector === s
                }
            }
            var $elems = $tr.find(".InlineHandlerDupChecker");
            $elems.each(function(i, elem) {
                var $elem = $(elem)
                  , selector = $elem.data("name")
                  , config = this.config.qlist_config
                  , col = config.columns.filter(by_selector(selector))[0]
                  , dup_checker = col && col.validate && (col.validate.InlineHandlerDupChecker || /(^|\b)InlineHandlerDupChecker($|\b)/.test(col.validate["class"]));
                if (dup_checker) {
                    if (dup_checker === !0) {
                        var entries = this.ctxt;
                        dup_checker = function() {
                            return entries
                        }
                    }
                    $elem.addClass("ValueDupChecker"),
                    $elem.data("ValueDupChecker", dup_value_checker(dup_checker, row, selector))
                }
            }
            .bind(this))
        },
        _subscribers: null,
        set_defaults: function(defaults) {
            this.defaults = defaults
        },
        menu_scope_init: function(fn) {
            this.menu_scope_init_fns.push(fn)
        },
        attach: function(config) {
            function select_col($td, col, entry) {
                return $td.addClass("inline"),
                h.select_format(col.selector, entry, col.options, col.validate, col.deps)
            }
            function toggle_col($td, col, entry) {
                return $td.addClass("inline"),
                h.toggle_format(col.selector, entry, "enable", "disable", col.deps)
            }
            function text_col($td, col, entry) {
                return $td.addClass("inline"),
                h.input_format(col.selector, entry, col.inline_type, col.validate, col.deps, col.placeholder)
            }
            function add_formatter(col) {
                function schema_option(result, option) {
                    var lang_key = option_lang_prefix + [schema.name, col.selector, option.name].join(".")
                      , translated = $.getInfo(lang_key, !0, !0);
                    return result[option.name] = translated || option.name,
                    result
                }
                var s = col.selector
                  , schema_col = schema && schema.children[s];
                config.format_fn[s] || ("options"in col || !schema_col || !schema_col.options || (col.options = schema_col.options.reduce(schema_option, {})),
                col.options ? "disable,enable" === Object.keys(col.options).sort().join(",") ? config.format_fn[s] = toggle_col : config.format_fn[s] = select_col : config.format_fn[s] = text_col)
            }
            function initMenus() {
                require(["angular", "jquery.ng_app"], function(angular, ng_app) {
                    var $menuAppElem = $(h.menuSelector)
                      , module = angular.module(h.menuSelector, []);
                    module.controller(ng_app.DEFAULT_QLIST_MENU_ITEMS_CONTROLLER, controller),
                    $menuAppElem.ng_app({
                        modules: [h.menuSelector]
                    })
                })
            }
            function controller($scope) {
                if (!$scope.__TESTING__) {
                    $scope.handlers = {};
                    var menu_items = $.extend({}, {
                        create: {
                            handler: h.inline_create
                        },
                        edit: {
                            handler: h.inline_edit
                        },
                        "delete": {
                            handler: h.inline_delete
                        }
                    }, config.menu_items || {});
                    Object.keys(menu_items).forEach(function(key) {
                        $scope[key] = menu_items[key].handler
                    }),
                    $scope.qlistSelector = h.qlistSelector,
                    h.menu_scopes.push($scope),
                    h.updateMenus(),
                    $scope.createEnabled = function() {
                        return this.menusEnabled.create
                    }
                    ,
                    $scope.editEnabled = function() {
                        return this.menusEnabled.edit
                    }
                    ,
                    $scope.editCliEnabled = function() {
                        return !1
                    }
                    ,
                    $scope.cloneEnabled = function() {
                        return this.menusEnabled.clone
                    }
                    ,
                    $scope.deleteEnabled = function() {
                        return this.menusEnabled["delete"]
                    }
                    ,
                    h.menu_scope_init_fns.forEach(function(fn) {
                        fn($scope)
                    })
                }
            }
            var l, load, h = this, schema = this.config.schema, option_lang_prefix = this.config.option_lang_prefix || "";
            if (config.row_attr = config.row_attr || [],
            config.row_attr.push({
                name: "data-" + this._data_key,
                selector: this.key
            }),
            config.options = config.options || {},
            config.options.inline = !0,
            config.columns) {
                config.format_fn = config.format_fn || {},
                l = config.columns.length;
                for (var i = 0; l > i; ++i)
                    add_formatter(config.columns[i])
            }
            return config.source || (config.source = this.ctxt),
            config.callbacks = config.callbacks || {},
            load = config.callbacks.load,
            config.callbacks.load = function() {
                var o = QListInlineHandlers.operations;
                h.$qlistElem = $(this),
                $.isFunction(load) && load.apply(this, arguments),
                h.$qlistElem.find("tr").each(function() {
                    var id = this.getAttribute("data-row-handler-id")
                      , entry = h.ctxt.filter(h._row_match(id))[0]
                      , $tr = $(this);
                    h._init_row(entry, $tr),
                    h._modified(o.INIT, h.ctxt, entry, null, $tr)
                }),
                h.fixed && (h.fixed.$tr = h.add_row_to_table(h.fixed.row),
                h.fixed.$tr.removeAttr("data-source-index"),
                h.fixed.$tr.toggleClass("pol_implicit", !0)),
                h.selected = [],
                h.$qlistElem.on("qlist_select_rows.inline_handlers", function(event, data) {
                    h.selected = data.entries.filter(function(row) {
                        return !!row
                    }),
                    h.fixed && h.fixed.$tr.hasClass("selected") && (h.selected.push(h.fixed.row),
                    h.selected.fixed = !0),
                    h.updateMenus()
                }),
                initMenus()
            }
            ,
            this.config.qlist_config = config,
            config
        },
        update_form: function() {
            this.submitted = !0;
            var fixed = this.fixed && this.fixed.submit ? [this.fixed.row] : [];
            if (this.$store) {
                var copy = this.ctxt.concat(fixed).map(function(orig) {
                    if (orig._password_orig) {
                        var result = {};
                        for (var i in orig)
                            i in orig._password_orig && orig._password_orig[i] === orig[i] || (result[i] = orig[i]);
                        return result
                    }
                    return orig
                });
                this.$store.val(JSON.stringify(copy))
            }
            return this._validate()
        },
        _validate: function() {
            var validator, valid = !0, h = this, columns = h.config.qlist_config.columns, $elem = this.$store || this.$qlistElem;
            if (!$elem)
                return !0;
            var form = $elem.closest("form").get(0);
            return validator = $(form).validate(),
            $.each(this.ctxt, function(i, entry) {
                var $row = h.$qlistElem.find('[data-row-handler-id="' + entry[h.key] + '"]');
                $row.toggleClass("editing", !0),
                $.each(columns, function(i, col) {
                    if (col.validate) {
                        var $elems = $row.find("." + col.selector + " .inline-edit");
                        $elems.is(":input") || ($elems = $elems.find(":input").first()),
                        $elems.each(function() {
                            var $elem = $(this);
                            valid = validator.element($elem) && valid,
                            valid && $elem.prop("name", null)
                        })
                    }
                }),
                $row.toggleClass("editing", !1)
            }),
            valid
        },
        updateMenus: function() {
            if (this.menu_scopes.length) {
                var max_rows = this.config.max_rows;
                max_rows && $.isFunction(max_rows) && (max_rows = max_rows());
                var can_create = (null === max_rows || this.ctxt.length < max_rows) && !this.config.read_only
                  , selected_row_count = this.selected.length
                  , apply = function(scope) {
                    scope.menusEnabled = scope.menusEnabled || {},
                    scope.menusEnabled.create = can_create,
                    scope.menusEnabled.edit = !this.config.read_only && 1 === selected_row_count,
                    scope.menusEnabled["delete"] = !this.config.read_only && !this.selected.fixed && selected_row_count > 0
                }
                .bind(this);
                this.menu_scopes.forEach(function(scope) {
                    scope.$$phase ? apply(scope) : scope.$apply(apply)
                })
            }
        },
        _row_match: function(id) {
            var handlers = this;
            return function(row_entry) {
                return String(row_entry[handlers.key]) === String(id)
            }
        }
    }),
    void 0 !== window.QListInlineHandlers)
        throw new Error("QListInlineHandlers already defined");
    window.QListInlineHandlers = QListInlineHandlers
}(jQuery, fweb),
function($) {
    "use strict";
    function get_new_display_master(length) {
        for (var new_display_master = [], _i = 0; length > _i; ++_i)
            new_display_master.push(_i);
        return new_display_master
    }
    function get_cookie_name(prefix) {
        return prefix + "_sorting_settings"
    }
    function clean_sorting_cookie_data(sorting_cookie_data, config) {
        var i, l, p, x, sort_item_template = {
            selector: "",
            direction: ""
        };
        if ($.isArray(sorting_cookie_data)) {
            for (l = sorting_cookie_data.length,
            i = 0; l > i; i++) {
                x = sorting_cookie_data[i];
                for (p in x)
                    x.hasOwnProperty(p) && !sort_item_template.hasOwnProperty(p) && delete x[p]
            }
            sorting_cookie_data = $.grep(sorting_cookie_data, function(x) {
                for (var p in sort_item_template)
                    if (sort_item_template.hasOwnProperty(p) && !x.hasOwnProperty(p))
                        return !1;
                return config.column_map.hasOwnProperty(x.selector)
            })
        } else
            sorting_cookie_data = void 0;
        return sorting_cookie_data
    }
    function simple_sort_comp_fn(x, y) {
        return y > x ? -1 : x > y ? 1 : 0
    }
    function default_clientside_sort_comp_fn(x, y) {
        function quick_type(obj) {
            var result = typeof obj;
            return "object" === result ? $.type(obj) : result
        }
        var xtype, x_reg_result, ytype, y_reg_result, ret;
        if (xtype = quick_type(x),
        ytype = quick_type(y),
        xtype === ytype)
            if ("string" === xtype) {
                if (x = x.toLowerCase(),
                y = y.toLowerCase(),
                x === y)
                    return 0;
                if (null === (x_reg_result = _digit_regex.exec(x)) || null === (y_reg_result = _digit_regex.exec(y)) || x_reg_result[1] !== y_reg_result[1])
                    return _no_locale_regex.test(x) && _no_locale_regex.test(y) ? x > y ? 1 : x === y ? 0 : -1 : x.localeCompare(y);
                if (ret = parseInt(x_reg_result[2], 10) - parseInt(y_reg_result[2], 10),
                0 !== ret)
                    return ret
            } else {
                if ("number" === xtype)
                    return x - y;
                if (null == x)
                    return 0
            }
        return null == y && (y = "number" === xtype ? 1 / 0 : "z" + y),
        null == x && (x = "number" === ytype ? 1 / 0 : "z" + x),
        y > x ? -1 : x > y ? 1 : 0
    }
    function numeric_sort_fn(x, y) {
        return x - y
    }
    function ip4_addr_sort(x, skip_test) {
        return skip_test || RegExpCommon.IP_HOST.test(x) ? (x = x.split("."),
        x.reduce(function(result, octet, i) {
            return (result | parseInt(octet, 10) << 8 * (3 - i)) >>> 0
        }, 0)) : 16777215
    }
    function ip6_addr_sort(x, skip_test) {
        if (!skip_test && !RegExpCommon.IP6_HOST.test(x))
            return x;
        var i, g = [], halves = x.split("::");
        if (2 === halves.length) {
            var first = halves[0].split(":")
              , last = halves[1].split(":");
            1 === first.length && "" === first[0] && (first = []),
            1 === last.length && "" === last[0] && (last = []);
            var remaining = 8 - (first.length + last.length);
            for (i = 0; i < first.length; i++)
                g.push(first[i]);
            for (i = 0; remaining > i; i++)
                g.push(0);
            for (i = 0; i < last.length; i++)
                g.push(last[i])
        } else
            1 === halves.length && (g = x.split(":"));
        var s;
        for (i = 0; i < g.length; i++)
            s = g[i],
            g[i] = "0000".substr(s.length) + s;
        return g.join("").toLowerCase()
    }
    function ip_addr_sort_compare(a, b) {
        return a = ip_addr_sort(a),
        b = ip_addr_sort(b),
        "number" == typeof a && "number" == typeof b ? a - b : a > b ? 1 : a === b ? 0 : -1
    }
    function ip_addr_sort(x) {
        return RegExpCommon.IP_HOST.test(x) ? ip4_addr_sort(x, !0) : RegExpCommon.IP6_HOST.test(x) ? "1" + ip6_addr_sort(x, !0) : "26553565535655356553565535655356553565535"
    }
    function ip_mask_sort(x) {
        return ip_addr_sort(x.split("/")[0])
    }
    var try_JSON_parse = fweb.util.dom.try_JSON_parse
      , RegExpCommon = fweb.util.patterns.commonRegExp
      , $cookieStore = {
        remove: fweb.util.persist.removeCookie,
        get: function(n) {
            return try_JSON_parse(fweb.util.persist.getCookie(n))
        },
        put: function(n, v) {
            return fweb.util.persist.setCookie(n, JSON.stringify(v))
        }
    }
      , SortState = function() {};
    SortState.prototype.init = function() {
        this._sorting_cache = {}
    }
    ,
    SortState.prototype.preload = function(that, internal) {
        if (this.core_config = internal.core.config,
        this.config = this.core_config.sort,
        this.core_state = internal.core.state,
        this.el = $(that),
        this.internal_fns = {
            qlistRefreshTable: internal.core.fn.qlistRefreshTable
        },
        null == this.core_state.sorting) {
            var sorting_cookie_data;
            this.config.save_in_cookie && (sorting_cookie_data = clean_sorting_cookie_data($cookieStore.get(this.cookie_name), this.core_config)),
            this.core_state.sorting = sorting_cookie_data || this.core_config.default_sort
        }
        this.resortIfNeeded()
    }
    ,
    SortState.prototype.postload = function(that, internal) {
        this.head_row = internal.core.head_row,
        this.add_sortable_indicators(),
        this.set_current_sort_icon(),
        this.head_row.off("click.sort"),
        this.head_row.on("click.sort", $.proxy(this, "onHeaderClick")),
        this.el.on("reset_columns.sort", $.proxy(this, "reset_sorting"))
    }
    ,
    SortState.prototype.resetDisplayMasterIfNeeded = function() {
        var source = this.getSource()
          , displayMaster = this.getDisplayMaster();
        return null == displayMaster || displayMaster.length !== source.length ? (this.setDisplayMaster(get_new_display_master(source.length)),
        !0) : !1
    }
    ,
    SortState.prototype.destroy = function() {
        this.core_state = null,
        this.core_config = null,
        this.el = null,
        null != this.head_row && this.head_row.off("click.sort"),
        this.head_row = null,
        this.internal_fns = null
    }
    ,
    SortState.prototype.onHeaderClick = function(event) {
        if (!this.core_config.options.fixed_sort) {
            var config = this.core_config
              , sort_columns = config.options.sort_columns
              , el = $(event.target).closest("th")
              , selector = el.data("selector");
            $.isFunction(config.callbacks.pre_sort) && config.callbacks.pre_sort(event, el, selector),
            this.el.find("tr.empty_row").length > 0 || (config.sort_fn["*"] || selector in config.sort_fn) && (event.stopPropagation(),
            (!sort_columns || sort_columns[selector]) && this.do_sort_toggle(selector))
        }
    }
    ,
    SortState.prototype.prepareFastSort = function(target) {
        this.core_config.fast_sort = [],
        this.core_config.fast_sort_target = target
    }
    ,
    SortState.prototype.disableFastSort = function() {
        this.core_config.fast_sort = void 0
    }
    ,
    SortState.prototype.checkFastSort = function(target) {
        this.config.fast_update === !1 || this.core_config.paging.enabled || null !== this.core_config.category.q_type && null != this.core_config.column_map.category ? this.disableFastSort() : this.prepareFastSort(target || this.el.find("tbody").eq(0))
    }
    ,
    SortState.prototype.fastSortEnabled = function(check) {
        return check && this.checkFastSort(),
        void 0 !== this.core_config.fast_sort
    }
    ,
    SortState.prototype.clear_sorting_cache = function() {
        this.core_state.display_master = get_new_display_master(this.getSource().length),
        this._sorting_cache = {},
        this.checkFastSort()
    }
    ,
    SortState.prototype.reset_sorting = function() {
        this.clear_sorting_cache(),
        this.source_order_indicator = !1,
        this.setSortValue(this.getDefaultSort()),
        $cookieStore.remove(this.cookie_name);
        var sortValue = this.getSortValue();
        null != sortValue && sortValue.length > 0 && this._do_sort()
    }
    ,
    SortState.prototype.getSortValue = function() {
        return this.core_state.sorting
    }
    ,
    SortState.prototype.setSortValue = function(value) {
        this.core_state.sorting = value
    }
    ,
    SortState.prototype.getDisplayMaster = function() {
        return this.core_state.display_master
    }
    ,
    SortState.prototype.setDisplayMaster = function(value) {
        this.core_state.display_master = value
    }
    ,
    SortState.prototype.getSource = function() {
        return this.core_config.source
    }
    ,
    SortState.prototype.getDefaultSort = function() {
        return this.core_config.default_sort
    }
    ,
    SortState.prototype.source_load_complete = function() {
        this.resortIfNeeded()
    }
    ,
    SortState.prototype.resortIfNeeded = function() {
        var sorting = this.getSortValue();
        this.resetDisplayMasterIfNeeded() && null != sorting && sorting.length > 0 && null != this.getSource() && (sorting !== this.getDefaultSort() || !this.config.default_sort_is_serverside) && this._do_sort()
    }
    ,
    SortState.prototype.set_current_sort_icon = function() {
        var sortValue = this.getSortValue()
          , source = this.getSource()
          , source_order = this.core_config.options.sort_source_order;
        sortValue && sortValue.length || !source_order || (sortValue = [source_order],
        this.setSortValue(sortValue));
        var $head_row, current_sort = (source.length > 0 || "then"in source) && null != sortValue ? sortValue[0] : void 0;
        $head_row = this.core_config.options.inline ? this.head_row : this.el.find(".qlist-fixed-head tr.heading"),
        $head_row.find("th").each(function() {
            var icon_class, $this = $(this), selector = $this.data("selector"), $indicator = $this.find(".sort-indicator");
            $indicator.find(".current-sort").remove(),
            current_sort && selector === current_sort.selector && (icon_class = "current-sort fa-sort-" + current_sort.direction,
            $indicator.append('<f-icon class="' + icon_class + '"></f-icon>'))
        })
    }
    ,
    SortState.prototype.add_sortable_indicators = function() {
        var config = this.core_config;
        if (!config.options.fixed_sort) {
            var sort_columns = config.options.sort_columns;
            this.el.find("tr.empty_row").length || this.head_row.add(this.el.find(".qlist-fixed-head tr.heading")).each(function() {
                $(this).find("th").each(function() {
                    var $this = $(this)
                      , selector = $this.data("selector");
                    if ((config.sort_fn["*"] || selector in config.sort_fn) && (!sort_columns || sort_columns[selector])) {
                        $this.addClass("can-sort");
                        var $inner_div = $this.find("> div");
                        $inner_div.find(".sort-indicator").length || $inner_div.append('<div class="sort-indicator"><f-icon class="fa-sort"></f-icon></div>')
                    }
                })
            })
        }
    }
    ;
    var argIndexOf, isServerSort, serverSortIndex, __indexOf = [].indexOf || function(item) {
        for (var i = 0, l = this.length; l > i; i++)
            if (i in this && this[i] === item)
                return i;
        return -1
    }
    ;
    SortState.prototype.do_sort_toggle = function(selector) {
        var config, current_direction, dirs, new_direction, state, _i, _len, _ref, _ref1;
        for (config = this.core_config,
        _ref = this.getSortValue(),
        _i = 0,
        _len = _ref.length; _len > _i; _i++)
            if (state = _ref[_i],
            state.selector === selector) {
                current_direction = state.direction;
                break
            }
        if (config.options.sort_columns && "string" == typeof config.options.sort_columns[selector]) {
            if (_ref.length && _ref[0].selector === selector)
                return;
            new_direction = config.options.sort_columns[selector]
        } else
            dirs = null != (_ref1 = config.sort_fn[selector]) ? _ref1.directions : void 0,
            new_direction = null != dirs ? dirs[($.inArray(current_direction, dirs) + 1) % dirs.length] : "asc" === current_direction ? "desc" : "asc";
        return this.do_sort([{
            selector: selector,
            direction: new_direction
        }])
    }
    ,
    SortState.prototype.do_sort = function(sort_args) {
        var config, defer, del_indicies, directionsNotRemoved, el, i, new_top_state, odd, old_sort_state, old_top_state, prevServerSortIndex, selectors, sortValue, sorting_event, _i, _j, _len, _len1, _ref, _ref3, _ref4, _this = this;
        if (config = this.core_config,
        old_sort_state = null != (_ref = this.getSortValue()) ? _ref.slice(0) : void 0,
        prevServerSortIndex = argIndexOf(old_sort_state, this.prevServerSort),
        null != sort_args) {
            for (old_top_state = this.getSortValue()[0],
            new_top_state = sort_args[0],
            selectors = $.map(sort_args, function(arg) {
                return arg.selector
            }),
            sortValue = this.getSortValue(),
            directionsNotRemoved = {},
            del_indicies = $.grep(get_new_display_master(sortValue.length), function(i) {
                var duplicate, st, _ref3, sort_fn;
                return st = sortValue[i],
                sort_fn = _this.core_config.sort_fn[st.selector],
                sort_fn && isServerSort(st, sort_fn) ? (_ref3 = st.direction,
                duplicate = __indexOf.call(directionsNotRemoved[st.selector] || [], _ref3) >= 0,
                duplicate || (directionsNotRemoved[st.selector] || (directionsNotRemoved[st.selector] = [])).push(st.direction),
                duplicate) : $.inArray(st.selector, selectors) >= 0
            }),
            _ref3 = del_indicies.reverse(),
            _i = 0,
            _len = _ref3.length; _len > _i; _i++)
                i = _ref3[_i],
                sortValue.splice(i, 1);
            this.setSortValue(clean_sorting_cookie_data(sort_args.slice(0).concat(this.getSortValue()), this.core_config))
        }
        if (sorting_event = $.Event("sorting"),
        this.el.trigger(sorting_event, [old_sort_state]),
        this.config.save_in_cookie && $cookieStore.put(config.ck_name.sorting, this.getSortValue()),
        sorting_event.isDefaultPrevented())
            return !1;
        if (defer = this._do_sort(null != sort_args ? sort_args.length : void 0, prevServerSortIndex))
            return defer;
        if (null != this.core_state.fast_sort)
            for (_ref4 = this.getDisplayMaster(),
            _j = 0,
            _len1 = _ref4.length; _len1 > _j; _j++)
                i = _ref4[_j],
                null != (el = this.core_state.fast_sort[i]) && (el.appendTo(this.core_state.fast_sort_target),
                odd ? el.addClass("odd") : el.removeClass("odd"),
                odd = !odd);
        else
            this.internal_fns.qlistRefreshTable();
        return this.el.trigger("sort", [old_sort_state]),
        !0
    }
    ,
    isServerSort = function(arg, fn) {
        var sort_fn, value = !1;
        return "server" === fn.kind || "complex" === fn.kind && fn.server ? value = !0 : (sort_fn = fn[arg.direction] || fn["*"]) && (value = "server" === sort_fn.kind),
        value
    }
    ,
    serverSortIndex = function(args) {
        var arg, i, r, _i, _len;
        for (r = -1,
        i = _i = 0,
        _len = args.length; _len > _i; i = ++_i)
            if (arg = args[i],
            isServerSort(arg, arg.fn)) {
                r = i;
                break
            }
        return r
    }
    ,
    argIndexOf = function(args, target) {
        var arg, i, r, _i, _len;
        if (r = -1,
        null == target)
            return r;
        for (i = _i = 0,
        _len = args.length; _len > _i; i = ++_i)
            if (arg = args[i],
            target.selector === arg.selector && target.direction === arg.direction) {
                r = i;
                break
            }
        return r
    }
    ,
    SortState.prototype.isNewServerSort = function(arg) {
        var p;
        return p = this.prevServerSort,
        null != arg && (null == p || arg.selector !== p.selector || arg.direction !== p.direction)
    }
    ,
    SortState.prototype.isGlobalServerSort = function() {
        var value = !1;
        return this.core_config.sort_fn["*"] && (value = isServerSort({
            selector: "*",
            direction: "*"
        }, this.core_config.sort_fn["*"])),
        value
    }
    ,
    SortState.prototype._doServerSort = function(index) {
        var sortArg, sortFn, sortFns;
        return null == index && (index = 0),
        sortFns = this.core_config.sort_fn,
        sortArg = this.getSortValue()[index],
        sortFn = sortFns[sortArg.selector] || sortFns["*"],
        "complex" === sortFn.kind && (sortFn = sortFn[sortArg.direction] || sortFn["*"] || sortFn.server),
        sortFn({
            current_sort: this.getSortValue(),
            target_sort: sortArg,
            display_master: this.getDisplayMaster()
        })
    }
    ,
    SortState.prototype._do_sort = function(count, prevServerSortIndex) {
        function gen_sort_cache() {
            var _l, _len3, _results;
            for (_results = [],
            _l = 0,
            _len3 = source.length; _len3 > _l; _l++)
                val = source[_l],
                _results.push(config.sort_fn[arg.selector](val[arg.selector]));
            return _results
        }
        function gen_key_cache() {
            var _l, _len3, _results;
            for (_results = [],
            _l = 0,
            _len3 = source.length; _len3 > _l; _l++)
                val = source[_l],
                _results.push(config.sort_fn[arg.selector](val));
            return _results
        }
        var arg, args, category_map, category_sort_fn, config, currentServerSort, currentServerSortIndex, defer, display_current, entry, get_complex_sort_child_test, get_simple_test, i, j, prevServerSort, source, tmp_obj, val, _i, _j, _k, _l, _len, _len1, _len2, _len3, _ref, _ref1, _ref2, _ref3, _s, _this = this;
        if (null == prevServerSortIndex && (prevServerSortIndex = -1),
        config = this.core_config,
        0 === this.getSortValue().length)
            return void this.setDisplayMaster(get_new_display_master());
        for (args = count ? this.getSortValue().slice(0, count) : this.getSortValue().slice(0),
        i = _i = 0,
        _len = args.length; _len > _i; i = ++_i)
            arg = args[i],
            tmp_obj = {
                fn: config.sort_fn[(_s = arg.selector)in config.sort_fn ? _s : "*"]
            },
            args[i] = $.extend(tmp_obj, args[i]);
        if (this.isGlobalServerSort(currentServerSort))
            return this._doServerSort() || !0;
        if (prevServerSort = this.prevServerSort,
        currentServerSortIndex = serverSortIndex(args),
        currentServerSort = this.getSortValue()[currentServerSortIndex],
        null != currentServerSort && (this.isNewServerSort(currentServerSort) || -1 !== prevServerSortIndex && currentServerSortIndex !== prevServerSortIndex))
            return this.prevServerSort = currentServerSort,
            defer = this._doServerSort(currentServerSortIndex),
            0 === currentServerSortIndex && this.setDisplayMaster(get_new_display_master()),
            defer || !0;
        if (currentServerSortIndex >= 0 && (args = args.slice(0, currentServerSortIndex)),
        null !== config.category.q_type && null != config.column_map.category) {
            for (category_map = {},
            _ref = this.getSource(),
            i = _j = 0,
            _len1 = _ref.length; _len1 > _j; i = ++_j)
                entry = _ref[i],
                entry.category in category_map || (category_map[entry.category] = i);
            category_sort_fn = function(a, b) {
                return numeric_sort_fn(category_map[a], category_map[b])
            }
            ,
            args.unshift({
                selector: "category",
                direction: "asc",
                fn: category_sort_fn
            })
        }
        for (source = this.getSource(),
        _k = 0,
        _len2 = args.length; _len2 > _k; _k++)
            arg = args[_k],
            "key" !== (null != (_ref1 = config.sort_fn[arg.selector]) ? _ref1.kind : void 0) || arg.selector in this._sorting_cache ? "key_row" !== (null != (_ref2 = config.sort_fn[arg.selector]) ? _ref2.kind : void 0) || arg.selector in this._sorting_cache || (this._sorting_cache[arg.selector] = gen_key_cache(source, config)) : this._sorting_cache[arg.selector] = gen_sort_cache(source, config);
        for (display_current = [],
        _ref3 = this.getDisplayMaster(),
        i = _l = 0,
        _len3 = _ref3.length; _len3 > _l; i = ++_l)
            j = _ref3[i],
            display_current[j] = i;
        get_simple_test = function(fn, arg, a, b) {
            return "comp_row" === fn.kind ? fn(source[a], source[b], default_clientside_sort_comp_fn) : fn(source[a][arg.selector], source[b][arg.selector], default_clientside_sort_comp_fn)
        }
        ,
        get_complex_sort_child_test = function(fn, arg, a, b) {
            return "key" === fn.kind ? simple_sort_comp_fn(fn(source[a][arg.selector]), fn(source[b][arg.selector])) : "key_row" === fn.kind ? simple_sort_comp_fn(fn(source[a]), fn(source[b])) : get_simple_test(fn, arg, a, b)
        }
        ,
        this.getDisplayMaster().sort(function(a, b) {
            var test, _len4, _m;
            if (null != source[a] && null != source[b])
                for (_m = 0,
                _len4 = args.length; _len4 > _m; _m++) {
                    if (arg = args[_m],
                    "key" === arg.fn.kind || "key_row" === arg.fn.kind)
                        test = simple_sort_comp_fn(_this._sorting_cache[arg.selector][a], _this._sorting_cache[arg.selector][b]);
                    else if ("complex" === arg.fn.kind)
                        if ("asc"in arg.fn && "asc" === arg.direction)
                            test = get_complex_sort_child_test(arg.fn.asc, arg, a, b);
                        else if ("desc"in arg.fn && "desc" === arg.direction)
                            test = get_complex_sort_child_test(arg.fn.desc, arg, a, b);
                        else {
                            if (!("ascdesc"in arg.fn) || "asc" !== arg.direction && "desc" !== arg.direction)
                                return get_complex_sort_child_test(arg.fn[arg.direction], arg, a, b);
                            test = get_complex_sort_child_test(arg.fn.ascdesc, arg, a, b)
                        }
                    else
                        test = get_simple_test(arg.fn, arg, a, b);
                    if (0 !== test)
                        return "asc" === arg.direction ? test : -test
                }
            return numeric_sort_fn(display_current[a], display_current[b])
        })
    }
    ,
    simple_sort_comp_fn.kind = "comp";
    var _digit_regex = /^(\D*)(\d{1,15})/
      , _no_locale_regex = /^[\w\-.\s]*$/;
    default_clientside_sort_comp_fn.kind = "comp",
    ip4_addr_sort.kind = "key",
    ip6_addr_sort.kind = "key",
    ip_addr_sort_compare.kind = "comp",
    ip_addr_sort.kind = "key",
    ip_mask_sort.kind = "key",
    "undefined" == typeof $.qlist && ($.qlist = {}),
    "undefined" == typeof $.qlist.sort_fns && ($.qlist.sort_fns = {}),
    $.qlist.sort_fns.ip4_addr_sort = ip4_addr_sort,
    $.qlist.sort_fns.ip6_addr_sort = ip6_addr_sort,
    $.qlist.sort_fns.ip_addr_sort = ip_addr_sort,
    $.qlist.sort_fns.ip_mask_sort = ip_mask_sort,
    $.qlist.ext || ($.qlist.ext = {});
    var extension = $.qlist.ext.sort = {
        config_path: "sort",
        managed: !0,
        enabled_config_path: "options.sorting",
        staticDepends: ["display_master"],
        defaults: {
            fast_update: !0,
            save_in_cookie: !0,
            hidden_sort: [],
            default_sort_is_serverside: !1
        },
        core_defaults: {
            default_sort: [],
            options: {
                sorting: !1,
                sort_columns: null,
                fixed_sort: !1
            },
            sort_fn: {
                "*": default_clientside_sort_comp_fn
            }
        },
        constructor: SortState,
        commands: {
            sort: function(that, internal_core, command) {
                var self = internal_core.$self;
                if (null != self)
                    return "string" === $.type(command) ? "clear_cache" === command ? self.clear_sorting_cache() : "reset" === command && self.reset_sorting() : self.do_sort(command),
                    that
            },
            getSortValue: function(that, internal_core) {
                var self = internal_core.$self;
                return null != self ? self.getSortValue() : void 0
            }
        },
        postconfigure: function(that, internal) {
            internal.core.config.ck_name.sorting = get_cookie_name(internal.core.config.prefix)
        },
        preload: function(that, internal) {
            var self = internal.$self;
            return null == self && (self = new SortState,
            self.init()),
            self.cookie_name = get_cookie_name(internal.core.config.prefix),
            self.preload(that, internal),
            "undefined" != typeof angular && $(that).one("$destroy", function() {
                self.destroy(),
                internal.core.state.sort = null
            }),
            self
        },
        postload: function(that, internal) {
            var self = internal.$self;
            return null == self && (self = new SortState,
            self.init()),
            self.cookie_name = get_cookie_name(internal.core.config.prefix),
            self.postload(that, internal),
            "undefined" != typeof angular && $(that).one("$destroy", function() {
                self.destroy(),
                internal.core.state.sort = null
            }),
            self
        },
        source_load_complete: function(that, internal) {
            null != internal.$self && internal.$self.source_load_complete()
        },
        load_row_frag: function(that, internal) {
            var state = internal.core.state
              , display_master = state.display_master
              , len = internal.core.config.source.length;
            display_master && display_master.length === len || (display_master = state.display_master = get_new_display_master(len))
        }
    };
    window.qlist_sorting = {
        ext: extension,
        constructor: SortState,
        get_new_display_master: get_new_display_master,
        sort_fns: {
            ip4_addr_sort: ip4_addr_sort,
            ip6_addr_sort: ip6_addr_sort,
            ip_addr_sort: ip_addr_sort,
            ip_addr_sort_compare: ip_addr_sort_compare,
            ip_mask_sort: ip_mask_sort
        }
    }
}(jQuery),
function($) {
    "use strict";
    function simplify_matches(matches) {
        return matches.sort(function(a, b) {
            var a_type = $.type(a)
              , b_type = $.type(b);
            return a_type === b_type && "array" === a_type ? a[0] - b[0] : b > a ? -1 : a > b ? 1 : 0
        }).reduce(function(result, current) {
            if ("array" !== $.type(current))
                return result;
            if (0 === result.length)
                return result.push(current),
                result;
            var last = result[result.length - 1];
            return last[1] > current[1] ? result : last[1] > current[0] ? (last[1] = current[1],
            result) : (result.push(current),
            result)
        }, [])
    }
    function get_highlighter(that, internal_core, get_column_value) {
        function set_config(config) {
            self._config = config,
            _recalc_highlight_html()
        }
        function highlight_dom_node(node) {
            node.classList && node.classList.add(self._config.highlight_class)
        }
        function highlight_jquery_el($el, toggle) {
            null == toggle && (toggle = !0),
            $el.toggleClass(self._config.highlight_class, toggle)
        }
        function _recalc_highlight_html() {
            self._highlight_html = (null != self._config.highlight_color ? 'style="background-color: ' + self._config.highlight_color + ';" ' : "") + 'class="' + self._config.highlight_class + '"'
        }
        function insert_highlighting_spans(match, value) {
            var simplified = simplify_matches(match);
            if (simplified.length < 1)
                throw new Error("Match array is invalid");
            var span_begin = "<span " + self._highlight_html + ">";
            return $.each(simplified.reverse(), function(i, current_match) {
                var start = current_match[0];
                "boolean" == typeof start && (start = 0),
                null == current_match[1] && (current_match = [start, value.length]),
                value = value.slice(0, current_match[0]) + span_begin + String.prototype.slice.apply(value, current_match) + "</span>" + value.slice(current_match[1])
            }),
            value
        }
        function robust_insert_highlighting_spans(match, value, fallback_original_value) {
            var original_value, $inner, matched;
            if (original_value = null != match.source ? match.source : fallback_original_value,
            value === original_value)
                try {
                    return insert_highlighting_spans(match, value)
                } catch (e) {}
            var reduced_match = match
              , match_src = match.source;
            if ($.isArray(match) ? (reduced_match = $.grep(match, function(submatch) {
                var submatch_src = submatch ? submatch.source || match_src : match_src;
                return submatch ? "string" == typeof submatch_src && fweb.util.patterns.htmlStringContains(value, submatch_src) : !1
            }),
            matched = reduced_match.length > 0) : matched = fweb.util.patterns.htmlStringContains(value, original_value),
            matched) {
                var highlightedMatches = [];
                return highlightedMatches.length = reduced_match.length,
                $inner = $("<div>"),
                $inner.append(value),
                $inner.walkTextNodes(function() {
                    for (var submatch, text = this.nodeValue, original_index = text.indexOf(original_value), everyMatchHighlighted = !0, i = 0, ii = reduced_match.length; ii > i && (submatch = reduced_match[i],
                    !0); i++)
                        if (!highlightedMatches[i]) {
                            everyMatchHighlighted = !1;
                            var source_value = submatch.source || original_value
                              , index_of_source = source_value === original_value ? original_index : text.indexOf(source_value);
                            if (index_of_source >= 0) {
                                if (source_value === text && this.classList && this.classList.contains(self._config.highlight_class)) {
                                    highlightedMatches[i] = !0;
                                    continue
                                }
                                try {
                                    $(this).replaceWith(text.slice(0, index_of_source) + insert_highlighting_spans(reduced_match, source_value) + text.slice(index_of_source + source_value.length)),
                                    highlightedMatches[i] = !0;
                                    continue
                                } catch (e) {
                                    continue
                                }
                            }
                        }
                    return everyMatchHighlighted ? !1 : void 0
                }),
                $inner.html()
            }
        }
        function robust_highlight_cell(match, value, fallback_original_value, td) {
            var formatted_value, $inner;
            return "number" === $.type(value) && (value = "" + value),
            "string" === $.type(value) && (formatted_value = robust_insert_highlighting_spans(match, value, fallback_original_value),
            null != formatted_value) ? formatted_value : ($inner = $("<div>"),
            $inner.append(value),
            null != td && td.is(".info_with_icon") || 0 !== $inner.has(SPAN_FORBIDDEN_SELECTOR).length || ($inner = $("<span>"),
            $inner.append(value)),
            value instanceof $ && value.find("." + self._config.highlight_class).length > 0 || highlight_jquery_el($inner),
            $inner)
        }
        function get_formatted_cell(td, selector, entry) {
            var source_index, $tr, search_matched, match, value, highlighted;
            if (null != state.current_results) {
                $tr = td.closest("tr"),
                source_index = $tr.data("sourceIndex"),
                null == source_index && (source_index = td.attr("atomicSourceIndex"),
                source_index && (source_index = +source_index)),
                null == source_index && (source_index = $tr.data("sectionFirstIndex")),
                search_matched = source_index in state.current_results;
                var search_selector = selector;
                if (search_matched) {
                    var search_result = state.current_results[source_index];
                    if (search_matched = selector in search_result,
                    !search_matched && selector in internal_core.config.column_map) {
                        var column_map = internal_core.config.column_map[selector];
                        if ($.isArray(column_map.combine))
                            for (var i = 0, len = column_map.combine.length; len > i && (search_selector = column_map.combine[i],
                            !(search_matched = search_selector in search_result)); ++i)
                                ;
                    }
                }
                if (!self._config.fast_update)
                    return value = get_column_value(td, selector, entry, state.current_results[source_index][search_selector]),
                    search_matched ? (match = state.current_results[source_index][search_selector],
                    highlighted = robust_highlight_cell(match, value, entry[selector], td),
                    highlighted instanceof jQuery && internal_core.config.options.atomic_render ? $("<div>").append(highlighted).html() : highlighted) : value;
                highlight_jquery_el(td, search_matched)
            }
            return get_column_value(td, selector, entry)
        }
        function get_formatted_category_header(value, first_index) {
            if (null != state.current_results) {
                var match = state.current_results[first_index].__category_header;
                if (null != match)
                    return robust_insert_highlighting_spans(match, value)
            }
            return value
        }
        var state, format_header, self = {};
        set_config(internal_core.config.search);
        var _ref, _ref2;
        return state = null == (_ref = internal_core) ? {} : null == (_ref2 = _ref.state) ? {} : _ref2.search || {},
        format_header = get_column_value,
        self.insert_highlighting_spans = insert_highlighting_spans,
        self.robust_insert_highlighting_spans = robust_insert_highlighting_spans,
        self.robust_highlight_cell = robust_highlight_cell,
        get_formatted_cell.__wrapped__ = get_column_value,
        get_formatted_category_header.__wrapped__ = get_column_value,
        self.set_config = set_config,
        self.get_formatted_cell = get_formatted_cell,
        self.get_formatted_category_header = get_formatted_category_header,
        self.highlight_html = self._highlight_html,
        self.highlight_dom_node = highlight_dom_node,
        self.highlight_jquery_el = highlight_jquery_el,
        self
    }
    var PHRASING_FORBIDDEN_SELECTOR = "address,article,aside,blockquote,details,div,dl,fieldset,figure,footer,form,h1,h2,h3,h4,h5,h6,header,hgroup,hr,map,menu,nav,ol,p,pre,section,table,ul"
      , INLINE_DISPLAY_FORBIDDEN_SELECTOR = "[display=none],[display=block]"
      , SPAN_FORBIDDEN_SELECTOR = PHRASING_FORBIDDEN_SELECTOR + "," + INLINE_DISPLAY_FORBIDDEN_SELECTOR;
    null == $.qlist.ext.objectSearch && ($.qlist.ext.objectSearch = {}),
    $.qlist.ext.objectSearch.get_highlighter = get_highlighter
}(jQuery),
function($) {
    "use strict";
    function SearchObject() {
        SearchObject.prototype.__constructor__.apply(this, arguments)
    }
    function declareSearchObject(spec, options) {
        return $.extend(new SearchObject(options), spec)
    }
    function defaultSearchObjectFactory(config) {
        return config.search.case_insensitive ? caseInsensitiveSearchObject : new SearchObject
    }
    function domSearchObjectFactory(that, internal_core, tbody, inner_search_obj) {
        return $.extend({}, inner_search_obj, {
            search_value_type: "row",
            search: dom_search_fn_factory(that, internal_core, tbody, $.proxy(inner_search_obj, "search"))
        })
    }
    function sectionHeaderSearchObjectFactory(format_fn, selector, default_search_obj) {
        var dummy_td = $("<td>");
        return declareSearchObject({
            preprocess_query: default_search_obj.preprocess_query,
            search: function(entry, query) {
                var formatted_value = format_fn(dummy_td, selector, entry)
                  , match = default_search_obj.search(formatted_value, query);
                return match && (match.source = formatted_value),
                match
            },
            search_value_type: "row"
        })
    }
    function categoryHeaderSearchObjectFactory(internal_core, default_search_obj) {
        var categories_map = internal_core.config.categories_map;
        return declareSearchObject({
            preprocess_query: default_search_obj.preprocess_query,
            search: function(entry, query) {
                var category, cur_category;
                for (cur_category in categories_map)
                    if (categories_map.hasOwnProperty(cur_category) && $.inArray(entry, categories_map[cur_category]) >= 0) {
                        category = cur_category;
                        break
                    }
                var match = default_search_obj.search(category, query);
                return match && (match.source = category),
                match
            },
            search_value_type: "row"
        })
    }
    function expansionSearchObjectFactory(that, internal_core, tbody, inner_search_obj) {
        return $.extend({}, inner_search_obj, {
            search: dom_search_fn_factory(that, internal_core, tbody, $.proxy(inner_search_obj, "search")),
            search_value_type: "row_expansion",
            expansion_parent_col: internal_core.config.search.expansion.parent_column,
            expansion_children_col: internal_core.config.search.expansion.children_column
        })
    }
    function config_fn_to_obj(config, target, config_key, options) {
        null == config_key && (config_key = target + "_fn");
        var i, _len, selector, _ref, target_fn, spec, obj = extend_merge({}, config[config_key], !0);
        for (selector in obj)
            if (obj.hasOwnProperty(selector))
                for (_ref = obj[selector],
                i = 0,
                _len = _ref.length; _len > i; i++)
                    target_fn = _ref[i],
                    spec = {},
                    spec[target] = target_fn,
                    $.extend(spec, options),
                    _ref[i] = declareSearchObject(spec);
        return obj
    }
    function do_search_callback(that, internal_core, value) {
        var deferred = $.Deferred();
        return null == internal_core.tbody && (internal_core.tbody = that.find("table.qlist tbody")),
        do_search(that, internal_core, value, deferred),
        deferred.promise()
    }
    function do_search(that, internal_core, value, deferred) {
        var state, config, search_val, tbody, indexed_rows, search_obj, searching_event, search_complete_event, old_query, args, i, _len, _ref;
        if (state = internal_core.state,
        config = internal_core.config,
        old_query = state.search.current_query,
        search_val = state.search.current_query = value,
        tbody = internal_core.tbody,
        searching_event = $.Event("searching"),
        that.trigger(searching_event, search_val),
        searching_event.isDefaultPrevented())
            return void deferred.reject();
        if (!search_val)
            return state.search.current_results = null,
            old_query !== search_val && (config.search.fast_update ? (indexed_rows = get_indexed_rows(tbody),
            _fast_filter_reset_widths(indexed_rows),
            indexed_rows.each(function(i, element) {
                $(element).show()
            })) : redraw_table(that, internal_core)),
            void deferred.resolve();
        if (old_query === search_val)
            return void deferred.resolve();
        var default_search_obj = defaultSearchObjectFactory(config);
        if (search_obj = {},
        !config.search.disable_fallback_dom_search) {
            var params = [that, internal_core, tbody, default_search_obj];
            search_obj = {
                __row__: [domSearchObjectFactory.apply(null, params)]
            },
            config.search.expansion && search_obj.__row__.push(expansionSearchObjectFactory.apply(null, params))
        }
        if (config.search.search_categories) {
            for (_ref = get_category_selectors(config),
            i = 0; i < _ref.length; i++)
                null != config.format_fn[_ref[i]] ? search_obj[_ref[i]] = [sectionHeaderSearchObjectFactory(config.format_fn[_ref[i]], _ref[i], default_search_obj)] : search_obj[_ref[i]] = [default_search_obj];
            config.categories.length > 0 && (search_obj.__category_header = [categoryHeaderSearchObjectFactory(internal_core, default_search_obj)])
        }
        for (search_obj = extend_merge(search_obj, internal_core.config.search.search_obj, !0),
        args = [["search"], ["search", "search_row_fn", {
            search_value_type: "row"
        }], ["rate"], ["group"], ["autocomplete_sync", "autocomplete_fn"]],
        i = 0,
        _len = args.length; _len > i; i++)
            search_obj = extend_merge(search_obj, config_fn_to_obj.apply(null, [config.search].concat(args[i])), !0);
        null != state.search.current_search && (state.search.current_search.cancel && state.search.current_search.cancel(),
        state.search.current_search = null),
        state.search.current_results = {},
        state.search.current_search = _do_search_async(config.source, search_val, search_obj).progress(function(search_results) {
            $.extend(state.search.current_results, search_results)
        }).then(function() {
            var search_results = state.search.current_results;
            state.search.current_search = null,
            search_complete_event = $.Event("search_complete"),
            that.trigger(search_complete_event, search_results, search_val),
            config.search.fast_update ? (indexed_rows = get_indexed_rows(tbody),
            _fast_filter_reset_widths(indexed_rows),
            indexed_rows.each(function(i, element) {
                var $element = $(element)
                  , index = $element.data("index");
                null == index && (index = $element.data("sourceIndex")),
                $element.toggle(index in search_results)
            }),
            _fast_filter_set_widths(indexed_rows)) : redraw_table(that, internal_core),
            deferred.resolve()
        }, function(e) {
            throw search_complete_event = $.Event("search_complete"),
            that.trigger(search_complete_event, state.search.current_results, search_val),
            e
        })
    }
    function _do_search(haystack, raw_query, search_obj, kwargs) {
        null == kwargs && (kwargs = {});
        var begin, end, found;
        begin = kwargs.begin,
        end = kwargs.end,
        null == begin && (begin = 0),
        null == end && (end = haystack.length);
        var search_obj_array, search_obj_cur, query, i, _len, j, results, selector, current, currentresult, currentresult_obj, currentresult_count, search_fn = function(key, value) {
            found = search_obj_cur.search("row" === search_obj_cur.search_value_type ? current : value, query, i, key),
            (found === !0 || found.length > 0) && (currentresult[key] = found,
            currentresult_count++)
        }, expand_current_results = function(entry) {
            var add_related = function(related, column) {
                var index = haystack.indexOf(related);
                index >= 0 && !results[index] && (results[index] = {},
                results[index][column] = [0, 0])
            }
              , parent_col = search_obj_cur.expansion_parent_col
              , children_col = search_obj_cur.expansion_children_col
              , parent = entry[parent_col] || null
              , children = entry[children_col] || [];
            children.forEach(function(child) {
                add_related(child, children_col)
            }),
            parent && add_related(parent, parent_col)
        };
        for (results = {},
        search_obj_array = search_obj["*"] || [],
        j = 0,
        _len = search_obj_array.length; _len > j; j++)
            for (search_obj_cur = search_obj_array[j],
            query = search_obj_cur.preprocess_query(raw_query),
            i = begin; end > i; i++)
                current = haystack[i],
                currentresult = {},
                currentresult_count = 0,
                $.each(current, search_fn),
                currentresult_count > 0 && (results[i] = extend_merge(results[i] || {}, currentresult));
        for (search_obj_array = search_obj.__row__ || [],
        j = 0,
        _len = search_obj_array.length; _len > j; j++)
            if (search_obj_cur = search_obj_array[j],
            query = search_obj_cur.preprocess_query(raw_query),
            "value" !== search_obj_cur.search_value_type)
                for (i = begin; end > i; i++)
                    current = haystack[i],
                    currentresult = search_obj_cur.search(current, query, i, "__row__"),
                    $.isArray(currentresult) && currentresult.length > 0 ? (results[i] = extend_merge(results[i] || {}, {
                        __row__: currentresult
                    }),
                    "row_expansion" === search_obj_cur.search_value_type && expand_current_results(current)) : $.isEmptyObject(currentresult) || (results[i] = extend_merge(results[i] || {}, currentresult),
                    "row_expansion" === search_obj_cur.search_value_type && expand_current_results(current));
        for (selector in search_obj)
            if (search_obj.hasOwnProperty(selector)) {
                if ("*" === selector || "__row__" === selector)
                    continue;
                for (search_obj_array = search_obj[selector] || [],
                j = 0,
                _len = search_obj_array.length; _len > j; j++)
                    for (search_obj_cur = search_obj_array[j],
                    query = search_obj_cur.preprocess_query(raw_query),
                    i = begin; end > i; i++)
                        current = haystack[i],
                        currentresult = search_obj_cur.search("row" === search_obj_cur.search_value_type ? current : current[selector], query, i, selector),
                        currentresult.length > 0 && (currentresult_obj = {},
                        currentresult_obj[selector] = currentresult,
                        results[i] = extend_merge(results[i] || {}, currentresult_obj))
            }
        return results
    }
    function _do_search_async(haystack, needle, search_fn) {
        function loop() {
            try {
                var begin = i;
                i += ASYNC_SEARCH_STEP_SIZE,
                _len > i ? (deferred.notify(_do_search(haystack, needle, search_fn, {
                    begin: begin,
                    end: Math.min(i, _len)
                })),
                current_timeout = setTimeout(loop, ASYNC_SEARCH_STEP_INTERVAL)) : (deferred.notify(_do_search(haystack, needle, search_fn, {
                    begin: begin
                })),
                deferred.resolve(_len))
            } catch (e) {
                deferred.reject(e)
            }
        }
        var _len = haystack.length
          , deferred = $.Deferred()
          , current_timeout = null
          , i = 0;
        return current_timeout = setTimeout(loop, 0),
        deferred.promise({
            cancel: function() {
                clearTimeout(current_timeout),
                deferred.reject(new Error("Search cancelled"))
            }
        })
    }
    function dom_search_fn_factory(that, internal_core, tbody, inner_search_fn) {
        function populate_row_frag(entry) {
            var cell_frag, i;
            for (row_frag.empty(),
            i = 0; _len > i; i++)
                cell_frag = cell_frag_base.clone(),
                cell_frag.append(get_column_value(cell_frag, _ref[i], entry)),
                row_frag.append(cell_frag);
            return row_frag
        }
        function dom_search_fn(entry, needle, index) {
            var cells, cell, i, col_selector, found, cell_text, row = jq_rows_by_index[index], result = {}, walk_fn = function(text) {
                return found = inner_search_fn(text, needle, index, col_selector),
                $.isArray(found) && found.length > 0 ? (found.source = text,
                result[col_selector] = found,
                !1) : void 0
            };
            for (null == row && (row = populate_row_frag(entry)),
            cells = row.children("td"),
            i = 0; _len > i; i++)
                col_selector = _ref[i],
                category_regexp.test("" + internal_config.column_map[col_selector]["class"]) || (cell = cells.eq(i),
                cell.find("." + internal_config.search.highlight_class).contents().unwrap(),
                cell.walkTextChunks(walk_fn),
                $.isArray(found) && found.length > 0 || (cell_text = cell.text(),
                found = inner_search_fn(cell_text, needle, index, col_selector),
                $.isArray(found) && found.length > 0 && (found.source = cell_text,
                result[col_selector] = found)));
            return result
        }
        var jq_rows_by_index = [];
        tbody.find("tr").filter(function() {
            var $this = $(this);
            return null != $this.data("index") || null != $this.data("sourceIndex")
        }).each(function(i, element) {
            var $element = $(element)
              , index = $element.data("index");
            null == index && (index = $element.data("sourceIndex")),
            jq_rows_by_index[index] = $element
        });
        var row_frag = $("<tr>")
          , cell_frag_base = $("<td>")
          , get_column_value = internal_core.fn.get_column_value
          , _ref = internal_core.config.chosen_columns
          , _len = _ref.length
          , internal_config = internal_core.config
          , category_regexp = /\bcategory\b/;
        return dom_search_fn
    }
    function default_search_fn(stringvalue, needle) {
        if ("string" != typeof stringvalue)
            return [];
        var i = stringvalue.indexOf(needle);
        return -1 === i ? [] : [[i, i + needle.length]]
    }
    function default_lowercase_search_fn(stringvalue, needle) {
        if ("string" != typeof stringvalue)
            return [];
        var lowerstring = stringvalue.toLowerCase()
          , i = lowerstring.indexOf(needle);
        return -1 === i ? [] : [[i, i + needle.length]]
    }
    function _fast_filter_reset_widths($indexed_rows) {
        var $first = $indexed_rows.first()
          , $firstvisible = $indexed_rows.filter(":visible:first")
          , $firstvisible_td = $firstvisible.find("td");
        $firstvisible.is($first) || ($first.find("td").width(function(i) {
            return $firstvisible_td.eq(i).width()
        }),
        $firstvisible.find("td").width(""))
    }
    function _fast_filter_set_widths($indexed_rows) {
        var $first = $indexed_rows.first()
          , $firstvisible = $indexed_rows.filter(":visible:first");
        if (!$firstvisible.is($first)) {
            var $first_td = $first.find("td");
            $firstvisible.find("td").width(function(i) {
                return $first_td.eq(i).width()
            })
        }
    }
    function redraw_table(that, internal_core, callback) {
        that.one("qlist_load_that", function() {
            "function" === $.type(callback) && callback()
        }),
        window.setTimeout(internal_core.fn.qlistRefreshTable, 5)
    }
    function get_indexed_rows(tbody) {
        return tbody.find("tr").filter(function() {
            var $this = $(this);
            return null != $this.data("index") || null != $this.data("sourceIndex")
        })
    }
    function get_category_selectors(config) {
        var _ref = $.map(config.columns, function(column) {
            var classes = (column["class"] || "").split(/\s+/);
            return $.inArray("category", classes) >= 0 ? column.selector : void 0
        });
        return _ref.concat(config.sections)
    }
    var extend_merge = window.fweb.util.objects.extend_merge;
    SearchObject.prototype = {
        constructor: SearchObject,
        __constructor__: function() {},
        preprocess_query: function(query) {
            return query
        },
        search: default_search_fn,
        search_value_type: "value",
        rate: function(value, query, selector, match_result) {
            return +(match_result.length > 0)
        },
        group: function(row_value, query, selector, row_match_result) {
            var result = [];
            return $.each(row_match_result, function(selector, value) {
                $.isArray(value) && value.length > 0 && result.append(selector)
            }),
            result
        },
        autocomplete: function(request, response) {
            var query = request.term;
            response(this.autocomplete_sync(query))
        },
        autocomplete_sync: function() {
            return []
        }
    };
    var ext_this, caseInsensitiveSearchObject = declareSearchObject({
        preprocess_query: function(query) {
            return ("" + query).toLowerCase()
        },
        search: default_lowercase_search_fn
    }), ASYNC_SEARCH_STEP_SIZE = 50, ASYNC_SEARCH_STEP_INTERVAL = 10, CONFIG_PATH = "search", get_highlighter = $.qlist.ext.objectSearch.get_highlighter;
    ext_this = $.qlist.ext.objectSearch = {
        depends: [],
        config_path: CONFIG_PATH,
        managed: !0,
        defaults: {
            enabled: !0,
            search_categories: !0,
            highlight: !0,
            highlight_color: "yellow",
            highlight_class: "search-highlight",
            fast_update: !1,
            case_insensitive: !0,
            autocomplete: !1,
            auto_async: !0,
            force_async: !1,
            group_order: [],
            focus_on_document_esc: !0,
            search_obj: {},
            search_obj_factory: {},
            search_fn: {},
            search_row_fn: {},
            rate_fn: {},
            group_fn: {},
            autocomplete_fn: {},
            strict_columns: {},
            disable_fallback_dom_search: !1
        },
        postinit: function(that, internal) {
            var config, state;
            return config = internal.core.config,
            config.search.default_search_obj = defaultSearchObjectFactory(config),
            state = internal.core.state.search,
            null == state && (state = internal.core.state.search = {}),
            {
                config: config.search,
                state: state
            }
        },
        get_formatted_cell: function(that, internal_core, get_column_value) {
            var config = internal_core.config.search;
            return config.highlight ? get_highlighter(that, internal_core, get_column_value).get_formatted_cell : get_column_value
        },
        get_formatted_category_header: function(that, internal_core, get_column_value) {
            var config = internal_core.config.search;
            return config.highlight ? get_highlighter(that, internal_core, get_column_value).get_formatted_category_header : get_column_value
        },
        get_filter_fn: function(that, internal_core, filter_fn) {
            function search_filter_fn(entry, filters) {
                return (null == current_results || $.inArray(entry, source)in current_results) && filter_fn(entry, filters)
            }
            var source = internal_core.config.source;
            if (null == internal_core.state || null == internal_core.state.search)
                return filter_fn;
            var current_results = internal_core.state.search.current_results;
            return search_filter_fn
        },
        commands: {
            search: function(that, internal_core, value) {
                return do_search_callback(that, internal_core, value)
            }
        }
    },
    $.extend($.qlist.ext.objectSearch, {
        SearchObject: SearchObject,
        declare: declareSearchObject,
        caseInsensitiveSearchObject: caseInsensitiveSearchObject,
        domSearchObjectFactory: domSearchObjectFactory,
        get_highlighter: get_highlighter
    })
}(jQuery),
function($) {
    var CONFIG_PATH, _findWhere = function(arr, attrs) {
        var result = null;
        return arr.some(function(value) {
            for (var key in attrs)
                if (attrs[key] !== value[key])
                    return !1;
            return result = value,
            !0
        }),
        result
    }, resolve_config = $.qlist._ext.resolve_config;
    $.qlist.ext.filterHighlight = {
        staticDepends: ["objectSearch"],
        depends: [],
        config_path: CONFIG_PATH = "column_filters.highlight",
        managed: !0,
        defaults: {
            enabled: !1,
            highlight_color: null,
            highlight_class: "filter-highlight"
        },
        core_defaults: {},
        get_formatted_cell: function(that, internal_core, get_column_value) {
            var filter_settings, get_highlighter, highlighter, search_obj;
            return filter_settings = internal_core.fn.get_filter_settings(),
            get_highlighter = $.qlist.ext.objectSearch.get_highlighter,
            highlighter = get_highlighter(that, internal_core, get_column_value),
            highlighter.set_config(resolve_config(internal_core.config, CONFIG_PATH)),
            search_obj = $.qlist.ext.objectSearch.caseInsensitiveSearchObject,
            function(td, selector, entry) {
                var flt, match, searchmatch, rval = get_column_value(td, selector, entry), origval = entry[selector];
                return "number" === $.type(origval) && (origval = "" + origval),
                flt = _findWhere(filter_settings, {
                    id: selector
                }),
                null != flt ? (match = [],
                $.each(flt.value, function(i, rawvalue) {
                    $.each(flt.logic.OR || "string" === flt.logic.search ? [rawvalue] : rawvalue.split(/"([^\"]*)"|'([^']*)'|\s/).filter(function(val) {
                        return null != val && val.trim()
                    }), function(i, value) {
                        $.merge(match, search_obj.search(origval, search_obj.preprocess_query(value)))
                    })
                }),
                match.length < 1 && "string" === $.type(origval) && (searchmatch = [0, null],
                searchmatch.source = origval,
                match.push(searchmatch)),
                highlighter.robust_highlight_cell(match, rval, origval, td)) : rval
            }
        }
    }
}(jQuery),
function(module) {
    module(this)
}
.call(this, function(global) {
    "use strict";
    function CellCollectionFormatter($ql, internal, formatter_definition, my_selector) {
        this.format_item = formatter_definition.format_item,
        this.format_requires_key = formatter_definition.requires_key,
        this.format_fallback = formatter_definition.format_fallback,
        this.selective_formatting = void 0 !== this.format_requires_key && "function" == typeof this.format_fallback,
        this.config = _resolve(internal.core.config, CONFIG_PATH),
        this.core_config = internal.core.config,
        this._count = formatter_definition.max || this.config.max,
        this.count_selector = formatter_definition.display_count,
        this.count_format_fn = null,
        this.count_template = $.validator.format(formatter_definition.count_template || '<div class="cell-collection-count">{0} ' + $.getInfo("members") + "</div>"),
        this.count_requires_key = formatter_definition.count_requires_key,
        this._selector = my_selector;
        var _ref;
        this.getCollection = null != (_ref = formatter_definition.source_fn) ? _ref : null != (_ref = this.data_selector = formatter_definition.selector) ? function(index, col, row) {
            return row[_ref]
        }
        : function(index, col, row) {
            return row[col.selector]
        }
    }
    function CellCollectionExtension($ql, internal) {
        this.$ql = $ql,
        this.internal = internal,
        this.formatters = {},
        this.config = _resolve(internal.core.config, CONFIG_PATH)
    }
    var $ = global.jQuery
      , util = (global.fweb,
    global.fweb.util)
      , declareSearchObject = (global.setCookie,
    global.getCookie,
    global.removeCookie,
    $.qlist.ext.objectSearch.declare)
      , FORMAT_FN_ID = "cell-collection"
      , _resolve = $.qlist._ext.resolve_config
      , DEFAULT_MAX = 20
      , T = {};
    T._item = $.validator.format('<div class="cell-collection-member">{0}</div>'),
    T.item = function(text) {
        return T._item.call(this, text)
    }
    ,
    T.itemList = function(that, scope, list, start, stop) {
        var i, _len, _maxlen, member, _ref, out = '<div class="flex-wrap">';
        for (i = start,
        _len = list.length,
        _maxlen = null != stop ? Math.min(_len, stop) : _len; _maxlen > i && (member = list[i],
        !0); ++i)
            out += T.item(that.format_item_highlighted(scope.td, scope.col, member, scope.sourceIndex, null == (_ref = scope.filteredIndicies) ? i : _ref[i]));
        return out += "</div>"
    }
    ,
    T._anchor_display_more = '{% lang "display_more" %}',
    T.anchor_display_more = util.functional.lazy(util.templates.j2translate, T._anchor_display_more),
    T.placeholder = util.functional.lazylazy($.validator.format, util.functional.lazy(util.templates.j2translate, '<label class="cell-collection-expand"><button type="button" class="compact-visual-toggle"></button>' + T._anchor_display_more + ' {% lang "cell_collection_amounts" %}</label>')),
    T.placeholder_filtered = util.functional.lazylazy($.validator.format, util.functional.lazy(util.templates.j2translate, '<div class="cell-collection-filtered">{% lang "cell_collection_filtered" %}</div>')),
    CellCollectionFormatter.prototype.type = FORMAT_FN_ID,
    CellCollectionFormatter.prototype.format_fn = function(td, col, row) {
        var selector = col.selector;
        if (null === td)
            return this.getCollection(null, col, row);
        if (this.selective_formatting && void 0 === row[this.format_requires_key])
            return this.format_fallback(td, col, row);
        var $td = $(td)
          , sourceIndex = $td.closest("tr").data("sourceIndex")
          , collection = this.getCollection(sourceIndex, col, row)
          , _ref = this.filterCollection(collection, selector, sourceIndex)
          , filtered = _ref[0]
          , filteredIndicies = _ref[1]
          , is_filtered = filtered !== collection && filtered.length != collection.length
          , out = T.itemList(this, {
            td: td,
            col: col,
            row: row,
            sourceIndex: sourceIndex,
            filteredIndicies: filteredIndicies
        }, filtered, 0, this._count)
          , _len = filtered.length;
        return _len > this._count && (out += T.placeholder()(_len - this._count, _len),
        out += '<div class="cell-collection-expansion" style="display: none;">' + T.itemList(this, {
            td: $td,
            col: {
                selector: selector
            },
            row: row,
            sourceIndex: sourceIndex,
            filteredIndicies: filteredIndicies
        }, filtered, this._count) + "</div>"),
        is_filtered && (out += T.placeholder_filtered()(collection.length)),
        out
    }
    ,
    CellCollectionFormatter.format_item_highlighted = function(member, col, row, sourceIndex) {
        return this.format_item(member, col, row)
    }
    ,
    CellCollectionFormatter.prototype.filterCollection = function(collection) {
        return [collection]
    }
    ,
    CellCollectionFormatter.prototype.getCollectionLength = function(td, col, row) {
        var sourceIndex = $(td).closest("tr").data("sourceIndex")
          , collection = this.getCollection(sourceIndex, {
            selector: this._selector
        }, row);
        return null != collection ? collection.length : void 0
    }
    ,
    CellCollectionFormatter.prototype.formatCount = function(td, col, row) {
        return this.count_template(this.getCollectionLength(td, col, row), $j.getInfo(this.core_config.column_map[this._selector].lang_key))
    }
    ,
    CellCollectionFormatter.prototype.transformCountFormatter = function(source_format_fn_obj, target_format_fn_obj) {
        if ("string" !== $.type(this.count_selector))
            return !1;
        var this_ = this
          , orig_format_fn = source_format_fn_obj[this.count_selector] || source_format_fn_obj["*"];
        return target_format_fn_obj[this.count_selector] = this.count_format_fn = function(td, col, row) {
            var value = orig_format_fn.apply(this, arguments)
              , exlude_row = this_.selective_formatting && void 0 === row[this_.format_requires_key] || void 0 !== this_.count_requires_key && void 0 === row[this_.count_requires_key];
            return exlude_row || (value += this_.formatCount(td, col, row)),
            value
        }
        ,
        this.count_format_fn.__wraps__ = orig_format_fn,
        !0
    }
    ,
    CellCollectionExtension.prototype.transformFormatters = function() {
        Object.keys(this.formatters).length > 0 && (window.console || {
            log: $.noop
        }).log("WARNING: reinitializing CellCollectionExtension formatters"),
        this.formatters = {};
        var new_format_fn = {}
          , this_ = this;
        $.each(this.internal.core.config.format_fn, function(key, value) {
            var formatter;
            $.isPlainObject(value) && value.type === FORMAT_FN_ID && (formatter = this_.newFormatter(key, value),
            new_format_fn[key] = $.proxy(formatter, "format_fn"),
            new_format_fn[key].context = formatter,
            formatter.transformCountFormatter(this_.internal.core.config.format_fn, new_format_fn))
        }),
        $.extend(this.internal.core.config.format_fn, new_format_fn)
    }
    ,
    CellCollectionExtension.prototype.setupExpansionClick = function() {
        var $label = this.$ql.find("label.cell-collection-expand")
          , $button = $label.find("button")
          , stopPropagation = function(event) {
            event.stopPropagation()
        };
        $label.off("click").on("click", stopPropagation),
        $label.off("dblclick").on("dblclick", stopPropagation),
        $button.off("dblclick").on("dblclick", stopPropagation),
        $button.off("click").on("click", function(event) {
            var $this = $(this)
              , expanded = !$this.hasClass("active");
            $this.toggleClass("active", expanded),
            $this.closest("td").find(".cell-collection-expansion").toggle(expanded),
            event.stopPropagation()
        })
    }
    ,
    CellCollectionExtension.prototype.newFormatter = function(selector, defn) {
        var formatter = new CellCollectionFormatter(this.$ql,this.internal,defn,selector);
        return this.formatters[selector] = formatter,
        formatter
    }
    ;
    var CONFIG_PATH;
    $.qlist.ext.cellCollection = {
        depends: [],
        config_path: CONFIG_PATH = "options.cell_collection_formatter",
        managed: !0,
        defaults: {
            _instance: null,
            enabled: !1,
            max: DEFAULT_MAX
        },
        commands: {
            getCellCollectionFormatter: function(that, internal_core, selector) {
                var instance = _resolve(internal_core.config, CONFIG_PATH)._instance;
                return instance.formatters[selector]
            }
        },
        postconfigure: function(that, internal) {
            var config = _resolve(internal.core.config, CONFIG_PATH)
              , oldinstance = config._instance;
            return null != oldinstance ? oldinstance : (config._instance = new CellCollectionExtension(that,internal),
            config._instance.transformFormatters(),
            config._instance)
        },
        postload: function(that, internal) {
            var instance = _resolve(internal.core.config, CONFIG_PATH)._instance;
            return instance.setupExpansionClick(),
            instance
        }
    };
    var SEARCH_CONFIG_PATH = $.qlist.ext.objectSearch.config_path;
    CellCollectionFormatter.prototype.getSearchState = function() {
        var _ref = this.config._instance.$ql.data("qlist_state");
        return null != _ref ? _resolve(_ref, SEARCH_CONFIG_PATH) : void 0
    }
    ,
    CellCollectionFormatter.prototype.getOwnSearchResults = function(selector, sourceIndex) {
        var searchState = this.getSearchState();
        if (null == searchState || null == searchState.current_results || null == searchState.current_results[sourceIndex] || null == searchState.current_results[sourceIndex][selector])
            return null;
        var collectionSearchResults;
        return $.each(searchState.current_results[sourceIndex][selector], function(index, searchResult) {
            return searchResult._is_collection_result ? (collectionSearchResults = searchResult,
            !1) : void 0
        }),
        collectionSearchResults || null
    }
    ,
    CellCollectionFormatter.prototype.filterCollection = function(collection, selector, sourceIndex) {
        var collectionSearchResults = this.getOwnSearchResults(selector, sourceIndex);
        if (null == collectionSearchResults)
            return [collection, null];
        var i = 0
          , filteredIndicies = []
          , filtered = $.grep(collection, function(item, index) {
            var matches = index in collectionSearchResults;
            return matches && (filteredIndicies[i] = index,
            i++),
            matches
        });
        return [filtered, filteredIndicies]
    }
    ,
    CellCollectionFormatter.prototype.newSearchObject = function() {
        var this_ = this
          , parentSearchObject = $.qlist.ext.objectSearch.caseInsensitiveSearchObject
          , collectionSearchFunction = function(list, target, index, selector) {
            var i, _len, member, match, formatted, matchObject = {
                _is_collection_result: !0
            }, foundSomething = !1;
            for (_len = Array.isArray(list) ? list.length : 0,
            i = 0; _len > i; ++i)
                member = list[i],
                formatted = this_.format_item(null, {
                    selector: selector
                }, member),
                match = parentSearchObject.search(formatted, target, index, selector),
                match && match.length > 0 && (foundSomething = !0,
                match.source = formatted,
                matchObject[i] = match);
            return foundSomething ? [matchObject] : []
        }
          , collectionSearchObject = declareSearchObject({
            preprocess_query: parentSearchObject.preprocess_query,
            search: collectionSearchFunction
        });
        return collectionSearchObject
    }
    ,
    CellCollectionExtension.prototype.extendSearchObject = function() {
        if (null == this._searchObj) {
            var formatter, _ref, collectionSearchObject = {};
            for (var selector in this.formatters)
                this.formatters.hasOwnProperty(selector) && (formatter = this.formatters[selector],
                null == (_ref = collectionSearchObject[selector]) && (_ref = collectionSearchObject[selector] = []),
                _ref.push(formatter.newSearchObject()));
            this._searchObj = collectionSearchObject,
            util.objects.extend_merge(_resolve(this.internal.core.config, SEARCH_CONFIG_PATH).search_obj, collectionSearchObject)
        }
    }
    ,
    CellCollectionFormatter.prototype.isHighlightingEnabled = function() {
        return _resolve(this.config._instance.$ql.data("config"), SEARCH_CONFIG_PATH).highlight
    }
    ,
    CellCollectionFormatter.prototype.format_item_highlighted = function(member, col, row, sourceIndex, memberIndex) {
        var formatted = this.format_item(member, col, row);
        if (!this.isHighlightingEnabled())
            return formatted;
        var collectionSearchResults = this.getOwnSearchResults(col.selector, sourceIndex);
        return null == collectionSearchResults ? formatted : this.config._instance.highlighter.robust_insert_highlighting_spans(collectionSearchResults[memberIndex], formatted, formatted)
    }
    ,
    CellCollectionExtension.prototype.initHighlighter = function() {
        this.highlighter = $.qlist.ext.objectSearch.get_highlighter(this.$ql, this.internal.core, null)
    }
    ,
    $.qlist.ext.cellCollectionSearch = {
        depends: ["cellCollection", "objectSearch"],
        config_path: CONFIG_PATH,
        managed: "auto",
        postconfigure: function(that, internal) {
            var cellCollection = internal.cellCollection;
            cellCollection.extendSearchObject(),
            cellCollection.initHighlighter()
        }
    }
}),
function(global, body) {
    body(jQuery)
}(this, function($) {
    $.qlist.ext.emptyFilteredResultsEvent = {
        config_path: "emptyFilteredResultsEvent",
        managed: !0,
        defaults: {
            enabled: !1
        },
        postload: function(that, internal) {
            var internal_core = internal.core
              , filterSettings = internal_core.fn.get_filter_settings();
            if (0 !== filterSettings.length) {
                var complete_filter_fn = internal_core.fn.get_complete_filter_fn(that, internal_core.config, internal_core.state);
                if (0 === internal_core.fn.get_filtered_lines(complete_filter_fn)) {
                    var emptyFilteredResultsEvent = $.Event("emptyFilteredResults");
                    that.trigger(emptyFilteredResultsEvent, [filterSettings, {
                        sourceLength: internal_core.config.source.length
                    }])
                }
            }
        }
    }
}),
function($) {
    "use strict";
    var cmdb = function(path, name) {
        return $.getJSON("/api/v2/cmdb/" + path + "/" + name).then(function(r) {
            return r.results
        })
    }
      , debounce = {
        resize: $.debounce(0, function() {
            $(window).trigger("resize")
        })
    }
      , cloudapp_meta_lookup = function() {
        var cloudapp = {};
        return function(id, callback) {
            Object.keys(cloudapp).length ? callback(cloudapp[id]) : cmdb("application", "internet-service").then(function(data) {
                data.forEach(function(app) {
                    cloudapp[app.id] = app
                }),
                callback(cloudapp[id])
            })
        }
    }()
      , interface_meta_lookup = function() {
        function lookup_interface(intf_name) {
            return $.ajax({
                url: base_url + intf_name,
                cache: !1,
                dataType: "json",
                data: params
            })
        }
        var params = {
            format: "name|alias|description|type"
        }
          , base_url = "/api/v2/cmdb/system/interface/"
          , interfaces = {};
        return function(intf_name, callback) {
            return intf_name ? (interfaces[intf_name] || (interfaces[intf_name] = lookup_interface(intf_name)),
            interfaces[intf_name].then(function(r) {
                interfaces[intf_name].result = r.results[0],
                callback(r.results[0])
            }, function() {
                interfaces[intf_name].result = {
                    name: intf_name
                },
                callback(interfaces[intf_name])
            }),
            interfaces[intf_name].result) : void 0
        }
    }()
      , interface_format_fn = function(td, column, entry) {
        var intf_name = entry[column.selector];
        if (td) {
            var value;
            if (interface_meta_lookup(intf_name, function(intf) {
                value = fweb.util["interface"].interfaceFormatFn(intf_name, intf, !0),
                td.html(value),
                debounce.resize()
            }),
            value)
                return ""
        }
        return intf_name
    }
      , format_fn = {
        name: function(td, col, entry) {
            var val = entry[col.selector];
            return td ? entry.q_class ? '<f-icon class="' + entry.q_class + '"></f-icon><span>' + escapeHTML(val) + "</span>" : escapeHTML(val) : val
        },
        comment: function(td, col, entry) {
            var val = entry[col.selector];
            return td ? fweb.util.formatters.truncate_comment(val) : val
        },
        q_ref: function(td, column, entry) {
            var val = entry[column.selector];
            return null == val ? val = "" : td && (val = '<a class="qlist_ref" href="#">' + val + "</a>"),
            val
        },
        q_status: function(td, column, entry) {
            var val = entry[column.selector];
            if (td) {
                var state = 1 == val ? "up" : "down";
                return '<a class="a_sprite tool_' + state + '"></a>'
            }
        },
        cloudapp: function(td, col, data) {
            var id = data[col.selector]
              , name = id
              , callbackFn = function(app) {
                name = app ? app.name : name,
                td && (td.find("[data-cloudapp-id=" + id + "]>span").text(name),
                debounce.resize())
            };
            return cloudapp_meta_lookup(id, callbackFn),
            '<div data-cloudapp-id="' + id + '"><f-icon class="fa-cloud"></f-icon><span>' + name + "</span></div>"
        },
        policyid: function(td, column, entry) {
            function getPolicyURL(policy) {
                function insertListValue(policyListUrl) {
                    var value = escapeHTML(policy.name || policyid);
                    if (!disableLink) {
                        var url = policyListUrl.url;
                        value = '<a href="' + url + '" target="_top">' + value + "</a>",
                        policy.comments && (value = '<span title="' + escapeHTML(policy.comments) + '">' + value + "</span>")
                    }
                    policy.name && (value = policyid + " (" + value + ")"),
                    td.html(value)
                }
                td && fweb.util.policy.getMatchingPolicyListUrl(name, entry).then(insertListValue)
            }
            var name = column.selector
              , policyid = entry[name]
              , disableLink = fweb.util.policy.disablePolicyLink(entry, name);
            if (fweb.util.policy.disableParsePolicy(entry))
                return policyid;
            var policy_name = fweb.util.policy.policyMetaLookup(policyid, entry.policytype, entry.subtype, getPolicyURL);
            return td ? "" : policyid + (policy_name ? " (" + policy_name + ")" : "")
        },
        policytype: function($td, col, data) {
            var policytype = data.policytype || "policy";
            return $.getInfo("Firewall::policytype." + policytype)
        },
        srcintf: interface_format_fn,
        dstintf: interface_format_fn,
        "interface": interface_format_fn,
        "*": function(td, column, element) {
            var selector = column.selector
              , raw = element[selector];
            if (!td)
                return raw;
            var render = escapeHTML;
            if ($.isArray(raw) && raw.length > 0) {
                var _ul_str = '<ul class="qlist_obj_list"><li>';
                return _ul_str + $.map(raw, function(x) {
                    if ($.isPlainObject(x) && "name"in x) {
                        var cls = x["css-class"] || "";
                        return '<span class="' + cls + '">' + render(x.name) + "</span>"
                    }
                    return "<span>" + render(x) + "</span>"
                }).join("</li><li>") + "</li></ul>"
            }
            return render(raw)
        }
    };
    format_fn.comments = format_fn.description = format_fn.comment,
    $.extend($.qlist.format_fn, format_fn)
}(jQuery),
function($, fweb) {
    "use strict";
    $.qlist.menu_items = {
        add_policy_block_items: function(block_map, config, which) {
            function add_menu_item(column) {
                function make_addrgrp_member(entry) {
                    return {
                        name: $.getInfo("Policy::Block::" + block + " {ADDRESS}", [entry[column]])
                    }
                }
                function make_address(entry) {
                    return {
                        cls: "icon_fw addr_range_0",
                        type: "iprange",
                        "start-ip": entry[column],
                        "end-ip": entry[column],
                        name: $.getInfo("Policy::Block::" + block + " {ADDRESS}", [entry[column]])
                    }
                }
                var block = block_map ? block_map[column] : column
                  , url = "/p/firewall/policy";
                menu_items["block_" + column] = {
                    url: "javascript: void 0",
                    "class": "tool_deny",
                    label: $.getInfo("Policy::Block::" + block),
                    handler: f_events.reportExceptions(function(q) {
                        function dlg_open(event) {
                            fweb_require(["jquery.validate.rules"], function(rules) {
                                $(event.target).find("form").validate({
                                    rules: rules.firewall["address" + six]
                                })
                            })
                        }
                        function got_group_name() {
                            var name_key = "Policy::BlockName::" + block + six
                              , name = $.getInfo(name_key);
                            settings.push({
                                selector: "name",
                                value: name
                            });
                            var prefs = {
                                key: "name",
                                pattern: name
                            };
                            CMDB.fetch("firewall", "policy" + six, prefs).then(got_name, show_error)
                        }
                        function got_name(results) {
                            var mkey = results.results[0] ? results.results[0].policyid + "/" : ""
                              , param = "block=" + encodeURIComponent(JSON.stringify(settings));
                            six = six ? "/" + six : "",
                            top.main ? top.main.location.href = url + six + "/edit/" + mkey + "?" + param : top.location.href = url + six + "/edit/" + mkey + "?" + param
                        }
                        function show_error(error) {
                            fweb.log(error),
                            Notify.post(JSON.stringify(error), "error")
                        }
                        var entries = get_entries(q, column)
                          , is_ipv6 = RegExp.prototype.test.bind(/:/);
                        if (entries.length > 0) {
                            var addresses = entries.map(pluck(column))
                              , six = is_ipv6(addresses[0]) ? "6" : "";
                            if (six && !addresses.every(is_ipv6) || !six && addresses.some(is_ipv6))
                                return void require(["notify"], function(Notify) {
                                    Notify.post($.getInfo("Unable to create a policy with mixed ipv4 and ipv6 addresses"), "error")
                                });
                            var settings = [{
                                path: "firewall",
                                name: "address" + six,
                                selector: entries.length > 1 ? void 0 : block,
                                values: entries.map(make_address)
                            }, {
                                selector: "srcaddr" === block ? "dstaddr" : "srcaddr",
                                values: ["all"]
                            }, {
                                selector: "service",
                                value: "ALL"
                            }, {
                                selector: "paction",
                                value: "deny"
                            }, {
                                selector: "srcintf",
                                values: ["any"]
                            }, {
                                selector: "dstintf",
                                values: ["any"]
                            }]
                              , dialog = $.Deferred()
                              , id = "block_policy_create_name_address_group_dlg"
                              , style = "<style>#" + id + " input { width: 100% }</style>"
                              , msg = $.getInfo("Enter a descriptive name for this Address Group")
                              , template = style + '<form><div id="' + id + '"><h4>' + msg + '</h4><input class="addr_grp_name" name="name"></div></form>';
                            if (entries.length > 1) {
                                var $dlg = fweb.dialog(template, {
                                    title: $.getInfo("Address Group Name"),
                                    open: dlg_open,
                                    buttons: [{
                                        text: $.getInfo("ok"),
                                        click: function() {
                                            return $($dlg[0]).find("form").validate().valid() ? (dialog.resolve($dlg.find(".addr_grp_name").val()),
                                            void $dlg.dialog("close")) : !1
                                        }
                                    }, {
                                        text: $.getInfo("cancel"),
                                        click: function() {
                                            dialog.reject(),
                                            $dlg.dialog("close")
                                        }
                                    }]
                                });
                                dialog.then(function(name) {
                                    settings.push({
                                        path: "firewall",
                                        name: "addrgrp" + six,
                                        selector: block,
                                        values: [{
                                            cls: "icon_fw addr_grp_0",
                                            name: name,
                                            member: entries.map(make_addrgrp_member)
                                        }]
                                    })
                                })
                            } else
                                dialog.resolve();
                            dialog.then(got_group_name)
                        }
                    })
                }
            }
            function add_quarantine(column) {
                function make_option(selected) {
                    return function(interval) {
                        var selected_attr = selected === interval ? ' selected="selected"' : "";
                        return '<option value="' + intervals[interval] + '" ' + selected_attr + ">" + $.getInfo(interval) + "</option>"
                    }
                }
                function success(result, jqxhr) {
                    "error" === result.status ? failure(jqxhr, result.error) : require(["notify"], function(Notify) {
                        Notify.post($.getInfo("Source has been quarantined"))
                    })
                }
                function failure(jqxhr, status) {
                    require(["notify"], function(Notify) {
                        Notify.post(status, "error")
                    })
                }
                var intervals = {
                    seconds: 1,
                    minutes: 60,
                    hours: 3600,
                    days: 86400
                }
                  , dependency = 'data-enable-if-checked="! [name=quarantine_permanent]"'
                  , template = fweb.util.dom.renderTemplate(['<form id="{{ id }}">', '<style type="text/css" rel="stylesheet">', "#{{ id }} .container {", "   display: inline-flex; flex-direction: column }", "#{{ id }} div { margin: 0.5ex 0; display: flex; ", "    justify-content: flex-end;", "}", "#{{ id }} { text-align: center }", "#{{ id }} .quarantine_duration { width: 6em }", "#{{ id }} .{{ perm }} label, #{{ id }} .{{ perm }} input {", "    vertical-align: middle }", "#{{ id }} p {", "   width: 70vw;", "   max-width: 20em;", "   text-align: left;", "}", "</style>", "<p>{{ message }}</p>", '<div class="container">', '  <div><input type="number" min="1" name="quarantine_duration" ', '    class="depends quarantine_duration number" {{ dep }} value="30">', '    <select name="multiplier" class="depends" {{ dep }}>', "    {{ opts }}", "    </select></div>", '  <div class="{{ perm }}"><label for="{{ perm }}">{{ ban }}</label>', '  <input type="checkbox" name="{{ perm }}" id="{{ perm }}">', "</div></div>", "</form>"].join("\n"), {
                    ban: $.getInfo("Permanent Ban"),
                    message: $.getInfo("A User Quarantine ban will be created..."),
                    dep: dependency,
                    opts: Object.keys(intervals).map(make_option("minutes")).join("\n"),
                    perm: "quarantine_permanent",
                    id: "quarantine_menu_dialog"
                })
                  , block = block_map ? block_map[column] : column;
                "srcaddr" === block && (menu_items["quarantine_" + column] = {
                    url: "javascript: void 0",
                    "class": "tool_quarantine",
                    label: $.getInfo("Quarantine Source"),
                    handler: f_events.reportExceptions(function(q) {
                        var $dlg, json, entries = get_entries(q, column);
                        require(["jquery.ui_dependencies", "csrf"], function() {
                            function open_dlg(event) {
                                $(event.target).ui_dependencies()
                            }
                            function ban() {
                                function to_object(obj, value) {
                                    return obj[value.name] = value.value,
                                    obj
                                }
                                var result = $dlg.find("form").serializeArray().reduce(to_object, {});
                                result.quarantine_duration && (json.expiry = result.quarantine_duration * result.multiplier),
                                close_dlg(),
                                $.ajax({
                                    url: "/api/v2/monitor/user/banned/add_users/",
                                    type: "POST",
                                    dataType: "json",
                                    data: JSON.stringify(json)
                                }).then(success, failure)
                            }
                            function close_dlg() {
                                $dlg.dialog("close").remove()
                            }
                            entries.length > 0 && (json = {
                                ip_addresses: entries.map(pluck(column))
                            },
                            $dlg = fweb.dialog(template, {
                                title: $.getInfo("Quarantine Duration"),
                                open: open_dlg,
                                buttons: [{
                                    text: $.getInfo("ok"),
                                    click: ban
                                }, {
                                    text: $.getInfo("cancel"),
                                    click: close_dlg
                                }]
                            }))
                        })
                    })
                })
            }
            function pluck(key) {
                return function(obj) {
                    return obj[key]
                }
            }
            function get_entries(q, column) {
                function deduplicate(key) {
                    var exists = {};
                    return function(entry) {
                        return exists[entry[key]] ? !1 : (exists[entry[key]] = entry,
                        !0)
                    }
                }
                var source = config && config.source || $(q.cur_elem).closest(".qlist-container").data("config").source;
                return q.get_checked_rows().get().map(function(row) {
                    return source[$(row).data("sourceIndex")]
                }).filter(deduplicate(column))
            }
            var f_events = fweb.util.events
              , menu_items = config && config.menu_items || {}
              , columns = Object.keys(block_map);
            return which && "quarantine" !== which || columns.forEach(add_quarantine),
            which && "block" !== which || columns.forEach(add_menu_item),
            menu_items
        }
    }
}(jQuery, fweb);
