
(function($) {

 function text(obj, def) { return obj ? obj : (def ? def : ""); }

    var input, $input;
    var fetched = false;

    var settings = {
        "data": [],
        "query": "",
        "formatItem": function (v) {
            return v.name ? v.name : v[0];
        },
        "matchContains": true,
        "width": 300
    }

    $.fn.searchBox = function(config) {
        settings = $.extend(settings, config);

        input = this;
        $input = $(input).css("float", "left");

        var x_clear = $("<div class='tool_clear icon_sprite search_clear'></div>")
            .click(function () {
                $input.val("");
                input.trigger("result");
            });
        $("<nobr></nobr>").appendTo($input.parent()).append(input).append(x_clear);

        $input.addClass("search_box")
            .focus(function() {
                if (fetched) return;

                $.getJSON(setQueryValue(text(settings.query, location.href), "q", Math.random()),
                    function (data) {
                        fetched = true;
                        $input.setOptions({"data": data});
                    }
                );
            })
            .autocomplete(settings.data, {
                "formatItem": settings.formatItem,
                "matchContains": true,
                "width": settings.width,
                "searchMode": true
            })
            .val(getQueryValue(text(settings.query, location.href), text($input.attr("id"), "search_box")))
            .show();

        return this;
    };
})(jQuery);

