var DetailsWindow = (function($) {
    var PERSIST_KEY = 'WVSDetailWindowLayout';
    var DEFAULT_DETAIL_SIZE = 300;
    var state = {south: {size: DEFAULT_DETAIL_SIZE}};//fweb.util.persist.get(PERSIST_KEY) || 
    var config = {
        "containerSelector" : "body",
        "mainPanelSelector" : "#main_window",
        "detailsPanelSelector" : "#logview-details",
        "contentBodySelector" : "#contentBody",
        "contentHeadSelector" : "#qlist_hdrrow",
        "detailsLocation" : "south",
        "initialHidden" : "false",
        "size": {
            south: 180
        },
        "formatCallbacks" : {},
        "rowData" : [],
        "getRowCallback" : function(row_id) { return config['rowData'][row_id]; },
        "getRowLengthCallback" : function() { return config['rowData'].length; },
        "langOverride" : {}
    };
    var busy;
    var layout;
    var detailsPanel;
    var mainPanel;
    var selectedRowEntry;
    var selectedRowEntryIndex;
    var rows = [];
    var first_row;

    function initialize(params) {
        var layout_params = [];
        var detail_loc;
        var p_size;
        var id_tmp;

        config = $.extend({}, config, params);

        mainPanel = $(config["mainPanelSelector"]);
        detailsPanel = $(config["detailsPanelSelector"]);

        if (detailsPanel.length < 1) {
            id_tmp = config["mainPanelSelector"].substr(1);
            mainPanel = appendMainPanel(id_tmp);
        }

        if (detailsPanel.length < 1) {
            id_tmp = config["detailPanelSelector"].substr(1);
            detailsPanel = appendDetailPanel(id_tmp);
        }

        mainPanel.scroll(fixHeaderScrollPosition);
        detail_loc = getDetailPaneLocation();

	layout_params["center"] = {
		paneSelector: config["mainPanelSelector"],
		onresize_end: refreshDisplay,
		minWidth: 200
	};

        layout_params[detail_loc] = {
                paneSelector: config["detailsPanelSelector"],
                initHidden: config["initialHidden"],
                resizable: true,
                togglerLength_open: 0,
                togglerLength_closed: 0,
                onresize_end: function(local) {
                    var size = layout.state[local].size;
                    config.size[local] = size;
                    state[local].size = size;
                    fweb.util.persist.put(PERSIST_KEY, state);
                }
            };

        //layout = $(config["containerSelector"]).layout(layout_params);
	layout = new FlexLayout($(config.containerSelector), layout_params);
//        setMenuButton("hidden");
        rows = $("tr", config['contentBodySelector']).get();
        first_row = rows[0];

        while ($(first_row).hasClass("heading") || $(first_row).hasClass("qlist_category")) {
            rows.shift();
            first_row = rows[0];
        }

        if (!config["initialHidden"]) {
        //    setMenuButton(config[detail_loc]);

            if (rows.length > 0) {
                if(params.rowData[1] && params.rowData[1].aggregate)
                {
                    selectRow(rows[1]);
                }else{
                    selectRow(first_row);
                }

            }

            showRowDetailsMenu(true);
        }

        busy = false;
    }

    function appendMainPanel(panel_id) {
        var html = "<div id=\"" + panel_id + "\"></div>";
        var b = $("body.main");
        
        b.wrapInner(html);

        return $(panel_id);
    }

    function appendDetailPanel(panel_id) {
        var html = $("<div id=\"" + panel_id + "\"></div>");

        return html.appendTo("body");
    }

    function sizeDetailPane() {
        var local = getDetailPaneLocation();
        var size = {
            "south" : parseInt(config["sizeSouth"]),
            "east" : parseInt(config["sizeEast"])
        }

        layout.sizePane(local, size[local]);
    }

    function refreshDisplay() {
	    var body_header = $(".ql-body-table");
	    body_header.resize(function() { $j('#contentHead').qlist('refresh');})

    }

    function fixHeaderScrollPosition() {
        var header = $("#hrdtc")[0];
        var container = $("#main_window")[0];

        $(header).css("marginLeft", "-" + container.scrollLeft + "px");
    }

    function setMenuButton(local) {
        var itemClass = "qlist_marked_menu_item";

        $("#mi_detail_right").toggleClass(itemClass, local == "east");
        $("#mi_detail_bottom").toggleClass(itemClass, local == "south");
        $("#mi_detail_close").toggleClass(itemClass, local == "hidden");
    }

    function toggleDetailsPanelLocation(local) {
        var curr = getDetailPaneLocation();

        busy = true;

        if (typeof(local) == "undefined" || curr !== local) {
            layout.swapPanes("east", "south");

            if (selectedRowEntry) {
                showRowDetailsPos(getDetailPaneLocation() == "south" ? "east" : "south");
            }

            sizeDetailPane();
            refreshDisplay();
        }

        setMenuButton(local);

        busy = false;
    }
   
    function selectRow(row) {
        if (typeof row == "undefined") {
            return;
        }

        if (typeof(selectedRowEntry) != "undefined") {
            $(selectedRowEntry).toggleClass("log_entry_selected", false);
            selectedRowEntry = null;
            selectedRowEntryIndex = 0;
        }
    	if(!($(row).hasClass("qlist_category")))
    	{
		var prevCategories = $(row).parent().prevAll();
		var prevIndex = 0;
		var i = 0;
                for(i=0; i<prevCategories.length; i++)
		{
			if(prevCategories[i].className === "category")
				prevIndex++;
		}
		// set selected entry
                selectedRowEntry = row;
                selectedRowEntryIndex = row.rowIndex - prevIndex - 1;
                $(selectedRowEntry).addClass("selected");
    	}
    }

    function handleRowDetailKeyPress(e) {
        var local = getDetailPaneLocation();
        var idx = selectedRowEntryIndex;
        var tr;

        if (e.keyCode != 38 && e.keyCode != 40)
            return;

        if (e.keyCode == 38)
            idx--;

        if (e.keyCode == 40)
            idx++;

        if (idx >= 0 && (tr = rows[idx])) {
            selectRow(tr);

            if (!layout.state[local].isHidden) {
                showRowDetails(tr);
            }

            return false;
        }
    }

    function showRowDetailsMenu(noFx) {
        if (selectedRowEntry == null) {
            selectRow(first_row);
        }

        if (noFx) {
            $.fx.off = true;
        }

        sizeDetailPane();
        showRowDetails();
        //updateSystemPosition(config['detailsLocation']);

        $.fx.off = false;
    }

    function showRowDetailsClick(e) {
        var target = e.target.parentNode;

        while (target) {
            if (target.tagName === "TR") {
                selectRow(target);
                sizeDetailPane();
//                if(document.forms[0].logType.value != 1)
                showRowDetails(target, e);

                break;
            }

            if (target.parentNode) {
                target = target.parentNode;
            } else {
                return false;
            }
        }

        return true;
    }

    function getDetailPaneLocation() {
        if (layout && layout.panes["east"] !== false) {
            config["detailsLocation"] = "east";
        }

        if (layout && layout.panes["south"] !== false) {
            config["detailsLocation"] = "south";
        }

        return config["detailsLocation"];
    }

    function setDetailPaneLocation(local) {
        if (local == "east" || local == "south") {
            config["detailsLocation"] = local;
        }

        return config["detailsLocation"];
    }

    function updateViewPos() {
        var icon = $("#view_pos");
        var pos = getDetailPaneLocation();
    }

    function showRowDetailsPos(pos) {
        var tr = selectedRowEntry;

        if (typeof(pos) !== "undefined") {
            setDetailPaneLocation(pos);
        }

        showRowDetails(tr);
    }

    function updateSystemPosition(pos) {
        var key = "set_detail";
        var data = {};
        var params = {
            'url': '/log/display'
        }

        if (pos == "east") {
            data[key] = "2";
        } else if (pos == "hidden") {
            data[key] = "0";
        } else {
            data[key] = "1";
        }

        params['data'] = data;

        $.ajax(params);
    }

    function showRowDetails(tr, e) {
        var row_entry;
        var header;
        var table;
        var html_buffer;
        var local = getDetailPaneLocation();

        if (typeof(tr) == "undefined") {
            tr = selectedRowEntry;

            if (!tr) {
                return;
            }
        }

        if (tr.rowIndex < 1 || $(tr).hasClass("qlist_category")) {
            return;
        }
	
	var prevCategories = $(tr).parent().prevAll();
	var prevIndex = 0;
	var i = 0;
	for(i=0; i<prevCategories.length; i++)
	{
		if(prevCategories[i].className === "category")
			prevIndex++;
	}

        // decrease header row & filter row
        row_entry = config['getRowCallback'](tr.rowIndex - prevIndex - 1);
        table = buildTable_new(row_entry,local == "south" ? 2 : 1,"disk_table"); 

        detailsPanel.empty().append(table);
        layout.show(config["detailsLocation"], true, true);
        setMenuButton(config["detailsLocation"]);
    }

    function showRowDetailsNext() {
        var tr = ie4 ? selectedRowEntry.nextSibling : selectedRowEntry.nextSibling.nextSibling;

        if (selectedRowEntry.rowIndex >= config['getRowLengthCallback']()) {
            return;
        }

        showRowDetails(tr);
        showRowDetailsScroll(tr);
    }

    function showRowDetailsPrev() {
        var tr = ie4 ? selectedRowEntry.previousSibling : selectedRowEntry.previousSibling.previousSibling;

        if (!tr) {
            return;
        }

        showRowDetails(tr);
        showRowDetailsScroll(tr);
    }

    function showRowDetailsScroll(tr) {
        var container = $("#tableContainer");

        if ((tr.offsetTop + tr.clientHeight) > (container.scrollTop + container.clientHeight)) {
            tr.scrollIntoView(false);
        }
        else if (tr.offsetTop < container.scrollTop) {
            tr.scrollIntoView(true);
        }

        $("#log_details").style.right = "0px";
    }

    function hideRowDetails() {
        var local = getDetailPaneLocation();

        setMenuButton("hidden");
        //updateSystemPosition("hidden");

        layout.hide(local, true);
    }
    function buildTable_new(row_entry,cols,id){
	    var lang_override;
	    var elems = [];
	    var rows = [];
	    var html;
	    var label;
	    var row_class, label_class;
	    var width = 100/cols;
	    var n = 0;

	    var obj = row_entry;
	    var row_num = 0;
	    var val;

	    lang_override = config["langOverride"];

	    var tb = document.createElement("div");
	    tb.id = "log_details_table";
	    $(tb).width("100%");

	    elems.push("<table id=\""+id+"\" cellspace=\"1\" cellpadding=\"0\" class=\"list log_details pre\" style=\"table-layout:fixed\">");

	    //no log detail data, just return a null table
	    if(row_entry == "")
	    {
		    elems.push("</table>");

		    return $(elems.join(""));
	    }

	    for(var i in obj)
	    {
		    label = (lang_override && lang_override[i]) ? lang_override[i] : $.getInfo(i);

		    row_class = (row_num % 2) ? "even" : "odd";
		    label_class = "label";

		    html = "";

		    if(n++ % cols == 0)
		    {
			    html += "<tr class=\"" + row_class + "\">";
		    }

		    if(typeof config["formatCallbacks"][i] == "function")
		    {
			    val = config["formatCallbacks"][i](i, obj[i]);
		    }
		    else
		    {
			    val = obj[i];
		    }

		    if(!val)
			    continue;

		    if(i == "aggregate" || i == "severity-value" || i == "profile_url" || i == "rule_url" || i == "_cache_id" || i == "rel_time")
		    {
			    continue;
		    }
		    else if(i == "severity")
		    {
			    var sev = obj["severity"];

			    html += "<td width=\"" + (width*0.3) + "%\" class=\"" + label_class + "\" ><b>" + label + "</b></td>" +
				    "<td width=\"" + (width*0.7) + "%\" class=\"value\" style=\"word-break:break-all; overflow:hidden;\"";

			    html += "><img src=/images/" + sev.toLowerCase() + ".png>&nbsp;" + val + "</td>";
		    }
		    else if(i == "miti_status")
		    {
			    var img_name;
			    if(val == "Open") 
				    img_name = "status_table.png";
			    else if(val == "Mitigated")
				    img_name = "status_tb.png";

			    html += "<td width=\"" + (width*0.3) + "%\" class=\"" + label_class + "\" ><b>" + label + "</b></td>" +
				    "<td width=\"" + (width*0.7) + "%\" class=\"value\" style=\"word-break:break-all; overflow:hidden;\"";

			    html += "><img src=/images/" + img_name + ">" + val + "</td>";
		    }
		    else
		    {
			    html += "<td width=\"" + (width*0.3) + "%\" class=\"" + label_class + "\" ><b>" + label + "</b></td>" +
				    "<td width=\"" + (width*0.7) + "%\" class=\"value\" style=\"word-break:break-all; overflow:hidden;\"";

			    html += ">" + val + "</td>";
		    }
		    if (n % cols == 0) {
			    width = "";
			    row_num++;
			    html += "</tr>";
		    }

		    rows.push(html);
	    }

	    elems.push(rows.join(""));

	    if (n % cols !== 0) {
		    while (n++ % cols != 0) {
			    row_num++;
			    elems.push("<td class=\"label\"></td><td class=\"value\"></td>");
		    }
	    }
	    elems.push("</tr>");

	    elems.push("</table>");

	    return $(elems.join(""));
    }

    function trigger_div(id)
    {
	    var div = document.getElementById("div_"+id);
	    var imgs = document.getElementById("imgs_"+id);
	    var imgh = document.getElementById("imgh_"+id);

	    if(!div || !imgs || !imgh)
		    return;

	    if(div.style.display == 'none')
	    {
		    div.style.display = '';
		    imgs.style.display = '';
		    imgh.style.display = 'none';
	    }
	    else
	    {
		    div.style.display = 'none';
		    imgs.style.display = 'none';
		    imgh.style.display = '';
	    }
    }

    return {
        "initialize" : initialize,
        "show" : showRowDetailsMenu,
        "hide" : hideRowDetails,
        "move" : toggleDetailsPanelLocation,
        "click" : showRowDetailsClick,
        "keypress" : handleRowDetailKeyPress,
        "buildtable":buildTable_new,
	"trigger_div":trigger_div
    };
})(jQuery);
