if (typeof lang == "undefined") {
	lang = {"com_info":{}};
}

$j.validator.addMethod('IP4Checker', function(value) {
	return RegExpCommon.IP_HOST.test(value);
}, lang.com_info["-8"]);

$j.validator.addMethod('IP4NetmaskChecker', function(value) {
	if (value == "") return true;

	return RegExpCommon.IP_MASK.test(value);
}, lang.com_info["-9"]);

$j.validator.addMethod('IP4ConflictChecker', function(value) {
	if (!parent || !parent.wizard) {
		return true;
	}

	if (value == "0.0.0.0") {
		return true;
	}

	var value_mask = $j("input[name='netmask']").val();
	if (!value_mask) {
		value_mask = "255.255.255.255";
	}

	value_ip = ipStrToNum(value);
	value_mask = ipStrToNum(value_mask);

	var history = parent.wizard.state.history;
	var data;
	var data_ip, data_mask, value_ip;

	for (var i = 0; i < history.length; i++) {
		data = history[i].data;

		if (!data.ip || !data.netmask || (data.ip == "0.0.0.0") || (data.mode != "static")) {
			continue;
		}

		data_ip = ipStrToNum(data.ip);
		data_mask = ipStrToNum(data.netmask);

		if (((data_ip & data_mask) == (value_ip & data_mask)) || ((data_ip & value_mask) == (value_ip & value_mask))) {
			return false;
		}
	}

	return true;
}, lang.com_info["err_ip_conflict"]);

$j.validator.addMethod('IP4RangeChecker', function(value, element) {
	var ip4range_fields = element.getAttribute("ip4range");

	if (ip4range_fields) {
		ip4range_fields = eval(ip4range_fields);
	}

	if (!ip4range_fields) {
		ip4range_fields = ["start-ip", "end-ip", "netmask"];
	}

	var start_ip = ip4range_fields[0];
	var end_ip = ip4range_fields[1];
	var netmask = ip4range_fields[2];

	if (!start_ip || !end_ip) {
		return false;
	}

	start_ip = $j("input[name='" + start_ip + "']").val();
	end_ip = $j("input[name='" + end_ip + "']").val();

	if (!netmask) {
		netmask = "0.0.0.0";
	}
	else {
		netmask = $j("input[name='" + netmask + "']").val();

		if (!netmask) {
			return false;
		}
	}

	if (!start_ip || !end_ip || !netmask) {
		return false;
	}

	start_ip = ipStrToNum(start_ip);
	end_ip = ipStrToNum(end_ip);
	netmask = ipStrToNum(netmask);

	if (((start_ip & netmask) != (end_ip & netmask)) || (start_ip > end_ip)) {
		return false;
	}

	return true;
}, lang.com_info["err_ip_range"]);

$j.validator.addMethod('XSSChecker', function(value) {
	return RegExpCommon.XSS.test(value);
}, lang.com_info["err_xss"]);

$j.validator.addMethod('PortChecker', function(value) {
	if (!RegExpCommon.INTEGER.test(value)) {
		return false;
	}

	if (value < 1 || value > 65535) {
		return false;
	}

	return true;
}, lang.com_info["-252"]);

$j.validator.addMethod('WeightChecker', function(value) {
	if (!RegExpCommon.INTEGER.test(value)) {
		return false;
	}

	if (value < 0 || value > 255) {
		return false;
	}
	
	return true;

}, lang.com_info["err_weight"]);

$j.validator.addMethod('SpilloverThresholdChecker', function(value) {
	if (!RegExpCommon.INTEGER.test(value)) {
		return false;
	}

	if (value < 0 || value > 2097000) {
		return false;
	}
	
	return true;
}, lang.com_info["err_range"] + " " + 0 + "-" + 2097000);

$j.validator.addMethod('PasswordChecker', function(value) {
	return JSONRPC.Wizard.Setup.password_check({"password": value});
}, lang.com_info["err_password"]);

$j.validator.addMethod('DuplicateEntryChecker', function(value, element, requests) {
	var ret = true;
	var params = {};

	for (var i = 0; i < requests.length; i++) {
		requests[i].mkey = value;
	}

	params.batch = requests;

	JSONRPC.Batch.send(params, {async: false, on_success: function (response) {
		var result;

		try {
			for (var i = 0; i < response.length; i++) {
				result = response[i].result;
				
				if (result) {
					throw result;
				}
			}
		}
		catch (err) {
			ret = false;
		}
	}});

	return ret;
}, lang.com_info["-15"]);

// the validation plugin has inherent support for ranges, but is buggy 
// with certain versions of jQuery, including the current one (1.3.2)
$j.validator.addMethod("RangeChecker", function (value, element) {
	if (!RegExpCommon.INTEGER.test(value)) {
		return false;
	}

	var min = 0;
	var max = Math.pow(2, 32) - 1;
	var range = element.getAttribute("range");

	if (range) {
		range = eval(range);
		var range_value = null;

		range_value = parseInt(range[0]);
		if (!isNaN(range_value)) min = range_value;

		range_value = parseInt(range[1]);
		if (!isNaN(range_value)) max = range_value;
	}

	$j.validator.messages["RangeChecker"] = lang.com_info["err_range"] + " " + min + "-" + max;

	if ((value < min) || (value > max)) {
		return false;
	}
	return true;
}, $j.validator.messages["RangeChecker"]);

