/*
  robot.js - misc JS code for sysconfadmin.c
  init Mar 2011 by Kai Liu
  GUI redesign project
  Copyright Fortinet Inc
*/
// admin_handle_selection_change - enable/disable the password button
// according to the current selection.
function admin_handle_selection_change(q)
{
    // Let the default handler handle the standard buttons.
    qlist_handle_selection_change(q);

    var aElems = q.get_checked_rows();

    if (aElems.length == 1 && parseInt(aElems[0].getAttribute("can_chg")) == 1)
    {
        if(parseInt(aElems[0].getAttribute("remote")) == 0)
            qmenu_enable_button($j("#mi_chg"), true, q);
        if(is_vdom == 1 && is_rw_admin == 0) {
            qmenu_enable_button($j("#mi_newedit"), true, q);
            qmenu_enable_button($j("#mi_edit"), false, q);
        }
    }else{
        qmenu_enable_button($j("#mi_chg"), false, q);
        qmenu_enable_button($j("#mi_newedit"), false, q);
    }

//    if(aElems.length != 1)
//	qmenu_enable_button($j("mi_del"), false, q);
}

// admin_menu - Override the default menubar to add buttons "Change Password "
function admin_menu(aItems)
{
    if(can_chg) {
        if(is_vdom == 1 && is_rw_admin == 0){
            var item = Page.createMenuItem({id:"mi_newedit", spriteClass:"tool_edit", ctxt:true,
                 text:qed_strtbl.edit,click:{fn:this.edit_handler}});
            aItems.push(item);    
        }        
        var mNew = Page.createMenuItem({id:"mi_chg", spriteClass:"tool_secure", ctxt:true,
                   text:admin_strtbl.chg, click:{fn: admin_onclick_chg} });
        aItems.push(mNew);
    }
}

function admin_onclick_chg()
{   
    var q = qlist_obj; // It would be cleaner if we could derive this from the event.

    var aElems = q.get_checked_rows();
    if (aElems.length != 1) return;

    var mkey = aElems[0].getAttribute("mkey");
    window.location.href = "/system/config/adminpwd?mkey=" + mkey;	
}
// adminlist_onload - onload handler for the admin list page.
function adminlist_onload()
{
    // Customize the qlist definition.
    qlist_obj.customize_menu_fn = admin_menu;
    qlist_obj.handle_selection_change_fn = admin_handle_selection_change;

    qlist_setup("qlist", admin_edit_url, admin_edit_url,false);
}
hlight_table('qlist', 1, 0, 'over');

addEvent(window, "load", adminlist_onload);
