/*
  autolearn.js - misc JS code for auto_policy.c
  init Mar 2011 by KaiLiu
  GUI redesign project
  Copyright Fortinet Inc
*/

top.f_get;
top.f_post;
top.f_head;
top.f_option;
top.f_track;
top.f_connect;
top.f_delete;
top.f_others;
top.f_par;
top.f_pw;
top.f_pb;
top.f_ps;
top.f_pu;
top.f_learn;
top.f_learn1;
top.f_account;
top.f_acper;
top.f_vicount;
top.f_viper;
top.f_url;

function reset_filter()
{
        top.f_get = true;
        top.f_post = true;
        top.f_head = true;
        top.f_option = true;
        top.f_track = true;
        top.f_connect = true;
        top.f_delete = true;
        top.f_others = true;
        top.f_par = false;
        top.f_pw = false;
        top.f_pb = false;
        top.f_ps = false;
        top.f_pu = 0;
        top.f_learn = true;
        top.f_learn1 = true;
        top.f_account = 0;
        top.f_acper = 0;
        top.f_vicount = 0;
        top.f_viper = 0;
        top.f_url = "";
}

function autolearn_view_elems(q, elem)
{
    var q = qlist_obj; // It would be cleaner if we could derive this from the event.

    var aElems = q.get_checked_rows();
    if (aElems.length != 1) return;

    var mkey = aElems[0].getAttribute("mkey");
    top.cur_policy = mkey;
    window.location.href = autolearn_url;
}
function autolearn_delete_elems(q, aElems)
{   
    var q = qlist_obj;
    var autolearn_delete_url = "/autolearn/cleardata";
    var aElems = q.get_checked_rows();
    var len = aElems.length;

    for (var i=0; i<len; i++)
    {

    	var mkey = aElems[i].getAttribute("mkey");
    	top.cur_policy = mkey;
    	if(i == 0)
		autolearn_delete_url = autolearn_delete_url + "?policy=" + mkey;
	else
		autolearn_delete_url += "&policy=" + mkey;
	
    }
    autolearn_delete_url += "&session_id=" + session_id;

    if(confirm(autolearn_strtbl.del_confirm1))
	window.location.href = autolearn_delete_url ;
}

function autolearn_handle_selection_change(q)
{
    // Let the default handler handle the standard buttons.
    qlist_handle_selection_change(q);

    var aElems = q.get_checked_rows();
    if (aElems.length == 0)
    {
	qmenu_enable_button($j("#mi_clean"), false, q);
    }else{
	qmenu_enable_button($j("#mi_clean"), true, q);
    }	
    if (aElems.length == 1)
    {
        qmenu_enable_button($j("#mi_view"), true, q);
    }else{
	qmenu_enable_button($j("#mi_view"), false, q);
    }
}

// autolearn_menu - Override the default menubar to add button "view" "clean data".
function autolearn_menu(aItems)
{
	var mView = Page.createMenuItem({id:"mi_view", spriteClass:"tool_view", ctxt:true,
			text:autolearn_strtbl.view, click:{fn:autolearn_view_elems} });
	aItems.push(mView);

    if(is_rw_admin)
    {
	    /*
        var mView = Page.createMenuItem({id:"mi_view", spriteClass:"tool_view", ctxt:true,
                   text:autolearn_strtbl.view, click:{fn:autolearn_view_elems} });
        aItems.push(mView);
	*/

        var mClean = Page.createMenuItem({id:"mi_clean", spriteClass:"tool_delete", ctxt:true,
                   text:autolearn_strtbl.clean, click:{fn:autolearn_delete_elems} });
        aItems.push(mClean);
    }
}
function showRowDetailsClick(e,event) {
//        var target = e.target.parentNode;
//	$j(":checkbox.qlist_cb", target).check(true);
        if(event.which ==1 /*&& e.tagName != "INPUT"*/)
        {
//		$j(":checkbox.qlist_cb", e.parentNode).uncheck();
//      	$j(":checkbox.qlist_cb", e).check(true);
        	autolearn_view_elems(e);
        }
        return true;
}

// autolearnlist_onload - onload handler for the autolearn policy list page.
function autolearnlist_onload()
{
    // Customize the qlist definition.
    qlist_obj.create_new = false;
    qlist_obj.create_edit = false;
    qlist_obj.create_del = false;
    qlist_obj.customize_menu_fn = autolearn_menu;
    qlist_obj.handle_selection_change_fn = autolearn_handle_selection_change;

    qlist_setup("qlist", autolearn_url, autolearn_url,false);
//    $j("tr", "#qlist").live("mousedown", function(e){ showRowDetailsClick(this,e);});
    $j("tr", "#qlist").live("dblclick", function(e){showRowDetailsClick(this, e);});
    
    reset_filter();
    top.cur_policy = "";
}
hlight_table('qlist', 1, 0, 'over');

addEvent(window, "load", autolearnlist_onload);

// Move the column chooser into the header bar.
qlist_add_header_extra($j("#extra_hdr_items")[0], $j("#qlist_right_menubar_container")[0]);
