/*
  browse_report.js - misc JS code for browse_report.c
  init Mar 2011 by Jianjiang Yan
  GUI redesign project
  Copyright Fortinet Inc
*/
function browsereport_edit_elems(q, elem)
{
    var q = qlist_obj; // It would be cleaner if we could derive this from the event.

    var aElems = q.get_checked_rows();
    if (aElems.length != 1) return;

    var mkey = aElems[0].getAttribute("mkey");
    var path = aElems[0].getAttribute("path");
    window.location.href = browsereport_url+"?doedit=" + mkey + "&path="+path;
}
function browsereport_delete_elems(q, aElems)
{   
    var browsereport_delete_url = "/clientlog/browse/delete";
    var len = aElems.length;

    if(len == 1)
    {
	browsereport_delete_url += "?confirm=1&reports=yes&filepath="
    }
    else
    {
	browsereport_delete_url += "?confirm=1&reports=batch&num="+len+"&total="+total+"&filepath="
    }
    for (var i=0; i<len; i++)
    {
        var mkey = aElems[i].getAttribute("mkey");
        var path = aElems[i].getAttribute("path");
	if(i>0) browsereport_delete_url += ">>";
        browsereport_delete_url += path + "/" + mkey;	
    }

    browsereport_delete_url += "&session_id="+session_id;

    $j.submitPOST(browsereport_delete_url);
}

function browsereport_handle_selection_change(q)
{
    // Let the default handler handle the standard buttons.
    qlist_handle_selection_change(q);

    var aElems = q.get_checked_rows();
	
    qmenu_enable_button($j("mi_view"), true, q);

    /*if (aElems.length == 1)
    {
        qmenu_enable_button($j("mi_rename"), true, q);
    }else{
	qmenu_enable_button($j("mi_rename"), false, q);
    }*/
}

// browsereport_menu - Override the default menubar to add button "run" "rename".
function browsereport_menu(aItems)
{
    if (is_rw_admin) {
        var mNew = Page.createMenuItem({id:"mi_refresh", spriteClass:"tool_retrieve", ctxt:false,
                   text:browsereport_strtbl.refresh, click:{fn:function(){document.client.submit()}} });
        aItems.push(mNew);

        /*var mRename = Page.createMenuItem({id:"mi_rename", spriteClass:"tool_edit", ctxt:true,
                   text:browsereport_strtbl.rename, click:{fn:browsereport_edit_elems} });
        aItems.push(mRename);*/
    }
}

// browsereportlist_onload - onload handler for the clientbrowsereport list page.
function browsereportlist_onload()
{
    var browsereport_create_url = browsereport_url+"_act?act=new";
    // Customize the qlist definition.
    qlist_obj.create_new = false;
    qlist_obj.create_edit = false;
    qlist_obj.customize_menu_fn = browsereport_menu;
    qlist_obj.handle_selection_change_fn = browsereport_handle_selection_change;

    //qlist_obj.edit_elem_fn = browsereport_edit_elems;
    qlist_obj.delete_elems_fn = browsereport_delete_elems;
    qlist_setup("qlist", browsereport_create_url, browsereport_create_url,false);
}
hlight_table('qlist', 1, 0, 'over');

addEvent(window, "load", browsereportlist_onload);

// Move the column chooser into the header bar.
qlist_add_header_extra($j("#extra_hdr_items")[0], $j("#qlist_right_menubar_container")[0]);
