!function(module, $) {
    "use strict";
    function sniffer_list_icon(className, title) {
        return is_rw_admin ? ' <f-icon class="fa-' + className + '" title="' + title + '" ></f-icon>' : " "
    }
    function sniffer_update_progress() {
        $.getJSON(API_SNIFFER_URL, function(data) {
            for (var i = 0; i < data.datas.length; i++) {
                var entry = data.datas[i]
                  , sniffer_id = entry.id
                  , sniffer_state = $("#sniffer_state_" + sniffer_id);
                if (sniffer_state.length > 0) {
                    var packets = entry.packets;
                    $(".msg", sniffer_state).toggle(!entry.running && 0 === packets),
                    $(".fa-play", sniffer_state).toggle(!entry.running).css("visibility", entry.running  || packets > 0? "hidden" : "visible"),
                    $(".fa-repeat", sniffer_state).toggle(!entry.running).css("visibility", !entry.running && packets > 0 ? "visible" : "hidden"),
                    $(".fa-stop", sniffer_state).toggle(entry.running).css("visibility", entry.running ? "visible" : "hidden"),
                    $(".fa-download", sniffer_state).css("visibility", !entry.running && packets > 0 ? "visible" : "hidden");
                    var max_packets = entry.max_packets || 1
                      , complete = 100 * packets / max_packets;
                    $("#sniffer_packets_" + sniffer_id).text(packets),
                    $("#sniffer_max_packets_" + sniffer_id).text(max_packets),
                    entry.running || packets > 0 ? $("#sniffer_progress_" + sniffer_id).progressbar("option", "value", complete).css("display", "inline-block") : $("#sniffer_progress_" + sniffer_id).hide()
                }
            }
            var _container = $(".qlist-container");
            _container.qlist && _container.qlist("refresh"),
            sniffer_timer = setTimeout(function() {
                sniffer_update_progress()
            }, 5e3)
        })
    }
    function sniffer_action(id, action) {
        var url = API_SNIFFER_URL + "?action=" + action + "&mkey=" + id;
        clearTimeout(sniffer_timer),
        $.post(url, function(data) {
            return "0" !== action || data.datas.length ? void sniffer_update_progress() : (alert($.getInfo("err_sniffer_start")),
            !1)
        })
    }
    function sniffer_download(id) {
        //var url = API_SNIFFER_URL + "/download/" + id + "/";
        //var mkey = qlist_get_row_attr(elems, 'mkey');
        var path = "/downloadfile?msg=34&name=";
        
        if(id){
            path = setQueryValue(path, 'name', id);
            path = setQueryValue(path, 'session_id', session_id);
            window.location.href = path;
        }
        //window.open(url, "_blank")
    }
    function sniffer_progress_init() {
        var states = $("span[id^=sniffer_state_]");
        if (states.length > 0) {
            var css = {
                width: 250,
                height: 14,
                display: "none",
                margin: "0 auto"
            };
            $("span[id^=sniffer_packets_]").text(0),
            $("span[id^=sniffer_state_]").html('<span class="msg">' + $.getInfo("st_not_running") + "</span> " + sniffer_list_icon("play", $.getInfo("act_play")) + sniffer_list_icon("repeat", $.getInfo("act_restart")) + sniffer_list_icon("stop", $.getInfo("act_stop")) + sniffer_list_icon("download", $.getInfo("act_download"))),
            $(".fa-stop, .fa-repeat").hide(),
            $(".fa-download").css("visibility", "hidden"),
            $("div[id^=sniffer_progress_]").progressbar({
                value: 0
            }).css(css),
            sniffer_update_progress()
        }
    }
    var API_SNIFFER_URL = "/system/network/packet_capture/list/json"
      , sniffer_timer = null ;
    module.sniffer_list_icon = sniffer_list_icon,
    module.sniffer_update_progress = sniffer_update_progress,
    module.sniffer_action = sniffer_action,
    module.sniffer_download = sniffer_download,
    module.sniffer_progress_init = sniffer_progress_init
}(window.SnifferCommon = window.SnifferCommon || {}, jQuery);

