/*global byod_common,fgd_common, $j, fweb, FOSGUI, byod_common*/
/* viewer.html *//*global resolve_apps, dm_ng */
/* Util.js     *//*global getQueryValue,setQueryValue, escapeHTML , getParams*/
/* filter.js   *//*global FIELD_TYPE, FIELD_TYPE_STRINGS */
/* log_formatter.js   *//* FOSGUI.LogFormatter  getFormatter(), format_fn_to */

var qlist_prefix = 'qlist_dm';
var now = new Date();
var param_filter = getQueryValue(window.location.search, 'filter');

var param_default_cols = getQueryValue(window.location.search,
		'default_cols') || '';
var qlist_columns_url = '/waf/device_manage/column';

qlist_prefix += param_default_cols.replace(/,/, '_');

/*
 * @param  {[Number]} device_id          The number that represents the device
 * @param  {[Array]} columns_collection  It is an array that contains objects
 *                                       with all available columns and default
 *                                       columns.
 *                                       ex: [{
 *                                           'columns': [{
 *                                               "fixed": true,
 *                                               "lang_key": "#",
 *                                               "selector": "#"
 *                                           },
 *                                           ...],
 *                                           'default_columns': Array
 *                                       },
 *                                       ...]
 * @return {[Array]}                     The list of columns which have the
 *                                       filter disabled
 */

function get_filter_disable_columns(columns) {
	'use strict';

	var LOG_FIELD_FCLD_FILTER = (1 << 2);
	var filter_disable_columns = [
		'#',
		'canvas',
		'webgl'
	];

	return filter_disable_columns;
}

function hide_wait()
{
	window.wij_end_modal_dialog(); 
}
function show_wait() {

	var template = '<div class="message"><f-icon class="fa-loading icon-xl"></f-icon>'+
		       '<div class="message-content ng-binding">' + $j.getInfo("load_wait") +'</div></div>';
	
	wij_display_modal_content(template);	
}

var formatter = FOSGUI.LogFormatter.getFormatter();

var last_session_id = 0;
function dm_onload(filter)
{
	'use strict';
	var arg_filter = filter;
	var json_path = '/waf/device_manage/json';

	filter = filter ? JSON.stringify(filter) : param_filter;
	json_path = setQueryValue(json_path, 'filter', filter);

	function single_arg_filter(arg) { return arg }

	dm_ng.ready = $j.when($j.getJSON(json_path).then(single_arg_filter), dm_ng.columns).then(
	function(content, column) {
		var $contentHead = $j('#contentHead').empty();
		if (content.status === 'error') {
			$j.alert($j.getInfo(content.error_code));
		}
		content.is_fortiview = false;
		content.is_all_session = false;

		$j(window).off('message.qlistsource')
		.on('message.qlistsource', function(event) {
			event = event.originalEvent || event;
			var data = event.data;
			if (event.origin !== window.location.origin || !data.get) {
				return;
			}
			if (data.get === 'qlist.source' && data.id) {
				event.source.postMessage({put: data.get, value: content.source, id: data.id},
					window.location.origin);
			}
		});

		function search_completed() {
			return content.completed >= 100;
		}

		now = new Date(Date.parse(content.now));

		function is_col(col_name) {
			return function(col) {
				return col.selector === col_name;
			};
		}
		// add filtered columns to default columns
		var filter_str = getParams({'filter': ''}).filter;
		if (filter_str) {
			var filter_obj = JSON.parse(filter_str);
			for (var i = 0, len = filter_obj.length; i < len; ++i) {
				var col = filter_obj[i].id;
				if (column.default_columns.indexOf(col) === -1 &&
						column.columns.some(is_col(col))) {
							column.default_columns.push(col);
						}
			}
		}
		function replace(expr, new_val) {
			return function(val) { return val.replace(expr, new_val) };
		}
		function in_arr(arr) {
			return function(val) { return arr.indexOf(val) !== -1 };
		}
		function not(fn) { return function(val) { return !fn(val) } }

		var add_cols = [];
		if (param_default_cols) {
			var remove_ex = /^-/;
			var remove_test = remove_ex.test.bind(remove_ex);
			var cols = param_default_cols.split(',');
			add_cols = cols
				.filter(not(remove_test));
			var rm_cols = cols.filter(remove_test)
				.map(replace(remove_ex, ''));
			column.default_columns = column.default_columns
				.filter(not(in_arr(rm_cols)))
				.concat(add_cols.filter(
							not(in_arr(column.default_columns))
						       ));
		}
		function col_order(cols, prop) {
			return function sort(a, b) {
				return index(prop ? a[prop] : a) - index(prop ? b[prop] : b);
			};
			function index(value) {
				value = cols.indexOf(value);
				return value > -1 ? value : Number.MAX_VALUE;
			}
		}

		function lang_order(a, b) {
			return $j.sortCompareText(
				$j.getInfo(a.lang_key),
				$j.getInfo(b.lang_key)
			);
		}
		last_session_id = content.session_id;

		var qlist_settings = {
			source: content.source,
			columns: column.columns
				.sort(lang_order)
				.sort(col_order(add_cols, 'selector')),
			default_columns: column.default_columns,
			checkboxes: {
				enabled: false,
				hide_disabled: false
			},
			options: {
				hide_default_buttons: true,
				disable_context_menu: true,
				resizable_columns:false,
				fixed_footer: true,
				//hide_menu: true,
				resize_to_parent: false,
				css_layout: true
			},
			column_filters: {
				enabled: false,
				value: JSON.parse(filter),
				highlight: { enabled: true},
				// disable default filtering
				filter_fn: null,
				server_side_reload: function() {
					dm_onload(arg_filter);
				}
			},
			row_attr: [
				{selector: '#', name: 'mkey'},
			],
			format_fn: {
				// set default to escape all outputs prevent XSS Injection
				'*': function(td, col, entry) {
					return escapeHTML(entry[col.selector]);
				}
			},
			paging: {
				enabled: true,
				server_side: true,
				total_lines: content.total_lines,
				completed: search_completed,
				last_page_button: true,
				fetch: function(page_num, cb) {
					if (content.session_id !== last_session_id) {
						return;
					}
					var path = json_path;
					path = setQueryValue(path, 'session_id', content.session_id);
					path = setQueryValue(path, 'page', page_num);
					path = setQueryValue(path, 'offset', dm_ng.offset);
					if (page_num !== content.page_num) {
						content.page_num = page_num;
						content.source.length = 0;
					} else {
						path = setQueryValue(path, 'fetched', content.source.length);
					}
					/* this for filter change page info*/
					var raw_path = decodeURI(json_path);
					var filter_start = raw_path.indexOf('logic"%3A{"is');
					var filter_end = raw_path.indexOf('id"%3A"');
					var is_filter = (raw_path.substring(filter_start,filter_end).indexOf('rel_time') != -1 )?true:false;
					dm_ng.showLoading();
					$j.getJSON(path, function(data) {
						dm_ng.hideLoading();
						content.completed = data.completed;
						//The call order is critical, because cb updates DOM
						cb(data);
						$j.merge(content.source, data.source);
						content.total_lines = data.total_lines;
						if (!$j('tr.selected', '#contentHead').length) {
						}

						$j(".ql-body-table").resize(function() {
							$j('#contentHead').qlist('refresh');
						})
						if(is_filter) changePageText(data.source.length);
						dm_ng.offset = data.offset;
					});
				}
			},
			prefix: qlist_prefix,
			callbacks: {
				load: function(){
					$j('#qlist_dm_qlist_yui_menubar').toggle(false);
				}
			}
		};

		if (getParams({fortiview: 0}).fortiview) {
			delete qlist_settings.menu_items;
			qlist_settings.options.hide_menu = true;
		}

		// delegate the format function to the appropriate formatter function
		for (var x in formatter) {
			qlist_settings.format_fn[x] = FOSGUI.LogFormatter.format_fn_to;
		}
		var result = $contentHead
			.removeData()
			.qlist(qlist_settings);
		$j.internationalizeLanguageEntries();

		$j('#loading').hide();

		var raw_path = decodeURI(json_path);
		var filter_start = raw_path.indexOf('logic"%3A{"is');
		var filter_end = raw_path.indexOf('id"%3A"');
		var is_filter = (raw_path.substring(filter_start,filter_end).indexOf('rel_time') != -1 )?true:false;
		if(is_filter) changePageText(content.source.length);

		dm_ng.offset = content.offset;

		setInactiveCountDown(timeout_in_sec);
		return $j.when(content.source, result);
	});

	dm_ng.onload = dm_onload;
}

dm_ng.showLoading = function() {
	'use strict';
	$j('#loading').css('display', '');
	$j('#contentHead').children().hide();
};


dm_ng.hideLoading = function() {
	'use strict';
	$j('#loading').hide();
	$j('#contentHead').children().show();
};

dm_ng.columns = $j.getJSON(qlist_columns_url).then(function(column) {
	'use strict';
	column.columns.forEach(function(col) {
		var returntrue = function() { return true; };
		// manually override the field type of some columns
		if (col.novalidate) {
			if (col.filter == null) { col.filter = {}; }
			col.filter.validate = returntrue;
		}

		if (col.selector === 'rel_time') {
			col.fld_type = FIELD_TYPE.DATE_TIME;
		}
		if ('fld_type' in col) {
			col.type = FIELD_TYPE_STRINGS[col.fld_type];
		}
	});
	return column;
});

dm_ng.get_filter_disable_columns = get_filter_disable_columns;

var page_ready = $j.Deferred(),
    search_ready = 
    fweb.util.functional.castToJQueryPromise(dm_ng.search_ready);
    $j(document).ready(page_ready.resolve.bind(page_ready));

//wrap onload function because otherwise the filter gets set incorrectly
$j.when(search_ready, page_ready)
	.then(function(filter) {
		'use strict';
		dm_onload(Array.isArray(filter) ? filter : undefined);
	});

function changePageText(num)
{
	$j(".total_lines").text(num);
	$j(".page_last").removeClass('list_action');
	$j(".page_last").addClass('tool_last0');
	$j(".page_current").attr('disabled','true');
	$j(".page_current").next().html ('');
	$j(".page_current").next().next().attr('style','display:none');
	$j(".total_lines").parent().parent().attr('style','display:none');
}
