var sub_module_list = (function($) {
	'use strict';

	var source;

	function type_format_fn(td, col, row_data)
        {
                var data = row_data[col.selector];
                var key = '';
                if(data == 'plain')
                        key = 'simple';
                else if(data == 'regular')
                        key = 'regex';
                return $j.getInfo(key, flt_lang);
        }

        function file_format_fn(td, col, row_data)
        {
                var data = row_data[col.selector];
                return escapeHTML(data);
        }

	function status_format_fn(td, col, row_data){
                var data = row_data[col.selector];
                return (data === "") ? data : $j.getInfo(data,fgt_lang);
        }

	function method_format_fn(td, col, row_data){
		var data = row_data[col.selector];
		return data.toUpperCase();
	}

	function setup_qlist()
	{
		if(table_key == '')
		{
			source = [];
			gen_qlist();
		}
		else
		{
			$.ajax({
				'url': '/cli-direct-action?mkey='+table_key+'&table_gid='+table_gid+'&child_gid='+child_gid+'&vdom='+vdom,
				'dataType': 'json',
				'success': function(response)
				{
					if(response.status == 1)
					{
						source = response.datas;
						gen_qlist();
					}
					else if(response.status == 0)
						error_handler(response.msg_id, "/waf/allow_method_exceptions/dlg?mkey=" + table_key+'&vdom='+vdom);
				},
				'cache': false
				});
		}
	}

	function gen_qlist(){
		if (!window.fgt_lang || !fgt_lang["global"])
			$j.addLang();

		var menu_items;
                if(is_rw_admin)
                {
                        menu_items = {
                                'edit': {
                                        'handler': sub_edit_click
                                },
                                'delete': {
                                        'handler': sub_delete_click
                                },
                        };

                }
                else
                {
                        menu_items = {
                                'edit': {
                                        'handler': sub_edit_click
                                }
                        };
                }

		var qlist_settings = {
			'prefix': 'allow_method_exception_sub',
			'source': source,
			'cr_new_url': create_sub_url,
			'cr_edit_url': edit_sub_url,
            'options':{ 
            	'popup': true,
            	'sliderwidth':1000
        	},
			'row_attr': [
				{name: 'id', selector: 'id'},
			],
			'columns': [
				{'selector': 'id', 'lang_key': $j.getInfo("member_id",flt_lang)},
				{'selector': 'host', 'lang_key': $j.getInfo("member_host",flt_lang)},
				{'selector': 'host-status', 'lang_key': $j.getInfo("member_host_status",flt_lang)},
				{'selector': 'request-file', 'lang_key': $j.getInfo("member_url",flt_lang)},
				{'selector': 'request-type', 'lang_key': $j.getInfo("member_url_type",flt_lang)},
				{'selector': 'allow-request', 'lang_key': $j.getInfo("member_method",flt_lang)}
			],
			'menu_items': menu_items,
			'default_columns':['id', 'host', 'host-status', 'request-file', 'request-type', 'allow-request'],
			'column_filters': {
				'enabled': true,
				'exempts': ['id', 'host-status', 'request-type', 'allow-request']
			},
			'handle_selection_change': sub_selection_changed,
			'format_fn': {
				'host-status': status_format_fn,
				'request-file': file_format_fn,
				'request-type': type_format_fn,
				'allow-request': method_format_fn
			}
                };

		var $container = $("#sub_content");
		$container.qlist(qlist_settings);

	}

	return {configure: setup_qlist};

})(jQuery);
