var sub_module_list = (function($) {
	'use strict';

	var source;

	function lang_format_fn(td, col, row_data){
                var data = row_data[col.selector];
                return (data === "") ? data : $j.getInfo(data,fgt_lang);
        }

	function protocol_format_fn(td, col, row_data){
		var data = row_data[col.selector];
		return data.toUpperCase();
	}

	function setup_qlist()
	{
		if(table_key == '')
		{
			source = [];
			gen_qlist();
		}
		else
		{
			$.ajax({
				'url': '/cli-direct-action?mkey='+table_key+'&table_gid='+table_gid+'&child_gid='+child_gid+'&vdom='+vdom,
				'dataType': 'json',
				'success': function(response)
				{
					if(response.status == 1)
					{
						source = response.datas;
						gen_qlist();
					}
					else if(response.status == 0)
						error_handler(response.msg_id, "/waf/allowed_origin/dlg?mkey=" + table_key+'&vdom='+vdom);
				},
				'cache': false
				});
		}
	}

	function gen_qlist(){
		if (!window.fgt_lang || !fgt_lang["global"])
			$j.addLang();

		var menu_items;
                if(is_rw_admin)
                {
                        menu_items = {
                                'edit': {
                                        'handler': sub_edit_click
                                },
                                'delete': {
                                        'handler': sub_delete_click
                                },
                        };

                }
                else
                {
                        menu_items = {
                                'edit': {
                                        'handler': sub_edit_click
                                }
                        };
                }

		var qlist_settings = {
			'prefix': 'allowed_origin_sub',
			'source': source,
			'cr_new_url': create_sub_url,
			'cr_edit_url': edit_sub_url,
			'options':{
				'popup': true,
				'sliderwidth':1000
			},
			'row_attr': [
				{name: 'id', selector: 'id'},
			],
			'columns': [
				{'selector': 'id', 'lang_key': $j.getInfo("member_id",flt_lang)},
				{'selector': 'protocol', 'lang_key': $j.getInfo("protocol",flt_lang)},
				{'selector': 'port', 'lang_key': $j.getInfo("port",flt_lang)},
				{'selector': 'include-sub-domains', 'lang_key': $j.getInfo("include_sub_domains",flt_lang)},
				{'selector': 'origin-name', 'lang_key': $j.getInfo("origin_value",flt_lang)}
			],
			'menu_items': menu_items,
			'default_columns':['id', 'protocol', 'port', 'include-sub-domains', 'origin-name'],
			'column_filters': {
				'enabled': true,
				'exempts': ['id', 'port', 'include-sub-domains', 'origin-name']
			},
			'handle_selection_change': sub_selection_changed,
			'format_fn': {
				'protocol': protocol_format_fn,
				'include-sub-domains': lang_format_fn
			}
                };

		var $container = $("#sub_content");
		$container.qlist(qlist_settings);

	}

	return {configure: setup_qlist};

})(jQuery);
