var sub_module_list = (function($) {
	'use strict';

	var source,source1, source2;

	function method_format_fn(td, col, row_data){
		var data = row_data[col.selector];
		return data.toUpperCase();
	}

	function sub_create_click(qlist, elems)
	{
		var create_sub_url = "";
		if(qlist.prefix == "allowed_method")
		{
			create_sub_url = create_method_sub_url;
		}else if(qlist.prefix == "allowed_header"){
			create_sub_url = create_allowed_header_sub_url;
		}else{
			create_sub_url = create_exposed_header_sub_url;
		}
		if(qlist.popup){
			var qlistSubSlide;
			qlistSubSlide = new top.Sliderin({ 
				title: '',  
				url: create_sub_url,  
				width: qlist.sliderwidth 
			}); 
			qlistSubSlide.open(); 
		}else{
			window.location.href = create_sub_url;
		}
	}
	// default sub list edit click function
	function sub_edit_click(qlist, elems)
	{
	    var mkey = qlist_get_row_attr(elems, 'id');
		var edit_url = "";
		if(qlist.prefix == "allowed_method")
		{
			edit_url = edit_method_sub_url;
		}else if(qlist.prefix == "allowed_header"){
			edit_url = edit_allowed_header_sub_url;
		}else{
			edit_url = edit_exposed_header_sub_url;
		}	       

	       if(mkey){
			edit_url = qlist_url_append_arg(edit_url, "id", mkey);
	               if(qlist.popup){
				var qlistSubSlide;
				qlistSubSlide = new top.Sliderin({ 
					title: '',  
					url: edit_url,  
					width: qlist.sliderwidth 
				}); 
				qlistSubSlide.open(); 
			}else{
				window.location.href = edit_url;		}
	       }
	}
	// default sub list delete click function
	function sub_delete_click(qlist, elems)
	{
	       var aElems = qlist.get_checked_rows();

	       var del_url = "";

			if(qlist.prefix == "allowed_method")
			{
				del_url = del_method_sub_url;
			}else if(qlist.prefix == "allowed_header"){
				del_url = del_allowed_header_sub_url;
			}else{
				del_url = del_exposed_header_sub_url;
			}	
			del_url = qlist_url_append_arg(del_url, "session_id", session_id);
	       aElems.each(function() {
			del_url = qlist_url_append_arg(del_url, "id", qlist_get_row_attr(this, 'id'));       });
	       $j.submitPOST(del_url);
	}

	function setup_qlist()
	{
		if(table_key == '')
		{
			source = [];
			source1 = [];
			source2 = [];
			gen_qlist();
		}
		else
		{
			$.ajax({
				'url': '/waf/cors_rule/sub_list_json?mkey='+table_key+'&vdom='+vdom,
				'dataType': 'json',
				'success': function(response)
				{
					if(response.status == 1)
					{
						source = response.allowed_methods;
						source1 = response.allowed_headers;
						source2 = response.exposed_headers;
						gen_qlist();
					}
					else if(response.status == 0)
						error_handler(response.msg_id, "/waf/cors_rule/dlg?mkey=" + table_key+'&vdom='+vdom);
				},
				'cache': false
				});
		}
	}

	function gen_qlist(){
		if (!window.fgt_lang || !fgt_lang["global"])
			$j.addLang();

		var menu_items;
                if(is_rw_admin)
                {
                        menu_items = {
                        		'create_new': {
										'handler': sub_create_click
								},
                                'edit': {
                                        'handler': sub_edit_click
                                },
                                'delete': {
                                        'handler': sub_delete_click
                                },
                        };

                }
                else
                {
                        menu_items = {
                                'edit': {
                                        'handler': sub_edit_click
                                }
                        };
                }

		var qlist_settings = {
			'prefix': 'allowed_method',
			'source': source,
            'options':{ 
            	'popup': true,
            	'sliderwidth':1000
        	},
			'row_attr': [
				{name: 'id', selector: 'id'},
			],
			'columns': [
				{'selector': 'id', 'lang_key': $j.getInfo("member_id",flt_lang)},
				{'selector': 'method', 'lang_key': $j.getInfo("method",flt_lang)}
			],
			'menu_items': menu_items,
			'default_columns':['id', 'method'],
			'column_filters': {
				'enabled': true,
				'exempts': ['id']
			},
			'handle_selection_change': sub_selection_changed,
			'format_fn': {
				'method': method_format_fn
			}
        };

		var qlist_settings1 = {
			'prefix': 'allowed_header',
			'source': source1,
            'options':{ 
            	'popup': true,
            	'sliderwidth':1000
        	},
			'row_attr': [
				{name: 'id', selector: 'id'},
			],
			'columns': [
				{'selector': 'id', 'lang_key': $j.getInfo("member_id",flt_lang)},
				{'selector': 'header', 'lang_key': $j.getInfo("header",flt_lang)}
			],
			'menu_items': menu_items,
			'default_columns':['id', 'header'],
			'column_filters': {
				'enabled': true,
				'exempts': ['id']
			},
			'handle_selection_change': sub_selection_changed,
			'format_fn': {
			}
        };
		var qlist_settings2 = {
			'prefix': 'exposed_header',
			'source': source2,
            'options':{ 
            	'popup': true,
            	'sliderwidth':1000
        	},
			'row_attr': [
				{name: 'id', selector: 'id'},
			],
			'columns': [
				{'selector': 'id', 'lang_key': $j.getInfo("member_id",flt_lang)},
				{'selector': 'header', 'lang_key': $j.getInfo("header2",flt_lang)}
			],
			'menu_items': menu_items,
			'default_columns':['id', 'header'],
			'column_filters': {
				'enabled': true,
				'exempts': ['id']
			},
			'handle_selection_change': sub_selection_changed,
			'format_fn': {
			}
        };
		var $container = $("#sub_content_0");		
		var $container1 = $("#sub_content_1");
		var $container2 = $("#sub_content_2");

		$container.qlist(qlist_settings);
		$container1.qlist(qlist_settings1);
		$container2.qlist(qlist_settings2);

	}

	return {configure: setup_qlist};

})(jQuery);
