var sub_module_list = (function($) {
	'use strict';

	var source;

	function lang_format_fn(td, col, row_data){
		var data = row_data[col.selector];
		return (data === "") ? data : $j.getInfo(data,flt_lang);
	}

	function type_format_fn(td, col, row_data)
	{
		var data = row_data[col.selector];
		return (data === "plain") ? $.getInfo('simple', flt_lang) : $.getInfo('regex', flt_lang);
	}

	function file_format_fn(td, col, row_data)
	{
		var data = row_data[col.selector];
		return escapeHTML(data);
	}

	function status_format_fn(td, col, row_data){
		var data = row_data[col.selector];
		return (data === "") ? data : $j.getInfo(data);
	}

	function source_ip_format_fn(td, col, row_data){
		var stus = row_data['source-ip-status'];
		var data = row_data[col.selector];
		if(stus == "disable")
			return "";
		else
			return data;

	}

	function setup_qlist()
	{
		if(table_key == '')
		{
			source = [];
			gen_qlist();
		}
		else
		{
			$j.ajax({
				'url': '/cli-direct-action?mkey='+table_key+'&table_gid='+table_gid+'&child_gid='+child_gid+'&vdom='+vdom,
				'dataType': 'json',
				'success': function(response)
				{
					if(response.status == 1)
					{
						source = response.datas;
						gen_qlist();
					}
					else if(response.status == 0)
						error_handler(response.msg_id, "/waf/http_constraints_expt/dlg?mkey=" + table_key + '&vdom=' + vdom);
				},
				'cache': false
			});
		}
	}

	function gen_qlist()
	{
		if(!window.fgt_lang || !fgt_lang["global"])
			$j.addLang();

		var menu_items;
		if(is_rw_admin)
		{
			menu_items = {
				'edit': {
					'handler': sub_edit_click
				},
				'delete': {
					'handler': sub_delete_click
				},
			};

		}
		else
		{
			menu_items = {
				'edit': {
					'handler': sub_edit_click
				}
			};
		}

		var qlist_settings = {
			'prefix': 'hpc_exception_sub',
			'source': source,
			'cr_new_url': create_sub_url,
			'cr_edit_url': edit_sub_url,
			'row_attr': [
				{name: 'id', selector: 'id'},
			],
            'options':{ 
            	'popup': true,
            	'sliderwidth':1000
        	},
			'columns': [
				{'selector': 'id', 'lang_key': $j.getInfo("member_id",flt_lang)},
				{'selector': 'host', 'lang_key': $j.getInfo("member_host",flt_lang)},
				{'selector': 'host-status', 'lang_key': $j.getInfo("member_host_status",flt_lang)},
				{'selector': 'source-ip-status', 'lang_key': $j.getInfo('sip', flt_lang)},
				{'selector': 'source-ip', 'lang_key': $j.getInfo('source_ip', flt_lang)},
				{'selector': 'request-file', 'lang_key': $j.getInfo("member_url",flt_lang)},
				{'selector': 'request-type', 'lang_key': $j.getInfo("member_url_type",flt_lang)},
				{'selector': 'max-http-header-length', 'lang_key': $j.getInfo("head_len",flt_lang)},
				{'selector': 'max-http-content-length', 'lang_key': $j.getInfo("content_len",flt_lang)},
				{'selector': 'max-http-body-length', 'lang_key': $j.getInfo("body_len",flt_lang)},
				{'selector': 'max-http-request-filename-length', 'lang_key': $j.getInfo("http_req_filename_len",flt_lang)},
				{'selector': 'max-http-request-length', 'lang_key': $j.getInfo("http_request_length",flt_lang)},
				{'selector': 'max-url-parameter-length', 'lang_key': $j.getInfo("url_parameter_length",flt_lang)},
				{'selector': 'max-cookie-in-request', 'lang_key': $j.getInfo("cookie_in_req",flt_lang)},
				{'selector': 'max-header-line-request', 'lang_key': $j.getInfo("header_line_request",flt_lang)},
				{'selector': 'Illegal-http-request-method-check', 'lang_key': $j.getInfo("http_req_method_check",flt_lang)},
				{'selector': 'max-url-parameter', 'lang_key': $j.getInfo("url_param",flt_lang)},
				{'selector': 'Illegal-host-name-check', 'lang_key': $j.getInfo("host_name_check",flt_lang)},
				{'selector': 'number-of-ranges-in-range-header', 'lang_key': $j.getInfo("number_of_range",flt_lang)},
				{'selector': 'block-malformed-request', 'lang_key': $j.getInfo("block_malformed_request",flt_lang)},
				{'selector': 'Illegal-content-length-check', 'lang_key': $j.getInfo("illegal_content_length",flt_lang)},
				{'selector': 'Illegal-content-type-check', 'lang_key': $j.getInfo("illegal_content_type",flt_lang)},
				{'selector': 'Illegal-responese-code-check', 'lang_key': $j.getInfo("illegal_res_code",flt_lang)},
				{'selector': 'Post-request-ctype-check', 'lang_key': $j.getInfo("post_req_ctype",flt_lang)},
				{'selector': 'max-http-header-name-length', 'lang_key': $j.getInfo("head_name_len",flt_lang)},
				{'selector': 'max-http-header-value-length', 'lang_key': $j.getInfo("head_value_len",flt_lang)},
				{'selector': 'parameter-name-check', 'lang_key': $j.getInfo("param_name",flt_lang)},
				{'selector': 'parameter-value-check', 'lang_key': $j.getInfo("param_value",flt_lang)},
				{'selector': 'Illegal-header-name-check', 'lang_key': $j.getInfo("illegal_head_name",flt_lang)},
				{'selector': 'Illegal-header-value-check', 'lang_key': $j.getInfo("illegal_head_value",flt_lang)},
				{'selector': 'max-http-body-parameter-length', 'lang_key': $j.getInfo("max_bparam_len",flt_lang)},
				{'selector': 'max-url-param-name-len', 'lang_key': $j.getInfo("max_param_name",flt_lang)},
				{'selector': 'max-url-param-value-len', 'lang_key': $j.getInfo("max_param_value",flt_lang)},
				{'selector': 'url-param-name-check', 'lang_key': $j.getInfo("urlparam_name_check",flt_lang)},
				{'selector': 'url-param-value-check', 'lang_key': $j.getInfo("urlparam_value_check",flt_lang)},
				{'selector': 'redundant-header-check', 'lang_key': $j.getInfo("redundant_header_value",flt_lang)},
				{'selector': 'duplicate-paramname-check', 'lang_key': $j.getInfo("duplicate_pname_check",flt_lang)},
				{'selector': 'rpc-protocol-check', 'lang_key': $j.getInfo("rpc_protocol", flt_lang)}
			],
			'menu_items': menu_items,
			'default_columns':['id', 'host-status', 'host', 'source-ip-status', 'source-ip', 'request-type', 'request-file'],
			'column_filters': {
				'enabled': true,
				'exempts': [
					'id', 'host-status', 'source-ip-status', 'request-type', 'max-http-header-length',
					'max-http-content-length', 'max-http-body-length', 'max-http-request-filename-length',
					'max-http-request-length', 'max-url-parameter-length', 'max-cookie-in-request',
					'max-header-line-request', 'Illegal-http-request-method-check', 'max-url-parameter',
					'Illegal-host-name-check', 'number-of-ranges-in-range-header', 'block-malformed-request',
					'Illegal-content-length-check', 'Illegal-content-type-check', 'Illegal-responese-code-check',
					'Post-request-ctype-check', 'max-http-header-name-length', 'max-http-header-value-length',
					'parameter-name-check', 'parameter-value-check', 'Illegal-header-name-check',
					'Illegal-header-value-check', 'max-http-body-parameter-length', 'max-url-param-name-len',
					'max-url-param-value-len', 'url-param-name-check', 'url-param-value-check',
					'redundant-header-check', 'duplicate-paramname-check']
			},
			'handle_selection_change': sub_selection_changed,
			'format_fn': {
				'host-status': lang_format_fn,
				'request-type': type_format_fn,
				'request-file': file_format_fn,
				'max-http-header-length': status_format_fn,
				'max-http-content-length': status_format_fn,
				'max-http-body-length': status_format_fn,
				'max-http-request-filename-length': status_format_fn,
				'max-http-request-length': status_format_fn,
				'max-url-parameter-length': status_format_fn,
				'max-cookie-in-request': status_format_fn,
				'max-header-line-request': status_format_fn,
				'Illegal-http-request-method-check': status_format_fn,
				'max-url-parameter': status_format_fn,
				'Illegal-host-name-check': status_format_fn,
				'number-of-ranges-in-range-header': status_format_fn,
				'block-malformed-request': status_format_fn,
				'Illegal-content-length-check': status_format_fn,
				'Illegal-content-type-check': status_format_fn,
				'Illegal-responese-code-check': status_format_fn,
				'Post-request-ctype-check': status_format_fn,
				'max-http-header-name-length': status_format_fn,
				'max-http-header-value-length': status_format_fn,
				'parameter-name-check': status_format_fn,
				'parameter-value-check': status_format_fn,
				'Illegal-header-name-check': status_format_fn,
				'Illegal-header-value-check': status_format_fn,
				'max-http-body-parameter-length': status_format_fn,
				'max-url-param-name-len': status_format_fn,
				'max-url-param-value-len': status_format_fn,
				'url-param-name-check': status_format_fn,
				'url-param-value-check': status_format_fn,
				'redundant-header-check': status_format_fn,
				'duplicate-paramname-check': status_format_fn,
				'source-ip-status': status_format_fn,
				'source-ip': source_ip_format_fn,
				'rpc-protocol-check': status_format_fn
			}
		};

		var $container = $("#sub_content");
		$container.qlist(qlist_settings);
	}

	return {configure: setup_qlist};
})(jQuery);
