var sub_module_list = (function($) {
	'use strict';

	var source;

	var match_obj_lang = {
		"http-host": "http_host",
		"http-request": "http_req",
		"url-parameter": "http_parameter",
		"http-referer": "http_refer",
		"http-cookie": "http_req_cookie",
		"http-header": "http_header",
		"source-ip": "source_ip",
		"x509-certificate-Subject": "x509_certificate_sub",
		"x509-certificate-Extension": "x509_certificate_ext",
		"https-sni": "https_sni",
		"geo-ip": "http_geoip",
		"enable": "enable",
		"disable": "disable",
		"and": "relationship_and",
		"or": "relationship_or",
		"match-begin": "match_begin",
		"match-end": "match_end",
		"match-sub": "match_sub",
		"match-domain": "match_domain",
		"match-dir": "match_dir",
		"match-reg": "match_reg",
		"ip-range": "match_range_ipv4",
		"ip-range6": "match_range_ipv6",
		"equal": "match_equal"
	};

	var name_value_lang = {
		'url-parameter': {
			name: 'parameter_name',
			value: 'parameter_value'
		},
		'http-cookie': {
			name: 'cookie_name',
			value: 'cookie_value'
		},
		'http-header': {
			name: 'header_name',
			value: 'header_value'
		}
	};

	function lang_format_fn(td, col, row_data){
		var data = row_data[col.selector];
		return (data === "") ? data : $j.getInfo(match_obj_lang[data],flt_lang);
	}

	function match_condition_format_fn(td, col, row_data) {
		var data = "";
		var object = row_data['match-object'];
		switch (object) {
			case 'http-host':
			case 'http-request':
			case 'http-referer':
			case 'https-sni':
				data = [
					'<b>',
					$j.getInfo(match_obj_lang[object], flt_lang),
					'</b>: <i>',
					$j.getInfo(match_obj_lang[row_data['match-condition']], flt_lang),
					'</i>: ',
					row_data['match-expression']
				].join('');
				break;
			case 'url-parameter':
			case 'http-cookie':
			case 'http-header':
				data = [
					'<b>',
					$j.getInfo(name_value_lang[object].name, flt_lang),
					'</b>: <i>',
					$j.getInfo(match_obj_lang[row_data['name-match-condition']], flt_lang),
					'</i>: ',
					row_data['name'],
					', <b>',
					$j.getInfo(name_value_lang[object].value, flt_lang),
					'</b>: <i>',
					$j.getInfo(match_obj_lang[row_data['value-match-condition']], flt_lang),
					'</i>: ',
					row_data['value']
				].join('');
				break;
			case 'source-ip':
				var sourceIpValue;
				if (row_data['match-condition'] == "match-reg") {
					sourceIpValue = row_data['match-expression'];
				} else if (row_data['start-ip'] == row_data['end-ip']) {
					sourceIpValue = row_data['start-ip'];
				} else {
					sourceIpValue = [row_data['start-ip'], '-', row_data['end-ip']].join('');
				}
				data = [
					'<b>',
					$j.getInfo(match_obj_lang[object], flt_lang),
					'</b>: <i>',
					$j.getInfo(match_obj_lang[row_data['match-condition']], flt_lang),
					'</i>: ',
					sourceIpValue
				].join('');
				break;
			case 'x509-certificate-Subject':
				data = [
					'<b>',
					$j.getInfo(match_obj_lang[object], flt_lang),
					'</b>: <i>',
					row_data['x509-subject-name'],
					'</i>: ',
					row_data['match-expression']
				].join('');
				break;
			case 'x509-certificate-Extension':
				data = [
					'<b>',
					$j.getInfo(match_obj_lang[object], flt_lang),
					'</b>: <i>',
					$j.getInfo(match_obj_lang[row_data['value-match-condition']], flt_lang),
					'</i>: ',
					row_data['value']
				].join('');
				break;
			case 'geo-ip':
				var countryValue = country_name_fn(row_data['country-list']);
				var countryShortValue = (countryValue.length > 95) ? (countryValue.substr(0, 90) + '...') : countryValue;
				data = [
					'<span title="',
					countryValue,
					'"><b>',
					$j.getInfo('country', flt_lang),
					'</b>: ',
					countryShortValue,
					'</span>'
				].join('');
		}
		return data;
	}

	function country_name_fn(country_list) {
		if (!country_list)
			return "";
		var i = 0,
			j = 0,
			countryCollection = [];
		country_list = country_list.replace(/\\/g, '');
		while (i < country_list.length) {
			if (country_list[i] == '"') {
				j = country_list.indexOf('" ', i + 1);
				if (j > 0) {
					countryCollection.push(country_list.substring(i + 1, j));
					i = j + 2;
				} else {
					break;
				}
			} else {
				j = country_list.indexOf(' ', i + 1);
				if (j > 0) {
					countryCollection.push(country_list.substring(i, j));
					i = j + 1;
				} else {
					break;
				}
			}
		}
		return countryCollection.join(', ');
	}

	// function match_string_format_fn(td, col, row_data){
	// 	var data = "";
	// 	var object = row_data['match-object'];
	// 	if((col.selector == "host" && object == "http-host")
	// 		||(col.selector == "url" && object == "http-request")
	// 		||(col.selector == "referer" && object == "http-referer")
	// 		||(col.selector == "https_sni" && object == "https-sni")
	// 	)
	// 	{
	// 		data = row_data['match-expression'];
	// 	}
		
	// 	return data;
	// }

	// function name_string_format_fn(td, col, row_data){
	// 	var data = "";
	// 	var object = row_data['match-object'];
	// 	if((col.selector == "param_name" && object == "url-parameter")
	// 		||(col.selector == "cookie_name" && object == "http-cookie")
	// 		||(col.selector == "header_name" && object == "http-header"))
	// 	{
	// 		data = row_data['name'];
	// 	}
		
	// 	return data;
	// }

	// function value_string_format_fn(td, col, row_data){
	// 	var data = "";
	// 	var object = row_data['match-object'];
	// 	if(col.selector == "x509_value" && object == "x509-certificate-Extension")
	// 		data = row_data['value'];

	// 	return data;
	// }

	// function ip_format_fn(td, col, row_data){
	// 	var data = "";
	// 	var condition = row_data['match-condition'];
	// 	if(row_data['match-object'] == "source-ip")
	// 	{
	// 		if(condition == "ip-range" || condition == "ip-range6")
	// 		{
	// 			data = row_data['start-ip']
	// 			 + (row_data['start-ip']!=row_data['end-ip']?("-" + row_data['end-ip']):"");
	// 		} else {
	// 			data = row_data['match-expression'];
	// 		}
	// 	}

	// 	return data;
	// }

	// function x509_name_format_fn(td, col, row_data){
	// 	var name = "";
	// 	var object = row_data['match-object'];
	// 	if(object == "x509-certificate-Subject")
	// 		name = row_data['x509-subject-name'] + " = " + row_data['match-expression'];
		
	// 	return name;
	// }

	function setup_qlist()
	{
		if(table_key == '')
		{
			source = [];
			gen_qlist();
		}
		else
		{
			$.ajax({
				//'url': '/prot/http_content_routing_policy/sub_list/json?mkey='+table_key,
				'url': '/cli-direct-action?mkey='+table_key+'&table_gid='+table_gid+'&child_gid='+child_gid+'&vdom='+vdom,
				'dataType': 'json',
				'success': function(response)
				{
					if(response.status == 1)
					{
						source = response.datas;
						gen_qlist();
					}
					else if(response.status == 0)
						error_handler(response.msg_id, "/prot/http_content_routing_policy/dlg?mkey=" + table_key);
				},
				'cache': false
				});
		}
	}

	function content_loaded(qlist) {}

	// function hcr_row_gen_fn(rowIndex, row_data)
	// {
	// 	var row_len = 0;
	// 	if(rowIndex != 0)
	// 	{
	// 		if(row_data.concatenate == 'or')
	// 		{
	// 			var tr = $('<tr/>').addClass('nodrag qlist_row qlist_skip_row unselectable').attr('can_edit', '0').attr('can_delete', '0');
	// 			this.before(tr);
	// 			var td = $('<td>').appendTo(tr);
	// 			var tr_head = $('tr', tr.closest('table'))[1];
	// 			if (!tr_head) {return;}

	// 			td.attr('colspan', tr_head.cells.length);
	// 			td.text('OR');

	// 			var odd = tr.prev().hasClass('odd');
	// 			tr.toggleClass('odd', !odd);
	// 		}
	// 	}

	// 	if(rowIndex != 0)
	// 	{
	// 		var odd = this.prev().hasClass('odd');
	// 		this.toggleClass('odd', !odd);
	// 	}
	// }

	function gen_qlist(){
		if (!window.fgt_lang || !fgt_lang["global"])
			$j.addLang();
		var menu_items;
		if(is_rw_admin)
		{
			menu_items = {
				'edit': {
					'handler': sub_edit_click
				},
				'delete': {
					'handler': sub_delete_click
				},
				'mi_insert': {
					'id': 'mi_insert',
					'class': 'tool_sprite tool_insert',
					'handler': sub_insert_click,
					'label': qed_strtbl.insert
				},
				'mi_move': {
					'id': 'mi_move',
					'class': 'tool_sprite tool_move',
					'handler': sub_move_click,
					'label': qed_strtbl.move
				}
			};
		}
		else
		{
			menu_items = {
				'edit': {
					'handler': sub_edit_click
				}
			};
		}

		var qlist_settings = {
            'prefix': 'http_content_routing_sub',
            'source': source,
			'cr_new_url': create_sub_url,
            'row_attr': [
                    {name: 'id', selector: 'id'},
            ],
            'options':{ 
            	'popup': true,
            	'sliderwidth':1000
        	},
            'columns': [
                {'selector': 'id', 'lang_key': $j.getInfo("member_id", flt_lang)},
                {'selector': 'match-object', 'lang_key': $j.getInfo("match_object", flt_lang)},
                {'selector': 'concatenate', 'lang_key': $j.getInfo("match_relationship", flt_lang)},
                {'selector': 'reverse', 'lang_key': $j.getInfo("reverse", flt_lang)},
                {'selector': 'match-condition', 'lang_key': $j.getInfo("match_condition", flt_lang)},
				// {'selector': 'host', 'lang_key': $j.getInfo("http_host",flt_lang)},
				// {'selector': 'url', 'lang_key': $j.getInfo("http_req",flt_lang)},
				// {'selector': 'referer', 'lang_key': $j.getInfo("http_refer",flt_lang)},
				// {'selector': 'param_name', 'lang_key': $j.getInfo("parameter_name",flt_lang)},
				// {'selector': 'cookie_name', 'lang_key': $j.getInfo("cookie_name",flt_lang)},
				// {'selector': 'header_name', 'lang_key': $j.getInfo("header_name",flt_lang)},
				// {'selector': 'x509_name', 'lang_key': $j.getInfo("x509_name",flt_lang)},
				// {'selector': 'x509_value', 'lang_key': $j.getInfo("x509_value",flt_lang)},
				// {'selector': 'https_sni', 'lang_key': $j.getInfo("https_sni", flt_lang)},
				// {'selector': 'ip_val', 'lang_key': $j.getInfo("source_ip",flt_lang)},
            ],
            'menu_items': menu_items,
            'default_columns':['id', 'match-object', 'concatenate', 'reverse', 'match-condition'],
            'column_filters': {
                    'enabled': true,
                    'exempts': ['id', 'concatenate', 'reverse', 'match-condition']
            },
            //'row_gen': hcr_row_gen_fn,
            'handle_selection_change': sub_selection_changed,
            // 'callbacks': {
            //         'load': content_loaded
            // },
            'format_fn': {
				'match-object': lang_format_fn,
				'concatenate': lang_format_fn,
				'reverse': lang_format_fn,
				'match-condition': match_condition_format_fn,
				// 'host': match_string_format_fn,
				// 'url': match_string_format_fn,
				// 'referer': match_string_format_fn,
				// 'https_sni': match_string_format_fn,
				// 'param_name': name_string_format_fn,
				// 'cookie_name': name_string_format_fn,
				// 'header_name': name_string_format_fn,
				// 'x509_name': x509_name_format_fn,
				// 'x509_value': value_string_format_fn,
				// 'ip_val': ip_format_fn,
			}
        };

        var $container = $("#sub_content");
        $container.qlist(qlist_settings);

	}

	return {configure: setup_qlist};

})(jQuery);
