var sub_module_list = (function($) {
	'use strict';

	function lang_format_fn(td, col, row_data) {
		var data = row_data[col.selector];
		return (data === "") ? data : $j.getInfo(data, fgt_lang);
	}

	function param_type_format_fn(td, col, row_data) {
		var data = row_data[col.selector];
		return (data == 1) ? $.getInfo('regular_input', flt_lang) : $.getInfo('password_input', flt_lang);
	}

	function status_format_fn(td, col, row_data) {
		var data = row_data[col.selector];
		return (data == 1) ? $.getInfo('enable', flt_lang) : $.getInfo('disable', flt_lang);
	}

	function setup_qlist() {
		if (!window.fgt_lang || !fgt_lang["global"])
			$j.addLang();

		if (table_key == '') {
			var source = [];
			gen_param_qlist(source);
			gen_domain_qlist(source);
		} else {
			$.ajax({
				url: '/waf/mitb_rule/sub_list_json?mkey=' + table_key + '&vdom=' + vdom,
				dataType: 'json',
				success: function(response) {
					if (response.status == 1)
					{
						// param list
						gen_param_qlist(response.param_list);
						// domain list
						gen_domain_qlist(response.domain_list);
					} else if (response.status == 0) {
						error_handler(response.msg_id, "/waf/mitb_rule/dlg?mkey=" + table_key + "&vdom=" + vdom);
					}
				},
				cache: false
			});
		}
	}

	function gen_param_qlist(source) {
		var menu_items;
		if (is_rw_admin) {
			menu_items = {
				edit: {
					handler: sub_param_edit_click
				},
				delete: {
					handler: sub_param_delete_click
				}
			}
		} else {
			menu_items = {
				edit: {
					handler: sub_param_edit_click
				}
			}
		}

		var qlist_settings = {
			prefix: 'mitb_param_sub',
			source: source,
			cr_new_url: create_sub_url,
			row_attr: [{name: 'name', selector: 'name'}],
			columns: [
				{selector: 'name', lang_key: $j.getInfo("name", flt_lang)},
				{selector: 'type', lang_key: $j.getInfo("type", flt_lang)},
				{selector: 'obfuscate', lang_key: $j.getInfo("obfuscate", flt_lang)},
				{selector: 'encrypt', lang_key: $j.getInfo("encrypt", flt_lang)},
				{selector: 'anti_keylogger', lang_key: $j.getInfo("anti_keyLogger", flt_lang)}
			],
			menu_items: menu_items,
			default_columns: ['name', 'type', 'obfuscate', 'encrypt', 'anti_keylogger'],
			column_filters: {
				enabled: false
			},
			options: {
				popup: true,
				sliderwidth: 1000
			},
			handle_selection_change: sub_selection_changed,
			format_fn: {
				'type': param_type_format_fn,
				'obfuscate': status_format_fn,
				'encrypt': status_format_fn,
				'anti_keylogger': status_format_fn
			}
		};

		var $container = $('#param_sub_content');
		$container.qlist(qlist_settings);
	}

	function gen_domain_qlist(source) {
		var menu_items;
		if (is_rw_admin) {
			menu_items = {
				edit: {
					handler: sub_domain_edit_click
				},
				delete: {
					handler: sub_domain_delete_click
				}
			}
		} else {
			menu_items = {
				edit: {
					handler: sub_domain_edit_click
				}
			}
		}

		var qlist_settings = {
			prefix: 'mitb_domain_sub',
			source: source,
			cr_new_url: create_sub_url_domain,
			row_attr: [{name: 'id', selector: 'id'}],
			columns: [
				{selector: 'id', lang_key: $j.getInfo("id", flt_lang)},
				{selector: 'domain', lang_key: $j.getInfo("domain", flt_lang)}
			],
			menu_items: menu_items,
			default_columns: ['id', 'domain'],
			column_filters: {
				enabled: false
			},
			options: {
				popup: true,
				sliderwidth: 1000
			},
			handle_selection_change: sub_selection_changed,
		};

		var $container = $('#domain_sub_content');
		$container.qlist(qlist_settings);
	}

	function sub_selection_changed(qlist) {
		qlist_handle_selection_change(qlist);
		qmenu_enable_button($('#mi_new_' + qlist.prefix), enable_createnew, qlist);
		var aElems = qlist.get_checked_rows();
		var can_delete = aElems.length > 0;
		var one_select = aElems.length === 1;
		var enable_edit = false;
		if (aElems.length === 1)	
			enable_edit = qlist.can_edit_fn(qlist, aElems[0]);	
		if (typeof(enable_editdel) != undefined && window.enable_editdel != undefined)
		{
			qmenu_enable_button($('mi_edit_' + qlist.prefix), enable_editdel && one_select, qlist);
			qmenu_enable_button($('mi_del_' + qlist.prefix), enable_editdel && can_delete, qlist);
		}
	}

	function sub_param_edit_click(qlist, elems) {
		var mkey = qlist_get_row_attr(elems, 'name');
		if (mkey) {
			var edit_url = qlist_url_append_arg(edit_sub_url, "name", encodeURIComponent(mkey));
			if (qlist.popup) {
				var qlistSubSlide;
				qlistSubSlide = new top.Sliderin({ 
					title: '',  
					url: edit_url,  
					width: qlist.sliderwidth 
				}); 
				qlistSubSlide.open(); 
			} else {
				window.location.href = edit_url;
			}
		}
	}

	function sub_param_delete_click(qlist, elems) {
		var aElems = qlist.get_checked_rows();
		var del_url = del_sub_url;
		del_url = qlist_url_append_arg(del_url, "session_id", session_id);
		aElems.each(function() {
			del_url = qlist_url_append_arg(del_url, "name", encodeURIComponent(qlist_get_row_attr(this, 'name')));
		});
		$j.submitPOST(del_url);
	}

	function sub_domain_edit_click(qlist, elems) {
		var mkey = qlist_get_row_attr(elems, 'id');
		if (mkey) {
			var edit_url = qlist_url_append_arg(edit_sub_url_domain, "id", mkey);
			if (qlist.popup) {
				var qlistSubSlide;
				qlistSubSlide = new top.Sliderin({ 
					title: '',  
					url: edit_url,  
					width: qlist.sliderwidth 
				}); 
				qlistSubSlide.open(); 
			} else {
				window.location.href = edit_url;
			}
		}
	}

	function sub_domain_delete_click(qlist, elems) {
		var aElems = qlist.get_checked_rows();
		var del_url = del_sub_url_domain;
		del_url = qlist_url_append_arg(del_url, "session_id", session_id);
		aElems.each(function() {
			del_url = qlist_url_append_arg(del_url, "id", qlist_get_row_attr(this, 'id'));
		});
		$j.submitPOST(del_url);
	}

	return {configure: setup_qlist};

})(jQuery);
