var sub_module_list = (function($) {
	'use strict';

	var source;
	var type_lang = {
		'icmp' : 'ICMP',
		'tcp' : 'TCP',
		'http' : 'HTTP',
		'https' : 'HTTPS',
		'tcp-ssl' : 'TCP SSL',
		'tcp-half-open' : 'TCP Half Open'
	};
	var method_lang = {
		'get' : "GET",
		'head' : "HEAD",
		'post' : "POST"
	};
	var match_type_lang = {
		'response-code' : 'status',
		'match-content' : 'string',
		'all' : 'all'
	};

	function html_encode_format_fn(td, col, row_data){
		var type = row_data['type'];
		if(!(type == 'http' || type == 'https'))
			return '';
		var data = row_data[col.selector];
		return (data === '') ? data : escapeHTML(data);
	}

	function option_format_fn(td, col, row_data){
		var type = row_data['type'];
		var data = row_data[col.selector];
		var options_lang = null;
		if(col.selector == 'type')
			options_lang = type_lang;
		else if(col.selector == 'method')
		{
			if(!(type == 'http' || type == 'https'))
				return '';
			options_lang = method_lang;
		}
		else
			return '';

		return options_lang[data] ? options_lang[data] : '';
	}

	function match_type_format_fn(td, col, row_data){
		var type = row_data['type'];
		if(!(type == 'http' || type == 'https'))
			return '';
		var data = row_data[col.selector];
		
		var lang = match_type_lang[data] ? match_type_lang[data] : '';
		return (lang === '') ? lang : $.getInfo(lang,flt_lang);
	}
	function match_content_format_fn(td, col, row_data){
		var type = row_data['match-type'];
		if(!(type !== "response-code"))
			return '';
		var data = row_data[col.selector];
		
		return (data === '') ? data : escapeHTML(data);
	}
	function response_code_format_fn(td, col, row_data){
		var type = row_data['match-type'];
		if(!(type !== "match-content"))
			return '';
		var data = row_data[col.selector];

		//fix bug 534113 by lxj 
		if(row_data['type'] != "http" && default_flag){
			data = '';
		}
		return (data === '') ? data : escapeHTML(data);
	}	
	function setup_qlist()
	{
		if(table_key == '')
		{
			source = [];
			gen_qlist();
		}
		else
		{
			$.ajax({
				'url': '/cli-direct-action?mkey='+table_key+'&table_gid='+table_gid+'&child_gid='+child_gid+'&vdom='+vdom,
				'dataType': 'json',
				'success': function(response)
				{
					if(response.status == 1)
					{
						source = response.datas;
						gen_qlist();
					}
					else if(response.status == 0)
						error_handler(response.msg_id, "/prot/health_check/dlg?mkey=" + table_key+'&vdom='+vdom);
				},
				'cache': false
				});
		}
	}

	function gen_qlist(){
		if (!window.fgt_lang || !fgt_lang["global"])
			$j.addLang();
		var menu_items;
		if(is_rw_admin)
		{
			menu_items = {
				'edit': {
					'handler': sub_edit_click
				},
				'delete': {
					'handler': sub_delete_click
				},
			};
		}
		else
		{
			menu_items = {
				'edit': {
					'handler': sub_edit_click
				}
			};
		}
		
		var qlist_settings = {
			'prefix': 'prot_health_check_sub',
			'source': source,
			'cr_new_url': create_sub_url,
			'row_attr': [
				{name: 'id', selector: 'id'},
			],
			'columns': [
				{'selector': 'id', 'lang_key': $j.getInfo("id",flt_lang)},
				{'selector': 'type', 'lang_key': $j.getInfo("protocol",flt_lang)},
				{'selector': 'interval', 'lang_key': $j.getInfo("interval",flt_lang)},
				{'selector': 'timeout', 'lang_key': $j.getInfo("timeout",flt_lang)},
				{'selector': 'retry-times', 'lang_key': $j.getInfo("retry",flt_lang)},
				{'selector': 'url-path', 'lang_key': $j.getInfo("url",flt_lang)},
				{'selector': 'method', 'lang_key': $j.getInfo("http_method_type",flt_lang)},
				{'selector': 'match-type', 'lang_key': $j.getInfo("match_type",flt_lang)},
				{'selector': 'match-content', 'lang_key': $j.getInfo("http_match_expr",flt_lang)},
				{'selector': 'response-code', 'lang_key': $j.getInfo("code",flt_lang)}
			],
			'menu_items': menu_items,
			'default_columns':['id', 'type', 'interval', 'timeout', 'retry-times'],
			'column_filters': {
				'enabled': true,
				'exempts': ['type', 'interval', 'timeout', 'retry-times', 'match-type', 'match-content']
			},
			'options':{ 'popup': true},
			'handle_selection_change': sub_selection_changed,
			'format_fn': {
				'type': option_format_fn,
				'url-path': html_encode_format_fn,
				'method': option_format_fn,
				'host': html_encode_format_fn,
				'match-type': match_type_format_fn,
				'match-content': match_content_format_fn,
				'response-code': response_code_format_fn,
			}
                };

		var $container = $("#sub_content");
		$container.qlist(qlist_settings);

	}

	return {configure: setup_qlist};

})(jQuery);
