$j(function(){
    $j('<div id="progress_dialog_bot" style="display:none;"><div id="progressbar_bot"><div class="progress_label">0%</div></div></div>').appendTo($j('body'));
    $j('<div id="import_dialog_bot" style="display:none;"><form enctype="multipart/form-data" id="import_form_bot"><div><div class="label">'+$j.getInfo('import_file_bot')+'</div><div><input type="file" name="import_file_bot"></div></div><input type="hidden" name="type" value="1"><input type="hidden" name="id" id="import_id_bot" value=""></form></div>').appendTo($j('body'));
    $j('<div id="result_dialog_bot" style="display:none;"><div id="result_msg_bot" class="label"></div></div></div>').appendTo($j('body'));

    var progress_dialog = $j('#progress_dialog_bot').dialog({
        modal: true,
        width: 400,
        draggable: false,
        autoOpen: false,
        dialogClass: 'progress_dialog',
        buttons: []
    });

    var progressbar = $j('#progressbar_bot').progressbar({
        value: 0,
        change: function() {
            $j('.progress_label').text( progressbar.progressbar( "value" ) + "%" );
        },
    });

    var import_dialog = $j("#import_dialog_bot").dialog({
        title: $j.getInfo("import_dialog_bot"),
        modal: true,
        width: 600,
        draggable: false,
        autoOpen: false,
        dialogClass: 'import_dialog',
        buttons: [{
            text: $j.getInfo("import"),
            click: clickImportBot
        },{
            text: $j.getInfo("cancel"),
            click: clickCancelBot
        }]
    });

    var result_dialog = $j('#result_dialog_bot').dialog({
        modal: true,
        width: 400,
        draggable: false,
        autoOpen: false,
        dialogClass: 'result_dialog',
        buttons: [{
            text: $j.getInfo('ok'),
            click: function() {
                $j('#result_dialog_bot').dialog('close')
            }
        }]
    });

    function clickImportBot() {
        var options = {
            url: '/waf/ml_policy/import_data_bot',
            type: 'post',
            dataType: 'json',
            beforeSubmit: function(formData, jqForm, options){
                if(formData[0].value == "") {
                    alert($j.getInfo("err_import_file"));
                    return false;
                }
                else{
                    return true;
                }
            },
            success: function(responseText, statusText, xhr, $form){
                if(responseText.status == 1)
                {
                    $j('#progress_dialog_bot').dialog('open');
                    check_import_bot($j('#import_id_bot').val());
                }
                else if(responseText.status == 0)
                    error_handler(responseText.msg_id);

                $j("#import_dialog_bot").dialog('close');
            },
            error: function(responseText, error){
                alert($j.getInfo("err_import"));
                $j("#import_dialog_bot").dialog('close');
            }
        };
        $j("#import_form_bot").ajaxSubmit(options);
    }
    function clickCancelBot() {
        $j("#import_dialog_bot").dialog('close');
    }
})

function export_data_bot(id) {
    $j('#progress_dialog_bot').dialog('option', 'title', $j.getInfo('export_dialog_bot'));
    $j('#progressbar_bot').progressbar('value', 0);
    $j.ajax({
        'url': '/waf/ml_policy/export_data_bot?id='+id+'&type=1&session_id='+session_id,
        'dataType': 'json',
        'success': function(response)
        {
            if(response.status == 1)
            {
                $j('#progress_dialog_bot').dialog('open');
                check_export_bot(id);
            }
            else if(response.status == 0)
                error_handler(response.msg_id, '/prot/policy/dlg?mkey='+document.forms[0].mkey.value);
        },
        'cache': false
    });
}

function import_data_bot(id) {
    $j('#progress_dialog_bot').dialog('option', 'title', $j.getInfo('import_dialog_bot'));
    $j('#progressbar_bot').progressbar('value', 0);
    $j('#import_id_bot').val(id);
    $j("#import_dialog_bot").dialog('open');
}

function check_export_bot(id) {
    $j.ajax({
        'url': '/waf/ml_policy/export_query_bot?id='+id+'&type=1&session_id='+session_id,
        'dataType': 'json',
        'success': function(response)
        {
            if(response.status == 1)
            {
                // $j('.progress_label').text($j.getInfo('exporting')+' '+response.percent+'%');
                $j('#progressbar_bot').progressbar( 'value', response.percent );
                if(response.percent == 100 && response.filename) {
                    // $j('#progress_dialog').dialog( 'option', 'buttons', [{
                    //  text: $j.getInfo('close'),
                    //  click: function() {
                    //      $j('#progress_dialog').dialog('close')
                    //  }
                    // }]);
                    setTimeout(function() {
                        $j('#progress_dialog_bot').dialog('close');
                        $j('#result_msg_bot').text($j.getInfo('export_success_bot'));
                        $j('#result_dialog_bot').dialog('open');
                        var file = response.filename.split('/').pop();
                        document.location.href = '/waf/ml_policy/export_download?msg=62&session_id=' + session_id + '&name=' + file;
                    }, 500);
                    return;
                }
                setTimeout(function() {
                    check_export_bot(id);
                }, 200);
            }
            else if(response.status == 0)
                error_handler(response.msg_id, '/prot/policy/dlg?mkey='+document.forms[0].mkey.value);
        },
        'cache': false
    });
}

function check_import_bot(id) {
    $j.ajax({
        'url': '/waf/ml_policy/import_query_bot?id='+id+'&type=1&session_id='+session_id,
        'dataType': 'json',
        'success': function(response)
        {
            if(response.status == 1)
            {
                // $j('.progress_label').text($j.getInfo('importing')+' '+response.percent+'%');
                $j('#progressbar_bot').progressbar( 'value', response.percent );
                if(response.percent == 100) {
                    setTimeout(function() {
                        $j('#progress_dialog_bot').dialog('close');
                        $j('#result_msg_bot').text($j.getInfo('import_success_bot'));
                        $j('#result_dialog_bot').dialog('open');
                    }, 500);
                    // $j('#progress_dialog').dialog( 'option', 'buttons', [{
                    //  text: $j.getInfo('close'),
                    //  click: function() {
                    //      $j('#progress_dialog').dialog('close')
                    //  }
                    // }]);
                    return;
                }
                setTimeout(function() {
                    check_import_bot(id);
                }, 200);
            }
            else if(response.status == 0)
                error_handler(response.msg_id, '/prot/policy/dlg?mkey='+document.forms[0].mkey.value);
        },
        'cache': false
    });
}

