var sub_module_list = (function($) {
	'use strict';

	var source;


	function port_format_fn(td, col, row_data){
		if(row_data['mode'] != 'server'){
			return '';
		}else{
			return row_data[col.selector];
		}
	}

	function mac_format_fn(td, col, row_data){
		if(row_data['mode'] != 'switch'){
			return '';
		}else{
			return row_data[col.selector];
		}
	}

	function interface_format_fn(td, col, row_data){
		if(row_data['mode'] != 'server'){
			return row_data[col.selector];
		}else{
			return '';
		}
	}

	function mode_format_fn(td, col, row_data){
		var data = row_data[col.selector];
		return (data === "") ? data : $.getInfo(data,fgt_lang);
	}

	function setup_qlist()
	{
		if(table_key == '')
		{
			source = [];
			gen_qlist();
		}
		else
		{
			$.ajax({
				'url': '/cli-direct-action?mkey='+table_key+'&table_gid='+table_gid+'&child_gid='+child_gid+'&vdom='+vdom,
				'dataType': 'json',
				'success': function(response)
				{
					if(response.status == 1)
					{
						source = response.datas;
						gen_qlist();
					}
					else if(response.status == 0)
						error_handler(response.msg_id, "/prot/traffic_mirror/dlg?mkey=" + table_key+'&vdom='+vdom);
				},
				'cache': false
				});
		}
	}

	function gen_qlist(){
		if (!window.fgt_lang || !fgt_lang["global"])
			$.addLang();
		var menu_items;
		if(is_rw_admin)
		{
			menu_items = {
				'edit': {
					'handler': sub_edit_click
				},
				'delete': {
					'handler': sub_delete_click
				}
			};
		}
		else
		{
			menu_items = {
				'edit': {
					'handler': sub_edit_click
				}
			};
		}

		var qlist_settings = {
			'prefix': 'traffic_mirror_sub',
			'source': source,
			'cr_new_url': create_sub_url,
			'row_attr': [
				{name: 'id', selector: 'id'},
			],
			'columns': [
				{'selector': 'id', 'lang_key': $.getInfo("member_id",flt_lang)},
				{'selector': 'mode', 'lang_key': $.getInfo("member_mode",flt_lang)},
				{'selector': 'interface', 'lang_key': $.getInfo("member_interface",flt_lang)},
				{'selector': 'destination-mac', 'lang_key': $.getInfo("member_mac",flt_lang)},
				{'selector': 'server-ip', 'lang_key': $.getInfo("member_server_ip",flt_lang)},
				{'selector': 'server-port', 'lang_key': $.getInfo("member_server_port",flt_lang)},
			],
			'menu_items': menu_items,
			'default_columns':['id', 'mode', 'interface', 'destination-mac', 'server-ip', 'server-port'],
			'column_filters': {
				'enabled': false
			},
			'handle_selection_change': sub_selection_changed,
			'format_fn': {
				'mode': mode_format_fn,
				'server-port': port_format_fn,
				'server-ip': port_format_fn,
				'destination-mac': mac_format_fn,
				'interface': interface_format_fn,
			},
			'options': {
				'sorting': true,
				'popup': true,
				'sliderwidth': 1000,
				'sort_columns':{'id':true,'mode':true,'interface':true,'destination-mac':true,'server-ip':true,'server-port':true}
			},
                };

		var $container = $("#sub_content");
		$container.qlist(qlist_settings);

	}

	return {configure: setup_qlist};

})(jQuery);
