sub_module_list = (function($) {
        'use strict';

        var source;
	var columns, default_columns, exempts;

        function setup_qlist()
        {
                if(table_key == '')
                {
                        source = [];
			columns = [
			{'selector': 'id', 'lang_key': $j.getInfo("member_id",flt_lang)},
			{'selector': 'ip', 'lang_key': $j.getInfo("member_ip",flt_lang) + ' / ' + $j.getInfo("member_domain", flt_lang)},
			{'selector': 'status', 'lang_key': $j.getInfo("member_status",flt_lang)},
			{'selector': 'port', 'lang_key': $j.getInfo("member_port",flt_lang)},
		//	{'selector': 'http2', 'lang_key': $j.getInfo("member_http2",flt_lang)},
			{'selector': 'ssl', 'lang_key': $j.getInfo("member_ssl",flt_lang)},
			{'selector': 'conn-limit', 'lang_key': $j.getInfo("conn_limit",flt_lang)},
			{'selector': 'recover', 'lang_key': $j.getInfo("recover",flt_lang)},
			{'selector': 'warm-up', 'lang_key': $j.getInfo("warm_up",flt_lang)},
			{'selector': 'warm-rate', 'lang_key': $j.getInfo("warm_rate",flt_lang)}
			];
			if(is_http)
				columns.push({'selector': 'http2', 'lang_key': $j.getInfo("member_http2",flt_lang)});

			default_columns = ['id', 'ip', 'status', 'port']; //, 'http2', 'ssl', 'conn-limit'];
			if(is_http)
				default_columns.push('http2');
			default_columns.push('ssl');
			default_columns.push('conn-limit');

			exempts = ['id', 'status', 'port', 'http2', 'ssl', 'conn-limit', 'revocer', 'warm-up', 'warm-rate'];
                        gen_qlist();
                }
                else
                {
			if(mode == 'inline')
			{
				if(balance == true)
				{
					columns = [
					{'selector': 'id', 'lang_key': $j.getInfo("member_id",flt_lang)},
					{'selector': 'ip', 'lang_key': $j.getInfo("member_ip",flt_lang) + ' / ' + $j.getInfo("member_domain", flt_lang)},
					{'selector': 'status', 'lang_key': $j.getInfo("member_status",flt_lang)},
					{'selector': 'port', 'lang_key': $j.getInfo("member_port",flt_lang)},
			//		{'selector': 'http2', 'lang_key': $j.getInfo("member_http2",flt_lang)},
					{'selector': 'ssl', 'lang_key': $j.getInfo("member_ssl",flt_lang)},
					{'selector': 'conn-limit', 'lang_key': $j.getInfo("conn_limit",flt_lang)},
					{'selector': 'recover', 'lang_key': $j.getInfo("recover",flt_lang)},
					{'selector': 'warm-up', 'lang_key': $j.getInfo("warm_up",flt_lang)},
					{'selector': 'warm-rate', 'lang_key': $j.getInfo("warm_rate",flt_lang)},
					{'selector': 'backup-server', 'lang_key': $j.getInfo("member_backup",flt_lang)},
					{'selector': 'health', 'lang_key': $j.getInfo("member_health",flt_lang)},
					{'selector': 'health-check-inherit', 'lang_key': $j.getInfo("member_inherit_hlck",flt_lang)}
					];
					if(is_http)
						columns.push({'selector': 'http2', 'lang_key': $j.getInfo("member_http2",flt_lang)});
					default_columns = ['id', 'ip', 'status', 'port'] //, 'http2', 'health-check-inherit', 'health', 'backup-server', 'ssl'];
					if(is_http)
						default_columns.push('http2');
					default_columns.push('health-check-inherit');
					default_columns.push('health');
					default_columns.push('backup-server');
					default_columns.push('ssl');
					exempts = ['id', 'status', 'port', 'http2', 'health-check-inherit', 'backup-server', 'ssl', 'conn-limit', 'revocer', 'warm-up', 'warm-rate'];
				}
				else
				{
					columns = [
					{'selector': 'id', 'lang_key': $j.getInfo("member_id",flt_lang)},
					{'selector': 'ip', 'lang_key': $j.getInfo("member_ip",flt_lang) + ' / ' + $j.getInfo("member_domain", flt_lang)},
					{'selector': 'status', 'lang_key': $j.getInfo("member_status",flt_lang)},
					{'selector': 'port', 'lang_key': $j.getInfo("member_port",flt_lang)},
		//			{'selector': 'http2', 'lang_key': $j.getInfo("member_http2",flt_lang)},
					{'selector': 'ssl', 'lang_key': $j.getInfo("member_ssl",flt_lang)},
					{'selector': 'conn-limit', 'lang_key': $j.getInfo("conn_limit",flt_lang)},
					{'selector': 'recover', 'lang_key': $j.getInfo("recover",flt_lang)},
					{'selector': 'warm-up', 'lang_key': $j.getInfo("warm_up",flt_lang)},
					{'selector': 'warm-rate', 'lang_key': $j.getInfo("warm_rate",flt_lang)}
					];
					if(is_http)
						columns.push({'selector': 'http2', 'lang_key': $j.getInfo("member_http2",flt_lang)});
					default_columns = ['id', 'ip', 'status', 'port']; //, 'http2', 'ssl', 'conn-limit'];
					if(is_http)
						default_columns.push('http2');
					default_columns.push('ssl');
					default_columns.push('conn-limit');
					exempts = ['id', 'status', 'port', 'http2', 'ssl', 'conn-limit', 'revocer', 'warm-up', 'warm-rate'];
				}
			}
			else if(mode == 'tp')
			{
				columns = [
				{'selector': 'id', 'lang_key': $j.getInfo("member_id",flt_lang)},
				{'selector': 'ip', 'lang_key': $j.getInfo("member_ip",flt_lang) + ' / ' + $j.getInfo("member_domain", flt_lang)},
				{'selector': 'status', 'lang_key': $j.getInfo("member_status",flt_lang)},
				{'selector': 'port', 'lang_key': $j.getInfo("member_port",flt_lang)},
				{'selector': 'http2', 'lang_key': $j.getInfo("member_http2",flt_lang)},
				{'selector': 'ssl', 'lang_key': $j.getInfo("member_ssl",flt_lang)},
				{'selector': 'certificate', 'lang_key': $j.getInfo("member_cert",flt_lang)}
				];
				default_columns = ['id', 'ip', 'status', 'port', 'http2', 'ssl', 'certificate'];
				exempts = ['id', 'status', 'port', 'http2', 'ssl', 'certificate'];
			}
			else
			{
				columns = [
				{'selector': 'id', 'lang_key': $j.getInfo("member_id",flt_lang)},
				{'selector': 'ip', 'lang_key': $j.getInfo("member_ip",flt_lang) + ' / ' + $j.getInfo("member_domain", flt_lang)},
				{'selector': 'status', 'lang_key': $j.getInfo("member_status",flt_lang)},
				{'selector': 'port', 'lang_key': $j.getInfo("member_port",flt_lang)},
				{'selector': 'ssl', 'lang_key': $j.getInfo("member_ssl",flt_lang)},
				{'selector': 'certificate', 'lang_key': $j.getInfo("member_cert",flt_lang)}
				];
				default_columns = ['id', 'ip', 'status', 'port', 'ssl', 'certificate'];
				exempts = ['id', 'status', 'port', 'ssl', 'certificate'];
			}

                        $.ajax({
				'url': '/cli-direct-action?mkey='+table_key+'&table_gid='+table_gid+'&child_gid='+child_gid,
                                'dataType': 'json',
                                'success': function(response)
                                {
                                        if(response.status == 1)
                                        {
                                                source = response.datas;
                                                gen_qlist();
                                        }
                                        else if(response.status == 0)
                                                error_handler(response.msg_id, "/prot/server_pool/dlg?mkey=" + table_key);
                                },
                                'cache': false
                                });
                }
        }

	function lang_format_fn(td, col, row_data)
	{
		var data = row_data[col.selector];
		return (data === "") ? data : $j.getInfo(data,flt_lang);
	}

	function inherit_format_fn(td, col, row_data)
	{
		var data = row_data[col.selector];
		var key = '';
		if(data == 'enable')
			key = 'yes';
		else if(data == 'disable')
			key = 'no';

		return $j.getInfo(key, fgt_lang);
	}

	function ip_format_fn(td, col, row_data)
	{
		var data = row_data[col.selector];
		var type_str = 'server-type';
		var type = row_data[type_str];
		var domain = row_data['domain'];

		if(type == 'physical')
			return data;
		else if(type == 'domain')
			return escapeHTML(domain);
		else
			return '';
	}

	function gen_qlist(){
		if (!window.fgt_lang || !fgt_lang["global"])
			$j.addLang();
                var menu_items;
                if(is_rw_admin)
                {
                        menu_items = {
                                'edit': {
                                        'handler': sub_edit_click
                                },
                                'delete': {
                                        'handler': sub_delete_click
                                }
                        };
                }
                else
                {
                        menu_items = {
                                'edit': {
                                        'handler': sub_edit_click
                                }
                        };
                }

		var qlist_settings = {
                        'prefix': 'server_pool_sub',
                        'source': source,
                        'cr_new_url': create_sub_url,
                        'row_attr': [
                                {name: 'id', selector: 'id'},
                        ],
                        'columns': columns,
                        'menu_items': menu_items,
                        'default_columns': default_columns,
                        'column_filters': {
                                'enabled': true,
                                'exempts': exempts
                        },
                        'handle_selection_change': sub_selection_changed,
                        'options':{ 
                                'popup': true,
                                'sliderwidth':1000
                        },
			'format_fn': {
				'status': lang_format_fn,
				'ssl': lang_format_fn,
				'backup-server': lang_format_fn,
				'health-check-inherit': inherit_format_fn,
				'ip': ip_format_fn,
				'http2': lang_format_fn
			}
                };

                var $container = $("#sub_content");
                $container.qlist(qlist_settings);

        }

        return {configure: setup_qlist};

})(jQuery);
