var sub_module_list = (function($) {
	'use strict';

	var source;
	function lang_format_fn(td, col, row_data){
		var data = row_data[col.selector];
		if(row_data['server-type'] == 'ldap' && col.selector == 'rsa-securid')
			return '';
		return (data === "") ? data : $j.getInfo(data,flt_lang);
	}

	function server_format_fn(td, col, row_data){
		var type = row_data['server-type'];
		if((type == 'ldap' && col.selector == 'radius-server') 
			|| (type == 'radius' && col.selector == 'ldap-server'))
			return '';

		return row_data[col.selector];
	}

	function setup_qlist()
	{
		if(table_key == '')
		{
			source = [];
			gen_qlist();
		}
		else
		{
			$.ajax({
				'url': '/cli-direct-action?mkey='+table_key+'&table_gid='+table_gid+'&child_gid='+child_gid+'&vdom='+vdom,
				'dataType': 'json',
				'success': function(response)
				{
					if(response.status == 1)
					{
						source = response.datas;
						gen_qlist();
					}
					else if(response.status == 0)
						error_handler(response.msg_id, "/prot/site_publish_helper_asp/dlg?mkey=" + table_key+'&vdom='+vdom);
				},
				'cache': false
				});
		}
	}

	function gen_qlist(){
		if (!window.fgt_lang || !fgt_lang["global"])
			$j.addLang();
		var menu_items;
		if(is_rw_admin)
		{
			menu_items = {
				'edit': {
					'handler': sub_edit_click
				},
				'delete': {
					'handler': sub_delete_click
				},
				'mi_insert': {
					'id': 'mi_insert',
					'class': 'tool_sprite tool_insert',
					'handler': sub_insert_click,
					'label': qed_strtbl.insert
				},
				'mi_move': {
					'id': 'mi_move',
					'class': 'tool_sprite tool_move',
					'handler': sub_move_click,
					'label': qed_strtbl.move
				}
			};
		}
		else
		{
			menu_items = {
				'edit': {
					'handler': sub_edit_click
				}
			};
		}

		var qlist_settings = {
			'prefix': 'site_pub_pol_sub',
			'source': source,
			'cr_new_url': create_sub_url,
			'row_attr': [
				{name: 'id', selector: 'id'},
			],
			'options': {
				'popup': true,
				'sliderwidth': 1000
			},
			'columns': [
				{'selector': 'id', 'lang_key': $j.getInfo("member_id",flt_lang)},
				{'selector': 'server-type', 'lang_key': $j.getInfo("auth_vali_method",flt_lang)},
				{'selector': 'ldap-server', 'lang_key': $j.getInfo("ldap_server",flt_lang)},
				{'selector': 'radius-server', 'lang_key': $j.getInfo("radius_server",flt_lang)},
				{'selector': 'rsa-securid', 'lang_key': $j.getInfo("rsa_securid",flt_lang)},
			],
			'menu_items': menu_items,
			'default_columns':['id', 'server-type', 'ldap-server', 'radius-server', 'rsa-securid'],
			'column_filters': {
				'enabled': false
			},
			'handle_selection_change': sub_selection_changed,
			'format_fn': {
				'server-type': lang_format_fn,
				'ldap-server': server_format_fn,
				'radius-server': server_format_fn,
				'rsa-securid': lang_format_fn
			}
		};

		var $container = $("#sub_content");
		$container.qlist(qlist_settings);

	}

	return {configure: setup_qlist};

})(jQuery);
