var sub_module_list = (function($) {
        'use strict';

        var source;

        function html_encode_format_fn(td, col, row_data){
		var data = row_data[col.selector];
		return (data === '') ? data : escapeHTML(data);
	}

        function setup_qlist()
        {
                if(table_key == '')
                {
                        source = [];
                        gen_qlist();
                }
                else
                {
                        $.ajax({
                                'url': '/cli-direct-action?mkey='+table_key+'&table_gid='+table_gid+'&child_gid='+child_gid,
                                'dataType': 'json',
                                'success': function(response)
                                {
                                        if(response.status == 1)
                                        {
                                                source = response.datas;
                                                gen_qlist();
                                        }
                                        else if(response.status == 0)
                                                error_handler(response.msg_id, "/system/cert_sni_offline/dlg?mkey=" + table_key);
                                },
                                'cache': false
                                });
                }
        }
	function type_format_fn(td, col, row_data){
		var data = row_data[col.selector];
		return (data === "plain") ? $j.getInfo("simple",flt_lang) : $j.getInfo("regex",flt_lang);
	}

	function gen_qlist(){
		if (!window.fgt_lang || !fgt_lang["global"])
			$.addLang();
                var menu_items;
                if(is_rw_admin)
                {
                        menu_items = {
                                'edit': {
                                        'handler': sub_edit_click
                                },
                                'delete': {
                                        'handler': sub_delete_click
                                }
                        };
                }
                else
                {
                        menu_items = {
                                'edit': {
                                        'handler': sub_edit_click
                                }
                        };
                }

		var qlist_settings = {
                        'prefix': 'sni_cert_offline_sub',
                        'source': source,
                        'cr_new_url': create_sub_url,
                        'row_attr': [
                                {name: 'id', selector: 'id'},
                        ],
                        'columns': [
                                {'selector': 'id', 'lang_key': $j.getInfo("member_id",flt_lang)},
                                {'selector': 'domain', 'lang_key': $j.getInfo("member_domain",flt_lang)},
                                {'selector': 'domain-type', 'lang_key': $j.getInfo("member_domain_type",flt_lang)},
                                {'selector': 'local-cert', 'lang_key': $j.getInfo("member_lcert",flt_lang)}
                        ],
                        'menu_items': menu_items,
                        'default_columns':['id', 'domain', 'domain-type','local-cert'],
                        'column_filters': {
                                'enabled': true,
                                'exempts': ['id']
                        },
                        'handle_selection_change': sub_selection_changed,
                        'format_fn': {
				'domain': html_encode_format_fn,
				'domain-type': type_format_fn
			}
                };

                var $container = $("#sub_content");
                $container.qlist(qlist_settings);

        }

        return {configure: setup_qlist};

})(jQuery);
