var sub_module_list = (function($) {
	'use strict';

	var source;

	function setup_qlist()
	{
		if(table_key == '')
		{
			source = [];
			gen_qlist();
		}
		else
		{
			$.ajax({
				'url': '/cli-direct-action?mkey='+table_key+'&table_gid='+table_gid+'&child_gid='+child_gid,
				'dataType': 'json',
				'success': function(response)
				{
					if(response.status == 1)
					{
						source = response.datas;
						gen_qlist();
					}
					else if(response.status == 0)
						error_handler(response.msg_id, "/system/global/advanced");
				},
				'cache': false
			});
		}
	}

	function type_format_fn(td, col, row_data){

		var type = row_data['field-type_val'];
		var html = ((type == 1)? $j.getInfo("cookie",flt_lang) : $j.getInfo("parameter",flt_lang));
		
		return html;
	}

	function html_encode_format_fn(td, col, row_data){
		var data = row_data[col.selector];
		return (data === '') ? data : escapeHTML(data);
	}

	function gen_qlist(){
		if (!window.fgt_lang || !fgt_lang["global"])
			$j.addLang();
		var menu_items;
		if(is_rw_admin)
		{
			menu_items = {
				'edit': {
					'handler': sub_edit_click
				},
				'delete': {
					'handler': sub_delete_click
				}
			};
		}
		else
		{
			menu_items = {
				'edit': {
					'handler': sub_edit_click
				}
			};
		}

		var qlist_settings = {
			'prefix': 'decoding_enhance_sub',
			'source': source,
			'cr_new_url': create_sub_url,
			'row_attr': [
			{name: 'id', selector: 'id'},
			],
			'columns': [
			{'selector': 'id', 'lang_key': $j.getInfo("id",flt_lang)},
			{'selector': 'field-type', 'lang_key': $j.getInfo("field_type",flt_lang)},
			{'selector': 'field-name', 'lang_key': $j.getInfo("field_name",flt_lang)},
			],
			'format_fn': {
				'field-type': type_format_fn,
				'field-name': html_encode_format_fn
			},
			'menu_items': menu_items,
			'default_columns':['id', 'field-type', 'field-name'],
			'column_filters': {
				'enabled': false
			},
			'handle_selection_change': sub_selection_changed,
		};

		var $container = $("#sub_content");
		$container.qlist(qlist_settings);

	}

	return {configure: setup_qlist};

})(jQuery);
