var sub_module_list = (function($) {
	'use strict';

	var source;
	var OP_MODE_TP = (1<<0);
	var OP_MODE_TI = (1<<3);

	function lang_format_fn(td, col, row_data){
		var data = row_data[col.selector];
		return (data === "") ? data : $j.getInfo(data,flt_lang);
	}

	function setup_qlist()
	{
		$.ajax({
			'url': '/system/firewall/policy/sub_list/json',
			'dataType': 'json',
			'success': function(response)
			{
				if(response.status == 1)
				{
					source = response.datas;
					gen_qlist();
				}
				else if(response.status == 0)
					error_handler(response.msg_id, "/system/firewall/policy/dlg");
			},
			'cache': false
		});
	}

	function gen_qlist(){
		if (!window.fgt_lang || !fgt_lang["global"])
			$j.addLang();
		var menu_items;
		if(is_rw_admin)
		{
			menu_items = {
				'edit': {
					'handler': sub_edit_click
				},
				'delete': {
					'handler': sub_delete_click
				},
				'mi_insert': {
					'id': 'mi_insert',
					'class': 'tool_sprite tool_insert',
					'handler': sub_insert_click,
					'label': qed_strtbl.insert
				},
				'mi_move': {
					'id': 'mi_move',
					'class': 'tool_sprite tool_move',
					'handler': sub_move_click,
					'label': qed_strtbl.move
				}
			};
		}
		else
		{
			menu_items = {
				'edit': {
					'handler': sub_edit_click
				}
			};
		}

		var qlist_settings = {
			'prefix': 'geo_except_sub',
			'source': source,
			'cr_new_url': create_sub_url,
			'row_attr': [
				{name: 'id', selector: 'id'},
			],
			'menu_items': menu_items,
			'column_filters': {
				'enabled': false
			},
			'format_fn': {
				'action': lang_format_fn,
			},
			'handle_selection_change': sub_selection_changed
        };
        
        if(op_mode == OP_MODE_TP || op_mode == OP_MODE_TI) {
			qlist_settings.columns = [
				{'selector': 'id', 'lang_key': $j.getInfo("id",flt_lang)},
				{'selector': 'vzone', 'lang_key': "V-zone"},
				{'selector': 'in-interface', 'lang_key': $j.getInfo("in_interface",flt_lang)},
				{'selector': 'out-interface', 'lang_key': $j.getInfo("out_interface",flt_lang)},
				{'selector': 'src-address', 'lang_key': $j.getInfo("source",flt_lang)},
				{'selector': 'dest-address', 'lang_key': $j.getInfo("destination",flt_lang)},
				{'selector': 'service', 'lang_key': $j.getInfo("service",flt_lang)},
				{'selector': 'action', 'lang_key': $j.getInfo("action",flt_lang)}
			];
			qlist_settings.default_columns=['id', 'vzone', 'in-interface', 'out-interface', 'src-address', 'dest-address', 'service', 'action'];
		}else{
			qlist_settings.columns = [
				{'selector': 'id', 'lang_key': $j.getInfo("id",flt_lang)},
				{'selector': 'in-interface', 'lang_key': $j.getInfo("in_interface",flt_lang)},
				{'selector': 'out-interface', 'lang_key': $j.getInfo("out_interface",flt_lang)},
				{'selector': 'src-address', 'lang_key': $j.getInfo("source",flt_lang)},
				{'selector': 'dest-address', 'lang_key': $j.getInfo("destination",flt_lang)},
				{'selector': 'service', 'lang_key': $j.getInfo("service",flt_lang)},
				{'selector': 'action', 'lang_key': $j.getInfo("action",flt_lang)}
			];
			qlist_settings.default_columns=['id', 'in-interface', 'out-interface', 'src-address', 'dest-address', 'service', 'action'];		
		}

		var $container = $("#sub_content");
		$container.qlist(qlist_settings);
		$("#table_dlg").show();

	}

	return {configure: setup_qlist};

})(jQuery);

