var sub_module_list = (function($) {
	'use strict';

	var source;

	var method_lang = {
                'get' : "GET",
                'head' : "HEAD",
                'post' : "POST"
        };
        var match_type_lang = {
                'response-code' : 'status',
                'match-content' : 'string',
                'all' : 'all'
        };

	function html_encode_format_fn(td, col, row_data){
                var data = row_data[col.selector];
                return (data === '') ? data : escapeHTML(data);
        }

	function match_type_format_fn(td, col, row_data){
                var data = row_data[col.selector];

                var lang = match_type_lang[data] ? match_type_lang[data] : '';
                return (lang === '') ? lang : $.getInfo(lang,flt_lang);
        }

	function option_format_fn(td, col, row_data){
                var data = row_data[col.selector];
		var lang = method_lang[data] ? method_lang[data] : '';
		return (lang === '') ? lang : $.getInfo(lang, flt_lang);
        }

	function setup_qlist()
	{
		if(table_key == '')
		{
			source = [];
			gen_qlist();
		}
		else
		{
			$.ajax({
				'url': '/cli-direct-action?mkey='+table_key+'&table_gid='+table_gid+'&child_gid='+child_gid+'&vdom='+vdom,
				'dataType': 'json',
				'success': function(response)
				{
					if(response.status == 1)
					{
						source = response.datas;
						gen_qlist();
					}
					else if(response.status == 0)
						error_handler(response.msg_id, "/system/ha_phlck/dlg?mkey=" + table_key+'&vdom='+vdom);
				},
				'cache': false
				});
		}
	}

	function gen_qlist(){
		if (!window.fgt_lang || !fgt_lang["global"])
			$j.addLang();
		var menu_items;
		if(is_rw_admin)
		{
			menu_items = {
				'edit': {
					'handler': sub_edit_click
				},
				'delete': {
					'handler': sub_delete_click
				},
			};
		}
		else
		{
			menu_items = {
				'edit': {
					'handler': sub_edit_click
				}
			};
		}

		var qlist_settings = {
			'prefix': 'ha_phlck_sub',
			'source': source,
			'cr_new_url': create_sub_url,
			'row_attr': [
				{name: 'id', selector: 'id'},
			],
			'options': {
				'popup': true,
				'sliderwidth': 1000
			},
			'columns': [
				{'selector': 'id', 'lang_key': $j.getInfo("id",flt_lang)},
				{'selector': 'interval', 'lang_key': $j.getInfo("interval",flt_lang)},
				{'selector': 'timeout', 'lang_key': $j.getInfo("timeout",flt_lang)},
				{'selector': 'retry-times', 'lang_key': $j.getInfo("retry",flt_lang)},
				{'selector': 'url-path', 'lang_key': $j.getInfo("url",flt_lang)},
				{'selector': 'method', 'lang_key': $j.getInfo("http_method_type",flt_lang)},
				{'selector': 'match-type', 'lang_key': $j.getInfo("match_type",flt_lang)},
				{'selector': 'response-code', 'lang_key': $j.getInfo("code", flt_lang)},
				{'selector': 'match-content', 'lang_key': $j.getInfo("http_match_expr",flt_lang)}
			],
			'menu_items': menu_items,
			'default_columns':['id', 'url-path', 'interval', 'timeout', 'retry-times', 'method', 'match-content'],
			'column_filters': {
				'enabled': false
			},
			'handle_selection_change': sub_selection_changed,
			'format_fn': {
                                'url-path': html_encode_format_fn,
                                'method': option_format_fn,
                                'match-type': match_type_format_fn,
                                'match-content': html_encode_format_fn,
                        }
		};

		var $container = $("#sub_content");
		$container.qlist(qlist_settings);

	}

	return {configure: setup_qlist};

})(jQuery);
