var sub_module_list = (function($) {
	'use strict';

	var source;
	var obj_lang = {
		'http-host' : "http_host",
		'http-url' : "http_url",
		'http-reference' : "http_ref",
		'http-body' : "http_body",
		'http-location' : "http_location"
	};

	function obj_format_fn(td, col, row_data){
		var data = row_data['object'];
		var lang = obj_lang[data] ? obj_lang[data] : '';
		return (lang === '') ? lang : $j.getInfo(lang,flt_lang);
	}

	function filter_format_fn(td, col, row_data){
		var data = row_data['protocol-filter'];
		return (data === '') ? data : $j.getInfo(data,fgt_lang);
	}

	function protocol_format_fn(td, col, row_data){
		if(!parseInt(row_data['protocol-filter_val']))
			return '';
		var data = row_data['HTTP-protocol'];
		return (data === '') ? data : $j.getInfo(data,flt_lang);
	}

	function html_encode_format_fn(td, col, row_data){
		var data = row_data[col.selector];
		return (data === '') ? data : escapeHTML(data);
	}

	function setup_qlist()
	{
		if(table_key == '')
		{
			source = [];
			gen_qlist();
		}
		else
		{
			$.ajax({
				'url': '/cli-direct-action?mkey='+table_key+'&table_gid='+table_gid+'&child_gid='+child_gid+'&vdom='+vdom,
				'dataType': 'json',
				'success': function(response)
				{
					if(response.status == 1)
					{
						source = response.datas;
						gen_qlist();
					}
					else if(response.status == 0)
						error_handler(response.msg_id, "/waf/url_rewrite_rule/dlg?mkey=" + table_key+'&vdom='+vdom);
				},
				'cache': false
				});
		}
	}

	function gen_qlist(){
		if (!window.fgt_lang || !fgt_lang["global"])
			$j.addLang();
		var menu_items;
		var action_type;
		if(source)


		if(is_rw_admin)
		{
			menu_items = {
				'edit': {
					'handler': sub_edit_click
				},
				'delete': {
					'handler': sub_delete_click
				}
			};
		}
		else
		{
			menu_items = {
				'edit': {
					'handler': sub_edit_click
				}
			};
		}

		var qlist_settings = {
			'prefix': 'url_rewrite_rule_sub',
			'source': source,
			'cr_new_url': create_sub_url,
			'row_attr': [
				{name: 'id', selector: 'id'},
			],
            'options':{ 
            	'popup': true,
            	'sliderwidth':1000
        	},
			'columns': [
				{'selector': 'id', 'lang_key': $j.getInfo("member_id",flt_lang)},
				{'selector': 'object', 'lang_key': $j.getInfo("member_obj",flt_lang)},
				{'selector': 'reg-exp', 'lang_key': $j.getInfo("member_reg",flt_lang)},
				{'selector': 'protocol-filter', 'lang_key': $j.getInfo("protocol_filter",flt_lang)},
				{'selector': 'HTTP-protocol', 'lang_key': $j.getInfo("protocol",flt_lang)},
			],
			'menu_items': menu_items,
			'default_columns':['id', 'object', 'reg-exp', 'protocol-filter', 'HTTP-protocol'],
			'column_filters': {
				'enabled': false
			},
			'handle_selection_change': sub_selection_changed,
			'format_fn': {
				'object': obj_format_fn,
				'protocol-filter': filter_format_fn,
				'HTTP-protocol': protocol_format_fn,
				'reg-exp': html_encode_format_fn
			}
                };

		var $container = $("#sub_content");
		$container.qlist(qlist_settings);

	}

	return {configure: setup_qlist};

})(jQuery);
