var sub_module_list = (function($) {
	'use strict';

	function lang_format_fn(td, col, row_data){
		var data = row_data[col.selector];
		return (data === "") ? data : $j.getInfo(data,flt_lang);
	}
	function vip_format_fn(td, col, row_data){
		var type = row_data["use_intfip"];
		return (type === "enable") ? row_data.interface+"("+row_data["intf-ip4"]+","+row_data["intf-ip6"]+")" : row_data.vip+"("+row_data["vip-ip4"]+","+row_data["vip-ip6"]+")";
	}

	var source;

	function setup_qlist()
	{
		if(table_key == '')
		{
			source = [];
			gen_qlist();
		}
		else
		{
			$.ajax({
				//'url': '/cli-direct-action?mkey='+table_key+'&table_gid='+table_gid+'&child_gid='+child_gid,
				'url':'/prot/vserver/sub_list/json?mkey='+table_key,
				'dataType': 'json',
				'success': function(response)
				{
					if(response.status == 1)
					{
						source = response.datas;
						gen_qlist();
					}
					else if(response.status == 0)
						error_handler(response.msg_id, "/prot/vserver/dlg?mkey=" + table_key);
				},
				'cache': false
				});
		}
	}

	function gen_qlist(){
		if (!window.fgt_lang || !fgt_lang["global"])
			$j.addLang();
		var menu_items;
		if(is_rw_admin)
		{
			menu_items = {
				'edit': {
					'handler': sub_edit_click
				},
				'delete': {
					'handler': sub_delete_click
				}
			};
		}
		else
		{
			menu_items = {
				'edit': {
					'handler': sub_edit_click
				}
			};
		}

		var qlist_settings = {
			'prefix': 'vserver_sub',
			'source': source,
			'cr_new_url': create_sub_url,
			'row_attr': [
				{name: 'id', selector: 'id'},
			],
			'columns': [
				{'selector': 'id', 'lang_key': $j.getInfo("member_id",flt_lang)},
				{'selector': 'use_intfip', 'lang_key': $j.getInfo("use_intfip",flt_lang)},
				{'selector': 'vip', 'lang_key': $j.getInfo("interface",flt_lang)+"/"+$j.getInfo("vip",flt_lang)},
				{'selector': 'status', 'lang_key': $j.getInfo("member_status",flt_lang)},
			],
			'menu_items': menu_items,
			'default_columns':['id', 'use_intfip', 'vip', 'status'],
			'column_filters': {
				'enabled': false
			},
			'handle_selection_change': sub_selection_changed,
			'format_fn': {
				'vip': vip_format_fn,
				'use_intfip': lang_format_fn,
				'status': lang_format_fn
			}
        };

		var $container = $("#sub_content");
		$container.qlist(qlist_settings);

	}

	return {configure: setup_qlist};

})(jQuery);
