var sub_module_list = (function($) {
	'use strict';

	var source;

	function setup_qlist()
	{
		if(table_key == '')
		{
			source = [];
			gen_qlist();
		}
		else
		{
			$.ajax({
				'url': '/cli-direct-action?mkey='+table_key+'&table_gid='+table_gid+'&child_gid='+child_gid,
				'dataType': 'json',
				'success': function(response)
				{
					if(response.status == 1)
					{
						source = response.datas;
						gen_qlist();
					}
					else if(response.status == 0)
						error_handler(response.msg_id, "/wad/filter/dlg?mkey=" + table_key);
				},
				'cache': false
				});
		}
	}

	function file_type_format_fn($td, col, row_data)
	{
		var val = row_data['file-type_val'];
		var type = '';
		if(val == 0)
			type = 'dir';
		else
			type = 'file';

		return $j.getInfo(type, flt_lang);
	}

	function gen_qlist(){
		if (!window.fgt_lang || !fgt_lang["global"])
			$j.addLang();
		var menu_items;
		if(is_rw_admin)
		{
			menu_items = {
				'edit': {
					'handler': sub_edit_click
				},
				'delete': {
					'handler': sub_delete_click
				}
			};
		}
		else
		{
			menu_items = {
				'edit': {
					'handler': sub_edit_click
				}
			};
		}

		var qlist_settings = {
			'prefix': 'wad_filter_sub',
			'source': source,
			'cr_new_url': create_sub_url,
            'options':{ 
            	'popup': true,
            	'sliderwidth':1000
        	},
			'row_attr': [
				{name: 'id', selector: 'id'},
			],
			'columns': [
				{'selector': 'id', 'lang_key': $j.getInfo("member_id",flt_lang)},
				{'selector': 'file-name', 'lang_key': $j.getInfo("member_name",flt_lang)},
				{'selector': 'file-type', 'lang_key': $j.getInfo("member_type",flt_lang)},
			],
			'menu_items': menu_items,
			'default_columns':['id', 'file-name', 'file-type'],
			'column_filters': {
				'enabled': true,
				'exempts':['id', 'file-type']
			},
			'handle_selection_change': sub_selection_changed,
			'format_fn': {
				'file-type': file_type_format_fn,
			}
        };

		var $container = $("#sub_content");
		$container.qlist(qlist_settings);

	}

	return {configure: setup_qlist};

})(jQuery);
