var sub_module_list = (function($) {
	'use strict';

	var source,source1, source2;

	function method_format_fn(td, col, row_data){
		var data = row_data[col.selector];
		return data.toUpperCase();
	}
	function status_format_fn(td, col, row_data){
		var data = row_data[col.selector];
		return data.replace(data[0],data[0].toUpperCase());
	}	
	function sub_create_click(qlist, elems)
	{
		var create_sub_url = "";
		if(qlist.prefix == "url_prefixes")
		{
			create_sub_url = create_url_prefixes_sub_url;
		}else{
			create_sub_url = create_url_setting_sub_url;
		}
		if(qlist.popup){
			var qlistSubSlide;
			qlistSubSlide = new top.Sliderin({ 
				title: '',  
				url: create_sub_url,  
				width: qlist.sliderwidth 
			}); 
			qlistSubSlide.open(); 
		}else{
			window.location.href = create_sub_url;
		}
	}
	// default sub list edit click function
	function sub_edit_click(qlist, elems)
	{
	    var mkey = qlist_get_row_attr(elems, 'id');
		var edit_url = "";
		if(qlist.prefix == "url_prefixes")
		{
			edit_url = edit_url_prefixes_sub_url;
		}else{
			edit_url = edit_url_setting_sub_url;
		}	       

	       if(mkey){
			edit_url = qlist_url_append_arg(edit_url, "id", mkey);
	               if(qlist.popup){
				var qlistSubSlide;
				qlistSubSlide = new top.Sliderin({ 
					title: '',  
					url: edit_url,  
					width: qlist.sliderwidth 
				}); 
				qlistSubSlide.open(); 
			}else{
				window.location.href = edit_url;		}
	       }
	}
	// default sub list delete click function
	function sub_delete_click(qlist, elems)
	{
	       var aElems = qlist.get_checked_rows();

	       var del_url = "";

			if(qlist.prefix == "url_prefixes")
			{
				del_url = del_url_prefixes_sub_url;
			}else{
				del_url = del_url_setting_sub_url;
			}	
			del_url = qlist_url_append_arg(del_url, "session_id", session_id);
	       aElems.each(function() {
			del_url = qlist_url_append_arg(del_url, "id", qlist_get_row_attr(this, 'id'));       });
	       $j.submitPOST(del_url);
	}
	function sub_move_click(qlist, elems)
	{
		var aElems = qlist.get_checked_rows();
		if(aElems.length != 1)	return;
		var url = "";
		if(qlist.prefix == "url_prefixes")
		{
			url = moveto_url_prefixes_sub_url;
		}else{
			url = moveto_url_setting_sub_url;
		}	
		url = qlist_url_append_arg(url, "item_id", aElems[0].getAttribute("id"));
		url = qlist_url_append_arg(url, "redir", "/success");
		wij_display_modal_dlg(url, {'width': 450, 'height': 180});
	}

	function sub_insert_click(qlist, elems)
	{ 
		var aElems = qlist.get_checked_rows();
		if(aElems.length != 1)	return;
		var url = "";
		if(qlist.prefix == "url_prefixes")
		{
			url = create_url_prefixes_sub_url;
		}else{
			url = create_url_setting_sub_url;
		}
		url = qlist_url_append_arg(url, "orderid", aElems[0].getAttribute("id"));
		url = qlist_url_append_redir(url);
		if(qlist.popup){
			var qlistSubSlide;
			qlistSubSlide = new top.Sliderin({ 
				title: '',  
				url: url,  
				width: qlist.sliderwidth 
			}); 
			qlistSubSlide.open(); 
		}else{
			window.location.href = url;
		}
	}
	function setup_qlist()
	{
		if(table_key == '')
		{
			source = [];
			source1 = [];
			gen_qlist();
		}
		else
		{
			$.ajax({
				'url': '/waf/api_rule/sub_list_json?mkey='+table_key+'&vdom='+vdom,
				'dataType': 'json',
				'success': function(response)
				{
					if(response.status == 1)
					{
						source = response.url_prefix;
						source1 = response.sub_url;
						gen_qlist();
					}
					else if(response.status == 0)
						error_handler(response.msg_id, "/waf/api_rule/dlg?mkey=" + table_key+'&vdom='+vdom);
				},
				'cache': false
				});
		}
	}

	function gen_qlist(){
		if (!window.fgt_lang || !fgt_lang["global"])
			$j.addLang();

		var menu_items;
                if(is_rw_admin)
                {
                        menu_items = {
                        		'create_new': {
										'handler': sub_create_click
								},
                                'edit': {
                                        'handler': sub_edit_click
                                },
                                'delete': {
                                        'handler': sub_delete_click
                                },
								'mi_insert': {
									'id': 'mi_insert',
									'class': 'tool_sprite tool_insert',
									'handler': sub_insert_click,
									'label': qed_strtbl.insert
								},
								'mi_move': {
									'id': 'mi_move',
									'class': 'tool_sprite tool_move',
									'handler': sub_move_click,
									'label': qed_strtbl.move
								}
                        };

                }
                else
                {
                        menu_items = {
                                'edit': {
                                        'handler': sub_edit_click
                                }
                        };
                }

		var qlist_settings = {
			'prefix': 'url_prefixes',
			'source': source,
            'options':{ 
            	'popup': true,
            	'sliderwidth':1000
        	},
			'row_attr': [
				{name: 'id', selector: 'id'},
			],
			'columns': [
				{'selector': 'id', 'lang_key': $j.getInfo("id",flt_lang)},
				{'selector': 'frontend_prefix', 'lang_key': $j.getInfo("frontend_prefix",flt_lang)},
				{'selector': 'backend_prefix', 'lang_key': $j.getInfo("backend_prefix",flt_lang)}
			],
			'menu_items': menu_items,
			'default_columns':['id', 'frontend_prefix', 'backend_prefix'],
			'column_filters': {
				'enabled': true,
				'exempts': ['id']
			},
			'handle_selection_change': sub_selection_changed			
        };

		var qlist_settings1 = {
			'prefix': 'url_setting',
			'source': source1,
            'options':{ 
            	'popup': true,
            	'sliderwidth':1000
        	},
			'row_attr': [
				{name: 'id', selector: 'id'},
			],
			'columns': [
				{'selector': 'id', 'lang_key': $j.getInfo("id",flt_lang)},
				{'selector': 'http_method', 'lang_key': $j.getInfo("http_method",flt_lang)},
				{'selector': 'url_expression', 'lang_key': $j.getInfo("url_expression",flt_lang)},
				{'selector': 'api_key_verify', 'lang_key': $j.getInfo('api_key_verification', flt_lang)}
			],
			'menu_items': menu_items,
			'default_columns':['id', 'http_method', 'url_expression', 'api_key_verify'],
			'column_filters': {
				'enabled': true,
				'exempts': ['id']
			},
			'handle_selection_change': sub_selection_changed,
			'format_fn': {
				'http_method':method_format_fn,
				'api_key_verify':status_format_fn
			}
        };
		var $container = $("#sub_content_0");		
		var $container1 = $("#sub_content_1");

		$container.qlist(qlist_settings);
		$container1.qlist(qlist_settings1);

	}

	return {configure: setup_qlist};

})(jQuery);

	var max_entry = 16;
    // add attach_header
    $j(".attach_header_new").click(function() {
        var last = $j("#attach_header_list");
        last = last.clone().appendTo(last.parent());
        $j("input", last).val("");
        // handle when it is cloned from a validated row
        $j("label.error", last).remove();
        $j("input", last).removeClass('error required valid');
        // handle when it is cloned from a disable row
        $j("input", last).enable(true);
        if ($j("div#attach_header_list").length > 1) {
            $j(".attach_header_remove").show();
        }
        if ($j("div#attach_header_list").length >= max_entry) {
            $j(".attach_header_new").hide();
        }
        //$j.ui_dependencies();
    });

    // delete attach_header, always keep at least one
    $j("#div_attach_header_list").delegate('.attach_header_remove', "click", function() {
        if ($j("div#attach_header_list").length > 1) {
        	if($j(this).closest("#attach_header_list").find(':input[name=attach_header]')[0].value != "")
        	{
        		document.forms[0].attach_header_change.value=2;
        		var old_id = document.forms[0].attach_header_del_id.value;
        		var del_id = $j(this).closest("#attach_header_list").find(':input[name=attach_header_id]')[0].value;
        		if(del_id !== '0')
        		{
        			if(old_id === '0')
        			{
        				document.forms[0].attach_header_del_id.value = del_id;
        			}else{
        				document.forms[0].attach_header_del_id.value += "," + del_id;
        			}
        		}

        	}
            $j(this).closest("#attach_header_list").remove();
            if ($j("div#attach_header_list").length == 1) {
                $j(".attach_header_remove").hide();
            }
            if ($j("div#attach_header_list").length < max_entry) {
                $j(".attach_header_new").show();
            }
        }
        //$j.ui_dependencies();
    });
function attach_header_check()
{
    //if($j(".attach_header_new")[0].style.display == 'none') return true; 
    var form = document.forms[0];
    
    var attach_header_change = form.attach_header_change;// 1:add 2:del
    if(attach_header_change.value == 0) return true;

    var attach_header = form.attach_header;
    var len = $j("input[name='attach_header']").length;
    var err_blank = $j.getInfo('attach_http_header')+$j.getInfo('err_blank');
    var err_char = $j.getInfo('err_char',fgt_lang);

    /* only one use this */
    if(len == 1) {
        if(!checkname(attach_header, err_blank, err_char)) return false;
        return true;
    }

    var i = 0;
    for(i=0; i < len; i++)
    {
    	if(!checkname(attach_header[i], err_blank, err_char)) return false;
    }
    
    return true;
}