var sub_module_list = (function($) {
	'use strict';

	var source;
	
	function lang_format_fn(td, col, row_data){
                var data = row_data[col.selector];
                return (data === "") ? data : $j.getInfo(data,fgt_lang);
        }
	
	function setup_qlist()
	{
		if(table_key == '')
		{
			source = [];
			gen_qlist();
		}
		else
		{
			$.ajax({
				'url': '/cli-direct-action?mkey='+table_key+'&table_gid='+table_gid+'&child_gid='+child_gid,
				'dataType': 'json',
				'success': function(response)
				{
					if(response.status == 1)
					{
						source = response.datas;
						gen_qlist();
					}
					else if(response.status == 0)
						error_handler(response.msg_id, "/waf/bot_client_rule/dlg?mkey=" + table_key);
				},
				'cache': false
				});
		}
	}
	function gen_qlist(){
		if (!window.fgt_lang || !fgt_lang["global"])
			$j.addLang();
		var menu_items;
		if(is_rw_admin)
		{
			menu_items = {
				'edit': {
					'handler': sub_edit_click
				},
				'delete': {
					'handler': sub_delete_click
				}
			};
		}
		else
		{
			menu_items = {
				'edit': {
					'handler': sub_edit_click
				}
			};
		}
		var qlist_settings = {
			'prefix': 'waf_bot_client_rule_sub',
			'source': source,
			'cr_new_url': create_sub_url,
			'options':{
				'popup': true,
				'sliderwidth':1000
			},
			'row_attr': [
				{name: 'id', selector: 'id'},
			],
			'columns': [
				{'selector': 'id', 'lang_key': $j.getInfo("member_id",fgt_lang)},
				{'selector': 'host-status', 'lang_key': $j.getInfo("member_host_status",flt_lang)},
				{'selector': 'host', 'lang_key': $j.getInfo("member_host", flt_lang)},
				{'selector': 'type', 'lang_key': $j.getInfo("member_type", flt_lang)},
				{'selector': 'url', 'lang_key': $j.getInfo("member_url", flt_lang)},
			],
			'menu_items': menu_items,
			'handle_selection_change': sub_selection_changed,
			'default_columns':['id', 'host-status', 'host', 'type', 'url'],
			'column_filters': {
				'enabled': true,
				'exempts':['id']
			},
			'format_fn': {
				'host-status': lang_format_fn,
				'type': lang_format_fn
			}
        };

		var $container = $("#sub_content");
		$container.qlist(qlist_settings);
	}
	return {configure: setup_qlist};

})(jQuery);
