var sub_module_list = (function($) {
	'use strict';

	var source;
	
	function setup_qlist()
	{
		if(table_key == '')
		{
			source = [];
			gen_qlist();
		}
		else
		{
			$j.ajax({
				'url': '/cli-direct-action?mkey='+table_key+'&table_gid='+table_gid+'&child_gid='+child_gid+'&vdom='+vdom,
				'dataType': 'json',
				'success': function(response)
				{
					if(response.status == 1)
					{
						source = response.datas;
						gen_qlist();
					}
					else if(response.status == 0)
						error_handler(response.msg_id, "/waf/brute_force_login/dlg?mkey=" + table_key + '&vdom=' + vdom);
				},
				'cache': false
			});
		}
	}

	function request_format_fn($td, col, row_data)
	{
		var request = row_data[col.selector];
		return escapeHTML(request);
	}

	function type_format_fn($td, col, row_data)
	{
		var str = '';
		var type = row_data[col.selector];

		if(type == "disable")
		{
			str = $j.getInfo("ip", flt_lang);
		}
		else
		{
			str = $j.getInfo("ip_port", flt_lang);
		}
		return str;
	}

	function gen_qlist()
	{
		if(!window.fgt_lang || !fgt_lang["global"])
			$j.addLang();

		var menu_items = {};
		
		if(is_rw_admin)
		{
			menu_items = {
				'edit': {
					'handler': sub_edit_click
				},
				'delete': {
					'handler': sub_delete_click
				},
			};
		}
		else
		{
			menu_items = {
				'edit': {
					'handler': sub_edit_click
				}
			};
		}
		if(docker_check){
			var columns = [
				{'selector': 'id', 'lang_key': $j.getInfo("id",flt_lang)},
				{'selector': 'host', 'lang_key': $j.getInfo("host",flt_lang)},
				{'selector': 'ip-port-enable', 'lang_key': $j.getInfo("type", flt_lang)},
				{'selector': 'request-file', 'lang_key': $j.getInfo("request", flt_lang)},				
				{'selector': 'access-limit-standalone-ip', 'lang_key': $j.getInfo("access_limit_standalone", flt_lang)},				
				{'selector': 'block-period', 'lang_key': $j.getInfo("block_period", flt_lang)},				
			];
			var default_columns = ['id', 'host', 'ip-port-enable', 'request-file', 'access-limit-standalone-ip', 'block-period'];
			var exempts = ['id', 'ip-port-enable', 'access-limit-standalone-ip', 'block-period'];
		}else{
			var columns = [
				{'selector': 'id', 'lang_key': $j.getInfo("id",flt_lang)},
				{'selector': 'host', 'lang_key': $j.getInfo("host",flt_lang)},
				{'selector': 'ip-port-enable', 'lang_key': $j.getInfo("type", flt_lang)},
				{'selector': 'request-file', 'lang_key': $j.getInfo("request", flt_lang)},				
				{'selector': 'access-limit-standalone-ip', 'lang_key': $j.getInfo("access_limit_standalone", flt_lang)},				
				{'selector': 'access-limit-share-ip', 'lang_key': $j.getInfo("access_limit_share", flt_lang)},				
				{'selector': 'block-period', 'lang_key': $j.getInfo("block_period", flt_lang)},				
			];
			var default_columns = ['id', 'host', 'ip-port-enable', 'request-file', 'access-limit-standalone-ip', 'access-limit-share-ip', 'block-period'];
			var exempts = ['id', 'ip-port-enable', 'access-limit-standalone-ip', 'access-limit-share-ip', 'block-period'];
		}
		
		
		var qlist_settings = {
			'prefix': 'brute_force_sub',
			'source': source,
			'cr_new_url': create_sub_url,
			'cr_edit_url': edit_sub_url,
            'options':{ 
            	'popup': true,
            	'sliderwidth':1000
        	},
			'row_attr': [
				{name: 'id', selector: 'id'},
			],
			'columns': columns,
			'menu_items': menu_items,
			'default_columns':default_columns,
			'column_filters': {
				'enabled': true,
				'exempts': exempts
			},
			'handle_selection_change': sub_selection_changed,
			'format_fn': {
				'request-file': request_format_fn,
				'ip-port-enable': type_format_fn
			}
		};

		var $container = $("#sub_content");
		$container.qlist(qlist_settings);
	}

	return {configure: setup_qlist};
})(jQuery);
