var sub_module_list = (function($) {
	'use strict';

	function lang_format_fn(td, col, row_data){
                var data = row_data[col.selector];
                return (data === "") ? data : $j.getInfo(data,fgt_lang);
        }

        function type_format_fn(td, col, row_data)
        {
        	if(col.selector == 'parameter-value-type' && row_data['parameter-filter'] != 'enable')
			return '';
                var data = row_data[col.selector];
                return (data === "plain") ? $.getInfo('simple', flt_lang) : $.getInfo('regex', flt_lang);
        }

        function file_format_fn(td, col, row_data)
        {
        	if(col.selector == 'parameter-value' && row_data['parameter-filter'] != 'enable')
			return '';
                var data = row_data[col.selector];
                return escapeHTML(data);
        }

	function param_name_format_fn(td, col, row_data)
	{
		if(row_data['parameter-filter'] != 'enable')
			return '';
		var data = row_data[col.selector];
		return data;
	}

	function setup_qlist()
	{
		if (!window.fgt_lang || !fgt_lang["global"])
			$j.addLang();

		if(table_key == '')
		{
			var source = [];
			gen_url_qlist(source);
			gen_page_qlist(source);
		}
		else
		{
			$.ajax({
				'url': '/waf/csrf/sub_list/json?mkey='+table_key+'&vdom='+vdom,
				'dataType': 'json',
				'success': function(response)
				{
					if(response.status == 1)
					{
						// url list
						gen_url_qlist(response.url_list);
						// page list
						gen_page_qlist(response.page_list);
					}
					else if(response.status == 0)
						error_handler(response.msg_id, "/waf/csrf/dlg?mkey=" + table_key + "&vdom=" + vdom);
				},
				'cache': false
				});
		}
	}

	function gen_url_qlist(source){
		var menu_items;
		if(is_rw_admin)
		{
			menu_items = {
				'edit': {
					'handler': sub_edit_click
				},
				'delete': {
					'handler': sub_delete_click
				}
			};
		}
		else
		{
			menu_items = {
				'edit': {
					'handler': sub_edit_click
				}
			};
		}

		var qlist_settings = {
			'prefix': 'csrf_url_sub',
			'source': source,
			'cr_new_url': create_sub_url,
			'row_attr': [
				{name: 'id', selector: 'id'},
			],
			'columns': [
				{'selector': 'id', 'lang_key': $j.getInfo("member_id",flt_lang)},
				{'selector': 'host', 'lang_key': $j.getInfo("member_host",flt_lang)},
				{'selector': 'host-status', 'lang_key': $j.getInfo("member_host_status",flt_lang)},
				{'selector': 'request-type', 'lang_key': $j.getInfo("member_url_type", flt_lang)},
				{'selector': 'request-url', 'lang_key': $j.getInfo("member_url", flt_lang)},
				{'selector': 'parameter-filter', 'lang_key': $j.getInfo("param_filter",flt_lang)},
				{'selector': 'parameter-name', 'lang_key': $j.getInfo("param_name",flt_lang)},
				{'selector': 'parameter-value-type', 'lang_key': $j.getInfo("param_type",flt_lang)},
				{'selector': 'parameter-value', 'lang_key': $j.getInfo("param_value",flt_lang)}
			],
			'menu_items': menu_items,
			'default_columns':['id', 'host-status', 'host', 'request-type', 'request-url', 'parameter-filter'],
			'column_filters': {
				'enabled': false
			},
			'options': {
				'popup': true,
				'sliderwidth':1000
			},
			'handle_selection_change': sub_selection_changed,
			'format_fn': {
                                'host-status': lang_format_fn,
                                'request-type': type_format_fn,
                                'request-url': file_format_fn,
                                'parameter-filter': lang_format_fn,
                                'parameter-value-type': type_format_fn,
                                'parameter-value': file_format_fn,
                                'parameter-name': param_name_format_fn
                        }
                };

		var $container = $("#url_sub_content");
		$container.qlist(qlist_settings);

	}

	function sub_page_selection_changed(qlist)
	{
		qlist_handle_selection_change(qlist);
		qmenu_enable_button($('#mi_new_' + qlist.prefix), enable_createnew, qlist);
		var aElems = qlist.get_checked_rows();
		var can_delete = aElems.length > 0;
		var one_select = aElems.length === 1;
		var enable_edit = false;
		if(aElems.length === 1)	enable_edit = qlist.can_edit_fn(qlist, aElems[0]);	if(typeof(enable_editdel) != undefined && window.enable_editdel != undefined)
		{
			qmenu_enable_button($('mi_edit_' + qlist.prefix), enable_editdel && one_select, qlist);
			qmenu_enable_button($('mi_del_' + qlist.prefix), enable_editdel && can_delete, qlist);
		}
	}

	function sub_page_delete_click(qlist, elems)
	{
		var aElems = qlist.get_checked_rows();
		var del_url = del_page_sub_url;
		del_url = qlist_url_append_arg(del_url, "session_id", session_id);
		aElems.each(function() {
				del_url = qlist_url_append_arg(del_url, "id", qlist_get_row_attr(this, 'id'));       });
		$j.submitPOST(del_url);
	}

	/*function sub_page_edit_click(qlist, elems)
	{
		var mkey = qlist_get_row_attr(elems, 'id');
		if(mkey){
			edit_page_sub_url = qlist_url_append_arg(edit_page_sub_url, "id", mkey);
			window.location.href = edit_page_sub_url;
		}
	}*/

	function sub_page_edit_click(qlist, elems)
	{
		var mkey = qlist_get_row_attr(elems, 'id');
		if(mkey){
			var edit_url = qlist_url_append_arg(edit_page_sub_url, "id", mkey);
			if(qlist.popup){
				var qlistSubSlide;
				qlistSubSlide = new top.Sliderin({ 
					title: '',  
					url: edit_url,  
					width: qlist.sliderwidth 
				}); 
				qlistSubSlide.open(); 
			}else{
				window.location.href = edit_page_sub_url;
			}
		}
	}

	function gen_page_qlist(source){
                var menu_items;
                if(is_rw_admin)
                {
                        menu_items = {
                                'edit': {
                                        'handler': sub_page_edit_click
                                },
                                'delete': {
                                        'handler': sub_page_delete_click
                                }
                        };
                }
                else
                {
                        menu_items = {
                                'edit': {
                                        'handler': sub_page_edit_click
                                }
                        };
                }

                var qlist_settings = {
                        'prefix': 'csrf_page_sub',
                        'source': source,
                        'cr_new_url': create_page_sub_url,
                        'row_attr': [
                                {name: 'id', selector: 'id'},
                        ],
                        'columns': [
                                {'selector': 'id', 'lang_key': $j.getInfo("member_id",flt_lang)},
                                {'selector': 'host', 'lang_key': $j.getInfo("member_host",flt_lang)},
                                {'selector': 'host-status', 'lang_key': $j.getInfo("member_host_status",flt_lang)},
                                {'selector': 'request-type', 'lang_key': $j.getInfo("member_url_type", flt_lang)},
                                {'selector': 'request-url', 'lang_key': $j.getInfo("member_url", flt_lang)},
                                {'selector': 'parameter-filter', 'lang_key': $j.getInfo("param_filter",flt_lang)},
				{'selector': 'parameter-name', 'lang_key': $j.getInfo("param_name",flt_lang)},
				{'selector': 'parameter-value-type', 'lang_key': $j.getInfo("param_type",flt_lang)},
				{'selector': 'parameter-value', 'lang_key': $j.getInfo("param_value",flt_lang)}
                        ],
                        'menu_items': menu_items,
                        'default_columns':['id', 'host-status', 'host', 'request-type', 'request-url', 'parameter-filter'],
                        'column_filters': {
                                'enabled': false
                        },
                        'options': {
                                'popup': true,
                                'sliderwidth':1000
                        },
			'handle_selection_change': sub_page_selection_changed,
                        'format_fn': {
                                'host-status': lang_format_fn,
                                'request-type': type_format_fn,
                                'request-url': file_format_fn,
                                'parameter-filter': lang_format_fn,
                                'parameter-value-type': type_format_fn,
                                'parameter-value': file_format_fn,
                                'parameter-name': param_name_format_fn
                        }
                };

                var $container = $("#page_sub_content");
                $container.qlist(qlist_settings);

        }

	return {configure: setup_qlist};

})(jQuery);
