var sub_module_list = (function($) {
	'use strict';

	var source;
	var operator_lang = {
		'RE': 'oper_exp',
		'GT': 'oper_great',
		'LT': 'oper_less',
		'NE': 'oper_ne',
		'EQ': 'oper_equal',
	};

	function case_format_fn(td, col, row_data){
		var data = row_data[col.selector];
		var operator_val = row_data['operator_val'];
		return (operator_val === '1' && data !== '') ? $j.getInfo(data,fgt_lang) : "";
	}

	function operator_format_fn(td, col, row_data){
		var data = row_data[col.selector];
		var lang = operator_lang[data] ? operator_lang[data] : '';
		return (lang === '') ? lang : $j.getInfo(lang,flt_lang);
	}

	function target_format_fn(td, col, row_data){
		var target = '';
		if('request-target' in row_data)
			target += row_data['request-target'];
		target += '';
		if('response-target' in row_data)
			target += row_data['response-target'];
		return target;
	}

	function html_encode_format_fn(td, col, row_data){
		var data = row_data[col.selector];        
                var operator_val = row_data['operator_val'];
                return (operator_val === '1' && data !== '') ? escapeHTML(data) : '';
	}

	function threshold_format_fn(td, col, row_data){
		var data = row_data[col.selector];
		var operator_val = row_data['operator_val'];
		return (operator_val !== '1' && data !== '') ? data : '';
	}

	function setup_qlist()
	{
		if(table_key == '')
		{
			source = [];
			gen_qlist();
		}
		else
		{
			$.ajax({
				'url': '/cli-direct-action?mkey='+table_key+'&table_gid='+table_gid+'&child_gid='+child_gid,
				'dataType': 'json',
				'success': function(response)
				{
					if(response.status == 1)
					{
						source = response.datas;
						gen_qlist();
					}
					else if(response.status == 0)
						error_handler(response.msg_id, "/waf/custom_signature/dlg?mkey=" + table_key);
				},
				'cache': false
				});
		}
	}

	function gen_qlist(){
		if (!window.fgt_lang || !fgt_lang["global"])
			$j.addLang();
		var menu_items;
		if(is_rw_admin)
		{
			menu_items = {
				'edit': {
					'handler': sub_edit_click
				},
				'delete': {
					'handler': sub_delete_click
				}
			};
		}
		else
		{
			menu_items = {
				'edit': {
					'handler': sub_edit_click
				}
			};
		}

		var qlist_settings = {
			'prefix': 'waf_cus_sig_sub',
			'source': source,
			'cr_new_url': create_sub_url,
			'row_attr': [
				{name: 'id', selector: 'id'},
			],
			'columns': [
				{'selector': 'id', 'lang_key': $j.getInfo("member_id",flt_lang)},
				{'selector': 'operator', 'lang_key': $j.getInfo("member_oper",flt_lang)},
				{'selector': 'target', 'lang_key': $j.getInfo("targets",flt_lang)},
				{'selector': 'case-sensitive', 'lang_key': $j.getInfo("member_case",flt_lang)},
				{'selector': 'expression', 'lang_key': $j.getInfo("member_expression",flt_lang)},
				{'selector': 'threshold', 'lang_key': $j.getInfo("member_threshold",flt_lang)},
			],
			'menu_items': menu_items,
			'default_columns':['id', 'operator', 'target', 'case-sensitive', 'expression', 'threshold'],
			'column_filters': {
				'enabled': false
			},
			'options': {
				'popup': true,
				'sliderwidth':1000
			},
			'handle_selection_change': sub_selection_changed,
			'format_fn': {
				'operator': operator_format_fn,
				'target': target_format_fn,
				'case-sensitive': case_format_fn,
				'expression': html_encode_format_fn,
				'threshold': threshold_format_fn
			}
                };

		var $container = $("#sub_content");
		$container.qlist(qlist_settings);

	}

	return {configure: setup_qlist};

})(jQuery);
