var sub_module_list = (function($) {
	'use strict';

	var source1, source2;
	var qlistSubSlide;    
	
	function color_format_fn(td, col, row_data)
	{
		var color_code = row_data["color"];
		var color;
		switch(color_code)
		{
			case 1:
				color = "#0000ff";
				break;
			case 2:
				color = "#000000";
				break;	
			case 3:
      				color = "#ff0000";
				break;
  			default:
				break;				

		}
		return '<span class="tip" title="" style="color:' + color + ';"' + '>'+ row_data[col.selector] + '</span>';		
	}
	function status_format_fn(td, col, row_data)
	{
		var check_status = parseInt(row_data[col.selector]);
		return '<div><input type="checkbox" name="status" id="status_"'+ row_data["id"] + 
			(check_status ?'checked':'') + '/></div>';
	}
	function content_loaded()
	{
		var title = '<div class="tooltip-item">' + $j.getInfo("tooltip_1", flt_lang) + "</div><br/>";
		title += '<div class="tooltip-item">' + $j.getInfo("tooltip_2", flt_lang) + "</div><br/>";
		title += '<div class="tooltip-item">' + $j.getInfo("tooltip_3", flt_lang) + "</div>";

		$(".tip").tooltip({
			content: title,
			position: {
				my: "left top",
				at: "right top"
			},
			tooltipClass: "tooltip-box"
		});
	}
	function fetch_url_action()
	{
		var pserverData = [];

		var createFetchTable = function(pserverData){
			var template;
			var i = 0;
			var selectOpt = '<select name="pserver" id="pserver">';

			for(i=0; i<pserverData.length; i++)
			{
				selectOpt += '<option value="' + pserverData[i].ip + '">' + pserverData[i].ip + '</option>';
			}
			selectOpt += '</select>';
			
			template = '<div class="content">' +
				   '<div class="field"><label>' + $j.getInfo("pserver", flt_lang) + 
				   '</label><div>' + selectOpt + '</div></div>' +
				   '<div class="field"><label>' + $j.getInfo("port", flt_lang) + '</label>' + 
				   '<div><input type="text" name="port" value="80" size="20"></div>' + 
				   '</div>' + 
				   '<div class="field"><label>' +$j.getInfo("protocol", flt_lang) + 
				   '</label><div class="radio-group"><input type="radio" id="protocol_http" name="protocol" value="0" checked>' + 
				   '<label for="protocol_http">' + $j.getInfo("http", flt_lang) + 
				   '</label>' + 
				   '<input type="radio" id="protocol_https" name="protocol" value="1"><label for="protocol_https">' + 
				   $j.getInfo("https", flt_lang) + '</label></div></div>' + 
				   '</div>';

			$("#fetch_config_table").empty().append(template).show();
			$("#fetch_table_1").hide();
			$("#fetch_table_2").hide();
			createFetchDialog();
		};

		var getFetchTableParameter = function(){
			var qlist_row1 = $("#post_url_table_list-qlist").find(".qlist_row");
			var qlist_row2 = $("#hidden_field_table_list-qlist").find(".qlist_row");
			var P={};

			if($(qlist_row1[0]).find(".empty_row").length == 0){
				for(var i=0; i<qlist_row1.length; i++)
				{
					if(qlist_row1[i].childNodes[2].firstElementChild.childNodes[0].checked == true)
					{
						var obj = new Object();
						obj["P" + i] = qlist_row1[i].childNodes[1].firstElementChild.innerHTML;
						$.extend(P, obj)
					}
				}
			}
			if($(qlist_row2[0]).find(".empty_row").length == 0){
				var j = 0;
				for(var i=0; i<qlist_row2.length; i++)
				{
					if(qlist_row2[i].childNodes[2].firstElementChild.childNodes[0].checked == true)
					{
						var obj = new Object();
						obj["H" + j] = qlist_row2[i].childNodes[1].firstElementChild.innerHTML;
						$.extend(P, obj);
						j++;
					}
				}
			}
			return P;
		};

		var fetchFormCheck = function(){
			var req_url = document.getElementsByName("req_url")[0].value;
			var port = document.getElementsByName("port")[0];
			var pserver = document.getElementById("pserver").value;
			if(req_url == "")
			{
				alert($j.getInfo("err_req_url", flt_lang));
				return false;
			}
			if(port.value == "")
			{
				alert($j.getInfo("err_port_input", flt_lang));
				return false;
			}
			if(checknumber(port, 1, 65535, $j.getInfo("err_port_input", flt_lang), $j.getInfo("port_limit", flt_lang)) == false)
			{
				return false;
			}
			if(pserver == "")
			{
				alert($j.getInfo("err_pserver", flt_lang));
				return false;
			}

			return true;
		};

		var createFetchDialog = function(){
			var fetchButtons = new Array();
			if(is_rw_admin)
			{
				fetchButtons =[{
					text: $j.getInfo("ok", fgt_lang),
					click: function(){
					    if($("#fetch_table_1").is(":visible") || $("#fetch_table_2").is(":visible")){
						var P = getFetchTableParameter();
						$.ajax({
							'url': '/waf/hidf_fetch_ci',
							'type': 'post',
							'data': $.extend({main_name: table_key, session_id: session_id, vdom: vdom}, P),
							'success': function(result){
								$("#fetch_url_dialog").dialog('close');
								document.location.href = "/waf/hidden_rule/dlg?mkey="+table_key+"&vdom=" + vdom;
							},
							'error': function(){
								alert("Send request failed.");
								$("#fetch_url_dialog").dialog('close');
							}
						});
					    }
					    else{
						if(fetchFormCheck() === true)
						{
						    $.ajax({
							'url': '/waf/hidf_fetch',
							'type': 'get',
							'data': {
								req_file: document.getElementsByName("req_url")[0].value, 
								port: document.getElementsByName("port")[0].value, 
								main_name: table_key, 
								pserver: document.getElementById("pserver").value,
								host: document.getElementById("pserver").value,
								flag: document.getElementById("protocol_http").checked == true ? 0 : 1,
								vdom: vdom
							},
							'success': function(result){
								$("#fetch_config_table").hide();
								$("#fetch_table_1").show();
								$("#fetch_table_2").show();
								createFetchURLTableList(result);
								$("#fetch_url_dialog").dialog('open');
							},
							'error': function(){
								alert("Fetch URL failed. Please check the network connection.");
							}
						   });
						}
					   }
					} 
				},{
					text: $j.getInfo("cancel", fgt_lang),
					click: function(){
						$("#fetch_url_dialog").dialog('close');
					}
				}]; 
			}
			else 
			{
				fetchButtons = [{
					text: $j.getInfo("return", fgt_lang),
					click: function(){
						$("#fetch_url_dialog").dialog('close');
					}
				}];
			}

			$("#fetch_url_dialog").dialog({
				modal: false,
				width: 550,
				autoOpen: false,
				buttons: fetchButtons
			});
			$("#fetch_url_dialog").dialog('open');
		};

		var createFetchURLTableList = function (Data)
		{
			var qlist_settings1 = {
				'prefix': 'post_url_table_list',
				'source': Data.post_url_table,
				'row_attr': [
				{name: 'key', selector: 'id'}
				],
				'columns': [
				{'selector': 'id', 'lang_key': $j.getInfo("id", flt_lang)},
				{'selector': 'post_url', 'lang_key': $j.getInfo("post_url", flt_lang)},
				{'selector': 'status', 'lang_key': $j.getInfo("status", flt_lang)},
				],
				'options':{
					'ref_column': false,
					'sorting': false,
					'hide_default_buttons': true,
					'hide_menu': true,
					'fixed_header': false,
	            	'popup': true,
	            	'sliderwidth':1000
				},
				'format_fn': {
					'id': color_format_fn,
					'post_url': color_format_fn,
					'status': status_format_fn
				},
				'callbacks': {
					'load': content_loaded
				}
			};
			
			var qlist_settings2 = {
				'prefix': 'hidden_field_table_list',
				'source': Data.hidden_field_table,
				'row_attr': [
				{name: 'key', selector: 'id'}
				],
				'columns': [
				{'selector': 'id', 'lang_key': $j.getInfo("id", flt_lang)},
				{'selector': 'hidden_field', 'lang_key': $j.getInfo("hidden_fields_name", flt_lang)},
				{'selector': 'status', 'lang_key': $j.getInfo("status", flt_lang)},
				],
				'options':{
					'ref_column': false,
					'sorting': false,
					'hide_default_buttons': true,
					'hide_menu': true,
					'fixed_header': false,
	            	'popup': true,
	            	'sliderwidth':1000
				},
				'format_fn': {
					'id': color_format_fn,
					'hidden_field': color_format_fn,
					'status': status_format_fn
				},
				'callbacks': {
					'load': content_loaded
				}
			};
			$('#fetch_table_1').qlist(qlist_settings1);
			$('#fetch_table_2').qlist(qlist_settings2);
		};
		
		$.ajax({
			'url': '/waf/hidden_rule/pserver/json?vdom=' + vdom,
			'dataType': 'json',
			'success': function(data)
			{
				pserverData = data;
				createFetchTable(pserverData);
			},
			'cache': false
		});
	}

	function sub_edit_click(qlist, elems)
	{
		var type;
		var sub_id = qlist_get_row_attr(elems, 'id');
		var sub_name = qlist_get_row_attr(elems, 'mkey');
		if(qlist.prefix == "hidden_rule_sub_1")
		{
			type = "edit_sub1";
			if(sub_name){
				show_url_dialog(sub_name, sub_id, type);
			}
			return;
		}
		else if(qlist.prefix == "hidden_rule_sub_2")
		{
			type = "edit_sub2";
			if(sub_name){
				show_name_dialog(sub_name, sub_id, type);
			}
			return;
		}
	}

	function sub_create_click(qlist, elems)
	{
		var type;
		if(qlist.prefix == "hidden_rule_sub_1")
		{
			type = "create_sub1";
			show_url_dialog("", "", type);
			return;
		}
		else if(qlist.prefix == "hidden_rule_sub_2")
		{
			type = "create_sub2";
			show_name_dialog("", "", type);
			return;
		}
	}

	function sub_delete_click(qlist, elems)
	{
		var type;
		var url;

		if(qlist.prefix == "hidden_rule_sub_1")
		{
			var url = "/waf/hidden_rule/table1del";
			var len = elems.length;

			type = "delete_sub1";
			url = qlist_url_append_arg(url, "main_name", table_key);
			url = qlist_url_append_arg(url, "session_id", session_id);
			url = qlist_url_append_arg(url, "type", type);
			url = qlist_url_append_arg(url, "vdom", vdom);

			for (var i = 0; i < len; i++) {
				var id = elems[i].getAttribute("id");
				url = qlist_url_append_arg(url, "sub_id", id);
			}
			url = qlist_url_append_redir(url);
			$j.submitPOST(url);
		}
		else if(qlist.prefix == "hidden_rule_sub_2")
		{
			var aElems = qlist.get_checked_rows();
			var del_url = del_sub_url;
			del_url = qlist_url_append_arg(del_url, "session_id", session_id);
			del_url = qlist_url_append_arg(del_url, "vdom", vdom);

			aElems.each(function() {
				del_url = qlist_url_append_arg(del_url, "id", qlist_get_row_attr(this, 'id'));
			});
			$j.submitPOST(del_url);
		}

	}

	function init_dialog(sub_name, sub_id, type, url)
	{
		var subTableButtons = new Array();
		if(is_rw_admin)
		{
			subTableButtons = [{
				text: $j.getInfo("ok", fgt_lang),
				click: function(){
					$.ajax({
						'url': url,
						'type': 'post',
						'data': {
							main_name: table_key, 
							type: type, 
							sub_name: top.Sliderin._active.length > 0?top.Sliderin._active[top.Sliderin._active.length-1]._$body.find('#sub_name').val():'',//document.getElementById("sub_name").value, 
							sub_id: sub_id,
							session_id: session_id,
							vdom: vdom
						},
						'success': function(result){
							top.Sliderin.closeLast();
							//$("#table_dialog").dialog('close');
							document.location.href = "/waf/hidden_rule/dlg?mkey="+table_key+"&vdom=" + vdom;
						},
						'error': function(result){
							//$("#table_dialog").dialog('close');
							top.Sliderin.closeLast();
							var err_url = "/error?msg=-"+result.responseText.replace(/[^0-9]/ig,"");
							document.location.href = err_url
						}
					});
				} 
			},{
				text: $j.getInfo("cancel", fgt_lang),
				click: function(){
					top.Sliderin.closeLast();
					//$("#table_dialog").dialog('close');
				}
			}];
		}
		else 
		{
			subTableButtons = [{
				text: $j.getInfo("return", fgt_lang),
				click: function(){
					top.Sliderin.closeLast();
					//$("#table_dialog").dialog('close');
				}
			}];
		}
		/*
		$("#table_dialog").dialog({
			modal: false,
		    	width: 550,
		    	autoOpen: false,
				buttons: subTableButtons[0]
		});
		*/
		//$("#table_dialog").dialog('open');

		if(qlistSubSlide)
		{

			qlistSubSlide.close();
		}
		qlistSubSlide = new top.Sliderin({ 
			title: '',  
			content: $("#table_dialog").html(),  
			width: 600,
			buttons : true,
			okButton : is_rw_admin?true:false,
			cancelButtonLabel : is_rw_admin?$j.getInfo("cancel", fgt_lang):$j.getInfo("return", fgt_lang),
			okButtonClick : subTableButtons[0].click,
			okButtonLabel : $j.getInfo("ok", fgt_lang)
		}); 
		qlistSubSlide.open(); 
	}
	function show_url_dialog(sub_name, sub_id, type)
	{
	
		var template = '<div class="content">' + 
			       '<div class="field"><label> ' + $j.getInfo("post_url") + ' </label>' + 
			       '<input name="sub_name" id="sub_name" value="'+ sub_name +'"></div>'
		               '</div>';	
		var url = "/waf/hidden_rule/table1add";
		
		//$("#table_dialog").empty().append(template).show();
		$("#table_dialog").empty().append(template);
		init_dialog(sub_name, sub_id, type, url);
	}

	function show_name_dialog(sub_name, sub_id, type)
	{
		var template = '<div class="content">' + 
			       '<div class="field"><label> ' + $j.getInfo("hidden_fields_name") + ' </label>' + 
			       '<input name="sub_name" id="sub_name" value="'+ sub_name +'"></div>'
		               '</div>';	
		var url = "/waf/hidden_rule/table2add";
		
		//$("#table_dialog").empty().append(template).show();
		$("#table_dialog").empty().append(template);
		init_dialog(sub_name, sub_id, type, url);

	}

	function setup_qlist()
	{
		if(table_key == '')
		{
			source1 = [];
			source2 = [];
			gen_qlist();
		}
		else
		{
			$.ajax({
				'url': '/waf/hidden_rule/sub_list/json?mkey='+table_key+'&vdom='+vdom,
				'dataType': 'json',
				'success': function(response)
				{
					if(response.status == 1)
					{
						source1 = response.urlTable;
						source2 = response.hostTable;
						gen_qlist();
					}
					else if(response.status == 0)
						error_handler(response.msg_id, "/waf/hidden_rule/dlg?mkey=" + table_key+'&vdom='+vdom);
				},
				'cache': false
				});
		}
	}

	function gen_qlist(){
		if (!window.fgt_lang || !fgt_lang["global"])
			$j.addLang();
		var menu_items;
		if(is_rw_admin)
		{
			menu_items = {
				'create_new': {
					handler: sub_create_click
				},
				'edit': {
					'handler': sub_edit_click
				},
				'delete': {
					'handler': sub_delete_click
				},
			};
		}
		else
		{
			menu_items = {
				'edit': {
					'handler': sub_edit_click
				}
			};
		}
		
		var qlist_settings1 = {
			'prefix': 'hidden_rule_sub_1',
			'source': source1,
            'options':{ 
            	'popup': true,
            	'sliderwidth':1000
        	},
			'row_attr': [
				{name: 'id', selector: 'id'},
			],
			'columns': [
				{'selector': 'id', 'lang_key': $j.getInfo("id",flt_lang)},
				{'selector': 'name', 'lang_key': $j.getInfo("post_url",flt_lang)}
			],
			'menu_items': menu_items,
			'column_filters': {
				'enabled': false
			},
			'handle_selection_change': sub_selection_changed,
			'format_fn': {
			}
                };
		
		var qlist_settings2 = {
			'prefix': 'hidden_rule_sub_2',
			'source': source2,
            'options':{ 
            	'popup': true,
            	'sliderwidth':1000
        	},
			'row_attr': [
				{name: 'id', selector: 'id'},
			],
			'columns': [
				{'selector': 'id', 'lang_key': $j.getInfo("id",flt_lang)},
				{'selector': 'name', 'lang_key': $j.getInfo("hidden_fields_name",flt_lang)}
			],
			'menu_items': menu_items,
			'column_filters': {
				'enabled': false
			},
			'handle_selection_change': sub_selection_changed,
			'format_fn': {
			}
                };


		var $container1 = $("#sub_content_1");
		var $container2 = $("#sub_content_2");
		$container1.qlist(qlist_settings1);
		$container2.qlist(qlist_settings2);

	}

	$("#fetch_url").on("click", fetch_url_action);

	return {
		configure: setup_qlist
	};

})(jQuery);
