var sub_module_list = (function($) {
	'use strict';

	var source;

	function lang_format_fn(td, col, row_data){
		var data = row_data[col.selector];
		return (data === "") ? data : $j.getInfo(data,flt_lang);
	}
	function url_status_format_fn(td, col, row_data){
		var data = row_data[col.selector];
		return (data === "") ? data : $j.getInfo(data,flt_lang);
	}
	function request_type_format_fn(td, col, row_data){
		var data = row_data[col.selector];
		var status = row_data["request-status"];
		var re_str = "";
		if(status === "enable" && data !== ""){
			re_str = $j.getInfo(data,flt_lang);
		}
		return re_str;
	}
	function request_file_format_fn(td, col, row_data){
		var data = row_data[col.selector];
		var status = row_data["request-status"];
		var re_str = "";
		if(status === "enable" && data !== ""){
			re_str = $j.getInfo(data,flt_lang);
		}
		return re_str;
	}
	function header_value_format_fn(td, col, row_data){
		var data = row_data[col.selector];
		if(row_data["name"] == "content-security-policy"){
			return escapeHTML(row_data["custom-value"]||"");
		}

		return (data === "") ? data : $j.getInfo(data,flt_lang);
	}

	function setup_qlist()
	{
		if(table_key == '')
		{
			source = [];
			gen_qlist();
		}
		else
		{
			$.ajax({
				'url': '/cli-direct-action?mkey='+table_key+'&table_gid='+table_gid+'&child_gid='+child_gid+'&vdom='+vdom,
				'dataType': 'json',
				'success': function(response)
				{
					if(response.status == 1)
					{
						source = response.datas;
						gen_qlist();
					}
					else if(response.status == 0)
						error_handler(response.msg_id, "/waf/url_rewrite_rule/dlg?mkey=" + table_key+'&vdom='+vdom);
				},
				'cache': false
				});
		}
	}

	function gen_qlist(){
		if (!window.fgt_lang || !fgt_lang["global"])
			$j.addLang();
		var menu_items;
		var action_type;
		if(source)


		if(is_rw_admin)
		{
			menu_items = {
				'edit': {
					'handler': sub_edit_click
				},
				'delete': {
					'handler': sub_delete_click
				},
				'mi_insert': {
					'id': 'mi_insert',
					'class': 'tool_sprite tool_insert',
					'handler': sub_insert_click,
					'label': qed_strtbl.insert
				},
				'mi_move': {
					'id': 'mi_move',
					'class': 'tool_sprite tool_move',
					'handler': sub_move_click,
					'label': qed_strtbl.move
				}
			};
		}
		else
		{
			menu_items = {
				'edit': {
					'handler': sub_edit_click
				}
			};
		}

		var qlist_settings = {
			'prefix': 'url_rewrite_rule_sub',
			'source': source,
			'cr_new_url': create_sub_url,
			'row_attr': [
				{name: 'id', selector: 'id'},
			],
			'columns': [
				{'selector': 'id', 'lang_key': $j.getInfo("member_id",flt_lang)},
				{'selector': 'request-status', 'lang_key': $j.getInfo("url_status",flt_lang)},
				{'selector': 'request-type', 'lang_key': $j.getInfo("request_type",flt_lang)},
				{'selector': 'request-file', 'lang_key': $j.getInfo("request_url",flt_lang)},
				{'selector': 'name', 'lang_key': $j.getInfo("name_type",flt_lang)},
				{'selector': 'value', 'lang_key': $j.getInfo("value_type",flt_lang)},
			],
			'menu_items': menu_items,
			'default_columns':['id', 'request-status', 'request-type', 'request-file', 'name', 'value'],
			'column_filters': {
				'enabled': false
			},
			'options': {
				'popup': true,
				'sliderwidth':1000
			},
			'handle_selection_change': sub_selection_changed,
			'format_fn': {
				'name': lang_format_fn,
				'value': header_value_format_fn,
				'request-status': url_status_format_fn,
				'request-type': request_type_format_fn,
				'request-file': request_file_format_fn
			}
                };

		var $container = $("#sub_content");
		$container.qlist(qlist_settings);

	}

	return {configure: setup_qlist};

})(jQuery);
