var sub_module_list = (function($) {
	'use strict';

	var source;
	var type_lang = {
		'trust-ip' : 'trust_ip',
		'black-ip' : 'black_ip',
	};

	function severity_format_fn(td, col, row_data){
		if(row_data['type']!='black-ip')
			return '';
		var data = row_data[col.selector];
		return (data === "") ? data : $.getInfo(data,fgt_lang);
	}

	function type_format_fn(td, col, row_data){
		var data = row_data[col.selector];
		var lang = type_lang[data] ? type_lang[data] : '';
		return (lang === '') ? lang : $.getInfo(lang,flt_lang);
	}

	function setup_qlist()
	{
		if(table_key == '')
		{
			source = [];
			gen_qlist();
		}
		else
		{
			$.ajax({
				'url': '/cli-direct-action?mkey='+table_key+'&table_gid='+table_gid+'&child_gid='+child_gid+'&vdom='+vdom,
				'dataType': 'json',
				'success': function(response)
				{
					if(response.status == 1)
					{
						source = response.datas;
						gen_qlist();
					}
					else if(response.status == 0)
						error_handler(response.msg_id, "/prot/ip_list_policy/dlg?mkey=" + table_key+'&vdom='+vdom);
				},
				'cache': false
				});
		}
	}

	function gen_qlist(){
		if (!window.fgt_lang || !fgt_lang["global"])
			$.addLang();
		var menu_items;
		if(is_rw_admin)
		{
			menu_items = {
				'edit': {
					'handler': sub_edit_click
				},
				'delete': {
					'handler': sub_delete_click
				}
			};
		}
		else
		{
			menu_items = {
				'edit': {
					'handler': sub_edit_click
				}
			};
		}

		var qlist_settings = {
			'prefix': 'waf_ip_lst_sub',
			'source': source,
			'cr_new_url': create_sub_url,
			'row_attr': [
				{name: 'id', selector: 'id'},
			],
			'columns': [
				{'selector': 'id', 'lang_key': $.getInfo("member_id",flt_lang)},
				{'selector': 'type', 'lang_key': $.getInfo("member_type",flt_lang)},
				{'selector': 'ip', 'lang_key': $.getInfo("member_ip",flt_lang)},
				{'selector': 'severity', 'lang_key': $.getInfo("member_severity",flt_lang)},
				{'selector': 'trigger-policy', 'lang_key': $.getInfo("member_trigger",flt_lang)},
			],
			'menu_items': menu_items,
			'default_columns':['id', 'type', 'ip', 'severity', 'trigger-policy'],
			'column_filters': {
				'enabled': false
			},
			'handle_selection_change': sub_selection_changed,
			'format_fn': {
				'type': type_format_fn,
				'severity': severity_format_fn,
			},
			'options': {
				'sorting': true,
				'popup': true,
				'sliderwidth': 1000
			},
                };

		var $container = $("#sub_content");
		$container.qlist(qlist_settings);

	}

	return {configure: setup_qlist};

})(jQuery);
