
var sub_module_list = (function($) {
	'use strict';

	function setup_qlist()
	{
		if (!window.fgt_lang || !fgt_lang["global"])
			$j.addLang();

		if(table_key == '')
		{
			var source = [];
			gen_urls_qlist(source);
			gen_ip_qlist(source);
		}
		else
		{
			$.ajax({
				'url': '/waf/ml_bot_detection_policy/sub_json?mkey='+table_key+'&vdom='+vdom,
				'dataType': 'json',
				'success': function(response)
				{
					if(response.status == 1)
					{
						// url list
						gen_urls_qlist(response.urls_list);
						// page list
						gen_ip_qlist(response.ip_list);
					}
					else if(response.status == 0)
						error_handler(response.msg_id, "/waf/ml_bot_detection_policy/dlg?mkey=" + table_key + "&vdom=" + vdom);
				},
				'cache': false
				});
		}
	}

	function sub_urls_delete_click(qlist, elems)
	{
		var aElems = qlist.get_checked_rows();
		var del_url = del_sub_url;
		del_url = qlist_url_append_arg(del_url, "session_id", session_id);
		aElems.each(function() {
				del_url = qlist_url_append_arg(del_url, "id", qlist_get_row_attr(this, 'id'));       });
		$j.submitPOST(del_url);
	}

	function dblclick_fn(q,col,ev)
	{
		var btn = $j(col).find('a');
		if(btn.length > 0 && btn[0].href != null)
			window.location.href = btn[0].href;
	}
	function sub_import_click(qlist, elems)
	{
		import_urls(policy_id);
	}	
	function gen_urls_qlist(source){
		var menu_items={};
        if(is_rw_admin)
        {
                menu_items = {
						'edit': {
                                'handler': sub_edit_click
                        },
                        'delete': {
                                'handler': sub_urls_delete_click
                        }
                };
        }else{
				menu_items = {
						'edit': {
                                'handler': sub_edit_click
                        }
                };
		}

		var qlist_settings = {
			'prefix': 'ml_bot_detection_policy_urls_sub',
			'source': source,
			'cr_new_url': create_sub_url,
			'menu_items': menu_items,
			'row_attr': [
				{name: 'id', selector: 'id'},
				{name: 'host_status', selector: 'host_status'},
				{name: 'host', selector: 'host'},
				{name: 'url_type', selector: 'url_type'},
				{name: 'url_pattern', selector: 'url_pattern'},
			],
			'columns': [
				{'selector': 'id', 'lang_key': $j.getInfo("id",flt_lang)},			
				{'selector': 'host_status', 'lang_key': $j.getInfo("member_host_status",flt_lang)},					
				{'selector': 'host', 'lang_key': $j.getInfo("member_host",flt_lang)},
				{'selector': 'url_type', 'lang_key': $j.getInfo("member_url_type",flt_lang)},					
				{'selector': 'url_pattern', 'lang_key': $j.getInfo("member_url",flt_lang)}
			],
			'options': {
				'hide_edit_button': false,
			},
			'default_columns':['id', 'host', 'host_status', 'url_type', 'url_pattern'],
			'column_filters': {
				'enabled': false
			}
		}


		var $container = $("#urls_sub_content");
		$container.qlist(qlist_settings);

	}

	function sub_ip_delete_click(qlist, elems)
	{
		var aElems = qlist.get_checked_rows();
		var del_url = del_ip_sub_url;
		del_url = qlist_url_append_arg(del_url, "session_id", session_id);
		aElems.each(function() {
				del_url = qlist_url_append_arg(del_url, "id", qlist_get_row_attr(this, 'id'));       });
		$j.submitPOST(del_url);
	}
	function sub_ip_edit_click(qlist, elems)
	{
		var mkey = qlist_get_row_attr(elems, 'id');
		var edit_url = edit_page_sub_url;
		if(mkey){
			edit_url = qlist_url_append_arg(edit_url, "id", mkey);
				   if(qlist.popup){
				var qlistSubSlide;
				qlistSubSlide = new top.Sliderin({ 
					title: '',  
					url: edit_url,  
					width: qlist.sliderwidth 
				}); 
				qlistSubSlide.open(); 
			}else{
				window.location.href = edit_url;		}
		}
	}
	function gen_ip_qlist(source){
		var menu_items={};
        if(is_rw_admin)
        {
                menu_items = {
						'edit': {
                                'handler': sub_ip_edit_click
                        },
                        'delete': {
                                'handler': sub_ip_delete_click
                        }
                };
        }else{
				menu_items = {
						'edit': {
                                'handler': sub_ip_edit_click
                        }
                };
		}
        var qlist_settings = {
                'prefix': 'ml_bot_detection_policy_ip_sub',
                'source': source,
                'cr_new_url': create_ip_sub_url,
				'menu_items': menu_items,
                'row_attr': [
                        {name: 'id', selector: 'id'},
                ],
                'columns': [
                        {'selector': 'id', 'lang_key': $j.getInfo("id",flt_lang)},
                        {'selector': 'ip', 'lang_key': $j.getInfo("ip_range",flt_lang)}
                ],
				'options': {
					'hide_edit_button': false,
				},
                'default_columns':['id', 'ip'],
                'column_filters': {
                        'enabled': false
                }
        };

        var $container = $("#ip_sub_content");
        $container.qlist(qlist_settings);

    }

	return {configure: setup_qlist};

})(jQuery);
