$j(function(){
	$j('<div id="progress_dialog" style="display:none;"><div id="progressbar"><div class="progress_label">0%</div></div></div>').appendTo($j('body'));
	$j('<div id="import_dialog" style="display:none;"><form enctype="multipart/form-data" id="import_form"><div><div class="label">'+$j.getInfo('import_file')+'</div><div><input type="file" name="import_file"></div></div><input type="hidden" name="type" value="2"><input type="hidden" name="id" id="import_id" value=""></form></div>').appendTo($j('body'));
	$j('<div id="result_dialog" style="display:none;"><div id="result_msg" class="label"></div></div></div>').appendTo($j('body'));

	var progress_dialog = $j('#progress_dialog').dialog({
		modal: true,
		width: 400,
		draggable: false,
		autoOpen: false,
		dialogClass: 'progress_dialog',
		buttons: []
	});

	var progressbar = $j('#progressbar').progressbar({
		value: 0,
		change: function() {
			$j('.progress_label').text( progressbar.progressbar( "value" ) + "%" );
		},
	});

	var import_dialog = $j("#import_dialog").dialog({
		title: $j.getInfo("import_dialog"),
		modal: true,
		width: 600,
		draggable: false,
		autoOpen: false,
		dialogClass: 'import_dialog',
		buttons: [{
			text: $j.getInfo("import"),
			click: clickImport
		},{
			text: $j.getInfo("cancel"),
			click: clickCancel
		}]
	});

	var result_dialog = $j('#result_dialog').dialog({
		modal: true,
		width: 400,
		draggable: false,
		autoOpen: false,
		dialogClass: 'result_dialog',
		buttons: [{
			text: $j.getInfo('ok'),
			click: function() {
				$j('#result_dialog').dialog('close');				
			}
		}],
		close: function( event, ui ) {
			document.location.href = '/waf/ml_policy/dlg?mkey=' + document.forms[0].mkey.value ;
		}
	});

	function clickImport() {
		var options = {
			url: '/waf/ml_policy/import_data',
			type: 'post',
			dataType: 'json',
			beforeSubmit: function(formData, jqForm, options){
				// import button disable
				$j('.ui-dialog-buttonpane').find('button:first').attr("disabled", "disabled");
				if(formData[0].value == "") {
					alert($j.getInfo("err_import_file"));
					return false;
				}
				else{
					return true;
				}
			},
			success: function(responseText, statusText, xhr, $form){
				if(responseText.status == 1)
				{
					// $j('#progress_dialog').dialog('open');
					// check_import($j('#import_id').val());
					$j('#result_msg').text($j.getInfo('import_success'));
                    $j('#result_dialog').dialog('open');
				}
				else if(responseText.status == 0)
					error_handler(responseText.msg_id, "/waf/ml_policy/dlg?mkey=" + document.forms[0].mkey.value );

				$j('.ui-dialog-buttonpane').find('button:first').removeAttr("disabled");
				$j("#import_dialog").dialog('close');
			},
			error: function(responseText, error){
				alert($j.getInfo("err_import"));
				$j('.ui-dialog-buttonpane').find('button:first').removeAttr("disabled");
				$j("#import_dialog").dialog('close');
			}
		};
		$j("#import_form").ajaxSubmit(options);
	}
	function clickCancel() {
		$j("#import_dialog").dialog('close');
	}
})

function export_domain(id,domain_name) {
	$j('#progress_dialog').dialog('option', 'title', $j.getInfo('export_dialog'));
	$j('#progressbar').progressbar('value', 0);
	$j.ajax({
		'url': '/waf/ml_policy/export_data?id='+id+'&type=2&domain_name='+domain_name+'&session_id='+session_id,
		'dataType': 'json',
		'success': function(response)
		{
			if(response.status == 1)
			{
				// $j('#progress_dialog').dialog('open');
				// check_export(id);
				$j('#result_msg').text($j.getInfo('export_success'));
				$j('#result_dialog').dialog('open');
				var file = response.filename.split('/').pop();
				document.location.href = '/waf/ml_policy/export_download?msg=61&session_id=' + session_id + '&name=' + file;
			}
			else if(response.status == 0)
				error_handler(response.msg_id, "/waf/ml_policy/dlg?mkey=" + document.forms[0].mkey.value );
		},
		'cache': false
	});
}

function import_domain(id) {
	$j('#progress_dialog').dialog('option', 'title', $j.getInfo('import_dialog'));
	$j('#progressbar').progressbar('value', 0);
	$j('#import_id').val(id);
	$j("#import_dialog").dialog('open');
}

// function check_export(id) {
// 	$j.ajax({
// 		'url': '/waf/ml_policy/export_query?id='+id+'&type=2&session_id='+session_id,
// 		'dataType': 'json',
// 		'success': function(response)
// 		{
// 			if(response.status == 1)
// 			{
// 				// $j('.progress_label').text($j.getInfo('exporting')+' '+response.percent+'%');
// 				$j('#progressbar').progressbar( 'value', response.percent );
// 				if(response.percent == 100 && response.filename) {
// 					// $j('#progress_dialog').dialog( 'option', 'buttons', [{
// 					// 	text: $j.getInfo('close'),
// 					// 	click: function() {
// 					// 		$j('#progress_dialog').dialog('close')
// 					// 	}
// 					// }]);
// 					setTimeout(function() {
// 						$j('#progress_dialog').dialog('close');
// 						$j('#result_msg').text($j.getInfo('export_success'));
// 						$j('#result_dialog').dialog('open');
// 						var file = response.filename.split('/').pop();
// 						document.location.href = '/waf/ml_policy/export_download?msg=61&session_id=' + session_id + '&name=' + file;
// 					}, 500);
// 					return;
// 				}
// 				setTimeout(function() {
// 					check_export(id);
// 				}, 200);
// 			}
// 			else if(response.status == 0)
// 				error_handler(response.msg_id, "/waf/ml_policy/dlg?mkey=" + document.forms[0].mkey.value );
// 		},
// 		'cache': false
// 	});
// }

// function check_import(id) {
// 	$j.ajax({
// 		'url': '/waf/ml_policy/import_query?id='+id+'&type=2&session_id='+session_id,
// 		'dataType': 'json',
// 		'success': function(response)
// 		{
// 			if(response.status == 1)
// 			{
// 				// $j('.progress_label').text($j.getInfo('importing')+' '+response.percent+'%');
// 				$j('#progressbar').progressbar( 'value', response.percent );
// 				if(response.percent == 100) {
// 					// $j('#progress_dialog').dialog( 'option', 'buttons', [{
// 					// 	text: $j.getInfo('close'),
// 					// 	click: function() {
// 					// 		$j('#progress_dialog').dialog('close')
// 					// 	}
// 					// }]);
// 					setTimeout(function() {
// 						$j('#progress_dialog').dialog('close');
// 						$j('#result_msg').text($j.getInfo('import_success'));
// 						$j('#result_dialog').dialog('open');
// 					}, 500);
// 					return;
// 				}
// 				setTimeout(function() {
// 					check_import(id);
// 				}, 200);
// 			}
// 			else if(response.status == 0)
// 				error_handler(response.msg_id, "/waf/ml_policy/dlg?mkey=" + document.forms[0].mkey.value );
// 		},
// 		'cache': false
// 	});
// }

var sub_module_list = (function($) {
	'use strict';

	function setup_qlist()
	{
		if (!window.fgt_lang || !fgt_lang["global"])
			$j.addLang();

		if(table_key == '')
		{
			var source = [];
			gen_domain_qlist(source);
			gen_ip_qlist(source);
		}
		else
		{
			$.ajax({
				'url': '/waf/ml_policy/sub_json?mkey='+table_key+'&vdom='+vdom,
				'dataType': 'json',
				'success': function(response)
				{
					if(response.status == 1)
					{
						// url list
						gen_domain_qlist(response.domain_list);
						// page list
						gen_ip_qlist(response.ip_list);
					}
					else if(response.status == 0)
						error_handler(response.msg_id, "/waf/ml_policy/dlg?mkey=" + table_key + "&vdom=" + vdom);
				},
				'cache': false
				});
		}
	}

	function view_domain_format_fn($td, col, row_data)
	{
		var html = '';
		var view_domain = '';

		var redir = document.getElementById("redir") ;

		var url_param = 'mkey='+row_data.mkey+'&table_key='+row_data.id+'&domain='+row_data.domain_name;
		url_param += '&policy_id='+row_data.policy_id+'&db_name='+row_data.db_name+'&db_id='+row_data.db_id;
		if(redir != '' && redir != null )
			url_param += '&redir='+redir.value;

		view_domain = '<a href="/waf/ml_policy/viewmenu?'+url_param+'" style="text-decoration: none;">';
		view_domain += '<f-icon class="fa-bars" title="'+$j.getInfo("view_domain",flt_lang)+'" style="cursor: pointer"></f-icon>';
		view_domain += '</a>';

		html = "<div>"+view_domain+"</div>";

		return html;
	}

	function action_format_fn($td, col, row_data)
	{
		var html = '';
		var view_domain = '';
		var refresh = '';
		var expt = '';
		var impt = '';
		var redir = document.getElementById("redir") ;

		var url_param = 'mkey='+row_data.mkey+'&table_key='+row_data.id+'&domain='+row_data.domain_name;
		url_param += '&policy_id='+row_data.policy_id+'&db_name='+row_data.db_name+'&db_id='+row_data.db_id;
		if(redir != '' && redir != null )
			url_param += '&redir='+redir.value;

		view_domain = '<a href="/waf/ml_policy/viewmenu?'+url_param+'" style="text-decoration: none;">';
		view_domain += '<f-icon class="fa-bars" title="'+$j.getInfo("view_domain",flt_lang)+'" style="cursor: pointer"></f-icon>';
		view_domain += '</a>';

		if (is_rw_admin) {
			refresh = '<a style="text-decoration: none;" id=\"refresh_domain_btn\" onclick="refresh_domain('+row_data.mkey +','+row_data.id+','+row_data.db_id+ ')">';
			refresh += '<f-icon class="fa-undo" title="'+$j.getInfo("rebuild",fgt_lang)+'" style="cursor: pointer"></f-icon>';
			refresh += '</a>';

			expt = '<a style="text-decoration: none;" id=\"export_domain_btn\" onclick="export_domain(\'' +row_data.db_id+ '\',\''+row_data.domain_name+'\')">';
			expt += '<f-icon class="ftnt-export" title="'+$j.getInfo("export",fgt_lang)+'" style="cursor: pointer"></f-icon>';
			expt += '</a>'; 
		} else {
			refresh = '<a style="text-decoration: none;" id=\"refresh_domain_btn\">';
			refresh += '<f-icon class="fa-undo" title="'+$j.getInfo("rebuild",fgt_lang)+'" style="color: #969696"></f-icon>';
			refresh += '</a>';

			expt = '<a style="text-decoration: none;" id=\"export_domain_btn\">';
			expt += '<f-icon class="ftnt-export" title="'+$j.getInfo("export",fgt_lang)+'" style="color: #969696"></f-icon>';
			expt += '</a>'; 
		}

		//impt = '<a style="text-decoration: none;" id=\"import_data_btn\" onclick="import_domain(\'' +row_data.policy_id+ '\')">';
		//impt += '<f-icon class="ftnt-import" title="'+$j.getInfo("import",fgt_lang)+'" style="cursor: pointer"></f-icon>';
		//impt += '</a>';

		html = "<div>"+/*view_domain+" "+*/ refresh+" "+expt+" "+impt+"</div>";

		return html;
	}


	function sub_domain_delete_click(qlist, elems)
	{
		var aElems = qlist.get_checked_rows();
		var del_url = del_sub_url;
		del_url = qlist_url_append_arg(del_url, "session_id", session_id);
		aElems.each(function() {
				del_url = qlist_url_append_arg(del_url, "id", qlist_get_row_attr(this, 'id'));       });
		$j.submitPOST(del_url);
	}

	function dblclick_fn(q,col,ev)
	{
		var btn = $j(col).find('a');
		if(btn.length > 0 && btn[0].href != null)
			window.location.href = btn[0].href;
	}
	function sub_import_click(qlist, elems)
	{
		import_domain(policy_id);
	}	
	function gen_domain_qlist(source){
		var menu_items={};
        if(is_rw_admin)
        {
                menu_items = {
                        'delete': {
                                'handler': sub_domain_delete_click
                        },
						'mi_move': {
							'id': 'mi_move',
							'class': 'tool_sprite tool_move',
							'handler': sub_move_click,
							'label': qed_strtbl.move
						},
						'mi_import': {
							'id': 'mi_import',
							'class': 'tool_sprite tool_import',
							'ctext':false,
							'handler': sub_import_click,
							'label': $j.getInfo("import",fgt_lang),
							'lazyload':false
						}
                };
        }

        if (!is_cmintf) {
			var qlist_settings = {
				'prefix': 'ml_policy_domain_sub',
				'source': source,
				'cr_new_url': create_sub_url,
				'menu_items': menu_items,
				'row_attr': [
					{name: 'id', selector: 'id'},
				],
				'columns': [
					{'selector': 'id', 'lang_key': $j.getInfo("id",flt_lang)},
					{'selector': 'domain_name', 'lang_key': $j.getInfo("domain",flt_lang)},
					{'selector': 'view_domain', 'lang_key': $j.getInfo('view_domain_data', flt_lang)},
					{'selector': 'action', 'lang_key': $j.getInfo("action",flt_lang)}
				],
				'options': {
					'hide_edit_button': true,
				},
				'default_columns':['id', 'domain_name', 'view_domain', 'action'],
				'column_filters': {
					'enabled': false
				},
				'handle_selection_change': sub_selection_changed,
				'format_fn': {
					'action' : action_format_fn,
					'view_domain': view_domain_format_fn
				},
				'callbacks': {
					'dblclick': dblclick_fn
				}
			};
		} else {
			// CMINTF platform, hide action column, remove dblclick
			var qlist_settings = {
				'prefix': 'ml_policy_domain_sub',
				'source': source,
				'cr_new_url': create_sub_url,
				'menu_items': menu_items,
				'row_attr': [
					{name: 'id', selector: 'id'},
				],
				'columns': [
					{'selector': 'id', 'lang_key': $j.getInfo("id",flt_lang)},
					{'selector': 'domain_name', 'lang_key': $j.getInfo("domain",flt_lang)}
				],
				'options': {
					'hide_edit_button': true,
				},
				'default_columns':['id', 'domain_name'],
				'column_filters': {
					'enabled': false
				}
			}
		};

		var $container = $("#domain_sub_content");
		$container.qlist(qlist_settings);

	}

	function sub_ip_delete_click(qlist, elems)
	{
		var aElems = qlist.get_checked_rows();
		var del_url = del_ip_sub_url;
		del_url = qlist_url_append_arg(del_url, "session_id", session_id);
		aElems.each(function() {
				del_url = qlist_url_append_arg(del_url, "id", qlist_get_row_attr(this, 'id'));       });
		$j.submitPOST(del_url);
	}
	function gen_ip_qlist(source){
		var menu_items={};
		if(is_rw_admin)
        {
                menu_items = {
                        'edit': {
                                'handler': sub_edit_click
                        },
                        'delete': {
                                'handler': sub_ip_delete_click
                        }
                };
        }
        else
        {
                menu_items = {
                        'edit': {
                                'handler': sub_edit_click
                        }
                };
        }
        var qlist_settings = {
                'prefix': 'ml_policy_ip_sub',
                'source': source,
                'cr_new_url': create_ip_sub_url,
				'menu_items': menu_items,
                'row_attr': [
                        {name: 'id', selector: 'id'},
                ],
                'columns': [
                        {'selector': 'id', 'lang_key': $j.getInfo("id",flt_lang)},
                        {'selector': 'ip', 'lang_key': $j.getInfo("ip_range",flt_lang)}
                ],
				'options': {
					'hide_edit_button': false,
				},
                'default_columns':['id', 'ip'],
                'column_filters': {
                        'enabled': false
                }
        };

        var $container = $("#ip_sub_content");
        $container.qlist(qlist_settings);

    }
	
	return {configure: setup_qlist};

})(jQuery);
