var sub_module_list = (function($) {
	'use strict';
	function url_format_fn(td, col, row_data) {
		var data = row_data[col.selector];
		if(typeof(data) === 'undefined') return data;
		return data.replace(/,/g, "<br>");
	}
	var source;

	function setup_qlist()
	{
		if(table_key == '')
		{
			source = [];
			gen_qlist();
		}
		else
		{
			$.ajax({
				'url': '/waf/openapi_protection_policy/schema_list_json?table_key='+table_key+'&table_gid='+table_gid+'&child_gid='+child_gid,
				'dataType': 'json',
				'success': function(response)
				{
					if(response.status == 1)
					{
						source = response.results;
						gen_qlist();
					}
					else if(response.status == 0)
						error_handler(response.msg_id, "/waf/openapi_protection_policy/dlg?mkey=" + table_key);
				},
				'cache': false
				});
		}
	}

	function gen_qlist(){
		if (!window.fgt_lang || !fgt_lang["global"])
			$j.addLang();
		var menu_items;
		if(is_rw_admin)
		{
			menu_items = {
				'delete': {
					'handler': sub_delete_click
				}
			};
		}
		else
		{
			menu_items = {};
		}

		var qlist_settings = {
			'prefix': 'start_pages_sub',
			'source': source,
			'cr_new_url': create_sub_url,
			'row_attr': [
				{name: 'id', selector: 'id'},
			],
			'options': {
				'hide_edit_button': true,				
				'popup': true,
				'sliderwidth':1000
			},
			'handle_selection_change': sub_selection_changed,
			'columns': [
				{'selector': 'id', 'lang_key': $j.getInfo("id",fgt_lang)},
				{'selector': 'name', 'lang_key': $j.getInfo('name', flt_lang) },
				{'selector': 'title', 'lang_key': $j.getInfo('title', flt_lang) },
				{'selector': 'desc', 'lang_key': $j.getInfo('desc', flt_lang) },
				{'selector': 'url', 'lang_key': $j.getInfo('url', flt_lang) },
			],
			'menu_items': menu_items,
			'default_columns':['id', 'name', 'title', 'desc', 'url'],
			'format_fn': {
				'url': url_format_fn
			},
			'column_filters': {
				'enabled': true,
				'exempts':['id']
			}
        };

		var $container = $("#sub_content");
		$container.qlist(qlist_settings);

	}

	return {configure: setup_qlist};

})(jQuery);
