var sub_module_list = (function($) {
	'use strict';

	var source;

	function setup_qlist()
	{
		if(table_key == '')
		{
			source = [];
			gen_qlist();
		}
		else
		{
			$.ajax({
				'url': '/cli-direct-action?mkey='+table_key+'&table_gid='+table_gid+'&child_gid='+child_gid+'&vdom='+vdom,
				'dataType': 'json',
				'success': function(response)
				{
					if(response.status == 1)
					{
						source = response.datas;
						gen_qlist();
					}
					else if(response.status == 0)
						error_handler(response.msg_id, "/waf/padding_oracle/dlg?mkey=" + table_key + "&vdom=" + vdom);
				},
				'cache': false
			});
		}
	}

	function url_type_format_fn($td, col, row_data)
	{
		var type_val = row_data['url-type_val'];
		var type_str = "";
		if(type_val == "0")
		{
			type_str = $j.getInfo("simple", flt_lang);
		}
		else
		{
			type_str = $j.getInfo("regex", flt_lang);
		}
		
		return type_str;
	}

	var target_obj = {
		url: 1 << 0,
	    	parameter: 1 << 1,
	    	cookie: 1 << 2
	};
	
	function target_url_format_fn($td, col, row_data)
	{
		var target_val = row_data.target_val;
		var html = '';

		if(target_val & target_obj.url)
		{
			html = '<span><img src="/images/icon_yes.gif" /></span>';	
		}
		else
		{
			html = '<span><img src="/images/icon_no.gif"></span>';
		}

		return html;
	}
	
	function target_parameter_format_fn($td, col, row_data)
	{
		var target_val = row_data.target_val;
		var html = '';

		if(target_val & target_obj.parameter)
		{
			html = '<span><img src="/images/icon_yes.gif" /></span>';	
		}
		else
		{
			html = '<span><img src="/images/icon_no.gif"></span>';
		}

		return html;
	}
	
	function target_cookie_format_fn($td, col, row_data)
	{
		var target_val = row_data.target_val;
		var html = '';

		if(target_val & target_obj.cookie)
		{
			html = '<span><img src="/images/icon_yes.gif" /></span>';	
		}
		else
		{
			html = '<span><img src="/images/icon_no.gif"></span>';
		}

		return html;
	}

	function protected_url_format_fn($td, col, row_data)
	{
		var url = row_data['protected-url'];
		return escapeHTML(url);
	}

	function gen_qlist()
	{
		if(!window.fgt_lang || !fgt_lang["global"])
			$j.addLang();

		var menu_items;
		if(is_rw_admin)
		{
			menu_items = {
				'edit': {
					'handler': sub_edit_click
				},
				'delete': {
					'handler': sub_delete_click
				},
			};

		}
		else
		{
			menu_items = {
				'edit': {
					'handler': sub_edit_click
				}
			};
		}

		var qlist_settings = {
			'prefix': 'padding_oracle_sub',
			'source': source,
			'cr_new_url': create_sub_url,
			'row_attr': [
				{name: 'id', selector: 'id'},
			],
			'columns': [
				{'selector': 'id', 'lang_key': $j.getInfo("member_id",flt_lang)},
				{'selector': 'url-type', 'lang_key': $j.getInfo("member_type",flt_lang)},
				{'selector': 'protected-url', 'lang_key': $j.getInfo("member_url",flt_lang)},
				{'selector': 'url', 'lang_key': $j.getInfo("member_target_url",flt_lang)},
				{'selector': 'parameter', 'lang_key': $j.getInfo("member_target_parameter",flt_lang)},
				{'selector': 'cookie', 'lang_key': $j.getInfo("member_target_cookie",flt_lang)},
			],
			'menu_items': menu_items,
			'default_columns':['id', 'url-type', 'protected-url', 'url', 'parameter', 'cookie'],
			'column_filters': {
				'enabled': true,
				'exempts': ['id', 'url-type', 'url', 'parameter', 'cookie']
			},
			'options': {
				'popup': true,
				'sliderwidth':1000
			},
			'handle_selection_change': sub_selection_changed,
			'format_fn': {
				'url': target_url_format_fn,
				'parameter': target_parameter_format_fn,
				'cookie': target_cookie_format_fn,
				'protected-url': protected_url_format_fn,
				'url-type': url_type_format_fn
			}
		};

		var $container = $("#sub_content");
		$container.qlist(qlist_settings);

	}
	return {configure: setup_qlist};
})(jQuery);
