var sub_module_list = (function($) {
	'use strict';

	var source;
	var name_type_lang = {
		'plain' : 'simple',
		'regular' : 'regex'
	};

	function lang_format_fn(td, col, row_data){
		var data = row_data[col.selector];
		return (data === "") ? data : $j.getInfo(data,flt_lang);
	}

	function g_lang_format_fn(td, col, row_data){
		var data = row_data[col.selector];
		return (data === "") ? data : $j.getInfo(data,fgt_lang);
	}

	function name_type_format_fn(td, col, row_data){
		var data = row_data[col.selector];
		var lang = name_type_lang[data] ? name_type_lang[data] : '';
		return (lang === '') ? lang : $.getInfo(lang,flt_lang);
	}

	function html_encode_format_fn(td, col, row_data){
		var data = row_data[col.selector];
		return (data === '') ? data : escapeHTML(data);
	}

	function data_type_format_fn(td, col, row_data){
		if(row_data['type-checked_val']==0 || row_data['argument-type_val']!=0)
			return '';
		var data = row_data[col.selector];
		if (data === '')
			return data;
		return (data in type_name_lang) ? type_name_lang[data] : '';
	}

	function setup_qlist()
	{
		if(table_key == '')
		{
			source = [];
			gen_qlist();
		}
		else
		{
			$.ajax({
				'url': '/cli-direct-action?mkey='+table_key+'&table_gid='+table_gid+'&child_gid='+child_gid+'&vdom='+vdom,
				'dataType': 'json',
				'success': function(response)
				{
					if(response.status == 1)
					{
						source = response.datas;
						gen_qlist();
					}
					else if(response.status == 0)
						error_handler(response.msg_id, "/waf/input_rule/dlg?mkey=" + table_key+'&vdom='+vdom);
				},
				'cache': false
				});
		}
	}

	function gen_qlist(){
		if (!window.fgt_lang || !fgt_lang["global"])
			$j.addLang();
		var menu_items;
		if(is_rw_admin)
		{
			menu_items = {
				'edit': {
					'handler': sub_edit_click
				},
				'delete': {
					'handler': sub_delete_click
				}
			};
		}
		else
		{
			menu_items = {
				'edit': {
					'handler': sub_edit_click
				}
			};
		}

		var qlist_settings = {
			'prefix': 'waf_param_vali_rule_sub',
			'source': source,
			'cr_new_url': create_sub_url,
			'row_attr': [
				{name: 'id', selector: 'id'},
			],
			'options': {
				'popup': true,
				'sliderwidth': 1000
			},
			'columns': [
				{'selector': 'id', 'lang_key': $j.getInfo("member_id",flt_lang)},
				{'selector': 'argument-name', 'lang_key': $j.getInfo("member_argument",flt_lang)},
				{'selector': 'max-length', 'lang_key': $j.getInfo("member_length",flt_lang)},
				{'selector': 'data-type', 'lang_key': $j.getInfo("member_data_type",flt_lang)},
				{'selector': 'is-essential', 'lang_key': $j.getInfo("member_flag",flt_lang)},
				{'selector': 'argument-name-type', 'lang_key': $j.getInfo("member_name_type",flt_lang)},
				{'selector': 'type-checked', 'lang_key': $j.getInfo("member_type_check",flt_lang)},
			],
			'menu_items': menu_items,
			'default_columns':['id', 'argument-name', 'max-length', 'data-type', 'is-essential', 'argument-name-type', 'type-checked'],
			'column_filters': {
				'enabled': false
			},
			'handle_selection_change': sub_selection_changed,
			'format_fn': {
				'data-type': data_type_format_fn,
				'is-essential': lang_format_fn,
				'argument-name-type': name_type_format_fn,
				'type-checked': g_lang_format_fn,
				'argument-name': html_encode_format_fn
			}
                };

		var $container = $("#sub_content");
		$container.qlist(qlist_settings);

	}

	return {configure: setup_qlist};

})(jQuery);
