var sub_module_list = (function($) {
	'use strict';

	var source;

	function match_format_fn(td, col, row_data){
		var data = row_data[col.selector];
		return (data === "no") ? $j.getInfo("match_this_condition",flt_lang) : $j.getInfo("unmatch_this_condition",flt_lang);
	}

	function type_format_fn(td, col, row_data){
		var data = row_data[col.selector];
		return (data === "simple-string") ? $j.getInfo("simple",flt_lang) : $j.getInfo("regex",flt_lang);
	}
	function escapeHTML_format_fn(td, col, row_data){
		var data = row_data[col.selector];
		return (data !== "") ? escapeHTML(data) : '';
	}	

	function setup_qlist()
	{
		if(table_key == '')
		{
			source = [];
			gen_qlist();
		}
		else
		{
			$.ajax({
				'url': '/cli-direct-action?mkey='+table_key+'&table_gid='+table_gid+'&child_gid='+child_gid+'&vdom='+vdom,
				'dataType': 'json',
				'success': function(response)
				{
					if(response.status == 1)
					{
						source = response.datas;
						gen_qlist();
					}
					else if(response.status == 0)
						error_handler(response.msg_id, "/waf/url_access_rule/dlg?mkey=" + table_key + '&vdom=' + vdom);
				},
				'cache': false
				});
		}
	}

	function gen_qlist(){
		if (!window.fgt_lang || !fgt_lang["global"])
			$j.addLang();
		var menu_items;
		if(is_rw_admin)
		{
			menu_items = {
				'edit': {
					'handler': sub_edit_click
				},
				'delete': {
					'handler': sub_delete_click
				}
			};
		}
		else
		{
			menu_items = {
				'edit': {
					'handler': sub_edit_click
				}
			};
		}

		var qlist_settings = {
			'prefix': 'url_access_rule_sub',
			'source': source,
			'cr_new_url': create_sub_url,
            'options':{ 
            	'popup': true,
            	'sliderwidth':1000
        	},
			'row_attr': [
				{name: 'id', selector: 'id'},
			],
			'columns': [
				{'selector': 'id', 'lang_key': $j.getInfo("member_id",flt_lang)},
				{'selector': 'type', 'lang_key': $j.getInfo("member_type",flt_lang)},
				{'selector': 'reg-exp', 'lang_key': $j.getInfo("member_reg",flt_lang)},
				{'selector': 'reverse-match', 'lang_key': $j.getInfo("member_obj",flt_lang)}
			],
			'menu_items': menu_items,
			'default_columns':['id', 'type', 'reg-exp', 'reverse-match'],
			'column_filters': {
				'enabled': true,
				'exempts':['id', 'type', 'reverse-match']
			},
			'handle_selection_change': sub_selection_changed,
			'format_fn': {
				'reverse-match': match_format_fn,
				'type': type_format_fn,
				'reg-exp':escapeHTML_format_fn
			}
        };

		var $container = $("#sub_content");
		$container.qlist(qlist_settings);

	}

	return {configure: setup_qlist};

})(jQuery);
