var sub_module_list = (function($) {
	'use strict';
	
	var source = [];

	function lang_format_fn(td, col, row_data){
                var data = row_data[col.selector];
                return (data === "") ? data : $j.getInfo(data,fgt_lang);
        }
	function setup_qlist()
	{
		if (!window.fgt_lang || !fgt_lang["global"])
			$j.addLang();

		if(table_key == '')
		{
			gen_name_qlist(source);
			gen_elem_qlist(source);
		}
		else
		{
			$.ajax({
				'url': '/waf/xml_security_rule/sub_list/json?mkey='+table_key+'&vdom='+vdom,
				'dataType': 'json',
				'success': function(response)
				{
					if(response.status == 1)
					{
						gen_name_qlist(response.ns_list);
						gen_elem_qlist(response.element_list);
					}
					else if(response.status == 0)
						error_handler(response.msg_id, "/waf/xml_security_rule/dlg?mkey=" + table_key + "&vdom=" + vdom);
				},
				'cache': false
				});
		}
	}

	function gen_name_qlist(source){
		var menu_items;
		if(is_rw_admin)
		{
			menu_items = {
				'edit': {
					'handler': sub_edit_click
				},
				'delete': {
					'handler': sub_delete_click
				}
			};
		}
		else
		{
			menu_items = {
				'edit': {
					'handler': sub_edit_click
				}
			};
		}

		var qlist_settings = {
			'prefix': 'xml_secure_name_sub',
			'source': source,
			'cr_new_url': create_sub_url,
			'row_attr': [
				{name: 'id', selector: 'id'},
			],
			'columns': [
				{'selector': 'id', 'lang_key': '#'},
				{'selector': 'prefix', 'lang_key': $j.getInfo("member_prefix",flt_lang)},
				{'selector': 'namespace', 'lang_key': $j.getInfo("member_namespace",flt_lang)},
			],
			'menu_items': menu_items,
			'default_columns':['id', 'prefix', 'namespace'],
			'column_filters': {
				'enabled': false
			},
			'options': {
				'popup': true,
				'sliderwidth':1000
			},
			'handle_selection_change': sub_selection_changed,
			'format_fn': {
                        }
                };

		var $container = $("#name_sub_content");
		$container.qlist(qlist_settings);

	}

	function sub_elem_selection_changed(qlist)
	{
		qlist_handle_selection_change(qlist);
		qmenu_enable_button($('#mi_new_' + qlist.prefix), enable_createnew, qlist);
		var aElems = qlist.get_checked_rows();
		var can_delete = aElems.length > 0;
		var one_select = aElems.length === 1;
		var enable_edit = false;
		if(aElems.length === 1)	
			enable_edit = qlist.can_edit_fn(qlist, aElems[0]);	
		if(typeof(enable_editdel) != undefined && window.enable_editdel != undefined)
		{
			qmenu_enable_button($('mi_edit_' + qlist.prefix), enable_editdel && one_select, qlist);
			qmenu_enable_button($('mi_del_' + qlist.prefix), enable_editdel && can_delete, qlist);
		}
	}

	function sub_elem_delete_click(qlist, elems)
	{
		var aElems = qlist.get_checked_rows();
		var del_url = del_elem_sub_url;
		del_url = qlist_url_append_arg(del_url, "session_id", session_id);
		aElems.each(function() {
				del_url = qlist_url_append_arg(del_url, "id", qlist_get_row_attr(this, 'id'));       });
		$j.submitPOST(del_url);
	}

	function sub_elem_edit_click(qlist, elems)
	{

		var mkey = qlist_get_row_attr(elems, 'id');
		var new_edit_url ='';
		if(mkey){
			new_edit_url = qlist_url_append_arg(edit_elem_sub_url, "id", mkey);
			if(qlist.popup){
				var qlistSubSlide;
				qlistSubSlide = new top.Sliderin({ 
					title: '',  
					url: new_edit_url,  
					width: qlist.sliderwidth 
				}); 
				qlistSubSlide.open(); 
			}else{
				window.location.href = new_edit_url;
			}
		}
	}

	function gen_elem_qlist(source){
                var menu_items;
                if(is_rw_admin)
                {
                        menu_items = {
                                'edit': {
                                        'handler': sub_elem_edit_click
                                },
                                'delete': {
                                        'handler': sub_elem_delete_click
                                }
                        };
                }
                else
                {
                        menu_items = {
                                'edit': {
                                        'handler': sub_elem_edit_click
                                }
                        };
                }

                var qlist_settings = {
                        'prefix': 'xml_secure_elem_sub',
                        'source': source,
                        'cr_new_url': create_elem_sub_url,
                        'row_attr': [
                                {name: 'id', selector: 'id'},
                        ],
                        'columns': [
                                {'selector': 'id', 'lang_key': '#'},
                                {'selector': 'xpath', 'lang_key': $j.getInfo("member_xpath",flt_lang)},
                                {'selector': 'direction', 'lang_key': $j.getInfo("member_direction",flt_lang)},
                        ],
                        'menu_items': menu_items,
                        'default_columns':['id', 'xpath', 'direction'],
                        'column_filters': {
                                'enabled': false
                        },
                        'options': {
                                'popup': true,
                                'sliderwidth':1000
                        },
			'handle_selection_change': sub_elem_selection_changed,
                        'format_fn': {
				'direction': lang_format_fn
                        }
                };

                var $container = $("#elem_sub_content");
                $container.qlist(qlist_settings);

        }

	return {configure: setup_qlist};

})(jQuery);
