/*
 *  wvs adv list
 * */

function closeLastSliderin()
{
	if(top.Sliderin)
		top.Sliderin.closeLast();
}

function sync_value_to()
{
	var doc, win;
	if(typeof (top.main) != 'undefined')
	{
		doc = top.frames['main'].frames['mainContent'].contentDocument;
		win = top.frames['main'].frames['mainContent'].contentWindow;
	}
	else if(typeof(top.fwb_frame) != 'undefined')
	{
		if(typeof(top.fwb_frame.contentWindow.embedded_iframe) != 'undefined')
		{
			doc = top.fwb_frame.contentWindow.embedded_iframe.contentWindow.mainContent.contentDocument;
			win = top.fwb_frame.contentWindow.embedded_iframe.contentWindow.mainContent.contentWindow;
		}
	}

	if(typeof(doc) == 'undefined' || typeof(win) == 'undefined')	return;

	doc.forms[0][type].value = calc_total_value();
	if(typeof(win.generate_data) == 'function')
	{
		win.generate_data();
	}
	if(typeof(win.sub_module_list) != 'undefined')
	{
		win.sub_module_list.configure();
	}
}

function adv_ok_click()
{
	sync_value_to();
	closeLastSliderin();
}

function calc_total_value()
{
	var value = 0;
	var chks =  jQuery('.toggle-switch');

	for(var i = 0; i < chks.length; i++)
	{
		var chk = chks[i];
		if(chk.checked)
			value += parseInt(chk.value);
	}

	return value;
}

function update_all()
{
	var checked = jQuery('#check_all')[0].checked;

	var chks = jQuery('.toggle-switch');
	for(var i = 0; i < chks.length; i++)
	{
		var chk = chks[i];
		if(chk.id == "check_all")	continue;
		chk.checked = checked;
	}
}

function update_part()
{
	var all = true;
	var chks = jQuery('.toggle-switch');
	for(var i = 0; i < chks.length; i++)
	{
		var chk = chks[i];
		if(chk.id == "check_all")	continue;

		if(!chk.checked)
		{
			all = false;
			break;
		}
	}
	jQuery('#check_all')[0].checked = all;
}

var module_list = (function($) {
	'use strict';

	function content_loaded(qlist) {
		update_part();
	}

	function status_format_fn(td, col, row_data)
	{
		var status = row_data[col.selector];
		var id = row_data['id'];
		var id_label = 'chk_' + id;
		var val = row_data['val'];

		var html = "<input class='toggle-switch' onclick='update_part()' type='checkbox' value='" + val +"' id='" + id_label + "' " + ((status === 1)?"checked":"") + "/>" + 
			"<label for='" +id_label+"'></label>";
		return html;
	}

	function gen_qlist(){
		if (!window.fgt_lang || !fgt_lang["global"])
			$.addLang();
		var qlist_settings = {
			'prefix': 'wvs_template_adv',
			'source': source,
			'columns': [
				{'selector': 'id', 'lang_key': '#'},
				{'selector': 'type', 'lang_key': type_label},
				{'selector': 'status', 'lang_key': '<input class="toggle-switch" onclick="update_all()" type="checkbox" value="0" id="check_all" /><label for="check_all"></label>'},
			],
			'default_columns': ['id', 'type', 'status'],
			'callbacks': {
				'load': content_loaded
			},
			'options': {
				'hide_default_buttons': true,
				'disable_context_menu': true,
			},
			'format_fn': {
				'status': status_format_fn
			}
		};

		var $container = $("#content");
		$container.qlist(qlist_settings);
	}
	return {configure: gen_qlist};

})(jQuery);

