var pow32 = 4294967296;

function calc_enable_count(type, val){
	var array = value_obj[type] || [];
	var count = 0;

	for(var i = 0; i < array.length; i++){

		// require big-interger js lib, to handle number greater than 32-bit bit operation higher bit can't take effect issue
		if(bigInt(val).and(bigInt(array[i])).toString() != '0')
			count++;

		/*
		if(val >= pow32 && array[i] >= pow32)
		{
			var new_val = val >>> 32;
			var new_arr = array[i] / pow32;
			if(new_val & new_arr)	count++;
		}
		else
		{
			if(val & array[i])      count++;
		}
		*/
	}
	return count;
}

// 2 means all enabled, 1 means part enabled, 0 means none
function calc_status(type, val)
{
	if(val == 0)	return 0;
	var array = value_obj[type] || [];
	for(var i = 0; i < array.length; i++)
	{
		// require big-interger js lib, to handle number greater than 32-bit bit operation higher bit can't take effect issue
		if(bigInt(val).and(bigInt(array[i])).toString() == '0')
			return 1;
		/*
		if(val >= pow32 && array[i] >= pow32)
		{
			var new_val = val >>> 32;
			var new_arr = array[i] / pow32;
			if((new_val & new_arr) == 0)
				return 1;
		}
		else
		{
			if((val & array[i]) == 0)
				return 1;
		}
		*/
	}

	return 2;
}

var types_array = ['audit', 'bruteforce', 'crawl', 'grep', /*'mangle', 'evasion',*/ 'infrastructure'];

function generate_data()
{
	var data = [];

	for(var i = 0; i < types_array.length; i++)
	{
		var type = types_array[i];
		var val = document.forms[0][type].value;
		data.push({'id': i+1, 'name': type, 'label': label_obj[type], 'count': calc_enable_count(type, val), 'status': calc_status(type, val)});
	}

	console.log(data);
	return data;
}

//var source = generate_data();

var sub_module_list = (function($) {
	'use strict';

	function qlist_edit_wvs_template_elem(q, elem)
	{
		var attr = qlist_get_row_attr(elem, "mkey");

		if (attr) {
			attr = encodeURIComponent(attr);
			var url = q.cr_edit_url;
			url = qlist_url_append_arg(url, "type", attr);

			var value = document.forms[0][attr].value;
			url = qlist_url_append_arg(url, "value", value);

			url = qlist_url_append_redir(url);
			if (q.popup) {
				var qlistSubSlide;
				qlistSubSlide = new top.Sliderin({
					title: '',
					url: url,
					width: q.sliderwidth
				});
				qlistSubSlide.open();
			} else {
				window.location.url = url;
			}
		}
	}

	function content_loaded()
	{
		$('.ql-head-container').css('display', 'none');
		$('.ql-body-table .name').css('text-align', 'left');
		$('.ql-body-table .name').css('padding-left', '10px');
	}

	function name_format_fn(td, col, row_data)
	{
		var data = row_data['label'];
		var status = row_data['status'] || 0;
		var cls_label = '';
		if(status == 0)
			cls_label = 'plugin_status_none';
		else if(status == 1)
			cls_label = 'plugin_status_part';
		else if(status == 2)
			cls_label = 'plugin_status_all';
		var html = "<span class='plugin_status " + cls_label +  "' ></span>";
		html += data;
		return html;
	}

	function setup_qlist()
	{
		gen_qlist();
	}
	function gen_qlist(){
		if (!window.fgt_lang || !fgt_lang["global"])
			$.addLang();

		var menu_items = {
			'edit': {
				'handler': qlist_edit_wvs_template_elem
			}
		};
		var qlist_settings = {
			'prefix': 'wvs_template_adv',
			'source': generate_data(),
			'cr_new_url': create_sub_url,
			'cr_edit_url': create_sub_url,
			'row_attr': [
				{name: 'id', selector: 'id'},
				{name: 'mkey', selector: 'name'}
			],
			'columns': [
				{'selector': 'id', 'lang_key': "#"},
				{'selector': 'name', 'lang_key': $j.getInfo("plugins",flt_lang)},
				{'selector': 'count', 'lang_key': $j.getInfo("count", flt_lang)},
			],
			'menu_items': menu_items,
			'default_columns':['id', 'name', 'count'],
			'column_filters': {
				'enabled': false,
			},
			'handle_selection_change': sub_selection_changed,
			'format_fn': {
				'name': name_format_fn
			},
			'callbacks': {
				'load': content_loaded
			},
			'options': {
				'popup': true,
				'sliderwidth': 500,
				'hide_create_button': true,
				'hide_delete_button': true,
			},
		};
		var $container = $("#sub_content");
		$container.qlist(qlist_settings);

	}
	return {configure: setup_qlist};
})(jQuery);
