
var hpc_edit = (function($) {
    'use strict';

    var colors = ['', '#d4fbff', '#faffa5', '#ffca5c', '#f32e2b'];
    var bcolors = ['', '#7bcade', '#d2ba00', '#e2a82e', '#d50000'];
    var values = ['level_off', 'level_low', 'level_medium', 'level_high', 'level_critical'];

    function _hpc_onload($hpc) {
        $('.hpc-status', $hpc).on('click', function() {
            var $parent = $(this).parents('tr');

            // Prevent disabled entries from using inline edit support.
            var can_edit = ($parent.attr('can_edit') === '1') ? '0' : '1';
            $parent.toggleClass('disabled').attr('can_edit', can_edit);

	    $parent.find('.level-slider').slider((can_edit == '1')?'enable':'disable');
        });

        // Range validation for http length.
        $('td.length input[name=hpc-1-length]',$hpc).attr({
            'min': 0,
            'max': 12288
        }).after(' (B)');

        // Range validation for max length of header name.
        $('td.length input[name=hpc-2-length]',$hpc).attr({
            'min': 0,
            'max': 255
        }).after(' (B)');

        // Range validation for max length of header value.
        $('td.length input[name=hpc-3-length]',$hpc).attr({
            'min': 0,
            'max': 12288
        }).after(' (B)');

        // Range validation for max length of http request.
        $('td.length input[name=hpc-7-length]',$hpc).attr({
            'min': 0,
            'max': 65536
        }).after(' (KB)');

        // Range validation for max count of header line request
        $('td.length input[name=hpc-8-length]',$hpc).attr({
            'min': 0,
            'max': 128
        });

        // Range validation for Total URL Parameters Length
        $('td.length input[name=hpc-10-length]',$hpc).attr({
            'min': 0,
            'max': 12288
        }).after(' (B)');

        // Range validation for Total Body Parameters Length 
        $('td.length input[name=hpc-11-length]',$hpc).attr({
            'min': 0,
            'max': 16384
        }).after(' (B)');      

        // Range validation for Number of URL Parameters
        $('td.length input[name=hpc-12-length]',$hpc).attr({
            'min': 0,
            'max': 1023
        });        

        // Range validation for max length (KB) of content
        $('td.length input[name=hpc-15-length]',$hpc).attr({
            'min': 0,
            'max': 65536
        }).after(' (KB)');     

        // Range validation for max length (KB) of body
        $('td.length input[name=hpc-21-length]',$hpc).attr({
            'min': 0,
            'max': 65536
        }).after(' (KB)'); 

        // Range validation for Number of Cookies in Request
        $('td.length input[name=hpc-22-length]',$hpc).attr({
            'min': 0,
            'max': 1023
        });     

        // Range validation Number of ranges in Range Header
        $('td.length input[name=hpc-23-length]',$hpc).attr({
            'min': 0,
            'max': 64
        });

	// Range HTTP request filename length
	$('td.length input[name=hpc-25-length]', $hpc).attr({
	    'min': 0,
	    'max': 12288
	}).after(' (B)');

	// Range Header Table Size
	$('td.length input[name=hpc-30-length]', $hpc).attr({
	    'min': 0,
	    'max': 16777215
	}).after(' (B)');

	// Range Number of Concurrent Streams
	$('td.length input[name=hpc-31-length]', $hpc).attr({
	    'min': 0,
	    'max': 100000
	});

	// Range Initial Window Size
	$('td.length input[name=hpc-32-length]', $hpc).attr({
	    'min': 0,
	    'max': 2147483647
	}).after(' (B)');

	// Range Frame Size
	$('td.length input[name=hpc-33-length]', $hpc).attr({
	    'min': 0,
	    'max': 16777215
	}).after(' (B)');

	// Range Header List Size
	$('td.length input[name=hpc-34-length]', $hpc).attr({
	    'min': 0,
	    'max': 16777215
	}).after(' (B)');

	// max url param name length
	$('td.length input[name=hpc-40-length]', $hpc).attr({
		'min': 0,
		'max': 8192
	}).after(' (B)');

	// max url param value length
	$('td.length input[name=hpc-41-length]', $hpc).attr({
		'min': 0,
		'max': 8192
	}).after(' (B)');

        // Range validation for period_block

        $('td.period_block input[type=number]',
            $hpc).attr({
            'min': 1,
            'max': 3600
            });

        $j('#hpc_qlist_yui_menubar')[0].style.display = 'none';

	$j('.compact-visual-toggle', $hpc).attr('disabled', false);

        /* hidden other group  */
        //$j('#hpc-qlist tbody:first')[0].style.display = 'none'
        //$j('#hpc-qlist tbody:first').next('tbody')[0].style.display = '';        

        $('td.action select[data-name=action]', $hpc).on('change', function() {
            var $parent = $(this).parents('tr');
            var id = $parent.attr('data-row-handler-id');

            var val = ($(this).val());
            var $block = $('td.period_block input#hpc-'+id+'-period_block', $hpc);
            $block.attr('disabled', val === '11' ? false: true);
        });

        $('td.period_block input', $hpc).each(function(){
            var $parent = $(this).parents('tr');
            var id = $parent.attr('data-row-handler-id');
            var action = $('td.action select', $parent).val();
            $(this).attr('disabled', action === '11' ? false: true);
        });  

	$j('div.level-slider').slider({
		range: 'min',
		max: 4,
		slide: function(event, ui) {
			var val = ui.value;
			process_slide(this, val);
			var score_field = get_score_field(this);
			score_field.val(val);
		}
	}).each(function(n ,i) {
		var jthis = $j(this);
		var score_field = get_score_field(this);
		var val = score_field.val();
		jthis.slider("option", "value", val);
		process_slide(this, val);
	});

        //$j('#hpc-qlist').attr({'style': 'table-layout:auto;word-wrap:break-word;word-break:break-all'});
        var i = 1;
        for(i = 1; i < 48; i++)
        {
            $j('#hpc-qlist tr[data-row-handler-id="'+i+'"]').after('<tr id="tips-'+i+'" style="display:none"><td colspan="9" style="text-align: left; white-space:normal ;background-color: #FFD710;"><div">'
                +$j.getInfo('tips_'+i)+'</div></td></tr>');

            $('#hpc-qlist label[id="name-'+i+'"]').click(function() {
                var id = $(this).parents('tr').attr('data-row-handler-id');//this.getAttribute('data-row-handler-id');
                var css = $('#tips-'+id).css('display');
                if(css === 'none') $('#tips-'+id).css('display','');
                else $('#tips-'+id).css('display','none');
            });
        
	    var $tr = $j('#hpc-qlist tr[data-row-handler-id="' + i + '"]');
	    var can_edit = ($tr.attr('can_edit') === '1') ? '1' : '0';
	    $tr.find('.level-slider').slider((can_edit == '1')?'enable':'disable');
        }
    }

    function get_score_field(elem) {
	    var jthis = $j(elem);
	    var score_id = jthis.attr('id').replace('-slider', '-score');
	    return $j('#' + score_id);
    }

    function process_slide(elem, val) {
	    var jthis = $j(elem);
	    jthis.children('div').css({
		    'background': colors[val],
		    'border-color': bcolors[val]
	    });

	    jthis.children('a').attr('title', $j.getInfo(values[val]));
	    $j('span.slider-level-disable-text', jthis).toggle(val == 0);
    }

    function configure_hpc() {
        var h = configure_hpc.qlist_handlers;
                      
        // 'hpc-mode' defaults to 'continous' and is configurable from
        // the CLI only.
        var $hpc = $('#hpc-table');

        var qlist_settings = {
            'prefix': 'hpc',
            'columns': [
                {'selector': 'status', 'lang_key': $j.getInfo('status')},
                {'selector': 'name', 'lang_key': $j.getInfo('name')},
                //{'selector': 'id'},
                {'selector': 'length', 'lang_key': $j.getInfo('length'),
                    'inline_type': 'number', 'validate': 'number required'
                },
                {'selector': 'action', 'lang_key': $j.getInfo('action'),
                    'options': action_options
                },  
                {'selector': 'period_block', 'lang_key': $j.getInfo('period_block'),
                    'inline_type': 'number', 'validate': 'number required'
                },                              
                {'selector': 'serverity', 'lang_key': $j.getInfo('severity'),
                    'options': serverity_options
                },
		{'selector': 'threat_weight', 'lang_key': $j.getInfo('threat_weight')
		},
                {'selector': 'trigger', 'lang_key': $j.getInfo('triggerAction'),
                    'options': trigger_options
                },
                {'selector': 'protocol', 'lang_key': $j.getInfo('protocol_support')}
            ],
            'options': {
                // List of hpc-table  is resizeable.
                'hide_create_button': true,
                'hide_delete_button': true,
                'fixed_header': false,
                'css_layout': false
            },
            'categories': ['category'],
            'category': {
                'sorted': false
            },
            'format_fn': {
                // A format function is provided to override the default
                // inline editing capabilities for this field.
                'action': function(td, column, entry) {
                    td.addClass('inline');
                    var options = {};
                    for (var i in column.options) {
                        // some rows doesn't have alert action
                    	if([27, 28, 29].indexOf(entry.id) < 0 || i != 2)
                    	    options[i] = column.options[i];
                    }
                    return h.select_format(column.selector, entry, options, column.validate, column.deps);
                },
                'name': function(td, column, entry) {
                    var html = '<label id="name-'+entry.id+'"><a style="color:#535b6b" href="javascript:;">'+entry.name +'</a></label>';
                    return html;
                },
                'status': function(td, column, entry) {
                    var $parent = td.parents(), can_edit = '1';
                    var html = '';
                    if(entry.status !== 'no')
                    {
                        html +='<input type="checkbox" ' +
                                   'class="hpc-status toggle-switch" ' +
                                   ' name="status_' + entry.id + '"' +
                                   ' id="status_' + entry.id + '"' +
                                   '" value="enable"';
                        if (entry.status === "enable") {
                            html += ' checked="checked"';
                        } else {
                            $parent.addClass('disabled');
                            can_edit = '0';
                        }                  



                        $parent.attr('can_edit', can_edit);

                        html += ' />';
                    }
                    html += '<label for="status_' + entry.id +'"></label>';

                    return html;
                },
                'length': function(td, column, entry)
                {
                    var html = '';
                    if(entry.length !== -1)
                    {
                        td.addClass('inline');
                        html = '<span class="inline-display length" data-name="length">'+ entry.length +'</span>';
                        html += '<input class="inline-edit qlist_col_field digits required valid" type="number" data-name="length" '+
                           ' value="'+ entry.length +'" name="hpc-' + entry.id + '-length" id="hpc-' + entry.id + '-length">';
                        //td.append('<label></label>');
                    }
                    return html;
                },
                'protocol': function(td, column, entry) {
                    return entry.protocol;
                },
		'threat_weight': function(td, column, entry) {
			var $parent = td.parents();
			var id = parseInt($parent.attr('data-row-handler-id'));
			if((id >= 1 && id <= 25) || (id >= 35 && id <= 39) || (id >= 40 && id <= 46))
			{
				td.addClass('inline');
				var threat_val = entry.threat_weight;
				var html = '';
				html += '<div class=\"div-slider\">';
				html += '<div id="threat_weight_' + id.toString() + '-slider" class="level-slider" style="margin-right: auto; margin-left: auto; float: none;">';
				html +=	'<span class="slider-level-disable-text" style="display:none">OFF</span>';
				html +=	'</div><div><span class="div-text" style="opacity: 1.0;"></span>'
				html +=	'<input name="threat_weight_' + id.toString() +'-score" id="threat_weight_' + id.toString() + '-score" value="' + threat_val + '" type="hidden"/>';
				html += '</div></div>';

				return html;
			}
			else
				return '';
		}
            },
            'callbacks': {
                'load': function() {
                    _hpc_onload($hpc);
                }
            }
        };

        if (!h) {
            h = configure_hpc.qlist_handlers =
                new QListInlineHandlers($('[name="entries"]'),
                                 {read_only: !is_rw_admin});
        }

        $hpc.qlist(h.attach(qlist_settings));
    }

    function configure(hpc_ids) {

        // hpc-table signatures will be excluded from the pattern
        // based filter list.

        configure_hpc();

        $('form').submit(function() {
            var result = $(this).valid() &&
                configure_hpc.qlist_handlers.update_form();
            return result;
        }).validate({'onsubmit': false});
    }

    return {configure: configure};
})(jQuery);
